/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay.application;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.dao.prepay.application.PrepayApplicationDao;

public class PrepayApplicationService {
    public static BigDecimal getTaxRate(String number, String zone, Date startDate, Date endDate) {
        Optional<DynamicObject> optional;
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter fstatus = new QFilter("entryentity.fstatus1", "=", (Object)"1");
        QFilter startdate = new QFilter("entryentity.startdate", "<=", (Object)startDate);
        QFilter enddate = new QFilter("entryentity.enddate", ">=", (Object)endDate).or(QFilter.isNull((String)"entryentity.enddate"));
        DynamicObjectCollection assist = QueryServiceHelper.query((String)"tpo_tcvat_assist", (String)"entryentity.wherejson,entryentity.fvalue1", (QFilter[])new QFilter[]{numberFilter, fstatus, startdate, enddate}, (String)"entryentity.endDate DESC");
        if (assist != null && assist.size() > 0 && (optional = assist.stream().filter(dynamicObject -> {
            if (!StringUtil.isNotEmpty((CharSequence)dynamicObject.getString("entryentity.wherejson"))) {
                return true;
            }
            QFilter[] recombine = FilterBuilderUtils.buildFilter((String)dynamicObject.getString("entryentity.wherejson"), (String)"tctb_tax_main").recombine();
            long filterCount = Arrays.stream(recombine).filter(s -> s.getProperty().equals("categoryentryentity.orgplace") && s.getValue().equals(zone)).count();
            return filterCount > 0L;
        }).findFirst()).isPresent()) {
            return optional.get().getBigDecimal("entryentity.fvalue1");
        }
        return null;
    }

    public static DynamicObject queryAssistData(String number, Date startDate, Date endDate) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter startdate = new QFilter("entryentity.startdate", "<=", (Object)startDate);
        QFilter enddate = new QFilter("entryentity.enddate", ">=", (Object)endDate).or(QFilter.isNull((String)"entryentity.enddate"));
        return QueryServiceHelper.queryOne((String)"tpo_tcvat_assist", (String)"entryentity.fvalue1", (QFilter[])new QFilter[]{numberFilter, startdate, enddate});
    }

    public static List<String> queryDeductedCanceledInvoiceSerialNo() {
        QFilter filter = new QFilter("invoice_status", "!=", (Object)"2").or(new QFilter("total_deduct", ">", (Object)BigDecimal.ZERO));
        DynamicObjectCollection special = QueryServiceHelper.query((String)"rim_inv_special", (String)"serial_no", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection ordinary = QueryServiceHelper.query((String)"rim_inv_ordinary", (String)"serial_no", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection electric = QueryServiceHelper.query((String)"rim_inv_electric", (String)"serial_no", (QFilter[])new QFilter[]{filter});
        Stream stream = Stream.concat(special.stream(), ordinary.stream());
        return Stream.concat(stream, electric.stream()).map(o -> o.getString("serial_no")).collect(Collectors.toList());
    }

    public static DynamicObjectCollection queryDeductEntryData(List<Long> specialList, List<Long> ordinaryList, List<Long> electricList) {
        QFilter totaldeductFilter = new QFilter("remain_deduct", ">", (Object)BigDecimal.ZERO);
        QFilter splitFilter = new QFilter("split", "=", (Object)"true");
        QFilter invoiceStatusFilter = new QFilter("invoice_status", "!=", (Object)"2");
        QFilter idFilter1 = new QFilter("id", "in", specialList);
        DynamicObject[] specialArrayObject = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"id,invoice_type,invoice_code,invoice_no,invoice_date,saler_name,main_goods_name,invoice_amount,total_tax_amount,total_amount,avail_deduct,remain_deduct,remark,total_deduct", (QFilter[])new QFilter[]{idFilter1, totaldeductFilter, splitFilter, invoiceStatusFilter});
        QFilter idFilter2 = new QFilter("id", "in", ordinaryList);
        DynamicObject[] ordinaryArrayObject = BusinessDataServiceHelper.load((String)"rim_inv_ordinary", (String)"id,invoice_type,invoice_code,invoice_no,invoice_date,saler_name,main_goods_name,invoice_amount,total_tax_amount,total_amount,avail_deduct,remain_deduct,remark,total_deduct", (QFilter[])new QFilter[]{idFilter2, totaldeductFilter, splitFilter, invoiceStatusFilter});
        QFilter idFilter3 = new QFilter("id", "in", electricList);
        DynamicObject[] electricArrayObject = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"id,invoice_type,invoice_code,invoice_no,invoice_date,saler_name,main_goods_name,invoice_amount,total_tax_amount,total_amount,avail_deduct,remain_deduct,remark,total_deduct", (QFilter[])new QFilter[]{idFilter3, totaldeductFilter, splitFilter, invoiceStatusFilter});
        DynamicObjectCollection invoiceCollection = new DynamicObjectCollection();
        invoiceCollection.addAll(Arrays.asList(specialArrayObject));
        invoiceCollection.addAll(Arrays.asList(ordinaryArrayObject));
        invoiceCollection.addAll(Arrays.asList(electricArrayObject));
        return invoiceCollection;
    }

    public static DynamicObjectCollection queryInvoiceData(List<Long> specialList, List<Long> ordinaryList, List<Long> electricList) {
        QFilter idFilter1 = new QFilter("id", "in", specialList);
        DynamicObject[] specialArrayObject = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"id,avail_deduct,total_deduct,invoice_type,invoice_code,invoice_no,invoice_date,saler_name,main_goods_name,total_tax_amount,remain_deduct,remark,invoice_amount,total_amount", (QFilter[])new QFilter[]{idFilter1});
        QFilter idFilter2 = new QFilter("id", "in", ordinaryList);
        DynamicObject[] ordinaryArrayObject = BusinessDataServiceHelper.load((String)"rim_inv_ordinary", (String)"id,avail_deduct,total_deduct,invoice_type,invoice_code,invoice_no,invoice_date,saler_name,main_goods_name,total_tax_amount,remain_deduct,remark,invoice_amount,total_amount", (QFilter[])new QFilter[]{idFilter2});
        QFilter idFilter3 = new QFilter("id", "in", electricList);
        DynamicObject[] electricArrayObject = BusinessDataServiceHelper.load((String)"rim_inv_electric", (String)"id,avail_deduct,total_deduct,invoice_type,invoice_code,invoice_no,invoice_date,saler_name,main_goods_name,total_tax_amount,remain_deduct,remark,invoice_amount,total_amount", (QFilter[])new QFilter[]{idFilter3});
        DynamicObjectCollection invoiceCollection = new DynamicObjectCollection();
        invoiceCollection.addAll(Arrays.asList(specialArrayObject));
        invoiceCollection.addAll(Arrays.asList(ordinaryArrayObject));
        invoiceCollection.addAll(Arrays.asList(electricArrayObject));
        return invoiceCollection;
    }

    public DynamicObjectCollection getDeductInvoiceCollection(String billno) {
        PrepayApplicationDao prepayApplicationDao = new PrepayApplicationDao();
        return prepayApplicationDao.loadApDeductEntityByBillno(billno);
    }

    public void deductentryHandle(String billno, DynamicObjectCollection collection) {
        DynamicObjectCollection deductEntity = this.getDeductInvoiceCollection(billno);
        if (!deductEntity.isEmpty()) {
            Map<Long, DynamicObject> entityMap = deductEntity.stream().collect(Collectors.toMap(k -> k.getLong("dinvoiceid"), v -> v, (m, n) -> m));
            collection.stream().filter(e -> entityMap.containsKey(e.getLong("id"))).forEach(e -> {
                DynamicObject dynamicObject = (DynamicObject)entityMap.get(e.getLong("id"));
                e.set("avail_deduct", (Object)dynamicObject.getBigDecimal("dcurrentdeduct").add(e.getBigDecimal("avail_deduct")));
                e.set("remain_deduct", (Object)dynamicObject.getBigDecimal("dcurrentdeduct").add(e.getBigDecimal("remain_deduct")));
                e.set("total_deduct", (Object)e.getBigDecimal("total_amount"));
            });
        }
    }

    public String validDeductionAmount(BigDecimal salesamount, BigDecimal deductionamount) {
        return PrepayApplicationService.validMessage("deduct", salesamount, deductionamount);
    }

    public String validSalesAmount(BigDecimal entryTotalamount, BigDecimal newTotalamount) {
        return PrepayApplicationService.validMessage("sales", entryTotalamount, newTotalamount);
    }

    public static String validMessage(String type, BigDecimal leftAmount, BigDecimal rightAmount) {
        switch (type) {
            case "sales": {
                if (leftAmount.compareTo(rightAmount) == 0) break;
                return ResManager.loadKDString((String)"\u672c\u6b21\u5e94\u7a0e\u9500\u552e\u989d\u4e0e\u9500\u552e\u989d\u660e\u7ec6\u7684\u5408\u8ba1\u503c\u4e0d\u4e00\u81f4\uff0c\u82e5\u624b\u52a8\u4fee\u6539\uff0c\u8bf7\u5220\u9664\u9500\u552e\u660e\u7ec6\u533a\u7684\u7684\u5355\u636e", (String)"PrepayApplicationService_0", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            case "deduct": {
                if (leftAmount.compareTo(rightAmount) >= 0) break;
                return ResManager.loadKDString((String)"\u201c\u589e\u503c\u7a0e\u8ba1\u7a0e\u57fa\u7840\u201d\u5c0f\u4e8e0\uff0c\u8bf7\u786e\u8ba4\u8fd9\u4e9b\u6570\u636e\uff1a\u201c\u672c\u671f\u5e94\u7a0e\u9500\u552e\u989d(\u542b\u7a0e)\u201d\u3001\u201c\u9884\u6536\u6b3e\u6263\u9664\u989d\u201d\u3001\u201c\u672c\u6b21\u5206\u5305\u6263\u9664\u989d\uff08\u542b\u7a0e\uff09\u201d\u3002", (String)"PrepayApplicationService_1", (String)"taxc-tcvat", (Object[])new Object[0]);
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public static BigDecimal getSalesOrDeductionAmount(IFormView getView, String entryName, String totalAmount) {
        DynamicObjectCollection salesentry = getView.getModel().getEntryEntity(entryName);
        return PrepayApplicationService.getTotalAmount(salesentry, totalAmount);
    }

    public static BigDecimal getTotalAmount(DynamicObjectCollection entryEntity, String totalAmount) {
        if (entryEntity.size() > 0) {
            return entryEntity.parallelStream().map(s -> s.getBigDecimal(totalAmount)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    public static void rollbackStatus(DynamicObject invoice) {
        Long sinvoiceid = invoice.getLong("sinvoiceid");
        DynamicObject sinvoice = BusinessDataServiceHelper.loadSingle((Object)sinvoiceid, (String)"sim_vatinvoice");
        sinvoice.set("advancepaymentstatus", (Object)"20");
        SaveServiceHelper.update((DynamicObject)sinvoice);
    }

    public static void calculateRollbackValue(DynamicObject invoice) {
        Long dinvoiceid = invoice.getLong("dinvoiceid");
        String dinvoicetype = invoice.getDynamicObject("dinvoicetype").getString("number");
        BigDecimal dcurrentdeduct = invoice.getBigDecimal("dcurrentdeduct");
        if ("1".equals(dinvoicetype) || "3".equals(dinvoicetype)) {
            PrepayApplicationService.rollbackDeduct(dinvoiceid, dcurrentdeduct, "rim_inv_ordinary");
        }
        if ("2".equals(dinvoicetype) || "4".equals(dinvoicetype)) {
            PrepayApplicationService.rollbackDeduct(dinvoiceid, dcurrentdeduct, "rim_inv_special");
        }
        if ("26".equals(dinvoicetype) || "27".equals(dinvoicetype)) {
            PrepayApplicationService.rollbackDeduct(dinvoiceid, dcurrentdeduct, "rim_inv_electric");
        }
    }

    private static void rollbackDeduct(Long dinvoiceid, BigDecimal dcurrentdeduct, String entity) {
        DynamicObject dinvoice = BusinessDataServiceHelper.loadSingle((Object)dinvoiceid, (String)entity);
        dinvoice.set("total_deduct", (Object)dinvoice.getBigDecimal("total_deduct").subtract(dcurrentdeduct));
        dinvoice.set("remain_deduct", (Object)dinvoice.getBigDecimal("remain_deduct").add(dcurrentdeduct));
        dinvoice.set("avail_deduct", (Object)dinvoice.getBigDecimal("avail_deduct").add(dcurrentdeduct));
        SaveServiceHelper.update((DynamicObject)dinvoice);
    }

    public static void getDeductByHistory(List<Long> specialList, List<Long> ordinaryList, List<Long> electricList, DynamicObjectCollection deductentry) {
        ((Stream)deductentry.stream().parallel()).forEach(i -> {
            if ("2".equals(i.getDynamicObject("dinvoicetype").getString("number")) || "4".equals(i.getDynamicObject("dinvoicetype").getString("number"))) {
                specialList.add(i.getLong("dinvoiceid"));
            }
            if ("1".equals(i.getDynamicObject("dinvoicetype").getString("number")) || "3".equals(i.getDynamicObject("dinvoicetype").getString("number"))) {
                ordinaryList.add(i.getLong("dinvoiceid"));
            }
            if ("26".equals(i.getDynamicObject("dinvoicetype").getString("number")) || "27".equals(i.getDynamicObject("dinvoicetype").getString("number"))) {
                electricList.add(i.getLong("dinvoiceid"));
            }
        });
    }

    public static List<Long> getExistData(Long id) {
        boolean exist = QueryServiceHelper.exists((String)"tcvat_prepay_application", (Object)id);
        List<Long> salesentryInvoiceId = Collections.emptyList();
        if (exist) {
            DynamicObject perpayApplication = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcvat_prepay_application");
            salesentryInvoiceId = perpayApplication.getDynamicObjectCollection("salesentry").stream().map(e -> e.getLong("sinvoiceid")).collect(Collectors.toList());
        }
        return salesentryInvoiceId;
    }

    public static BigDecimal getRateAmount(String rateStr) {
        if (StringUtil.isNotBlank((CharSequence)rateStr)) {
            return BigDecimalUtil.toBigDecimal((Object)rateStr.replace("%", "")).divide(BigDecimalUtil.toBigDecimal((Object)100), 4, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }
}

