/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class PrepayDeclareService {
    public static void refreshElement(ListSelectedRowCollection list) {
        List<Object> pklist = list.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().collect(Collectors.toList());
        PrepayDeclareService.refreshElement(pklist, "audit");
    }

    public static void refreshElement(List<Object> pklist, String operate) {
        DynamicObject[] loadResult;
        DynamicObject[] prepayList = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"sbbid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pklist.toArray())});
        List sbbidList = Arrays.stream(prepayList).map(p -> p.getLong("sbbid")).collect(Collectors.toList());
        for (DynamicObject entity : loadResult = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{new QFilter("id", "in", sbbidList)})) {
            DeclareMQSender.sendMQ((DynamicObject)entity, null, (String)DeclareMQType.DECLARE.name(), (String)operate, (String)"tcvat_prepay_declare_bill");
        }
    }

    public static void updateVatinvoice(DynamicObject declare, boolean isApply) {
        block26: {
            DynamicObject[] dyos;
            String declareserialno = declare.getString("declareserialno");
            DynamicObject prepay = BusinessDataServiceHelper.loadSingle((String)"tcvat_prepay_application", (String)"prepaystatus,salesentry.sadvancepaymentstatus,salesentry.sinvoiceid", (QFilter[])new QFilter[]{new QFilter("declarenumber", "=", (Object)declareserialno)});
            if (prepay != null) {
                if (isApply) {
                    prepay.set("prepaystatus", (Object)"4");
                } else {
                    prepay.set("prepaystatus", (Object)"2");
                }
                DynamicObjectCollection salesentry = prepay.getDynamicObjectCollection("salesentry");
                ArrayList<Long> sinvoiceidlist = new ArrayList<Long>();
                for (DynamicObject[] dyo : salesentry) {
                    if (isApply) {
                        dyo.set("sadvancepaymentstatus", (Object)"40");
                    } else {
                        dyo.set("sadvancepaymentstatus", (Object)"30");
                    }
                    sinvoiceidlist.add(dyo.getLong("sinvoiceid"));
                }
                DynamicObject[] sim_vatinvoice_output_sigs = BusinessDataServiceHelper.load((Object[])sinvoiceidlist.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"sim_vatinvoice_output_sig"));
                if (sim_vatinvoice_output_sigs != null) {
                    for (DynamicObject sinvoice : sim_vatinvoice_output_sigs) {
                        if (isApply) {
                            sinvoice.set("advancepaymentstatus", (Object)"40");
                            continue;
                        }
                        sinvoice.set("advancepaymentstatus", (Object)"30");
                    }
                }
                try (TXHandle h = TX.required();){
                    try {
                        SaveServiceHelper.update((DynamicObject)prepay);
                        SaveServiceHelper.update((DynamicObject[])sim_vatinvoice_output_sigs);
                        break block26;
                    }
                    catch (Throwable t) {
                        h.markRollback();
                        throw t;
                    }
                }
            }
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcvat_prepay_declare_bill", (String)"prepayproject,skssqq,skssqz,org", (QFilter[])new QFilter[]{new QFilter("declareserialno", "=", (Object)declareserialno)});
            long prepayproject = dynamicObject.getLong("prepayproject");
            DynamicObject dynamicObject_1 = QueryServiceHelper.queryOne((String)"tcvat_prepay_project_info", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)prepayproject)});
            long projectid = dynamicObject_1.getLong("id");
            long org = dynamicObject.getLong("org");
            Date skssqq = dynamicObject.getDate("skssqq");
            Date skssqz = dynamicObject.getDate("skssqz");
            QFilter skssqzFilter = new QFilter("issuetime", "<=", (Object)DateUtils.getDayLast((Date)skssqz));
            QFilter skssqqFilter = new QFilter("issuetime", ">=", (Object)DateUtils.getDayFirst((Date)skssqq));
            QFilter orgFilter = new QFilter("orgid", "=", (Object)org);
            QFilter projectidFilter = new QFilter("project", "=", (Object)projectid);
            for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)"sim_vatinvoice_output_sig", (String)"advancepaymentstatus", (QFilter[])new QFilter[]{skssqzFilter, skssqqFilter, orgFilter, projectidFilter})) {
                if (isApply) {
                    dyo.set("advancepaymentstatus", (Object)"40");
                } else {
                    dyo.set("advancepaymentstatus", (Object)"30");
                }
                SaveServiceHelper.update((DynamicObject)dyo);
            }
        }
    }

    public static Boolean checkDeclareSerialno(String declareserialno) {
        DynamicObject serialno = BusinessDataServiceHelper.loadSingle((String)"tcvat_prepay_declare_bill", (String)"id,declareserialno", (QFilter[])new QFilter[]{new QFilter("declareserialno", "=", (Object)declareserialno)});
        if (null != serialno) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static DynamicObject queryNsrxx(String orgId, String startdate, String enddate, String declareSerialno, String projectid) {
        Date start = null;
        Date end = null;
        if (null != startdate) {
            start = DateUtils.stringToDate((String)startdate);
        }
        if (null != enddate) {
            end = DateUtils.stringToDate((String)enddate);
        }
        QFilter q1 = new QFilter("accountorg", "=", (Object)Long.parseLong(orgId));
        QFilter q2 = new QFilter("skssqq", "=", (Object)start);
        QFilter q3 = new QFilter("skssqz", "=", (Object)end);
        QFilter q5 = new QFilter("declareserialno", "=", (Object)declareSerialno);
        QFilter q6 = new QFilter("prepayproject", "=", (Object)Long.parseLong(projectid));
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_prepay_declare_bill", (String)"id,billstatus,declarestatus", (QFilter[])new QFilter[]{q1, q2, q3, q5, q6});
    }

    public static void syncBillstatus(Object[] collect, String status) {
        if (collect.length > 0) {
            DynamicObject[] nsrxx = BusinessDataServiceHelper.load((Object[])collect, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
            Arrays.stream(nsrxx).forEach(e -> e.set("billstatus", (Object)status));
            SaveServiceHelper.save((DynamicObject[])nsrxx);
        }
    }

    public static String createCodeNumber() {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_prepay_declare_bill");
        return DeclareServiceHelper.generateSBBNo((String)"tcvat_prepay_declare_bill", (DynamicObject)dynamicObject, null);
    }

    public static void deletePrepayDeclareAccount(String declareserialno) {
        boolean isExist = QueryServiceHelper.exists((String)"tcvat_prepay_declare_bill", (QFilter[])new QFilter[]{new QFilter("declareserialno", "=", (Object)declareserialno)});
        if (!isExist) {
            DeleteServiceHelper.delete((String)"tcvat_project_account", (QFilter[])new QFilter[]{new QFilter("declareserialno", "=", (Object)declareserialno)});
        }
    }

    public static boolean hasEmptyCollection(Object[] primaryKeyValues) {
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"entryentity", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        return Arrays.stream(query).anyMatch(e -> e.getDynamicObjectCollection("entryentity").size() == 0);
    }

    public static Boolean checkCard(String orgID, IFormView view, IPageCache pageCache) {
        TaxAppEnum taxEnum = TaxAppEnum.getEnumInstanceByAppid((String)"tcvat");
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(orgID)));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            DynamicObject object = (DynamicObject)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity").get(0);
            if (Objects.equals("0", object.getString("enable"))) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u4fe1\u606f\u8fdb\u884c\u542f\u7528\u3002", (String)"PrepayDeclarationPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]), ((DynamicObject)((List)result.getData()).get(0)).getString("taxorg.taxpayer"), taxEnum.getName()));
                return Boolean.FALSE;
            }
            pageCache.put("deadline", object.getString("deadline"));
            pageCache.put("taxpayertype", object.getString("taxpayertype"));
        }
        return Boolean.TRUE;
    }
}

