/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay.engine.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.prepay.engine.impl.AccountEngine;

public class PrepayEngineUtils {
    private static final List<EngineTask<TcvatEngineModel, DynamicObject>[]> engineTaskList = new ArrayList<EngineTask<TcvatEngineModel, DynamicObject>[]>();

    public static void execute(RequestContext context, TcvatEngineModel engineModel) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Future> futures = new ArrayList<Future>();
        engineModel.getCustom().put("isAccountingOrg", Boolean.TRUE);
        for (EngineTask<TcvatEngineModel, DynamicObject>[] tasks : engineTaskList) {
            for (EngineTask<TcvatEngineModel, DynamicObject> task : tasks) {
                task.setCtx(context);
                task.setEngineModel((EngineModel)engineModel);
                futures.add(ThreadPoolsService.getInstance().submitFutrue(task));
            }
            for (Future future : futures) {
                future.get(300L, TimeUnit.SECONDS);
            }
        }
    }

    static {
        engineTaskList.add(new EngineTask[]{new AccountEngine()});
    }
}

