/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PrepayInvoiceService {
    public static final String RIM_INV_ORDINARY = "rim_inv_ordinary";
    public static final String RIM_INV_SPECIAL = "rim_inv_special";
    public static final String RIM_INV_ELECTRIC = "rim_inv_electric";
    public static final String RIM_INVOICE = "tcvat_prepay_in_invoice";
    private static final String TCVAT_PREPAY_APPLICATION = "tcvat_prepay_application";
    private static final String TCVAT_PREPAY_DECLARE_BILL = "tcvat_prepay_declare_bill";

    public boolean isAllEmptyProject(DynamicObject[] selectRows) {
        List projects = Arrays.stream(selectRows).map(e -> e.getDynamicObject("project")).collect(Collectors.toList());
        return projects.stream().filter(Objects::isNull).count() == (long)projects.size();
    }

    public boolean isSame(DynamicObject[] selectRows, String key) {
        List projects = Arrays.stream(selectRows).map(e -> e.getDynamicObject(key)).collect(Collectors.toList());
        if (projects.stream().filter(Objects::isNull).count() == (long)projects.size()) {
            return true;
        }
        long id = projects.get(0) == null ? 0L : ((DynamicObject)projects.get(0)).getLong("id");
        for (DynamicObject project : projects) {
            long tmp = project == null ? 0L : project.getLong("id");
            if (id == tmp) continue;
            return false;
        }
        return true;
    }

    public List<String> containsSplit(DynamicObject[] selectRows) {
        List serials = Arrays.stream(selectRows).map(e -> e.getString("serial_no")).collect(Collectors.toList());
        DynamicObjectCollection specialInvoices = QueryServiceHelper.query((String)RIM_INV_SPECIAL, (String)"split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serials)});
        DynamicObjectCollection ordinaryInvoices = QueryServiceHelper.query((String)RIM_INV_ORDINARY, (String)"split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serials)});
        DynamicObjectCollection electricInvoices = QueryServiceHelper.query((String)RIM_INV_ELECTRIC, (String)"split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serials)});
        ArrayList<String> splitList = new ArrayList<String>();
        splitList.addAll(specialInvoices.stream().map(e -> e.getString("split")).collect(Collectors.toList()));
        splitList.addAll(ordinaryInvoices.stream().map(e -> e.getString("split")).collect(Collectors.toList()));
        splitList.addAll(electricInvoices.stream().map(e -> e.getString("split")).collect(Collectors.toList()));
        return splitList;
    }

    public void setInvoiceSplit(DynamicObjectCollection selectRows, String splitFlag) {
        List invoiceList = selectRows.stream().map(e -> e.getString("serial_no")).collect(Collectors.toList());
        DynamicObject[] ordinaryInvoices = BusinessDataServiceHelper.load((String)RIM_INV_ORDINARY, (String)"invoice_code,invoice_no,invoice_type,split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", invoiceList)});
        DynamicObject[] specialInvoices = BusinessDataServiceHelper.load((String)RIM_INV_SPECIAL, (String)"invoice_code,invoice_no,invoice_type,split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", invoiceList)});
        DynamicObject[] electricInvoices = BusinessDataServiceHelper.load((String)RIM_INV_ELECTRIC, (String)"invoice_code,invoice_no,invoice_type,split", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", invoiceList)});
        Arrays.stream(ordinaryInvoices).forEach(e -> e.set("split", (Object)splitFlag));
        Arrays.stream(specialInvoices).forEach(e -> e.set("split", (Object)splitFlag));
        Arrays.stream(electricInvoices).forEach(e -> e.set("split", (Object)splitFlag));
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])ordinaryInvoices);
                SaveServiceHelper.save((DynamicObject[])specialInvoices);
                SaveServiceHelper.save((DynamicObject[])electricInvoices);
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }

    public void updateInvoiceOfProject(List<Object> list, long prepayProject) {
        DynamicObject[] invoiceList = BusinessDataServiceHelper.load((String)RIM_INVOICE, (String)"project,serial_no", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
        Arrays.stream(invoiceList).forEach(e -> e.set("project", (Object)prepayProject));
        List<String> serialnoList = Arrays.stream(invoiceList).map(e -> e.getString("serial_no")).collect(Collectors.toList());
        DynamicObject[] ordinary = this.initInvoiceDeduct(RIM_INV_ORDINARY, serialnoList);
        DynamicObject[] special = this.initInvoiceDeduct(RIM_INV_SPECIAL, serialnoList);
        DynamicObject[] electric = this.initInvoiceDeduct(RIM_INV_ELECTRIC, serialnoList);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])invoiceList);
                SaveServiceHelper.save((DynamicObject[])ordinary);
                SaveServiceHelper.save((DynamicObject[])special);
                SaveServiceHelper.save((DynamicObject[])electric);
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
    }

    public DynamicObject[] initInvoiceDeduct(String invoiceTable, List<String> serialnoList) {
        DynamicObject[] subInvoice = BusinessDataServiceHelper.load((String)invoiceTable, (String)"total_amount, total_deduct, avail_deduct, remain_deduct", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialnoList)});
        Arrays.stream(subInvoice).filter(e -> {
            BigDecimal totalAmount = Optional.ofNullable(e.getBigDecimal("total_amount")).orElse(BigDecimal.ZERO);
            BigDecimal totalDeduct = Optional.ofNullable(e.getBigDecimal("total_deduct")).orElse(BigDecimal.ZERO);
            BigDecimal remainDeduct = Optional.ofNullable(e.getBigDecimal("remain_deduct")).orElse(BigDecimal.ZERO);
            return totalDeduct.compareTo(BigDecimal.ZERO) == 0 && remainDeduct.compareTo(BigDecimal.ZERO) == 0 && totalAmount.compareTo(totalDeduct.add(remainDeduct)) != 0;
        }).forEach(e -> {
            e.set("avail_deduct", (Object)Optional.ofNullable(e.getBigDecimal("total_amount")).orElse(BigDecimal.ZERO));
            e.set("remain_deduct", (Object)Optional.ofNullable(e.getBigDecimal("total_amount")).orElse(BigDecimal.ZERO));
        });
        return subInvoice;
    }

    public boolean existPrepayDeclare(DynamicObject[] selectRows) {
        HashSet declarenumberSet = new HashSet();
        Arrays.stream(selectRows).forEach(e -> {
            QFilter q1 = new QFilter("deductentry.dinvoicecode", "=", (Object)e.getString("invoice_code"));
            QFilter q2 = new QFilter("deductentry.dinvoiceno", "=", (Object)e.getString("invoice_no"));
            QFilter q3 = new QFilter("deductentry.dinvoicetype.id", "=", (Object)e.getDynamicObject("invoice_type").getLong("id"));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)TCVAT_PREPAY_APPLICATION, (String)"declarenumber", (QFilter[])new QFilter[]{q1, q2, q3});
            if (!collection.isEmpty()) {
                collection.stream().forEach(c -> declarenumberSet.add(c.getString("declarenumber")));
            }
        });
        QFilter q1 = new QFilter("declareserialno", "in", declarenumberSet);
        QFilter q2 = new QFilter("declarestatus", "in", Arrays.asList("editing", "declared", "importing"));
        return QueryServiceHelper.exists((String)TCVAT_PREPAY_DECLARE_BILL, (QFilter[])new QFilter[]{q1, q2});
    }

    public boolean isPushPrepayApplication(List<Object> pkIdList) {
        DynamicObjectCollection main = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIdList)});
        List serialnoList = main.stream().map(e -> e.getString("serial_no")).collect(Collectors.toList());
        DynamicObjectCollection ordinary = QueryServiceHelper.query((String)RIM_INV_ORDINARY, (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialnoList)});
        DynamicObjectCollection special = QueryServiceHelper.query((String)RIM_INV_SPECIAL, (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialnoList)});
        DynamicObjectCollection electric = QueryServiceHelper.query((String)RIM_INV_ELECTRIC, (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialnoList)});
        ArrayList list = new ArrayList();
        ordinary.stream().forEach(e -> list.add(e.getLong("id")));
        special.stream().forEach(e -> list.add(e.getLong("id")));
        electric.stream().forEach(e -> list.add(e.getLong("id")));
        return QueryServiceHelper.exists((String)TCVAT_PREPAY_APPLICATION, (QFilter[])new QFilter[]{new QFilter("deductentry.dinvoiceid", "in", list)});
    }
}

