/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.rule;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BillFilterOperService {
    private static final Set<String> types = new HashSet<String>(Arrays.asList("67", "83"));

    public static void removeCompareTypes(List<Map<String, Object>> filterColumns) {
        for (Map<String, Object> filterColumn : filterColumns) {
            List compareTypes = (List)filterColumn.get("compareTypes");
            if (!"baseinvoicetype.name".equals(filterColumn.get("fieldName")) && !"baseinvoicetype.number".equals(filterColumn.get("fieldName"))) continue;
            compareTypes.removeIf(t -> !types.contains(t.getId()));
        }
    }

    public static void renameFieldCaption(List<Map<String, Object>> filterColumns) {
        for (Map<String, Object> filterColumn : filterColumns) {
            Object type = filterColumn.get("type");
            String caption = (String)filterColumn.get("fieldCaption");
            if (!caption.contains(".")) continue;
            if ("basedata".equals(type)) {
                filterColumn.put("fieldCaption", caption.replaceAll("\\.", ""));
                continue;
            }
            filterColumn.put("fieldCaption", caption.split("\\.")[1]);
        }
    }
}

