/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DeductRuleService {
    public static final List<String> nssbDeductType = Arrays.asList("VAT_JXDK_BQDK_1", "VAT_JXDK_BQDK_2", "VAT_JXDK_BQDK_3", "VAT_JXDK_BQDK_4", "VAT_JXDK_BQDK_5", "VAT_JXDK_BQDK_6", "VAT_JXDK_BQDK_7", "VAT_JXDK_BQDK_8", "VAT_JXDK_BQDK_9", "VAT_JXDK_BQDK_10", "VAT_JXDK_BQDK_11", "VAT_JXDK_BQDK_12", "VAT_JXDK_BQDK_14", "VAT_JXDK_BQDK_15", "VAT_JXDK_BQDK_16", "VAT_JXDK_BQDK_17", "VAT_JXDK_BQDK_18", "VAT_JXDK_DDK_1", "VAT_JXDK_DDK_3", "VAT_JXDK_DDK_4", "VAT_JXDK_DDK_6", "VAT_JXDK_DDK_7", "VAT_JXDK_DDK_9", "VAT_JXDK_DDK_00");
    public static final List<String> sjjtDeductType = Arrays.asList("VAT_JXDK_BQDK_1", "VAT_JXDK_BQDK_2", "VAT_JXDK_BQDK_3", "VAT_JXDK_BQDK_4", "VAT_JXDK_BQDK_5", "VAT_JXDK_BQDK_6", "VAT_JXDK_BQDK_7", "VAT_JXDK_BQDK_8", "VAT_JXDK_BQDK_9", "VAT_JXDK_BQDK_10", "VAT_JXDK_BQDK_11", "VAT_JXDK_BQDK_12", "VAT_JXDK_BQDK_14", "VAT_JXDK_BQDK_15", "VAT_JXDK_BQDK_16", "VAT_JXDK_BQDK_17", "VAT_JXDK_BQDK_18", "VAT_JXDK_DDK_1", "VAT_JXDK_DDK_3", "VAT_JXDK_DDK_4", "VAT_JXDK_DDK_6", "VAT_JXDK_DDK_7", "VAT_JXDK_DDK_9", "VAT_JXDK_DDK_00");

    public List<QFilter> getListFilterParameterByRulePurpose(String rulepurpose) {
        if (StringUtil.isBlank((CharSequence)rulepurpose)) {
            return Collections.singletonList(new QFilter("number", "in", nssbDeductType));
        }
        if (rulepurpose.contains("nssb") && rulepurpose.contains("sjjt")) {
            return Collections.singletonList(new QFilter("number", "in", nssbDeductType));
        }
        if (rulepurpose.contains("nssb")) {
            return Collections.singletonList(new QFilter("number", "in", nssbDeductType));
        }
        if (rulepurpose.contains("sjjt")) {
            return Collections.singletonList(new QFilter("number", "in", sjjtDeductType));
        }
        return Collections.singletonList(new QFilter("number", "in", nssbDeductType));
    }

    public AtomicBoolean validDeductTypeByRulePurpose(String rulePurpose, DynamicObject deductTypeObject) {
        AtomicBoolean result = new AtomicBoolean(true);
        if (null == rulePurpose) {
            result.set(false);
            return result;
        }
        if (rulePurpose.contains("nssb")) {
            Optional.ofNullable(deductTypeObject).ifPresent(d -> {
                if (!nssbDeductType.contains(d.getString("number"))) {
                    result.set(false);
                }
            });
        }
        return result;
    }
}

