/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.common.dto.SharePlanEntity;

public class DiffDeductionOpService {
    private static final String VAT_CEKCLX_008 = "VAT_CEKCLX_008";

    public static String isRuleRepeatOrShared(DynamicObject rule) {
        String diffType = rule.getDynamicObject("difftype").getString("number");
        String ruleType = rule.getString("ruletype");
        String deductProject = rule.getString("deductproject");
        if ("private".equals(ruleType) && "bqsjkce".equals(deductProject) && !VAT_CEKCLX_008.equals(diffType)) {
            String msg = DiffDeductionOpService.checkRepeatWithDbPrivate(rule);
            if (StringUtil.isNotBlank((CharSequence)msg)) {
                return msg;
            }
            msg = DiffDeductionOpService.checkRepeatWithDbPublic(rule);
            if (StringUtil.isNotBlank((CharSequence)msg)) {
                return msg;
            }
        }
        return null;
    }

    private static String checkRepeatWithDbPublic(DynamicObject rule) {
        QFilter[] filters = new QFilter[]{new QFilter("orgentity.org", "in", Collections.singletonList(rule.getLong("org.id"))), new QFilter("ruleentity.rule.deductproject", "=", (Object)"bqsjkce")};
        List<SharePlanEntity> plans = DiffDeductionOpService.querySharePlanByFilters(filters);
        return DiffDeductionOpService.diffPublicRuleRepeatWithPublic(new DynamicObject[]{rule}, Collections.singletonList(rule.getDynamicObject("org")), plans);
    }

    public static String diffPublicRuleEntryRepeat(DynamicObject[] sourceList, DynamicObject[] targetList) {
        for (DynamicObject a : sourceList) {
            for (DynamicObject b : targetList) {
                if (a.getString("number").equals(b.getString("number")) || !DiffDeductionOpService.isRepeat(a, b)) continue;
                return String.format(ResManager.loadKDString((String)"\u4e00\u4e2a\u5171\u4eab\u65b9\u6848\u4e2d\u540c\u4e00\u4e2a\u5dee\u989d\u6263\u9664\u7c7b\u578b\u7684\u5b9e\u9645\u6263\u9664\u989d\u7684\u89c4\u5219\u5361\u7247\u53ea\u80fd\u5b58\u5728\u4e00\u6761\uff0c\u4ee5\u4e0b\u4e3a\u91cd\u590d\u89c4\u5219\uff1a%1$s,%2$s\u3002", (String)"SbxSharePlanFormPlugin_11", (String)"taxc-tcvat", (Object[])new Object[0]), a.getString("number"), b.getString("number"));
            }
        }
        return null;
    }

    public static String diffPublicRuleRepeatWithPrivate(DynamicObject[] publicRules, DynamicObject[] privateRules) {
        for (DynamicObject a : publicRules) {
            for (DynamicObject b : privateRules) {
                if (!DiffDeductionOpService.isRepeat(a, b)) continue;
                return String.format(ResManager.loadKDString((String)"\u4e00\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\u540c\u4e00\u4e2a\u5dee\u989d\u6263\u9664\u7c7b\u578b\u7684\u5b9e\u9645\u6263\u9664\u989d\u7684\u89c4\u5219\u5361\u7247\u53ea\u80fd\u5b58\u5728\u4e00\u6761\uff0c%1$s\u5df2\u5b58\u5728\u4e00\u6761\u81ea\u7528\u7684\u5dee\u989d\u6263\u9664\u89c4\u5219\u5361\u7247\uff1a%2$s\u3002", (String)"SbxSharePlanFormPlugin_12", (String)"taxc-tcvat", (Object[])new Object[0]), b.getString("org.name"), b.getString("number"));
            }
        }
        return null;
    }

    public static String diffPublicRuleRepeatWithPublic(DynamicObject[] shareRuleList, List<DynamicObject> shareOrgs, List<SharePlanEntity> plans) {
        for (DynamicObject shareRule : shareRuleList) {
            for (DynamicObject shareOrg : shareOrgs) {
                for (SharePlanEntity plan : plans) {
                    for (DynamicObject sharedRule : plan.getRules()) {
                        for (Long sharedOrg : plan.getOrgIds()) {
                            if (shareOrg.getLong("id") != sharedOrg.longValue() || !DiffDeductionOpService.isRepeat(shareRule, sharedRule)) continue;
                            return String.format(ResManager.loadKDString((String)"\u4e00\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\u540c\u4e00\u4e2a\u5dee\u989d\u6263\u9664\u7c7b\u578b\u7684\u5b9e\u9645\u6263\u9664\u989d\u7684\u89c4\u5219\u5361\u7247\u53ea\u80fd\u5b58\u5728\u4e00\u6761\uff0c%1$s\u5df2\u5728%2$s\u5171\u4eab\u65b9\u6848\u4e2d\u88ab\u5206\u914d%3$s\u89c4\u5219\u3002", (String)"SbxSharePlanFormPlugin_13", (String)"taxc-tcvat", (Object[])new Object[0]), shareOrg.getString("name"), plan.getNumber(), sharedRule.getString("number"));
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isRepeat(DynamicObject source, DynamicObject target) {
        return source.getString("taxpayertype").equals(target.getString("taxpayertype")) && source.getLong("difftype.id") == target.getLong("difftype.id") && source.getString("deductproject").equals(target.getString("deductproject")) && DiffDeductionOpService.rulePurposeExists(source.getString("rulepurpose"), target.getString("rulepurpose"));
    }

    private static String checkRepeatWithDbPrivate(DynamicObject rule) {
        Long orgId = rule.getLong("org.id");
        String taxpayertype = rule.getString("taxpayertype");
        String rulepurpose = rule.getString("rulepurpose");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", (Object)taxpayertype);
        QFilter difftypeFilter = new QFilter("difftype", "=", (Object)rule.getLong("difftype.id"));
        QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"private");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter deductProjectFilter = new QFilter("deductproject", "=", (Object)"bqsjkce");
        DynamicObjectCollection rules = QueryServiceHelper.query((String)rule.getDataEntityType().getName(), (String)"number,rulepurpose", (QFilter[])new QFilter[]{orgFilter, taxpayertypeFilter, difftypeFilter, ruletypeFilter, enableFilter, deductProjectFilter});
        if (!CollectionUtils.isEmpty((Collection)rules)) {
            DynamicObject dbRule = (DynamicObject)rules.get(0);
            String dbRulePurpose = dbRule.getString("rulepurpose");
            if (!dbRule.getString("number").equals(rule.getString("number")) && DiffDeductionOpService.rulePurposeExists(dbRulePurpose, rulepurpose)) {
                return String.format(ResManager.loadKDString((String)"\u6b64\u7a0e\u52a1\u7ec4\u7ec7\u5df2\u5b58\u5728\u540c\u4e00\u4e2a\u5dee\u989d\u6263\u9664\u7c7b\u578b\u7684\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u89c4\u5219\u914d\u7f6e%s\uff0c\u8bf7\u52ff\u91cd\u65b0\u914d\u7f6e\u3002", (String)"DiffDeductionSaveOp_1", (String)"taxc-tcvat", (Object[])new Object[0]), dbRule.getString("number"));
            }
        }
        return null;
    }

    public static boolean rulePurposeExists(String sourceRulePurpose, String targetRulePurpose) {
        String[] split1 = sourceRulePurpose.split(",");
        String[] split2 = targetRulePurpose.split(",");
        for (String s : split1) {
            if (!Arrays.asList(split2).contains(s) || !StringUtil.isNotBlank((CharSequence)s)) continue;
            return true;
        }
        return false;
    }

    public static List<SharePlanEntity> querySharePlanByFilters(QFilter[] filters) {
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"tcvat_sbx_shareplan", (String)"number,orgentity.org,ruleentity.rule", (QFilter[])filters);
        if (rules == null || rules.length == 0) {
            return new ArrayList<SharePlanEntity>();
        }
        ArrayList<SharePlanEntity> plans = new ArrayList<SharePlanEntity>(rules.length);
        for (DynamicObject rule : rules) {
            SharePlanEntity plan = new SharePlanEntity();
            plan.setNumber(rule.getString("number"));
            List<DynamicObject> entryRules = rule.getDynamicObjectCollection("ruleentity").stream().map(r -> r.getDynamicObject("rule")).collect(Collectors.toList());
            plan.setRules(entryRules);
            List<Long> entryOrgIds = rule.getDynamicObjectCollection("orgentity").stream().map(r -> r.getLong("org.id")).collect(Collectors.toList());
            plan.setOrgIds(entryOrgIds);
            plans.add(plan);
        }
        return plans;
    }
}

