/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.sjjt.provision;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.subplugin.provision.IProvisionFieldSubPlugin;
import kd.taxc.bdtaxr.business.subplugin.provision.args.ProvisionFieldBeforeArgs;
import kd.taxc.bdtaxr.business.subplugin.provision.impl.DefaultProvisionFieldSubPlugin;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleAmountDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleFetchDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleQueryDto;
import kd.taxc.bdtaxr.common.dto.ProvisionRuleResultDto;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationSysEnum;
import kd.taxc.bdtaxr.common.helper.ProvisionOpHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionRuleDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GenerateProvisionBillService {
    public static final String ITP_PROVISTON_ITEM = "itp_proviston_item";
    public static final String TCVAT_SJJT_DRAFT_QUERY = "tcvat_sjjt_draft_query";
    public static final String TPO_DECLARE_MAIN_TSD = "tpo_declare_main_tsd";
    private static final Log LOGGER = LogFactory.getLog(GenerateProvisionBillService.class);

    public Map<Boolean, Map<Long, String>> generateProvisionBill(List<Long> draftIdList) {
        ArrayList<Object> requestParamList = new ArrayList<Object>(12);
        HashMap<Boolean, Map<Long, String>> responseMap = new HashMap<Boolean, Map<Long, String>>();
        HashMap successMap = new HashMap();
        HashMap failMap = new HashMap();
        responseMap.put(Boolean.TRUE, successMap);
        responseMap.put(Boolean.FALSE, failMap);
        if (ObjectUtils.isEmpty(draftIdList)) {
            return responseMap;
        }
        HashMap<String, Long> draftMap = new HashMap<String, Long>(12);
        this.createRequestParam(draftIdList, requestParamList, draftMap);
        String responseList = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(requestParamList)});
        BaseResult data = (BaseResult)SerializationUtils.fromJsonString((String)responseList, BaseResult.class);
        if (data.getCode().equals(BaseResult.OK)) {
            List responses = (List)data.getData();
            responses.stream().forEach(rowMap -> {
                for (Map.Entry entry : rowMap.entrySet()) {
                    String draftBillNo = (String)entry.getKey();
                    successMap.put(draftMap.get(draftBillNo), "");
                }
            });
        }
        return responseMap;
    }

    private void createRequestParam(List<Long> draftIdList, ArrayList<Object> requestParamList, Map<String, Long> draftMap) {
        DynamicObject[] draftObjects = BusinessDataServiceHelper.load((Object[])draftIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_SJJT_DRAFT_QUERY));
        ArrayList<ProvisionRuleQueryDto> queryDtoList = new ArrayList<ProvisionRuleQueryDto>(draftObjects.length);
        for (DynamicObject draftObject : draftObjects) {
            List<Long> taxTypeIds = this.getTaxTypeIds();
            for (Long l : taxTypeIds) {
                ProvisionRuleQueryDto dto = new ProvisionRuleQueryDto();
                dto.setOrgId(Long.valueOf(draftObject.getDynamicObject("org").getLong("id")));
                dto.setTaxationsysId(TaxationSysEnum.CHAIN_MAINLAND.getId());
                dto.setTaxtype(l);
                dto.setTemplateType(draftObject.getString("templatetype"));
                queryDtoList.add(dto);
            }
            draftMap.put(draftObject.getString("billno"), draftObject.getLong("id"));
        }
        TaxResult provisionRules = ProvisionRuleDataServiceHelper.getProvisionRules(queryDtoList);
        List data = (List)provisionRules.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            Map<String, List<ProvisionRuleResultDto>> ruleMaps = data.stream().collect(Collectors.groupingBy(o -> o.getOrgId() + "_" + o.getTemplateType()));
            Map<Long, DynamicObject> ruleIdMap = data.stream().map(ProvisionRuleResultDto::getRules).flatMap(Collection::stream).collect(Collectors.toMap(o -> o.getLong("id"), o -> o, (o1, o2) -> o1));
            ArrayList<ProvisionRuleFetchDto> fetchDtoList = new ArrayList<ProvisionRuleFetchDto>();
            HashMap<Long, DynamicObject> draftIdMap = new HashMap<Long, DynamicObject>(draftObjects.length);
            for (DynamicObject draftObject : draftObjects) {
                draftIdMap.put(draftObject.getLong("id"), draftObject);
                String key = draftObject.getDynamicObject("org").getLong("id") + "_" + draftObject.getString("templatetype");
                List<ProvisionRuleResultDto> list = ruleMaps.get(key);
                if (!CollectionUtils.isNotEmpty(list)) continue;
                for (ProvisionRuleResultDto ruleResultDto : list) {
                    List ruleIds = ruleResultDto.getRuleIds();
                    for (Long ruleId : ruleIds) {
                        ProvisionRuleFetchDto fetchDto = new ProvisionRuleFetchDto();
                        fetchDto.setId(Long.valueOf(draftObject.getLong("id")));
                        fetchDto.setOrgId(Long.valueOf(draftObject.getDynamicObject("org").getLong("id")));
                        fetchDto.setStartDate(draftObject.getDate("skssqq"));
                        fetchDto.setEndDate(draftObject.getDate("skssqz"));
                        fetchDto.setRuleId(ruleId);
                        fetchDtoList.add(fetchDto);
                    }
                }
            }
            TaxResult taxResult = ProvisionRuleDataServiceHelper.getProvisionRuleAmount(fetchDtoList);
            List resultList = (List)taxResult.getData();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
                HashMap<Long, DynamicObject> itemMap = new HashMap<Long, DynamicObject>();
                for (ProvisionRuleAmountDto provisionRuleAmountDto : resultList) {
                    DynamicObject rule = ruleIdMap.get(provisionRuleAmountDto.getRuleId());
                    if (rule == null || rule.get("provistonitem") == null) continue;
                    DynamicObject item = rule.getDynamicObject("provistonitem");
                    long itemId = item.getLong("id");
                    itemMap.put(itemId, item);
                    Long draftId = provisionRuleAmountDto.getId();
                    String key = draftId + "_" + itemId;
                    BigDecimal total = amountMap.computeIfAbsent(key, e -> BigDecimal.ZERO);
                    BigDecimal fetchAmount = provisionRuleAmountDto.getFetchAmount();
                    if ("NTE-ZERO".equals(rule.getString("generatecondition")) && BigDecimal.ZERO.compareTo(fetchAmount) == 0) continue;
                    total = total.add(fetchAmount);
                    amountMap.put(key, total);
                }
                for (Map.Entry entry : amountMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String[] split = key.split("_");
                    if (split.length != 2) continue;
                    long draftId = Long.parseLong(split[0]);
                    long itemId = Long.parseLong(split[1]);
                    BigDecimal amount = (BigDecimal)entry.getValue();
                    Long[] provisionItemArray = new Long[]{itemId, ((DynamicObject)itemMap.get(itemId)).getLong("taxtype.id")};
                    DynamicObject draft = (DynamicObject)draftIdMap.get(draftId);
                    if (draft == null) continue;
                    requestParamList.add(this.createParamsMap(provisionItemArray, amount, draft));
                }
            }
        }
    }

    private List<Long> getTaxTypeIds() {
        return Arrays.asList(1L, 6L, 19L, 20L);
    }

    private Map<String, Object> createParamsMap(Long[] provisionItemArray, BigDecimal amount, DynamicObject draftDynmicObject) {
        Map<String, Object> map = new HashMap<String, Object>(16);
        if (draftDynmicObject == null) {
            return map;
        }
        DefaultProvisionFieldSubPlugin plugin = new DefaultProvisionFieldSubPlugin();
        PluginProxy pluginProxy = PluginProxy.create((Object)plugin, IProvisionFieldSubPlugin.class, (String)"kd.taxc.bdtaxr.business.subplugin.provision.IProvisionFieldSubPlugin", null);
        ProvisionFieldBeforeArgs args = new ProvisionFieldBeforeArgs();
        args.setId(Long.valueOf(draftDynmicObject.getLong("id")));
        args.setDraftEntity(draftDynmicObject.getDynamicObjectType().getName());
        List list = pluginProxy.callReplaceIfPresent(p -> p.beforeSave(args));
        if (list != null && list.size() > 0) {
            map = (Map)list.get(0);
        }
        map.put("coins", 1);
        map.put("provistonitem", provisionItemArray[0]);
        map.put("taxorg", draftDynmicObject.getLong("org.id"));
        map.put("taxsystem", draftDynmicObject.getLong("taxsystem.id"));
        map.put("taxtype", provisionItemArray[1]);
        map.put("startdate", draftDynmicObject.get("skssqq"));
        map.put("enddate", draftDynmicObject.get("skssqz"));
        map.put("entitynumber", draftDynmicObject.getString("billno"));
        map.put("accountsettype", "");
        String templatetype = draftDynmicObject.getString("templatetype");
        map.put("sourcedrafttype", ProvisionOpHelper.getTemplateType((String)templatetype));
        map.put("entitytype", TPO_DECLARE_MAIN_TSD);
        TaxResult orgId = OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)draftDynmicObject.getLong("org.id"));
        map.put("accountorg", orgId.getData());
        Date entrydate = draftDynmicObject.getDate("skssqz");
        if ("VAT_RTA".equals(templatetype)) {
            entrydate = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)entrydate, (int)1));
        }
        map.put("entrydate", entrydate);
        map.put("total", amount);
        map.put("creator", RequestContext.get().getCurrUserId());
        map.put("modifier", RequestContext.get().getCurrUserId());
        return map;
    }
}

