/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.sjjt.provisionitem;

import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.hz.HzActualDeductionProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.hz.HzDeductionProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.hz.HzJzjtYsjeProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.hz.HzUnpaidVATProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.rta.JjdjfseJzjtProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.rta.JjdjfseYbxmProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.rta.JzjtytsjeProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.rta.SjjzdjseJzjtProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.rta.SjjzdjseYbxmProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.rta.ZzsybtseJzjtProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.rta.ZzsybtseYbxmProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.xgm.FjsfCswhjssProvisionItemXgmStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.xgm.FjsfDfjyffjProvisionItemXgmStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.xgm.FjsfJyffjProvisionItemXgmStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.xgm.TaxPayableProvisionItemXgmStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.xgm.TaxReductionBqfseProvisionItemXgmStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.xgm.TaxReductionSjdjseProvisionItemXgmStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.ActualDeductionProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.DeductionProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.FjsfCswhjssProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.FjsfDfjyffjProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.FjsfJyffjProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.JzjtYsjeProvisionItemStrategy;
import kd.taxc.tcvat.business.service.sjjt.provisionitem.ybnsr.UnpaidVATProvisionItemStrategy;

public class ProvisionItemStrategyFactory {
    private static final Log LOGGER = LogFactory.getLog(ProvisionItemStrategyFactory.class);
    private static final Map<String, Map<String, ProvisionItemStrategy>> strategyMap = new HashMap<String, Map<String, ProvisionItemStrategy>>();

    private ProvisionItemStrategyFactory() {
    }

    private static void init() {
        Map ybnsrMap = strategyMap.computeIfAbsent("draft_zzsybnsr_sjjt", s -> new HashMap());
        Map ybhzMap = strategyMap.computeIfAbsent("draft_zzsybnsr_ybhz_sjjt", s -> new HashMap());
        Map yzMap = strategyMap.computeIfAbsent("draft_zzsybnsr_yz_zjg_sjjt", s -> new HashMap());
        Map jhzMap = strategyMap.computeIfAbsent("draft_zzsybnsr_hz_zjg_sjjt", s -> new HashMap());
        Map xgmMap = strategyMap.computeIfAbsent("draft_zzsxgmnsr_sjjt", s -> new HashMap());
        Map rtaMap = strategyMap.computeIfAbsent("VAT_RTA", s -> new HashMap());
        ybnsrMap.put("JTSX-0009", new ActualDeductionProvisionItemStrategy());
        ybnsrMap.put("JTSX-0010", new UnpaidVATProvisionItemStrategy());
        ybnsrMap.put("JTSX-0011", new DeductionProvisionItemStrategy());
        ybnsrMap.put("JTSX-0012", new FjsfCswhjssProvisionItemStrategy());
        ybnsrMap.put("JTSX-0013", new FjsfJyffjProvisionItemStrategy());
        ybnsrMap.put("JTSX-0014", new FjsfDfjyffjProvisionItemStrategy());
        ybnsrMap.put("JTSX-0032", new JzjtYsjeProvisionItemStrategy());
        ybhzMap.put("JTSX-0009", new HzActualDeductionProvisionItemStrategy());
        ybhzMap.put("JTSX-0010", new HzUnpaidVATProvisionItemStrategy());
        ybhzMap.put("JTSX-0011", new HzDeductionProvisionItemStrategy());
        ybhzMap.put("JTSX-0032", new HzJzjtYsjeProvisionItemStrategy());
        yzMap.putAll(ybhzMap);
        jhzMap.putAll(ybhzMap);
        xgmMap.put("JTSX-0012", new FjsfCswhjssProvisionItemXgmStrategy());
        xgmMap.put("JTSX-0013", new FjsfJyffjProvisionItemXgmStrategy());
        xgmMap.put("JTSX-0014", new FjsfDfjyffjProvisionItemXgmStrategy());
        xgmMap.put("JTSX-0015", new TaxPayableProvisionItemXgmStrategy());
        xgmMap.put("JTSX-0016", new TaxReductionBqfseProvisionItemXgmStrategy());
        xgmMap.put("JTSX-0017", new TaxReductionSjdjseProvisionItemXgmStrategy());
        rtaMap.put("JTSX-0045", new JjdjfseYbxmProvisionItemStrategy());
        rtaMap.put("JTSX-0046", new JjdjfseJzjtProvisionItemStrategy());
        rtaMap.put("JTSX-0047", new SjjzdjseYbxmProvisionItemStrategy());
        rtaMap.put("JTSX-0048", new SjjzdjseJzjtProvisionItemStrategy());
        rtaMap.put("JTSX-0049", new ZzsybtseYbxmProvisionItemStrategy());
        rtaMap.put("JTSX-0050", new ZzsybtseJzjtProvisionItemStrategy());
        rtaMap.put("JTSX-0051", new JzjtytsjeProvisionItemStrategy());
    }

    public static ProvisionItemStrategy getStrategy(String templateType, String provisionNumber) {
        Map<String, ProvisionItemStrategy> map = strategyMap.get(templateType);
        if (map != null) {
            return map.get(provisionNumber);
        }
        return null;
    }

    static {
        ProvisionItemStrategyFactory.init();
    }
}

