/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;

public class SqlBuilder {
    private static volatile SqlBuilder instance;
    private static final String INPUT_INVOICE_SIGN_ENTITY_NAME = "tcvat_input_invoice_sign";
    private static final String INPUT_ROLLOUT_REGISTER_ENTITY_NAME = "tcvat_rollout_register";

    private SqlBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlBuilder getInstance() {
        if (instance != null) return instance;
        Class<SqlBuilder> clazz = SqlBuilder.class;
        synchronized (SqlBuilder.class) {
            if (instance != null) return instance;
            instance = new SqlBuilder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static List<QFilter> getRolloutFilterList(String entityName, Long orgid, EngineModel engineModel, QFilter conditionJsonFilter) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        String taxPeriod = "";
        if (!engineModel.getCustom().isEmpty()) {
            taxPeriod = (String)engineModel.getCustom().get("taxperiod");
        }
        Map orgRelationMap = (Map)engineModel.getCustom().get("OrgRelationMap");
        QFilter orgFilter = EngineCalcFilterService.getOrgQfilterByRelation((Map)orgRelationMap, (Long)orgid, (String)entityName, (String)entityName, (String)"org");
        QFilter taxPeriodFilter = new QFilter("rollouttaxperiod", "=", (Object)taxPeriod);
        QFilter rolloutTypeFilter = new QFilter("rollouttype", "!=", (Object)"7");
        QFilter registerFilter = new QFilter("registerstatus", "=", (Object)"1").and("registertype", "=", (Object)"1").and("consumertype", "!=", (Object)"7").and("summaryflag", "=", (Object)"1");
        QFilter apportionFilter = new QFilter("apportionstatus", "=", (Object)"1").and("apportiontype", "=", (Object)"1").and("consumertype", "=", (Object)"7").and("summaryflag", "=", (Object)"0");
        list.add(orgFilter);
        list.add(taxPeriodFilter);
        list.add(rolloutTypeFilter);
        list.add(registerFilter.or(apportionFilter));
        if (null != conditionJsonFilter) {
            list.add(conditionJsonFilter);
        }
        return list;
    }

    private static List<QFilter> getSignFilterList(String entityName, Long orgid, EngineModel engineModel, QFilter conditionJsonFilter) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        String taxPeriod = "";
        if (!engineModel.getCustom().isEmpty()) {
            taxPeriod = (String)engineModel.getCustom().get("taxperiod");
        }
        Map orgRelationMap = (Map)engineModel.getCustom().get("OrgRelationMap");
        QFilter orgFilter = EngineCalcFilterService.getOrgQfilterByRelation((Map)orgRelationMap, (Long)orgid, (String)entityName, (String)entityName, (String)"org");
        QFilter taxPeriodFilter = new QFilter("taxperiod", "=", (Object)taxPeriod);
        QFilter signTypeFilter = new QFilter("signtype", "=", (Object)"3");
        QFilter signStatusFilter = new QFilter("signstatus", "=", (Object)"1");
        QFilter dataTypeFilter = new QFilter("type", "=", (Object)"1");
        list.add(orgFilter);
        list.add(taxPeriodFilter);
        list.add(signTypeFilter);
        list.add(signStatusFilter);
        list.add(dataTypeFilter);
        if (null != conditionJsonFilter) {
            list.add(conditionJsonFilter);
        }
        return list;
    }

    public static BigDecimal querySumTaxAmount(Long orgid, String selectField, String entityName, EngineModel model, QFilter conditionJsonFilter) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        DynamicObjectCollection collection = new DynamicObjectCollection();
        if (StringUtils.equals((CharSequence)INPUT_INVOICE_SIGN_ENTITY_NAME, (CharSequence)entityName)) {
            collection = QueryServiceHelper.query((String)entityName, (String)("sum(" + selectField + ") as taxamount"), (QFilter[])SqlBuilder.getSignFilterList(entityName, orgid, model, conditionJsonFilter).toArray(new QFilter[0]));
        }
        if (StringUtils.equals((CharSequence)INPUT_ROLLOUT_REGISTER_ENTITY_NAME, (CharSequence)entityName)) {
            collection = QueryServiceHelper.query((String)entityName, (String)("sum(" + selectField + ") as taxamount"), (QFilter[])SqlBuilder.getRolloutFilterList(entityName, orgid, model, conditionJsonFilter).toArray(new QFilter[0]));
        }
        if (collection.size() > 0) {
            totalAmount = ((DynamicObject)collection.get(0)).getBigDecimal(0);
        }
        return totalAmount;
    }
}

