/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.taxrefund;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQEvent;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQSender;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQType;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.taxrefund.StateInitDataService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundAccountService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundApplyService;
import org.apache.commons.collections.CollectionUtils;

public class AccountServiceHelper {
    private static final String TCVAT_TAX_REFUND_ACCOUNT_FIELDS = "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,snmzcze,sshydl,skssqq,skssqz,nsxydj,clldse,ktsbl,bqrzxfdzpse,zzszyfpse,amount,bqsqthclldtse,startqmldse,bqksqthldtse,bqsqthzlldtse,sqthxm,ldtssqbbm,tsbljd,zytssj,tsqylx,zzssbbbh,bqdkhgzyjksse,bqjjskwspzse,bqsbdkjxsehj,bqmdtytse,sqmdsedjqs,sqldsets,dqxzkyytcdldtse,ldtsbqkce,sqjckyykcdldtse,jzxqkyykcdldtse,hgzyjksse,ljdkjjkwspzse,ljdkjxse,inputrate,bndzzsysxsehj,sndzzsysxsehj,qygm,summonth,bqksqthzlldse,bqksqthclldse,zlldtserq";
    private TaxRefundApplyService taxRefundApplyService = new TaxRefundApplyService();

    public static boolean existTotalData(Long orgId) {
        return QueryServiceHelper.exists((String)"tcvat_totaldata_init", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
    }

    public static int getTaxLimitSteptSize(String taxlimt) {
        if ("aysb".equals(taxlimt) || taxlimt.equals("month")) {
            return 1;
        }
        if ("ajsb".equals(taxlimt) || taxlimt.equals("season")) {
            return 3;
        }
        return 0;
    }

    public static boolean isJanuaryOrFirstSeaon(String taxlimit, Date skssqq) {
        int taxLimitSteptSize;
        int month = DateUtils.getMonthOfDate((Date)skssqq);
        return month - (taxLimitSteptSize = AccountServiceHelper.getTaxLimitSteptSize(taxlimit)) <= 0;
    }

    public static boolean existAccountDataWithDate(Long orgId, Date skssqq, Date skssqz) {
        return QueryServiceHelper.exists((String)"tcvat_tax_refund_manage_a", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)skssqz)});
    }

    public static DynamicObject getAccountDataWithDate(Long orgId, Date skssqq, Date skssqz) {
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_tax_refund_manage_a", (String)TCVAT_TAX_REFUND_ACCOUNT_FIELDS, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)skssqz)});
    }

    public DynamicObject[] getAccountDataByRange(Set<Long> orgIdList) {
        return BusinessDataServiceHelper.load((String)"tcvat_tax_refund_manage_a", (String)TCVAT_TAX_REFUND_ACCOUNT_FIELDS, (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgIdList.toArray())});
    }

    public static boolean isBiggerZeroAccountData(Long orgId, Date skssqq) {
        DynamicObjectCollection accountData = QueryServiceHelper.query((String)"tcvat_tax_refund_manage_a", (String)"bqsqthclldtse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId).and(new QFilter("skssqz", "<", (Object)skssqq))});
        return CollectionUtils.isEmpty((Collection)accountData) ? Boolean.FALSE.booleanValue() : accountData.stream().filter(s -> s.getBigDecimal("bqsqthclldtse").compareTo(BigDecimal.ZERO) > 0).findAny().isPresent();
    }

    public static boolean isBiggerZeroInitData(Long orgId, Date skssqq) {
        DynamicObjectCollection accountData = QueryServiceHelper.query((String)"tcvat_statet_init", (String)"stockbackamount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId).and(new QFilter("skssqz", "<", (Object)skssqq))});
        return CollectionUtils.isEmpty((Collection)accountData) ? Boolean.FALSE.booleanValue() : accountData.stream().filter(s -> s.getBigDecimal("stockbackamount").compareTo(BigDecimal.ZERO) > 0).findAny().isPresent();
    }

    public static DynamicObject getLastAccountData(Long orgId, Date skssqq, Date skssqz) {
        Map preTaxPeriodMap = DateUtils.getPrePeriodByTaxLimit((Date)skssqq, (String)DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
        if (preTaxPeriodMap.size() == 0) {
            return null;
        }
        return AccountServiceHelper.getCurrentDynamicObject(orgId, (Date)preTaxPeriodMap.get("startDate"), (Date)preTaxPeriodMap.get("endDate"), 0, "tcvat_tax_refund_manage_a", TCVAT_TAX_REFUND_ACCOUNT_FIELDS);
    }

    public static DynamicObject getLastTotalInitData(Long orgId, Date skssqq, Date skssqz) {
        Map preTaxPeriodMap = DateUtils.getPrePeriodByTaxLimit((Date)skssqq, (String)DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
        if (preTaxPeriodMap.size() == 0) {
            return null;
        }
        return AccountServiceHelper.getCurrentDynamicObject(orgId, (Date)preTaxPeriodMap.get("startDate"), (Date)preTaxPeriodMap.get("endDate"), 0, "tcvat_totaldata_init", "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,sndcxqjxse,sndzzsysxsehj,datasource,snmzcze,zzszyfpse,hgzyjksse,ljdkjjkwspzse,ljdkjxse,totalmonth,inputrate,skssqq,skssqz");
    }

    private static DynamicObject getCurrentDynamicObject(Long orgId, Date skssqq, Date skssqz, int deductMonth, String entityName, String fieldName) {
        Date sdate = DateUtils.addMonth((Date)skssqq, (int)deductMonth);
        Date edate = DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)skssqz, (int)deductMonth));
        DynamicObject accountData = QueryServiceHelper.queryOne((String)entityName, (String)fieldName, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", "=", (Object)sdate), new QFilter("skssqz", "=", (Object)edate)});
        return accountData;
    }

    public static String getCompanyCredit(Long orgId, Date skssqq) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            List collect = ((DynamicObject)result.getData()).getDynamicObjectCollection("taxcreditrating").stream().filter(d -> d.getDate("year") != null && d.getDate("year").compareTo(DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)skssqq, (int)-1))) >= 0 && d.getDate("year").compareTo(DateUtils.getLastDateOfYear1((Date)skssqq)) <= 0).sorted((o1, o2) -> o2.getDate("year").compareTo(o1.getDate("year"))).collect(Collectors.toList());
            return collect.stream().map(s -> s.getString("creditlevel")).findFirst().orElse("");
        }
        return "";
    }

    public static DynamicObject getInitBqqmldse(String entityName, Long orgId, String taxlimit, Date date) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"amount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", "=", (Object)DateUtils.getFirstDateOfMonth((Date)date)), new QFilter("skssqz", "=", (Object)("aysb".equals(taxlimit) ? DateUtils.getLastDateOfMonth2((Date)date) : DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)date))))});
        return dynamicObject;
    }

    public static BigDecimal getInitBqqmldse(String entityName, Long orgId, Date date) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"amount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)date))});
        return null == dynamicObject ? BigDecimal.ZERO : dynamicObject.getBigDecimal("amount");
    }

    public static DynamicObject getFjsfDyo(DynamicObject declareDyo) {
        return QueryServiceHelper.queryOne((String)"tcvat_sb_fjsf", (String)"ldtsbqkce", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)declareDyo.getString("id")), new QFilter("ewblxh", "=", (Object)"1")});
    }

    public Set<String> conflictOrgName(Object[] successPkIds) {
        DynamicObject[] taxRefundAccountArray = this.getExistTaxrefundAccountByOrg(successPkIds);
        HashSet<String> conflictOrgName = new HashSet<String>(taxRefundAccountArray.length);
        if (taxRefundAccountArray.length == 0) {
            return conflictOrgName;
        }
        for (DynamicObject taxRefundAccount : taxRefundAccountArray) {
            conflictOrgName.add(taxRefundAccount.getDynamicObject("org").getString("name"));
        }
        return conflictOrgName;
    }

    public Set<String> checkTaxRefundApply(Object[] successPkIds) {
        DynamicObject[] taxRefundApplyArray;
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((Object[])successPkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_totaldata_init"));
        HashSet<String> conflictOrgName = new HashSet<String>(dynamicObject.length);
        if (dynamicObject.length == 0) {
            return conflictOrgName;
        }
        HashSet<Long> orgidList = new HashSet<Long>(dynamicObject.length);
        for (DynamicObject object : dynamicObject) {
            orgidList.add(object.getLong("org.id"));
        }
        for (DynamicObject taxRefundApply : taxRefundApplyArray = this.taxRefundApplyService.queryTaxRefundApplyByRange(orgidList)) {
            conflictOrgName.add(taxRefundApply.getString("org.name"));
        }
        return conflictOrgName;
    }

    public List<Long> conflictOrgId(Object[] successPkIds) {
        ArrayList<Long> conflictOrgId = new ArrayList<Long>(successPkIds.length);
        DynamicObject[] taxRefundAccountArray = this.getExistTaxrefundAccountByOrg(successPkIds);
        if (taxRefundAccountArray.length == 0) {
            return conflictOrgId;
        }
        for (DynamicObject taxRefundAccount : taxRefundAccountArray) {
            conflictOrgId.add(taxRefundAccount.getLong("org.id"));
        }
        return conflictOrgId;
    }

    private DynamicObject[] getExistTaxrefundAccountByOrg(Object[] successPkIds) {
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((Object[])successPkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvat_totaldata_init"));
        HashSet<Long> orgidList = new HashSet<Long>(dynamicObject.length);
        for (DynamicObject object : dynamicObject) {
            orgidList.add(object.getLong("org.id"));
        }
        DynamicObject[] taxRefundAccountArray = this.getAccountDataByRange(orgidList);
        return taxRefundAccountArray;
    }

    public void deleteAllData(Object[] successPkIds) {
        List<Long> list = this.conflictOrgId(successPkIds);
        AccountServiceHelper.delteAccountData(list);
        StateInitDataService.delteTotalInitData(successPkIds);
    }

    public static void delteAccountData(List<Long> orgIds) {
        DynamicObjectCollection taxRefundAccount = QueryServiceHelper.query((String)"tcvat_tax_refund_manage_a", (String)"id,org,skssqq,skssqz,bqsqthclldtse,bqsqthzlldtse", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        ArrayList<Date> skssqqList = new ArrayList<Date>(taxRefundAccount.size());
        ArrayList<Date> skssqzList = new ArrayList<Date>(taxRefundAccount.size());
        ArrayList<Long> idList = new ArrayList<Long>(taxRefundAccount.size());
        for (DynamicObject object : taxRefundAccount) {
            idList.add(object.getLong("id"));
            skssqqList.add(object.getDate("skssqq"));
            skssqzList.add(object.getDate("skssqz"));
        }
        ArrayList<DynamicObject> declareReportList = new ArrayList<DynamicObject>(taxRefundAccount.size());
        AccountServiceHelper.buildUpdateDeclareReport(declareReportList, orgIds, skssqqList, skssqzList);
        SaveServiceHelper.save((DynamicObject[])declareReportList.toArray(new DynamicObject[0]));
        DeleteServiceHelper.delete((String)"tcvat_tax_refund_manage_a", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        TaxRefundMQSender.sendMQ((List)taxRefundAccount, (String)TaxRefundMQType.TAX_REFUND.name(), (String)TaxRefundMQEvent.DELETE.name());
    }

    private static void buildUpdateDeclareReport(List<DynamicObject> declareReportList, List<Long> orgidList, List<Date> skssqqList, List<Date> skssqzList) {
        QFilter filterList = new QFilter("org", "in", orgidList).and(new QFilter("skssqq", "in", skssqqList)).and(new QFilter("skssqz", "in", skssqzList)).and(new QFilter("type", "in", Arrays.asList("zzsybnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg")));
        DynamicObject[] declareReport = BusinessDataServiceHelper.load((String)"tcvat_zzs_declare_list", (String)"id,billno,billstatus,creator,auditor,modifier,auditdate,createtime,modifytime,ewblxh,nsrsbh,templateid,sshymc,fddbrxm,zcdz,scjydz,khyh,yhzh,registertype,phonenum,yssr,nsrmc,datatype,taxlimit,declaretype,paytype,paydate,paystatus,declarer,payer,declarestatus,sbrq,type,skssqq,skssqz,bqybtse,org,riskcontent,ismodified,archivestatus,archivetime,taxrefundstatus", (QFilter[])new QFilter[]{filterList});
        if (null == declareReport || declareReport.length == 0) {
            return;
        }
        for (DynamicObject report : declareReport) {
            report.set("taxrefundstatus", (Object)"yc");
            declareReportList.add(report);
        }
        AccountServiceHelper.updateTaxRefundDetail(declareReport);
    }

    private static void updateTaxRefundDetail(DynamicObject[] declareReport) {
        TaxRefundAccountService taxRefundAccountService = new TaxRefundAccountService();
        DynamicObjectCollection taxRefundStatusDetailCollection = new DynamicObjectCollection();
        ArrayList<Long> declareReportIdList = new ArrayList<Long>(declareReport.length);
        for (DynamicObject report : declareReport) {
            declareReportIdList.add(report.getLong("id"));
            taxRefundAccountService.createTaxRefundDetail((List<DynamicObject>)taxRefundStatusDetailCollection, report, "datainit");
        }
        taxRefundAccountService.deleteTaxRefundDetail(declareReportIdList);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])taxRefundStatusDetailCollection.toArray((Object[])new DynamicObject[0])));
    }
}

