/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.taxrefund;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.common.util.ZzsOrgCheckUtil;
import org.apache.commons.collections.CollectionUtils;

public class StateInitDataService {
    public static final List<String> TYPELIST = Lists.newArrayList((Object[])new String[]{"zzsybnsr", "zzsybnsr_zjg", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg"});

    public void setInitData(List<DynamicObject> stateInitList, Long orgId, List<Long> conflictIdList, Map<Long, String> confilctMap) {
        Date startDate = DateUtils.stringToDate((String)"2019-03-01");
        Date skssqq = DateUtils.getFirstDateOfMonth((Date)startDate);
        Date skssqz = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth1((Date)new Date()));
        DynamicObject[] declareDyoArray = StateInitDataService.getAllDeclareReport(orgId, skssqq, skssqz);
        DynamicObjectCollection initDataCollection = StateInitDataService.getAllInitData(orgId, skssqq, skssqz, "tcvat_statet_init");
        Map<String, List<DynamicObject>> initDataMap = initDataCollection.stream().collect(Collectors.groupingBy(s -> String.format("%s_%s_%s", s.getString("org"), DateUtils.format((Date)s.getDate("skssqq"), (String)"yyyyMM"), DateUtils.format((Date)s.getDate("skssqz"), (String)"yyyyMM"))));
        for (DynamicObject object : declareDyoArray) {
            List<DynamicObject> dynamicObjectList = initDataMap.get(String.format("%s_%s_%s", object.getDynamicObject("org").getString("id"), DateUtils.format((Date)object.getDate("skssqq"), (String)"yyyyMM"), DateUtils.format((Date)object.getDate("skssqz"), (String)"yyyyMM")));
            if (null != dynamicObjectList && dynamicObjectList.size() > 0) {
                DynamicObject initData = dynamicObjectList.get(0);
                this.doConfictDate(conflictIdList, confilctMap, initData);
                continue;
            }
            this.setStateInitData(stateInitList, object.getDynamicObject("org").getLong("id"), object.getDate("skssqq"), object.getDate("skssqz"));
        }
    }

    private void doConfictDate(List<Long> conflictIdList, Map<Long, String> confilctMap, DynamicObject initData) {
        long id = initData.getLong("id");
        conflictIdList.add(id);
        String start = DateUtils.format((Date)initData.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
        String end = DateUtils.format((Date)initData.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
        confilctMap.put(id, start + "-" + end);
    }

    private void setStateInitData(List<DynamicObject> stateInitList, Long orgId, Date skssqq, Date skssqz) {
        long operator = RequestContext.get().getCurrUserId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_statet_init");
        dynamicObject.set("billno", (Object)DeclareServiceHelper.generateSBBNo((String)"tcvat_statet_init"));
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        dynamicObject.set("datasource", (Object)"0");
        dynamicObject.set("amount", (Object)this.getQmldtse(orgId, skssqq, skssqz, "qmldse"));
        dynamicObject.set("increbackamount", (Object)this.getJybfnsjcybjse(orgId, skssqq, skssqz, "22"));
        dynamicObject.set("stockbackamount", (Object)BigDecimal.ZERO);
        dynamicObject.set("creator", (Object)operator);
        dynamicObject.set("modifier", (Object)operator);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifytime", (Object)new Date());
        stateInitList.add(dynamicObject);
    }

    public void updateConfilctData(Long orgId, List<Long> conflictIdList) {
        ArrayList coverStateInitList = new ArrayList();
        conflictIdList.forEach(id -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcvat_statet_init");
            Date skssqq = dynamicObject.getDate("skssqq");
            Date skssqz = dynamicObject.getDate("skssqz");
            dynamicObject.set("amount", (Object)this.getQmldtse(orgId, skssqq, skssqz, "qmldse"));
            dynamicObject.set("increbackamount", (Object)this.getJybfnsjcybjse(orgId, skssqq, skssqz, "22"));
            coverStateInitList.add(dynamicObject);
        });
        SaveServiceHelper.save((DynamicObject[])coverStateInitList.toArray(new DynamicObject[coverStateInitList.size()]));
    }

    public BigDecimal getQmldtse(Long orgId, Date skssqq, Date skssqz, String seName) {
        DynamicObject declareReport = StateInitDataService.getDeclareReport(orgId, skssqq, skssqz);
        return StateInitDataService.getZbDyoSe(declareReport, seName);
    }

    public BigDecimal getJybfnsjcybjse(Long orgId, Date skssqq, Date skssqz, String ewblxh) {
        DynamicObject declareDyo = StateInitDataService.getDeclareDyo(orgId, skssqq, skssqz);
        return StateInitDataService.getFbSecondDyo(declareDyo, ewblxh);
    }

    public static DynamicObject getDeclareDyo(Long orgId, Date skssqq, Date skssqz) {
        return QueryServiceHelper.queryOne((String)"tcvat_zzs_declare_list", (String)"billno,billstatus,creator,auditor,modifier,auditdate,createtime,modifytime,ewblxh,nsrsbh,templateid,sshymc,fddbrxm,zcdz,scjydz,khyh,yhzh,registertype,phonenum,yssr,nsrmc,datatype,taxlimit,declaretype,paytype,paydate,paystatus,declarer,payer,declarestatus,sbrq,type,skssqq,skssqz,bqybtse,org,riskcontent,ismodified,archivestatus,archivetime,taxrefundstatus,entryentity.taxtypes,entryentity.bqdybtse,entryentity.deferpayapply,entryentity.sjje,entryentity.qjje,id,entryentity.id,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)skssqz)), new QFilter("type", "in", TYPELIST)});
    }

    public static DynamicObject getAuditDeclareDyo(Long orgId, Date skssqq, Date skssqz) {
        return QueryServiceHelper.queryOne((String)"tcvat_zzs_declare_list", (String)"billno,billstatus,creator,auditor,modifier,auditdate,createtime,modifytime,ewblxh,nsrsbh,templateid,sshymc,fddbrxm,zcdz,scjydz,khyh,yhzh,registertype,phonenum,yssr,nsrmc,datatype,taxlimit,declaretype,paytype,paydate,paystatus,declarer,payer,declarestatus,sbrq,type,skssqq,skssqz,bqybtse,org,riskcontent,ismodified,archivestatus,archivetime,taxrefundstatus,entryentity.taxtypes,entryentity.bqdybtse,entryentity.deferpayapply,entryentity.sjje,entryentity.qjje,id,entryentity.id,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)skssqz)), new QFilter("billstatus", "=", (Object)"C"), new QFilter("type", "in", TYPELIST)});
    }

    public static DynamicObject getDeclareReport(Long orgId, Date skssqq, Date skssqz) {
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_zzs_declare_list", (String)"billno,billstatus,creator,auditor,modifier,auditdate,createtime,modifytime,ewblxh,nsrsbh,templateid,sshymc,fddbrxm,zcdz,scjydz,khyh,yhzh,registertype,phonenum,yssr,nsrmc,datatype,taxlimit,declaretype,paytype,paydate,paystatus,declarer,payer,declarestatus,sbrq,type,skssqq,skssqz,bqybtse,org,riskcontent,ismodified,archivestatus,archivetime,taxrefundstatus,entryentity.taxtypes,entryentity.bqdybtse,entryentity.deferpayapply,entryentity.sjje,entryentity.qjje,id,entryentity.id,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)skssqz)), new QFilter("type", "in", TYPELIST)});
    }

    public static DynamicObject[] getAllDeclareReportByCondition(Long orgId, Date skssqq, Date skssqz) {
        return BusinessDataServiceHelper.load((String)"tcvat_zzs_declare_list", (String)"billno,billstatus,creator,auditor,modifier,auditdate,createtime,modifytime,ewblxh,nsrsbh,templateid,sshymc,fddbrxm,zcdz,scjydz,khyh,yhzh,registertype,phonenum,yssr,nsrmc,datatype,taxlimit,declaretype,paytype,paydate,paystatus,declarer,payer,declarestatus,sbrq,type,skssqq,skssqz,bqybtse,org,riskcontent,ismodified,archivestatus,archivetime,taxrefundstatus,entryentity.taxtypes,entryentity.bqdybtse,entryentity.deferpayapply,entryentity.sjje,entryentity.qjje,id,entryentity.id,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)skssqz)), new QFilter("billstatus", "=", (Object)"C"), new QFilter("type", "in", TYPELIST)});
    }

    public static DynamicObject[] getAllDeclareReport(Long orgId, Date skssqq, Date skssqz) {
        return BusinessDataServiceHelper.load((String)"tcvat_zzs_declare_list", (String)"billno,billstatus,creator,auditor,modifier,auditdate,createtime,modifytime,ewblxh,nsrsbh,templateid,sshymc,fddbrxm,zcdz,scjydz,khyh,yhzh,registertype,phonenum,yssr,nsrmc,datatype,taxlimit,declaretype,paytype,paydate,paystatus,declarer,payer,declarestatus,sbrq,type,skssqq,skssqz,bqybtse,org,riskcontent,ismodified,archivestatus,archivetime,taxrefundstatus,entryentity.taxtypes,entryentity.bqdybtse,entryentity.deferpayapply,entryentity.sjje,entryentity.qjje,id,entryentity.id,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)skssqz)), new QFilter("type", "in", TYPELIST)});
    }

    public static BigDecimal getZbDyoSe(DynamicObject declareDyo, String seName) {
        if (null == declareDyo) {
            return BigDecimal.ZERO;
        }
        DynamicObject zbDyo = QueryServiceHelper.queryOne((String)"tcvat_ybnsr_zb", (String)"qmldse,jxse,mdtytse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)declareDyo.getString("id")), new QFilter("ewblxh", "=", (Object)"1")});
        return null == zbDyo ? BigDecimal.ZERO : zbDyo.getBigDecimal(seName);
    }

    public static BigDecimal getFbSecondDyo(DynamicObject declareDyo, String ewblxh) {
        if (declareDyo == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject fbDyo = QueryServiceHelper.queryOne((String)"tcvat_ybnsr_fb2", (String)"se", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)declareDyo.getString("id")), new QFilter("ewblxh", "=", (Object)ewblxh)});
        return fbDyo == null ? BigDecimal.ZERO : fbDyo.getBigDecimal("se");
    }

    public static DynamicObject getFbFiveDyo(DynamicObject declareDyo) {
        return QueryServiceHelper.queryOne((String)"tcvat_sb_fjsf_jz", (String)"id,ewblxh,ewblname,sbbid,sfysxgmjzzzc,cswhjssjzbl,jyffjjzbl,dfjyfjjzbl,sfyssdjsqydmzc,djxztze,sqldkdmje,jzxqkdmje,jzxqkyykcdldtse,dqxzkyytcdldtse,sqjckyykcdldtse,skssqq,skssqz,bqsfsyjzzc,gtgsh,xxwlqy", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)declareDyo.getString("id")), new QFilter("ewblxh", "=", (Object)"1")});
    }

    public static DynamicObject getInitData(Long orgId, Date skssqq, Date skssqz, String formId) {
        if (null == skssqq && null == skssqz) {
            return QueryServiceHelper.queryOne((String)formId, (String)"id,skssqq,skssqz", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        }
        return QueryServiceHelper.queryOne((String)formId, (String)"id,skssqq,skssqz", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", "=", (Object)skssqq), new QFilter("skssqz", "=", (Object)skssqz)});
    }

    public static DynamicObjectCollection getAllInitData(Long orgId, Date skssqq, Date skssqz, String formId) {
        return QueryServiceHelper.query((String)formId, (String)"id,org,skssqq,skssqz", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", ">=", (Object)skssqq), new QFilter("skssqz", "<=", (Object)skssqz)});
    }

    public Long suitOrg(String entityName) {
        Long orgId = RequestContext.get().getOrgId();
        if (StateInitDataService.isSuit(orgId, entityName)) {
            return orgId;
        }
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((String)"tcvat", (String)"tcvat_statet_init", (String)"47150e89000000ac");
        if (hasPermOrgs.hasAllOrgPerm()) {
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
            if (CollectionUtils.isEmpty((Collection)col)) {
                return null;
            }
            for (DynamicObject orgDyo : col) {
                if (orgId.equals(orgDyo.getLong("id")) || !StateInitDataService.isSuit(orgDyo.getLong("id"), entityName)) continue;
                return orgDyo.getLong("id");
            }
        } else {
            hasPermOrgs.getHasPermOrgs().remove(orgId);
            Long suitOrg = StateInitDataService.getSuitOrg(hasPermOrgs, entityName);
            return suitOrg;
        }
        return null;
    }

    private static Long getSuitOrg(HasPermOrgResult hasPermOrgs, String entityName) {
        List allPermOrgs = hasPermOrgs.getHasPermOrgs();
        if (!CollectionUtils.isEmpty((Collection)allPermOrgs)) {
            for (Long orgId : allPermOrgs) {
                if (!StateInitDataService.isSuit(orgId, entityName)) continue;
                return orgId;
            }
        }
        return null;
    }

    private static boolean isSuit(Long orgId, String entityName) {
        String checkResult = ZzsOrgCheckUtil.getCheckResult(String.valueOf(orgId), entityName);
        return StringUtil.isEmpty((CharSequence)checkResult);
    }

    public static String doVerifyValid(Long orgId, Date skssqq, Date skssqz, String entityName) {
        String checkResult = ZzsOrgCheckUtil.getCheckResult(String.valueOf(orgId), entityName);
        if (!StringUtil.isEmpty((CharSequence)checkResult)) {
            return checkResult;
        }
        Map<String, String> taxLimitCheck = ZzsOrgCheckUtil.checkTaxLimit(orgId, skssqq, skssqz);
        if (StringUtils.equalsIgnoreCase((CharSequence)taxLimitCheck.get("code"), (CharSequence)"true")) {
            return taxLimitCheck.get("failInfo");
        }
        return "";
    }

    public static Long getOrgIdByOrgNumber(String orgNumber) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)orgNumber);
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
            return ((DynamicObject)result.getData()).getLong("taxorg.id");
        }
        return null;
    }

    public static void delteTotalInitData(Object[] pkIds) {
        DeleteServiceHelper.delete((String)"tcvat_totaldata_init", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
    }
}

