/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.taxrefund;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQEvent;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQSender;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQType;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.tcvat.business.service.jzjt.JzjtService;
import kd.taxc.tcvat.business.service.taxrefund.AccountServiceHelper;
import kd.taxc.tcvat.business.service.taxrefund.WriteBackToAccountService;
import org.apache.commons.compress.utils.Sets;

public class TaxRefundApplyService {
    private static final Log logger = LogFactory.getLog(TaxRefundApplyService.class);
    private Set<String> YSQORZYTS = Sets.newHashSet((Object[])new String[]{"ysq", "zyts"});
    JzjtService jzjtService = new JzjtService();

    public DynamicObject queryTaxRefundApply(Long orgid, Date skssqq, Date skssqz) {
        QFilter filter = new QFilter("org", "=", (Object)orgid).and("skssqq", ">=", (Object)skssqq).and("skssqz", "<=", (Object)skssqz).and("type", "=", (Object)"tcvat_taxrefund");
        return BusinessDataServiceHelper.loadSingle((String)"tcvat_tax_refund_apply", (String)"id,billstatus,entryentity,entryentity.bljd,entryentity.zytssj", (QFilter[])new QFilter[]{filter});
    }

    public DynamicObject queryTaxRefundApplyByBillNo(String BillNo) {
        QFilter filter = new QFilter("billno", "=", (Object)BillNo);
        return QueryServiceHelper.queryOne((String)"tcvat_tax_refund_apply", (String)"id,org,skssqq,skssqz", (QFilter[])new QFilter[]{filter});
    }

    public DynamicObject[] queryTaxRefundApplyByRange(Set<Long> orgidList) {
        QFilter filter = new QFilter("org", "in", (Object)orgidList.toArray()).and("type", "=", (Object)"tcvat_taxrefund");
        return BusinessDataServiceHelper.load((String)"tcvat_tax_refund_apply", (String)"id,org", (QFilter[])new QFilter[]{filter});
    }

    public void sendTaxRefundInfo(Object operationKey, DynamicObject[] dataEntities, TaxResult<List<DynamicObject>> refunds) {
        Map deleResult;
        Map addResult;
        ArrayList<Map<String, Object>> addOrUpdateRefunds = new ArrayList<Map<String, Object>>(dataEntities.length);
        ArrayList<String> deleteNums = new ArrayList<String>();
        for (DynamicObject entity : dataEntities) {
            String bljd;
            DynamicObject refundInfo = this.getRefundByApplyNo(entity.getString("billno"), refunds);
            if (this.YSQORZYTS.contains(operationKey)) {
                boolean flag;
                bljd = ((DynamicObject)entity.getDynamicObjectCollection("entryentity").get(0)).getString("bljd");
                boolean bl = flag = "yts".equals(bljd) && Objects.nonNull(refundInfo) && "0".equals(refundInfo.getString("taxrefundstatus"));
                if (this.YSQORZYTS.contains(bljd) && Objects.nonNull(refundInfo) || flag) continue;
                Map<String, Object> map = this.buildNewRefundMap(Objects.nonNull(refundInfo) ? refundInfo : entity, "0", null, Objects.nonNull(refundInfo));
                if ("zyts".equals(bljd) && Objects.isNull(refundInfo)) {
                    map.put("applicationdate", null);
                }
                addOrUpdateRefunds.add(map);
                continue;
            }
            if ("wsq".equals(operationKey) && Objects.nonNull(refundInfo)) {
                deleteNums.add(refundInfo.getString("declarenum"));
                continue;
            }
            if (!"yts".equals(operationKey)) continue;
            bljd = ((DynamicObject)entity.getDynamicObjectCollection("entryentity").get(0)).getString("bljd");
            if (Objects.nonNull(refundInfo) && "1".equals(refundInfo.getString("taxrefundstatus"))) continue;
            Map<String, Object> map = this.buildNewRefundMap(Objects.nonNull(refundInfo) ? refundInfo : entity, "1", new Date(), Objects.nonNull(refundInfo));
            if ("zyts".equals(bljd) && Objects.isNull(refundInfo)) {
                map.put("applicationdate", null);
            }
            addOrUpdateRefunds.add(map);
        }
        HashMap result = new HashMap();
        if (CollectionUtils.isNotEmpty(addOrUpdateRefunds) && !((Boolean)(addResult = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"addOrUpdateTaxRefund", (Object[])new Object[]{addOrUpdateRefunds})).get("success")).booleanValue()) {
            List errors = (List)addResult.get("data");
            errors.forEach(one -> {
                String failnum = (String)one.get("failnum");
                String errormsg = (String)one.get("errormsg");
                result.put(failnum, errormsg);
            });
        }
        if (CollectionUtils.isNotEmpty(deleteNums) && !((Boolean)(deleResult = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"deleteTaxRefundInfo", (Object[])new Object[]{deleteNums})).get("success")).booleanValue()) {
            List errors = (List)deleResult.get("data");
            errors.forEach(one -> {
                String failnum = (String)one.get("failnum");
                String errormsg = (String)one.get("errormsg");
                result.put(failnum, errormsg);
            });
        }
        logger.info("sendTaxRefundInfo\u6267\u884c\u7684\u7ed3\u679c\u4e3a{}", result);
        if (!result.isEmpty()) {
            throw new KDBizException((String)result.get(dataEntities[0].getString("billno")));
        }
    }

    public void updateTaxRefund(String operationKey, List<DynamicObject> taxRefundAccountList, Long org, Date skssqq, Date skssqz) {
        DynamicObject taxRefundAccount = AccountServiceHelper.getAccountDataWithDate(org, skssqq, skssqz);
        if (null == taxRefundAccount) {
            return;
        }
        taxRefundAccount.set("tsbljd", (Object)operationKey);
        taxRefundAccount.set("zytssj", "zyts".equals(operationKey) ? DateUtils.format((Date)new Date()) : null);
        taxRefundAccountList.add(taxRefundAccount);
    }

    public void updateDeclareReport(String operationKey, List<DynamicObject> declareReportList, Long org, Date skssqq, Date skssqz) {
        QFilter filterList = new QFilter("org", "=", (Object)org).and(new QFilter("skssqq", "=", (Object)skssqq)).and(new QFilter("skssqz", "=", (Object)skssqz)).and(new QFilter("type", "in", Arrays.asList("zzsybnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg")));
        DynamicObject declareReport = BusinessDataServiceHelper.loadSingle((String)"tcvat_zzs_declare_list", (String)"type,taxrefundstatus", (QFilter[])new QFilter[]{filterList});
        if (null == declareReport) {
            return;
        }
        declareReport.set("taxrefundstatus", (Object)operationKey);
        declareReportList.add(declareReport);
    }

    public Map<String, Object> buildNewRefundMap(DynamicObject applyDyo, String status, Date dzDate, boolean isHis) {
        HashMap<String, Object> temp = new HashMap<String, Object>(32);
        long orgId = applyDyo.getDynamicObject("org").getLong("id");
        temp.put("org", orgId);
        temp.put("startdate", applyDyo.get(isHis ? "startdate" : "skssqq"));
        temp.put("enddate", applyDyo.get(isHis ? "enddate" : "skssqz"));
        temp.put("taxcategory", 1L);
        temp.put("applicationdate", isHis ? applyDyo.get("applicationdate") : new Date());
        temp.put("currency", 1L);
        temp.put("refundableamount", isHis ? applyDyo.get("refundableamount") : this.getYtje(applyDyo));
        temp.put("taxoffice", isHis ? applyDyo.get("taxoffice") : this.jzjtService.getTaxoffice(orgId));
        temp.put("declaretype", isHis ? applyDyo.get("declaretype") : applyDyo.getDynamicObject("templatetype").getString("number"));
        temp.put("declarenum", isHis ? applyDyo.get("declarenum") : applyDyo.get("billno"));
        temp.put("creator", isHis ? applyDyo.get("creator") : Long.valueOf(RequestContext.get().getCurrUserId()));
        temp.put("billstatus", isHis ? applyDyo.get("billstatus") : "C");
        temp.put("datasource", isHis ? applyDyo.get("datasource") : "0");
        temp.put("isvoucher", isHis ? applyDyo.get("isvoucher") : "0");
        temp.put("taxrefundstatus", status);
        temp.put("accountdate", dzDate);
        if (isHis) {
            temp.put("id", applyDyo.get("id"));
            temp.put("billno", applyDyo.get("billno"));
            temp.put("notes", applyDyo.get("notes"));
        }
        if ("1".equals(status)) {
            temp.put("actualrefundamount", temp.get("refundableamount"));
        } else {
            temp.put("actualrefundamount", BigDecimal.ZERO);
        }
        return temp;
    }

    private BigDecimal getYtje(DynamicObject applyDyo) {
        DynamicObjectCollection entryentity = applyDyo.getDynamicObjectCollection("entryentity");
        DynamicObject entry = (DynamicObject)entryentity.get(0);
        BigDecimal bqsqthdzlldse = BigDecimalUtil.toBigDecimal((Object)entry.get("bqsqthdzlldse"));
        BigDecimal bqsqthdclldse = BigDecimalUtil.toBigDecimal((Object)entry.get("bqsqthdclldse"));
        return bqsqthdzlldse.add(bqsqthdclldse).setScale(10, 4);
    }

    public DynamicObject getRefundByApplyNo(String billNo, TaxResult<List<DynamicObject>> refunds) {
        if (!refunds.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)refunds.getData()))) {
            return null;
        }
        List data = (List)refunds.getData();
        return data.stream().filter(one -> billNo.equals(one.getString("declarenum"))).findFirst().orElse(null);
    }

    public void taxRefundApplyUnaudit(Long orgId, Date skssqq, Date skssqz) {
        DynamicObject[] refundAccountArray;
        ArrayList<DynamicObject> declareReportList = new ArrayList<DynamicObject>(10);
        DynamicObject applyObject = this.queryTaxRefundApply(orgId, skssqq, skssqz);
        if (null == applyObject) {
            return;
        }
        ((DynamicObject)applyObject.getDynamicObjectCollection("entryentity").get(0)).set("bljd", (Object)"wsq");
        ((DynamicObject)applyObject.getDynamicObjectCollection("entryentity").get(0)).set("zytssj", null);
        for (DynamicObject dyo : refundAccountArray = BusinessDataServiceHelper.load((String)"tcvat_tax_refund_manage_a", (String)"billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,snmzcze,sshydl,skssqq,skssqz,nsxydj,clldse,ktsbl,bqrzxfdzpse,zzszyfpse,amount,bqsqthclldtse,startqmldse,bqksqthldtse,bqsqthzlldtse,sqthxm,ldtssqbbm,tsbljd,zytssj,tsqylx,zzssbbbh,bqdkhgzyjksse,bqjjskwspzse,bqsbdkjxsehj,bqmdtytse,sqmdsedjqs,sqldsets,dqxzkyytcdldtse,ldtsbqkce,sqjckyykcdldtse,jzxqkyykcdldtse,hgzyjksse,ljdkjjkwspzse,ljdkjxse,inputrate,bndzzsysxsehj,sndzzsysxsehj,qygm,summonth,bqksqthzlldse,bqksqthclldse,zlldtserq,id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", "=", (Object)skssqq), new QFilter("skssqz", "=", (Object)skssqz)})) {
            WriteBackToAccountService.deleteData(dyo);
        }
        this.updateDeclareReport("wsq", declareReportList, orgId, skssqq, skssqz);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{applyObject});
        SaveServiceHelper.save((DynamicObject[])refundAccountArray);
        SaveServiceHelper.save((DynamicObject[])declareReportList.toArray(new DynamicObject[0]));
    }

    public List<DynamicObject> taxRefundApplyAudit(Long orgId, Date skssqq, Date skssqz) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        DynamicObject accountData = AccountServiceHelper.getAccountDataWithDate(orgId, skssqq, skssqz);
        if (null != accountData) {
            WriteBackToAccountService.writeBack(accountData, orgId, skssqq, skssqz);
            list.add(accountData);
            TaxRefundMQSender.sendMQ(list, (String)TaxRefundMQType.TAX_REFUND.name(), (String)TaxRefundMQEvent.UPDATE.name());
        }
        return list;
    }

    public boolean isMatch(String regex, String orginal) {
        if (StringUtil.isBlank((CharSequence)orginal)) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher isNum = pattern.matcher(orginal);
        return isNum.matches();
    }
}

