/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.taxrefund.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.mq.TaxRefundStatusHandler;
import kd.taxc.tcvat.business.service.taxrefund.StateInitDataService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundAccountService;

public class AccountRecalcEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(AccountRecalcEngine.class);

    protected DynamicObject execute() throws Exception {
        try {
            logger.info("\u5f00\u59cb\u6267\u884c\u7559\u62b5\u9000\u7a0e\u53f0\u8d26\u91cd\u65b0\u8ba1\u7b97\u5f15\u64ce");
            long start = System.currentTimeMillis();
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
            TcvatEngineModel engineModel = (TcvatEngineModel)this.getEngineModel();
            this.calSummaryAccountList(summaryList, engineModel);
            logger.info("\u7ed3\u675f\u6267\u884c\u7559\u62b5\u9000\u7a0e\u53f0\u8d26\u91cd\u65b0\u8ba1\u7b97\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    public void calSummaryAccountList(List<DynamicObject> summaryList, EngineModel engineModel) {
        TaxRefundAccountService taxRefundAccountService = new TaxRefundAccountService();
        TaxRefundStatusHandler taxRefundStatusHandler = new TaxRefundStatusHandler();
        Long orgId = Long.parseLong(engineModel.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)engineModel.getStartDate());
        DynamicObject[] summarys = taxRefundAccountService.getAllTaxRefundFromSkssqqToNow(orgId, skssqq);
        logger.info("\u8981\u66f4\u65b0\u7684\u53f0\u8d26\u6761\u6570====  " + summarys.length);
        for (int i = 0; i < summarys.length; ++i) {
            DynamicObject account = summarys[i];
            account = taxRefundAccountService.createAccount(account, orgId, account.getDate("skssqq"), account.getDate("skssqz"), "recalc");
            summaryList.add(account);
            SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
            DynamicObject declareDyo = StateInitDataService.getDeclareReport(orgId, account.getDate("skssqq"), account.getDate("skssqz"));
            if (null == declareDyo) {
                return;
            }
            taxRefundAccountService.deleteTaxRefundDetail(Collections.singletonList(declareDyo.getLong("id")));
            taxRefundStatusHandler.auditHandler(declareDyo);
        }
    }
}

