/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.transfer.apportion;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class InputApportionService {
    private static final String APPORTION_DETAIL_ENTITY = "tcvat_apportion_detail";
    private static final String ROLLOUT_DETAIL_ENTITY = "tcvat_rollout_register";
    private static String[] FIELDS = new String[]{"id", "org", "invoicecode", "invoiceno", "createtime", "creator", "rollouttaxperiod", "consumertype", "rollouttype", "remark", "currentregistertaxamount", "projectincome", "incomesummary", "apportionrate", "apportiontaxamount", "apportionstatus"};
    private static DataType[] DATATYPES = new DataType[]{DataType.LongType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.DateType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType};
    private static String[] SUM_FIELDS = new String[]{"id", "currentregistertaxamount", "apportiontaxamount"};
    private static String QUERY_FIELDS = "id, org,invoicecode,invoiceno,createtime,creator,rollouttaxperiod,consumertype,rollouttype,apportionremark,currentregistertaxamount,projectincome,incomesummary,apportionrate,apportiontaxamount,apportionstatus";

    public static void saveApportionCalcData(List<DynamicObject> list) {
        ArrayList<DynamicObject> mainList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> insertDynamicObjects = new ArrayList<DynamicObject>(list.size());
        for (DynamicObject obj : list) {
            DynamicObject dObj = BusinessDataServiceHelper.newDynamicObject((String)APPORTION_DETAIL_ENTITY);
            dObj.set("apportioncreatetime", (Object)new Date());
            dObj.set("apportionmodifytime", (Object)new Date());
            dObj.set("modifier", (Object)RequestContext.get().getUserId());
            dObj.set("creator", (Object)RequestContext.get().getUserId());
            dObj.set("org", obj.getDynamicObject("org").get("id"));
            dObj.set("rollouttaxperiod", obj.get("rollouttaxperiod"));
            dObj.set("consumertype", obj.get("consumertype"));
            dObj.set("rollouttype", obj.get("rollouttype"));
            dObj.set("apportionremark", obj.get("apportionremark"));
            dObj.set("apportionstatus", (Object)"1");
            dObj.set("apportiontype", (Object)"1");
            dObj.set("currentregistertaxamount", (Object)obj.getBigDecimal("currentregistertaxamount"));
            dObj.set("projectincome", (Object)obj.getBigDecimal("projectincome"));
            dObj.set("incomesummary", (Object)obj.getBigDecimal("incomesummary"));
            BigDecimal apportionRate = new BigDecimal(obj.getString("apportionrate").replaceAll("%", "")).divide(new BigDecimal(100), 6, 4);
            dObj.set("apportionrate", (Object)apportionRate);
            dObj.set("apportiontaxamount", (Object)obj.getBigDecimal("apportiontaxamount"));
            dObj.set("registercoshareid", (Object)obj.getString("registercoshareid"));
            dObj.set("shareid", (Object)obj.getString("id"));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("id"), (String)ROLLOUT_DETAIL_ENTITY, (String)"id,projectincome,incomesummary,apportionrate,apportionstatus,apportiontype,apportiontaxamount,rollouttaxamount,apportionmodifytime,modifier");
            if (null != dynamicObject) {
                dynamicObject.set("apportiontaxamount", (Object)obj.getBigDecimal("apportiontaxamount"));
                dynamicObject.set("rollouttaxamount", (Object)obj.getBigDecimal("apportiontaxamount"));
                dynamicObject.set("projectincome", (Object)obj.getBigDecimal("projectincome"));
                dynamicObject.set("incomesummary", (Object)obj.getBigDecimal("incomesummary"));
                dynamicObject.set("apportionrate", (Object)apportionRate);
                dynamicObject.set("apportionstatus", (Object)"1");
                dynamicObject.set("apportiontype", (Object)"1");
                dynamicObject.set("apportionmodifytime", (Object)new Date());
                dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
                mainList.add(dynamicObject);
            }
            insertDynamicObjects.add(dObj);
        }
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])insertDynamicObjects.toArray(new DynamicObject[insertDynamicObjects.size()]));
                SaveServiceHelper.save((DynamicObject[])mainList.toArray(new DynamicObject[mainList.size()]));
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }

    public static List<QFilter> getFilterListByField(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                FilterItemInfo item = (FilterItemInfo)list.get(i);
                String name = item.getPropName();
                Object value = item.getValue();
                String compareType = item.getCompareType();
                if (StringUtils.equals((CharSequence)"type", (CharSequence)name)) {
                    name = "rollouttype";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"period", (CharSequence)name)) {
                    name = "rolloutperiod";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"orgs.id", (CharSequence)name) || StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name)) {
                    DynamicObjectCollection dynamicObject;
                    if (StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name) && null != (dynamicObject = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)value))) && dynamicObject.size() > 0) {
                        value = ((DynamicObject)dynamicObject.get(0)).getString("id");
                    }
                    name = "org";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"status", (CharSequence)name)) continue;
                name = "apportionstatus";
                qFilterList.add(new QFilter(name, compareType, value));
            }
            qFilterList.add(new QFilter("registerstatus", "=", (Object)"1"));
            qFilterList.add(new QFilter("registertype", "=", (Object)"1"));
            qFilterList.add(new QFilter("consumertype", "=", (Object)"7"));
            qFilterList.add(new QFilter("summaryflag", "=", (Object)"0"));
        }
        return qFilterList;
    }

    public static DataSet collectDateSet(List<QFilter> qFilterList, String algoKey) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)ROLLOUT_DETAIL_ENTITY, (String)QUERY_FIELDS, (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"createtime desc");
        return InputApportionService.getSumDataSetByAlgo(dataSet, SUM_FIELDS, algoKey);
    }

    public static DataSet getSumDataSetByAlgo(DataSet dataSet, String[] sumFields, String algoKey) {
        if (dataSet.copy().count("id", true) > 0) {
            GroupbyDataSet groupbyDataSet = dataSet.copy().groupBy();
            for (String sumField : sumFields) {
                groupbyDataSet.sum(sumField);
            }
            DataSet dataSetSum = groupbyDataSet.finish();
            Long primaryId = 0L;
            Long defaultLongId = -1L;
            ArrayList<Object[]> coll = new ArrayList<Object[]>();
            if (dataSetSum.copy().count("id", true) > 0) {
                for (Row row : dataSetSum.copy()) {
                    BigDecimal currentregistertaxamount = BigDecimalUtil.setScale((Object)row.getString("currentregistertaxamount"));
                    BigDecimal apportiontaxamount = BigDecimalUtil.setScale((Object)row.getString("apportiontaxamount"));
                    coll.add(new Object[]{primaryId, defaultLongId, "", "", null, defaultLongId, "", "", "count", "", currentregistertaxamount, null, null, null, apportiontaxamount, ""});
                }
                RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);
                CollectionInput inputs = new CollectionInput(rowMeta, coll);
                DataSet dataSetCount = Algo.create((String)algoKey).createDataSet(new Input[]{inputs});
                dataSet = dataSet.union(dataSetCount);
            }
        }
        return dataSet;
    }
}

