/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class DeclareQueryUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(DeclareQueryUpgradePlugin.class);
    private static final String TCVAT_ZZS_DECLARE_LIST = "tcvat_zzs_declare_list";
    private static final String EWBLXH = "ewblxh";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BQYBTSE = "bqybtse";
    private static final String SBBID = "sbbid";
    private static final String ZZSXGMNSR = "zzsxgmnsr";
    private static final String FJSF = "fjsf";
    private static final String ZZSYBNSR_ZJG = "zzsybnsr_zjg";
    private static final String ZZSYBNSR_FZJG = "zzsybnsr_fzjg";
    private static final String ZZSYBNSR_YBHZ = "zzsybnsr_ybhz";
    private static final String ZZSYBNSR = "zzsybnsr";
    private static final String BQDYBTSE = "bqdybtse";
    private static final String TAXTYPES = "taxtypes";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        for (String number : Arrays.asList(TCVAT_ZZS_DECLARE_LIST, "tcvat_xgm_zb", "tcvat_ybnsr_zb", "tcvat_sb_fjsf")) {
            Boolean isExist = this.metaIsExist(number);
            if (isExist.booleanValue()) continue;
            this.addLog(ERROR, String.format("The %s is not exist!", number));
            return;
        }
        ArrayList<DynamicObject[]> updateList = new ArrayList<DynamicObject[]>(4);
        updateList.add(this.dealOldSbb());
        updateList.add(this.dealNewSbb());
        try (TXHandle h = TX.requiresNew();){
            try {
                for (DynamicObject[] objects : updateList) {
                    if (objects == null || objects.length <= 0) continue;
                    List collect = Arrays.stream(objects).collect(Collectors.toList());
                    List partition = Lists.partition(collect, (int)2);
                    for (List objectList : partition) {
                        SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[objectList.size()]));
                    }
                }
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error(ERROR_INFO, t);
                throw new RuntimeException(t);
            }
        }
    }

    private DynamicObject[] dealOldSbb() {
        long l2 = System.currentTimeMillis();
        QFilter qFilter = new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{ZZSXGMNSR, ZZSYBNSR})).and("skssqq", "<", (Object)DateUtils.stringToDate((String)"2021-07-01"));
        QFilter qFilter2 = new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{ZZSYBNSR_ZJG, ZZSYBNSR_FZJG, FJSF, ZZSYBNSR_YBHZ}));
        this.addLog(INFO, "select * from t_tctb_declare_main where (fnsrtype in ( 'zzsybnsr_zjg', 'zzsybnsr_fzjg', 'fjsf', 'zzsybnsr_ybhz')) or (fnsrtype in ('zzsybnsr', 'zzsxgmnsr') and skssqq < '2021-07-01')");
        QFilter or = qFilter.or(qFilter2);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)TCVAT_ZZS_DECLARE_LIST, (String)MetadataUtil.getAllSubFieldString((String)TCVAT_ZZS_DECLARE_LIST), (QFilter[])or.toArray());
        long l3 = System.currentTimeMillis();
        this.addLog(INFO, String.format("Result Size: %d", load == null ? 0 : load.length));
        this.addLog(INFO, String.format("Use Time(ms): %d", l3 - l2));
        if (load == null || load.length == 0) {
            return null;
        }
        Map<String, List<DynamicObject>> typeMap = Arrays.stream(load).collect(Collectors.groupingBy(a -> a.getString("type")));
        for (Map.Entry<String, List<DynamicObject>> entry : typeMap.entrySet()) {
            String type = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            List<String> sbbids = value.stream().map(a -> a.getString("id")).collect(Collectors.toList());
            switch (type) {
                case "fjsf": {
                    DynamicObjectCollection fjsfb = this.queryData(Lists.newArrayList((Object[])new String[]{"9"}), "sbbid,ewblxh,bqybse", "tcvat_sb_fjsf", sbbids);
                    Map<String, DynamicObject> idMap = fjsfb.stream().collect(Collectors.toMap(a -> a.getString(SBBID), b -> b, (m, n) -> n));
                    value.forEach(a -> {
                        String id = a.getString("id");
                        DynamicObject object = (DynamicObject)idMap.get(id);
                        if (object != null) {
                            BigDecimal bqybse = object.getBigDecimal("bqybse");
                            DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection(ENTRYENTITY);
                            dynamicObjectCollection.clear();
                            DynamicObject object1 = dynamicObjectCollection.addNew();
                            object1.set(BQDYBTSE, (Object)bqybse);
                            object1.set(TAXTYPES, (Object)"2");
                            a.set(BQYBTSE, (Object)bqybse);
                        } else {
                            DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection(ENTRYENTITY);
                            dynamicObjectCollection.clear();
                            DynamicObject object1 = dynamicObjectCollection.addNew();
                            object1.set(BQDYBTSE, (Object)BigDecimal.ZERO);
                            object1.set(TAXTYPES, (Object)"2");
                        }
                    });
                    break;
                }
                case "zzsxgmnsr": {
                    DynamicObjectCollection xgmzb = this.queryData(Lists.newArrayList((Object[])new String[]{"1", "2"}), "sbbid,ewblxh,bqybtse", "tcvat_xgm_zb", sbbids);
                    Map<String, BigDecimal> idValueMap = xgmzb.stream().collect(Collectors.toMap(a -> a.getString(SBBID), b -> b.getBigDecimal(BQYBTSE), BigDecimal::add));
                    value.forEach(a -> {
                        String id = a.getString("id");
                        BigDecimal bqybse = (BigDecimal)idValueMap.get(id);
                        if (bqybse != null) {
                            DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection(ENTRYENTITY);
                            dynamicObjectCollection.clear();
                            DynamicObject object1 = dynamicObjectCollection.addNew();
                            object1.set(TAXTYPES, (Object)"1");
                            object1.set(BQDYBTSE, (Object)bqybse);
                            a.set(BQYBTSE, (Object)bqybse);
                        } else {
                            DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection(ENTRYENTITY);
                            dynamicObjectCollection.clear();
                            DynamicObject object1 = dynamicObjectCollection.addNew();
                            object1.set(BQDYBTSE, (Object)BigDecimal.ZERO);
                            object1.set(TAXTYPES, (Object)"1");
                        }
                    });
                    break;
                }
                case "zzsybnsr_zjg": 
                case "zzsybnsr_fzjg": 
                case "zzsybnsr_ybhz": 
                case "zzsybnsr": {
                    DynamicObjectCollection ybzb = this.queryData(Lists.newArrayList((Object[])new String[]{"1", "3"}), "sbbid,ewblxh,bqybtse", "tcvat_ybnsr_zb", sbbids);
                    Map<String, BigDecimal> ybzbMap = ybzb.stream().collect(Collectors.toMap(a -> a.getString(SBBID), b -> b.getBigDecimal(BQYBTSE), BigDecimal::add));
                    value.forEach(a -> {
                        String id = a.getString("id");
                        BigDecimal bqybse = (BigDecimal)ybzbMap.get(id);
                        if (bqybse != null) {
                            DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection(ENTRYENTITY);
                            dynamicObjectCollection.clear();
                            DynamicObject object1 = dynamicObjectCollection.addNew();
                            object1.set(TAXTYPES, (Object)"1");
                            object1.set(BQDYBTSE, (Object)bqybse);
                            a.set(BQYBTSE, (Object)bqybse);
                        } else {
                            DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection(ENTRYENTITY);
                            dynamicObjectCollection.clear();
                            DynamicObject object1 = dynamicObjectCollection.addNew();
                            object1.set(BQDYBTSE, (Object)BigDecimal.ZERO);
                            object1.set(TAXTYPES, (Object)"1");
                        }
                    });
                }
            }
        }
        return load;
    }

    private DynamicObject[] dealNewSbb() {
        long l = System.currentTimeMillis();
        QFilter qFilter = new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{ZZSXGMNSR, ZZSYBNSR})).and("skssqq", ">=", (Object)DateUtils.stringToDate((String)"2021-07-01"));
        this.addLog(INFO, "select * from t_tctb_declare_main where fnsrtype in ('zzsybnsr', 'zzsxgmnsr') and skssqq >= '2021-07-01'");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)TCVAT_ZZS_DECLARE_LIST, (String)MetadataUtil.getAllSubFieldString((String)TCVAT_ZZS_DECLARE_LIST), (QFilter[])qFilter.toArray());
        long l1 = System.currentTimeMillis();
        this.addLog(INFO, String.format("Result Size: %d", load == null ? 0 : load.length));
        this.addLog(INFO, String.format("Use Time(ms): %d", l1 - l));
        Map<String, List<DynamicObject>> typeMap = Arrays.stream(load).collect(Collectors.groupingBy(a -> a.getString("type")));
        for (Map.Entry<String, List<DynamicObject>> entry : typeMap.entrySet()) {
            String type = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            List<String> sbbids = value.stream().map(a -> a.getString("id")).collect(Collectors.toList());
            switch (type) {
                case "zzsxgmnsr": {
                    DynamicObjectCollection xgmzb = this.queryData(Lists.newArrayList((Object[])new String[]{"1", "2", "5"}), "sbbid,ewblxh,bqybtse,cswhjssbqybtse,jyffjbqybtsfe,dfjyfjbqybtsfe", "tcvat_xgm_zb", sbbids);
                    Map<String, List<DynamicObject>> collects = xgmzb.stream().collect(Collectors.groupingBy(a -> a.getString(EWBLXH)));
                    List one = collects.getOrDefault("1", new ArrayList(0));
                    Map<String, BigDecimal> oneMap = one.stream().collect(Collectors.toMap(a -> a.getString(SBBID), b -> b.getBigDecimal(BQYBTSE), BigDecimal::add));
                    List two = collects.getOrDefault("2", new ArrayList(0));
                    Map<String, BigDecimal> twoMap = two.stream().collect(Collectors.toMap(a -> a.getString(SBBID), b -> b.getBigDecimal(BQYBTSE), BigDecimal::add));
                    List five = collects.getOrDefault("5", new ArrayList(0));
                    Function<DynamicObject, BigDecimal> function = b -> {
                        BigDecimal cswhjssbqybtse = b.getBigDecimal("cswhjssbqybtse") == null ? BigDecimal.ZERO : b.getBigDecimal("cswhjssbqybtse");
                        BigDecimal jyffjbqybtsfe = b.getBigDecimal("jyffjbqybtsfe") == null ? BigDecimal.ZERO : b.getBigDecimal("jyffjbqybtsfe");
                        BigDecimal dfjyfjbqybtsfe = b.getBigDecimal("dfjyfjbqybtsfe") == null ? BigDecimal.ZERO : b.getBigDecimal("dfjyfjbqybtsfe");
                        return cswhjssbqybtse.add(jyffjbqybtsfe).add(dfjyfjbqybtsfe);
                    };
                    Map<String, BigDecimal> fiveMap = five.stream().collect(Collectors.toMap(a -> a.getString(SBBID), function, BigDecimal::add));
                    value.forEach(a -> {
                        String id = a.getString("id");
                        BigDecimal oneBig = oneMap.getOrDefault(id, BigDecimal.ZERO);
                        BigDecimal twoBig = twoMap.getOrDefault(id, BigDecimal.ZERO);
                        BigDecimal fiveBig = fiveMap.getOrDefault(id, BigDecimal.ZERO);
                        DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection(ENTRYENTITY);
                        dynamicObjectCollection.clear();
                        DynamicObject object1 = dynamicObjectCollection.addNew();
                        object1.set(TAXTYPES, (Object)"1");
                        object1.set(BQDYBTSE, (Object)oneBig.add(twoBig));
                        DynamicObject object2 = dynamicObjectCollection.addNew();
                        object2.set(TAXTYPES, (Object)"2");
                        object2.set(BQDYBTSE, (Object)fiveBig);
                        a.set(BQYBTSE, (Object)oneBig.add(twoBig).add(fiveBig));
                    });
                    break;
                }
                case "zzsybnsr": {
                    DynamicObjectCollection ybnsrzb = this.queryData(Lists.newArrayList((Object[])new String[]{"1", "3"}), "sbbid,ewblxh,bqybtse,cswhjssbqybtse,jyffjbqybtsfe,dfjyfjbqybtsfe", "tcvat_ybnsr_zb", sbbids);
                    Map<String, List<DynamicObject>> ybcollects = ybnsrzb.stream().collect(Collectors.groupingBy(a -> a.getString(EWBLXH)));
                    List ybone = ybcollects.getOrDefault("1", new ArrayList(0));
                    Map<String, BigDecimal> yboneMap = ybone.stream().collect(Collectors.toMap(a -> a.getString(SBBID), b -> b.getBigDecimal(BQYBTSE), BigDecimal::add));
                    List ybthree = ybcollects.getOrDefault("3", new ArrayList(0));
                    Map<String, BigDecimal> ybthreeMap = ybthree.stream().collect(Collectors.toMap(a -> a.getString(SBBID), b -> b.getBigDecimal(BQYBTSE), BigDecimal::add));
                    Function<DynamicObject, BigDecimal> ybfunction = b -> {
                        BigDecimal cswhjssbqybtse = b.getBigDecimal("cswhjssbqybtse") == null ? BigDecimal.ZERO : b.getBigDecimal("cswhjssbqybtse");
                        BigDecimal jyffjbqybtsfe = b.getBigDecimal("jyffjbqybtsfe") == null ? BigDecimal.ZERO : b.getBigDecimal("jyffjbqybtsfe");
                        BigDecimal dfjyfjbqybtsfe = b.getBigDecimal("dfjyfjbqybtsfe") == null ? BigDecimal.ZERO : b.getBigDecimal("dfjyfjbqybtsfe");
                        return cswhjssbqybtse.add(jyffjbqybtsfe).add(dfjyfjbqybtsfe);
                    };
                    Map<String, BigDecimal> fjsfMap = ybone.stream().collect(Collectors.toMap(a -> a.getString(SBBID), ybfunction, BigDecimal::add));
                    value.forEach(a -> {
                        String id = a.getString("id");
                        BigDecimal oneBig = yboneMap.getOrDefault(id, BigDecimal.ZERO);
                        BigDecimal threeBig = ybthreeMap.getOrDefault(id, BigDecimal.ZERO);
                        BigDecimal fjsfBig = fjsfMap.getOrDefault(id, BigDecimal.ZERO);
                        DynamicObjectCollection dynamicObjectCollection = a.getDynamicObjectCollection(ENTRYENTITY);
                        dynamicObjectCollection.clear();
                        DynamicObject object1 = dynamicObjectCollection.addNew();
                        object1.set(TAXTYPES, (Object)"1");
                        object1.set(BQDYBTSE, (Object)oneBig.add(threeBig));
                        DynamicObject object2 = dynamicObjectCollection.addNew();
                        object2.set(TAXTYPES, (Object)"2");
                        object2.set(BQDYBTSE, (Object)fjsfBig);
                        a.set(BQYBTSE, (Object)oneBig.add(threeBig).add(fjsfBig));
                    });
                }
            }
        }
        return load;
    }

    private DynamicObjectCollection queryData(List ewbxh, String columns, String entity, List<String> sbbids) {
        QFilter qFilter = new QFilter(EWBLXH, "in", (Object)ewbxh).and(SBBID, "in", sbbids);
        return QueryServiceHelper.query((String)entity, (String)columns, (QFilter[])qFilter.toArray());
    }
}

