/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.upgradeservice.DeductRuleAndDraftUpgradeService;
import org.apache.commons.collections4.CollectionUtils;

public class DeductionDraftUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(DeductionDraftUpgradeService.class);
    private final String remark = ResManager.loadKDString((String)"\u7cfb\u7edf\u65b0\u589e\u6570\u636e\u4e0b\u94bb\u5f39\u6846\uff0c\u201c\u8c03\u6574\u6570\u503c\u201d\u4e3a\u4e4b\u524d\u5728\u5e95\u7a3f\u91cc\u7684\u586b\u5199\u7684\u503c\u3002", (String)"DeductionDraftUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]);
    private DeductRuleAndDraftUpgradeService service = new DeductRuleAndDraftUpgradeService();

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"updatedata", "delete"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        String key = source.getKey();
        if ("delete".equals(key)) {
            this.deleteData();
        }
    }

    public void deleteData() {
        StringBuilder message = new StringBuilder();
        message.append("DeductionDraftUpgradeService revert start\n");
        String deleteAdjustSql = "delete from t_tcvat_draft_edit where fdraftid in (select fid from t_tcvat_deduction_summary where fdescription = 'autoupdated' and fdeductiontype in ('1','2','21','4','5','6','8','9')) and ftzsm= '" + this.remark + "'";
        String deleteDetailSql = "delete from t_tcvat_deduct_detail_bil where ftaxaccountserialno in (select fserialno from t_tcvat_deduction_summary where fdescription = 'autoupdated' and fdeductiontype in ('1','2','21','4','5','6','8','9'))";
        String summaryUpdateSql = "update t_tcvat_deduction_summary set fdescription = ' ' where fdescription = 'autoupdated' and fdeductiontype in ('1','2','21','4','5','6','8','9')";
        String deleteHzAdjustSql = "delete from t_tcvat_draft_edit where fdraftid in (select fid from t_tcvat_hz_deduction_sum where fdescription = 'autoupdated' and fdeductiontype in ('1','2','21','4','5','6','8','9')) and ftzsm= '" + this.remark + "'";
        String deleteHzDetailSql = "delete from t_tcvat_ybhz_deduct_det where ftaxaccountserialno in (select fserialno from t_tcvat_hz_deduction_sum where fdescription = 'autoupdated' and fdeductiontype in ('1','2','21','4','5','6','8','9')) and fdeductiontype in ('1','2','21','4','5','6','8','9')";
        String summaryHzUpdateSql = "update t_tcvat_hz_deduction_sum set fdescription = ' ' where fdescription = 'autoupdated' and fdeductiontype in ('1','2','21','4','5','6','8','9')";
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)deleteAdjustSql);
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)deleteDetailSql);
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)summaryUpdateSql);
        message.append("DeductionDraftUpgradeService revert ybnsr complete\n");
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)deleteHzAdjustSql);
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)deleteHzDetailSql);
        DB.execute((DBRoute)DBRoute.of((String)"taxc"), (String)summaryHzUpdateSql);
        message.append("DeductionDraftUpgradeService revert hz complete\n");
        if (this.getView() != null) {
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
            codeSQLshow.setText(message.toString());
            this.getView().updateView();
        }
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("DeductionDraftUpgradeService update start\n");
        long l = System.currentTimeMillis();
        try {
            if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_draft_main")) {
                this.updateYbnsrData(message);
                this.updateHzData(message);
            }
            message.append("\nDeductionDraftUpgradeService update complete ").append(System.currentTimeMillis() - l).append("ms");
        }
        catch (Exception e) {
            message.append(this.getStackTraceMessage(e)).append(System.currentTimeMillis() - l).append("ms");
            result.setSuccess(false);
        }
        result.setLog(message.toString());
        return result;
    }

    /*
     * Exception decompiling
     */
    public void updateHzData(StringBuilder message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void updateYbnsrData(StringBuilder message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Map<String, String>> queryDeductionSum() {
        String draftSql = "select fid,fserialno,forgid,ftaxperiod,fdeductiontype from t_tcvat_deduction_summary where forgid in (select forgid from t_tctb_draft_main where ftemplatetype = 'draft_zzsybnsr') and (fdescription is null or fdescription = '' or fdescription = ' ') and fdeductiontype in ('1','2','21','4','5','6','8','9')";
        DataSet deductDraftList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)draftSql);
        if (deductDraftList.isEmpty()) {
            deductDraftList.close();
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> deductionSumList = new ArrayList<Map<String, String>>(8);
        while (deductDraftList.hasNext()) {
            Row row = deductDraftList.next();
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("FID", row.getString("FID"));
            map.put("FSERIALNO", row.getString("FSERIALNO"));
            map.put("FORGID", row.getString("FORGID"));
            map.put("FTAXPERIOD", row.getString("FTAXPERIOD"));
            map.put("FDEDUCTIONTYPE", row.getString("FDEDUCTIONTYPE"));
            deductionSumList.add(map);
        }
        deductDraftList.close();
        return deductionSumList;
    }

    public List<Map<String, String>> queryHzDeductionSum() {
        String draftSql = "select fid,fserialno,forgid,fstartdate,fenddate,fdeductiontype,ftaxpayertype from t_tcvat_hz_deduction_sum where forgid in (select forgid from t_tctb_draft_main where ftemplatetype in ('draft_zzsybnsr_ybhz','draft_zzsybnsr_hz_zjg','draft_zzsybnsr_yz_zjg')) and (fdescription is null or fdescription = '' or fdescription = ' ') and fdeductiontype in ('1','2','21','4','5','6','8','9')";
        DataSet deductDraftList = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)draftSql);
        if (deductDraftList.isEmpty()) {
            deductDraftList.close();
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> deductionSumList = new ArrayList<Map<String, String>>(8);
        while (deductDraftList.hasNext()) {
            Row row = deductDraftList.next();
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("FID", row.getString("FID"));
            map.put("FSERIALNO", row.getString("FSERIALNO"));
            map.put("FORGID", row.getString("FORGID"));
            map.put("FSTARTDATE", row.getString("FSTARTDATE"));
            map.put("FENDDATE", row.getString("FENDDATE"));
            map.put("FDEDUCTIONTYPE", row.getString("FDEDUCTIONTYPE"));
            map.put("FTAXPAYERTYPE", row.getString("FTAXPAYERTYPE"));
            deductionSumList.add(map);
        }
        deductDraftList.close();
        return deductionSumList;
    }

    private void updateExecute(List<Object[]> countParamList, List<Object[]> invoiceamountParamList, List<Object[]> taxamountParamList, String deductType, int index, List<Map<String, String>> draftDetailListSumList, List<Map<String, String>> deductionSum) {
        if (CollectionUtils.isEmpty(deductionSum)) {
            return;
        }
        Map<Object, Object> ftaxaccountserialno = new HashMap();
        if (CollectionUtils.isNotEmpty(draftDetailListSumList)) {
            ftaxaccountserialno = draftDetailListSumList.stream().collect(Collectors.groupingBy(d -> String.valueOf(d.get("FTAXACCOUNTSERIALNO"))));
        }
        long[] countDetailFid = DB.genLongIds(null, (int)deductionSum.size());
        long[] amountDetailFid = DB.genLongIds(null, (int)deductionSum.size());
        long[] taxAmountDetailFid = DB.genLongIds(null, (int)deductionSum.size());
        DynamicObject ruleDynamicObject = this.service.getRuleDynamicObject(deductType);
        DynamicObject rule = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity").get(index);
        DynamicObject rule1 = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity1").get(index);
        DynamicObject rule11 = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity11").get(index);
        int i = 0;
        for (Map<String, String> map : deductionSum) {
            BigDecimal count = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal taxAmount = BigDecimal.ZERO;
            String serialno = map.get("FSERIALNO");
            Long orgid = Long.valueOf(map.get("FORGID"));
            String taxperiod = map.get("FTAXPERIOD");
            Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
            Date skssqz = DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
            List invoiceList = (List)ftaxaccountserialno.get(serialno);
            if (CollectionUtils.isNotEmpty((Collection)invoiceList)) {
                count = new BigDecimal(invoiceList.size());
                for (Map invoiceMap : invoiceList) {
                    amount = amount.add(new BigDecimal((String)invoiceMap.get("FAMOUNT")));
                    taxAmount = taxAmount.add(new BigDecimal((String)invoiceMap.get("FTAXAMOUNT")));
                }
            }
            invoiceamountParamList.add(new Object[]{amountDetailFid[i], skssqq, skssqz, rule.getString("filtercondition"), rule.getString("conditionjson"), rule.getString("bizname"), amount, BigDecimal.ZERO, "0", "positive", "zjjs", rule.getLong("amountfield"), orgid, "amount", serialno, rule.getLong("table")});
            taxamountParamList.add(new Object[]{taxAmountDetailFid[i], skssqq, skssqz, rule1.getString("filtercondition1"), rule1.getString("conditionjson1"), rule1.getString("bizname1"), taxAmount, BigDecimal.ZERO, "0", "positive", "zjjs", rule1.getLong("amountfield1"), orgid, "taxamount", serialno, rule1.getLong("table1")});
            countParamList.add(new Object[]{countDetailFid[i], skssqq, skssqz, rule11.getString("filtercondition11"), rule11.getString("conditionjson11"), rule11.getString("bizname11"), count, BigDecimal.ZERO, "0", "positive", "zjjs", rule11.getLong("amountfield11"), orgid, "count", serialno, rule11.getLong("table11")});
            ++i;
        }
    }

    private void updateHzExecute(List<Object[]> countParamList, List<Object[]> invoiceamountParamList, List<Object[]> taxamountParamList, String deductType, int index, List<Map<String, String>> draftDetailListSumList, List<Map<String, String>> deductionSum) {
        if (CollectionUtils.isEmpty(deductionSum) || CollectionUtils.isEmpty(draftDetailListSumList)) {
            return;
        }
        Map<Object, Object> ftaxaccountserialno = new HashMap();
        if (CollectionUtils.isNotEmpty(draftDetailListSumList)) {
            ftaxaccountserialno = draftDetailListSumList.stream().collect(Collectors.groupingBy(d -> String.valueOf(d.get("FTAXACCOUNTSERIALNO"))));
        }
        DynamicObject ruleDynamicObject = this.service.getRuleDynamicObject(deductType);
        DynamicObject rule = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity").get(index);
        DynamicObject rule1 = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity1").get(index);
        DynamicObject rule11 = (DynamicObject)ruleDynamicObject.getDynamicObjectCollection("entryentity11").get(index);
        for (Map<String, String> map : deductionSum) {
            String serialno = map.get("FSERIALNO");
            String ftaxpayertype = map.get("FTAXPAYERTYPE");
            String fdeductiontype = map.get("FDEDUCTIONTYPE");
            Long orgid = Long.valueOf(map.get("FORGID"));
            String fstartdate = map.get("FSTARTDATE");
            String fenddate = map.get("FENDDATE");
            Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)fstartdate, (String)"yyyy-MM-dd HH:mm:ss"));
            Date skssqz = DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)fenddate, (String)"yyyy-MM-dd HH:mm:ss"));
            List invoiceList = (List)ftaxaccountserialno.get(serialno);
            if (!CollectionUtils.isNotEmpty((Collection)invoiceList)) continue;
            Map<String, List<Map>> orgInvoiceMap = invoiceList.stream().collect(Collectors.groupingBy(o -> (String)o.get("FSUBORG")));
            for (Map.Entry<String, List<Map>> entry : orgInvoiceMap.entrySet()) {
                Long suborg = Long.valueOf(entry.getKey());
                List<Map> invoices = entry.getValue();
                BigDecimal count = BigDecimal.ZERO;
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal taxAmount = BigDecimal.ZERO;
                count = new BigDecimal(invoices.size());
                for (Map invoiceMap : invoices) {
                    amount = amount.add(new BigDecimal((String)invoiceMap.get("FAMOUNT")));
                    taxAmount = taxAmount.add(new BigDecimal((String)invoiceMap.get("FTAXAMOUNT")));
                }
                invoiceamountParamList.add(new Object[]{this.genLongId(), skssqq, skssqz, rule.getString("filtercondition"), rule.getString("conditionjson"), rule.getString("bizname"), amount, BigDecimal.ZERO, "0", "positive", "zjjs", rule.getLong("amountfield"), orgid, "amount", serialno, rule.getLong("table"), ftaxpayertype, suborg, fdeductiontype});
                taxamountParamList.add(new Object[]{this.genLongId(), skssqq, skssqz, rule1.getString("filtercondition1"), rule1.getString("conditionjson1"), rule1.getString("bizname1"), taxAmount, BigDecimal.ZERO, "0", "positive", "zjjs", rule1.getLong("amountfield1"), orgid, "taxamount", serialno, rule1.getLong("table1"), ftaxpayertype, suborg, fdeductiontype});
                countParamList.add(new Object[]{this.genLongId(), skssqq, skssqz, rule11.getString("filtercondition11"), rule11.getString("conditionjson11"), rule11.getString("bizname11"), count, BigDecimal.ZERO, "0", "positive", "zjjs", rule11.getLong("amountfield11"), orgid, "count", serialno, rule11.getLong("table11"), ftaxpayertype, suborg, fdeductiontype});
            }
        }
    }

    private long genLongId() {
        return DB.genLongId(null);
    }

    private void updateDkdj(List<Object[]> countParamList, List<Object[]> taxamountParamList, List<String> serialNoList) {
        if (CollectionUtils.isEmpty(serialNoList)) {
            return;
        }
        String serials = String.join((CharSequence)"','", serialNoList);
        String dkdjDetailSql = "select fid,forgid,fcount,famount,ftaxamount,fserialno,ftaxperiod from t_tcvat_deduction_summary where fdeductiontype = '5' and fserialno in ('" + serials + "')";
        DataSet dkdjDetailList = DB.queryDataSet((String)"DeductionDraftUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)dkdjDetailSql);
        if (!dkdjDetailList.isEmpty()) {
            DynamicObject customRuleObject = this.service.getRuleDynamicObject("VAT_JXDK_BQDK_9");
            ArrayList dkdjDetailSumList = new ArrayList(500);
            ArrayList<Long> ids = new ArrayList<Long>(512);
            while (dkdjDetailList.hasNext()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                Row row = dkdjDetailList.next();
                ids.add(Long.valueOf(row.getString("FID")));
                map.put("FID", row.getString("FID"));
                map.put("FSERIALNO", row.getString("FSERIALNO"));
                map.put("FORGID", row.getString("FORGID"));
                map.put("FTAXPERIOD", row.getString("FTAXPERIOD"));
                map.put("FAMOUNT", row.getString("FAMOUNT"));
                map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
                map.put("FCOUNT", row.getString("FCOUNT"));
                dkdjDetailSumList.add(map);
            }
            String fdraftids = ids.stream().map(Objects::toString).collect(Collectors.joining(","));
            String adjustSql = "select fdraftid,foriginamount,frowcode from t_tcvat_draft_edit where fdrafttype='tcvat_deduction_list' and fdraftid in (" + fdraftids + ")";
            DataSet adjustList = DB.queryDataSet((String)"DeductionDraftUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)adjustSql);
            HashMap<String, String> adjustMap = new HashMap<String, String>(16);
            while (adjustList.hasNext()) {
                Row row = adjustList.next();
                String fdraftid = row.getString("FDRAFTID");
                String foriginamount = row.getString("FORIGINAMOUNT");
                String frowcode = row.getString("FROWCODE");
                adjustMap.put(fdraftid + "_" + frowcode, foriginamount);
            }
            long[] dkdjCountDetailFid = DB.genLongIds(null, (int)dkdjDetailSumList.size());
            long[] dkdjTaxAmountDetailFid = DB.genLongIds(null, (int)dkdjDetailSumList.size());
            int seq = 0;
            for (Map map : dkdjDetailSumList) {
                DynamicObject rule1 = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity1").get(0);
                DynamicObject rule11 = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity11").get(0);
                Long orgid = Long.valueOf((String)map.get("FORGID"));
                Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)String.valueOf(map.get("FTAXPERIOD")), (String)"yyyy-MM"));
                Date skssqz = DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)String.valueOf(map.get("FTAXPERIOD")), (String)"yyyy-MM"));
                String serialno = String.valueOf(map.get("FSERIALNO"));
                String fid = (String)map.get("FID");
                String taxamt = (String)adjustMap.get(fid + "_taxamount");
                BigDecimal taxAmount = StringUtils.isNotBlank((CharSequence)taxamt) ? new BigDecimal(taxamt) : new BigDecimal((String)map.get("FTAXAMOUNT"));
                String cnt = (String)adjustMap.get(fid + "_count");
                BigDecimal count = StringUtils.isNotBlank((CharSequence)cnt) ? new BigDecimal(cnt) : new BigDecimal((String)map.get("FCOUNT"));
                taxamountParamList.add(new Object[]{dkdjTaxAmountDetailFid[seq], skssqq, skssqz, rule1.getString("filtercondition1"), rule1.getString("conditionjson1"), rule1.getString("bizname1"), taxAmount, BigDecimal.ZERO, "0", "positive", "zjjs", rule1.getLong("amountfield1"), orgid, "taxamount", serialno, rule1.getLong("table1")});
                countParamList.add(new Object[]{dkdjCountDetailFid[seq], skssqq, skssqz, rule11.getString("filtercondition11"), rule11.getString("conditionjson11"), rule11.getString("bizname11"), count, BigDecimal.ZERO, "0", "positive", "zjjs", rule11.getLong("amountfield11"), orgid, "count", serialno, rule11.getLong("table11")});
                ++seq;
            }
            adjustList.close();
        }
        dkdjDetailList.close();
    }

    private void updateHzDkdj(List<Object[]> countParamList, List<Object[]> taxamountParamList, List<String> serialNoList) {
        if (CollectionUtils.isEmpty(serialNoList)) {
            return;
        }
        DynamicObject customRuleObject = this.service.getRuleDynamicObject("VAT_JXDK_BQDK_9");
        String serials = String.join((CharSequence)"','", serialNoList);
        String dkdjDetailSql = "select fid,forgid,fcount,famount,ftaxamount,fserialno,fstartdate,fenddate,ftaxpayertype,fdeductiontype from t_tcvat_hz_deduction_sum where fdeductiontype = '5' and fserialno in ('" + serials + "')";
        DataSet dkdjDetailList = DB.queryDataSet((String)"DeductionDraftUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)dkdjDetailSql);
        if (!dkdjDetailList.isEmpty()) {
            ArrayList dkdjDetailSumList = new ArrayList(500);
            ArrayList<Long> ids = new ArrayList<Long>(512);
            while (dkdjDetailList.hasNext()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                Row row = dkdjDetailList.next();
                ids.add(Long.valueOf(row.getString("FID")));
                map.put("FID", row.getString("FID"));
                map.put("FSERIALNO", row.getString("FSERIALNO"));
                map.put("FORGID", row.getString("FORGID"));
                map.put("FSTARTDATE", row.getString("FSTARTDATE"));
                map.put("FENDDATE", row.getString("FENDDATE"));
                map.put("FTAXPAYERTYPE", row.getString("FTAXPAYERTYPE"));
                map.put("FAMOUNT", row.getString("FAMOUNT"));
                map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
                map.put("FDEDUCTIONTYPE", row.getString("FDEDUCTIONTYPE"));
                map.put("FCOUNT", row.getString("FCOUNT"));
                dkdjDetailSumList.add(map);
            }
            String fdraftids = ids.stream().map(Objects::toString).collect(Collectors.joining(","));
            String adjustSql = "select fdraftid,foriginamount,frowcode from t_tcvat_draft_edit where fdrafttype='tcvat_hz_deduction_list' and fdraftid in (" + fdraftids + ")";
            DataSet adjustList = DB.queryDataSet((String)"DeductionDraftUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)adjustSql);
            HashMap<String, String> adjustMap = new HashMap<String, String>(16);
            while (adjustList.hasNext()) {
                Row row = adjustList.next();
                String fdraftid = row.getString("FDRAFTID");
                String foriginamount = row.getString("FORIGINAMOUNT");
                String frowcode = row.getString("FROWCODE");
                adjustMap.put(fdraftid + "_" + frowcode, foriginamount);
            }
            long[] dkdjCountDetailFid = DB.genLongIds(null, (int)dkdjDetailSumList.size());
            long[] dkdjTaxAmountDetailFid = DB.genLongIds(null, (int)dkdjDetailSumList.size());
            int seq = 0;
            for (Map map : dkdjDetailSumList) {
                DynamicObject rule1 = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity1").get(0);
                DynamicObject rule11 = (DynamicObject)customRuleObject.getDynamicObjectCollection("entryentity11").get(0);
                Long orgid = Long.valueOf((String)map.get("FORGID"));
                Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)String.valueOf(map.get("FSTARTDATE")), (String)"yyyy-MM-dd HH:mm:ss"));
                Date skssqz = DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)String.valueOf(map.get("FENDDATE")), (String)"yyyy-MM-dd HH:mm:ss"));
                String fdeductiontype = String.valueOf(map.get("FDEDUCTIONTYPE"));
                String serialno = String.valueOf(map.get("FSERIALNO"));
                String ftaxpayertype = String.valueOf(map.get("FTAXPAYERTYPE"));
                String fid = (String)map.get("FID");
                String taxamt = (String)adjustMap.get(fid + "_taxamount");
                BigDecimal taxAmount = StringUtils.isNotBlank((CharSequence)taxamt) ? new BigDecimal(taxamt) : new BigDecimal((String)map.get("FTAXAMOUNT"));
                String cnt = (String)adjustMap.get(fid + "_count");
                BigDecimal count = StringUtils.isNotBlank((CharSequence)cnt) ? new BigDecimal(cnt) : new BigDecimal((String)map.get("FCOUNT"));
                taxamountParamList.add(new Object[]{dkdjTaxAmountDetailFid[seq], skssqq, skssqz, rule1.getString("filtercondition1"), rule1.getString("conditionjson1"), rule1.getString("bizname1"), taxAmount, BigDecimal.ZERO, "0", "positive", "zjjs", rule1.getLong("amountfield1"), orgid, "taxamount", serialno, rule1.getLong("table1"), ftaxpayertype, orgid, fdeductiontype});
                countParamList.add(new Object[]{dkdjCountDetailFid[seq], skssqq, skssqz, rule11.getString("filtercondition11"), rule11.getString("conditionjson11"), rule11.getString("bizname11"), count, BigDecimal.ZERO, "0", "positive", "zjjs", rule11.getLong("amountfield11"), orgid, "count", serialno, rule11.getLong("table11"), ftaxpayertype, orgid, fdeductiontype});
                ++seq;
            }
            adjustList.close();
        }
        dkdjDetailList.close();
    }

    private void updateAdjust(String deductType, List<String> serialNoList, List<Object[]> adjustList, String tableName, String drafttype) {
        if (CollectionUtils.isEmpty(serialNoList)) {
            return;
        }
        String serials = String.join((CharSequence)"','", serialNoList);
        String summarySql = "select fid,forgid,fcount,famount,ftaxamount from " + tableName + " where (fcount!=0 or famount!=0 or ftaxamount!=0) and fdeductiontype = '" + deductType + "' and fserialno in ('" + serials + "')";
        DataSet summarySet = DB.queryDataSet((String)"TaxCategoryUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)summarySql);
        if (!summarySet.isEmpty()) {
            ArrayList sumList = new ArrayList(500);
            while (summarySet.hasNext()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                Row row = summarySet.next();
                map.put("FID", row.getString("FID"));
                map.put("FORGID", row.getString("FORGID"));
                map.put("FAMOUNT", row.getString("FAMOUNT"));
                map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
                map.put("FCOUNT", row.getString("FCOUNT"));
                sumList.add(map);
            }
            long[] countFid = DB.genLongIds(null, (int)sumList.size());
            long[] amountFid = DB.genLongIds(null, (int)sumList.size());
            long[] taxAmountFid = DB.genLongIds(null, (int)sumList.size());
            int seq = 0;
            String rmk = "4".equals(deductType) ? " " : this.remark;
            for (Map map : sumList) {
                Long id = Long.valueOf((String)map.get("FID"));
                Long orgid = Long.valueOf((String)map.get("FORGID"));
                BigDecimal count = new BigDecimal((String)map.get("FCOUNT"));
                BigDecimal amount = new BigDecimal((String)map.get("FAMOUNT"));
                BigDecimal taxAmount = new BigDecimal((String)map.get("FTAXAMOUNT"));
                if (BigDecimal.ZERO.compareTo(count) != 0) {
                    adjustList.add(new Object[]{countFid[seq], "2", "", orgid, BigDecimal.ZERO, count, rmk, id, "count", BigDecimal.ZERO, "", drafttype});
                }
                if (BigDecimal.ZERO.compareTo(amount) != 0) {
                    adjustList.add(new Object[]{amountFid[seq], "2", "", orgid, BigDecimal.ZERO, amount, rmk, id, "amount", BigDecimal.ZERO, "", drafttype});
                }
                if (BigDecimal.ZERO.compareTo(taxAmount) != 0) {
                    adjustList.add(new Object[]{taxAmountFid[seq], "2", "", orgid, BigDecimal.ZERO, taxAmount, rmk, id, "taxamount", BigDecimal.ZERO, "", drafttype});
                }
                ++seq;
            }
        }
        summarySet.close();
    }

    private List<Map<String, String>> query(String baseInvoiceTypeId, String deductType, List<String> serialNoList) {
        if (CollectionUtils.isEmpty(serialNoList)) {
            return Collections.emptyList();
        }
        String serials = String.join((CharSequence)"','", serialNoList);
        String specialDetailSql = "select forgid,ftaxaccountserialno,ftaxperiod,fdeductiontype,fbaseinvoicetype,famount,ftaxamount from t_tcvat_deduction_detail where fbaseinvoicetype in (" + baseInvoiceTypeId + ") and fdeductiontype = '" + deductType + "' and ftaxaccountserialno in ('" + serials + "')";
        DataSet draftDetailList = DB.queryDataSet((String)"DeductionDraftUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)specialDetailSql);
        if (draftDetailList.isEmpty()) {
            draftDetailList.close();
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> draftDetailListSumList = new ArrayList<Map<String, String>>(500);
        while (draftDetailList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = draftDetailList.next();
            map.put("FTAXACCOUNTSERIALNO", row.getString("FTAXACCOUNTSERIALNO"));
            map.put("FAMOUNT", row.getString("FAMOUNT"));
            map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
            map.put("FDEDUCTIONTYPE", row.getString("FDEDUCTIONTYPE"));
            map.put("FTAXPERIOD", row.getString("FTAXPERIOD"));
            map.put("FBASEINVOICETYPE", row.getString("FBASEINVOICETYPE"));
            map.put("FORGID", row.getString("FORGID"));
            draftDetailListSumList.add(map);
        }
        draftDetailList.close();
        return draftDetailListSumList;
    }

    private List<Map<String, String>> queryHz(String baseInvoiceTypeId, String deductType, List<String> serialNoList) {
        if (CollectionUtils.isEmpty(serialNoList)) {
            return Collections.emptyList();
        }
        String serials = String.join((CharSequence)"','", serialNoList);
        String specialDetailSql = "select forgid,ftaxaccountserialno,fstartdate,fenddate,fdeductiontype,fbaseinvoicetype,famount,ftaxamount,ftaxpayertype,fsuborg from t_tcvat_hz_deduct_detail where fbaseinvoicetype in (" + baseInvoiceTypeId + ") and fdeductiontype = '" + deductType + "' and ftaxaccountserialno in ('" + serials + "')";
        DataSet draftDetailList = DB.queryDataSet((String)"DeductionDraftUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)specialDetailSql);
        if (draftDetailList.isEmpty()) {
            draftDetailList.close();
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> draftDetailListSumList = new ArrayList<Map<String, String>>(500);
        while (draftDetailList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = draftDetailList.next();
            map.put("FORGID", row.getString("FORGID"));
            map.put("FTAXACCOUNTSERIALNO", row.getString("FTAXACCOUNTSERIALNO"));
            map.put("FSTARTDATE", row.getString("FSTARTDATE"));
            map.put("FENDDATE", row.getString("FENDDATE"));
            map.put("FDEDUCTIONTYPE", row.getString("FDEDUCTIONTYPE"));
            map.put("FBASEINVOICETYPE", row.getString("FBASEINVOICETYPE"));
            map.put("FAMOUNT", row.getString("FAMOUNT"));
            map.put("FTAXAMOUNT", row.getString("FTAXAMOUNT"));
            map.put("FTAXPAYERTYPE", row.getString("FTAXPAYERTYPE"));
            map.put("FSUBORG", row.getString("FSUBORG"));
            draftDetailListSumList.add(map);
        }
        draftDetailList.close();
        return draftDetailListSumList;
    }

    private List<Map<String, String>> queryCustomDetail(List<String> serialNoList) {
        if (CollectionUtils.isEmpty(serialNoList)) {
            return Collections.emptyList();
        }
        String serials = String.join((CharSequence)"','", serialNoList);
        String specialDetailSql = "select ftaxaccountserialno,forgid,ftax_period,fcustom_declaration_no,ftotal_tax_amount,feffective_tax_amount,funit_price from t_tcvat_customs_detail where ftaxaccountserialno in ('" + serials + "')";
        DataSet draftDetailList = DB.queryDataSet((String)"DeductionDraftUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)specialDetailSql);
        if (draftDetailList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> draftDetailListSumList = new ArrayList<Map<String, String>>(500);
        while (draftDetailList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = draftDetailList.next();
            map.put("FTAXACCOUNTSERIALNO", row.getString("FTAXACCOUNTSERIALNO"));
            map.put("FORGID", row.getString("FORGID"));
            map.put("FCUSTOM_DECLARATION_NO", row.getString("FCUSTOM_DECLARATION_NO"));
            map.put("FTAXPERIOD", row.getString("FTAX_PERIOD"));
            map.put("FTAXAMOUNT", row.getString("FEFFECTIVE_TAX_AMOUNT"));
            map.put("FAMOUNT", row.getString("FUNIT_PRICE"));
            draftDetailListSumList.add(map);
        }
        return draftDetailListSumList;
    }

    private List<Map<String, String>> queryHzCustomDetail(List<String> serialNoList) {
        if (CollectionUtils.isEmpty(serialNoList)) {
            return Collections.emptyList();
        }
        String serials = String.join((CharSequence)"','", serialNoList);
        String specialDetailSql = "select fsuborg,ftaxaccountserialno,forgid,ftax_period,fcustom_declaration_no,ftotal_tax_amount,feffective_tax_amount,funit_price from t_tcvat_hz_customs_detail where ftaxaccountserialno in ('" + serials + "')";
        DataSet draftDetailList = DB.queryDataSet((String)"DeductionDraftUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)specialDetailSql);
        if (draftDetailList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> draftDetailListSumList = new ArrayList<Map<String, String>>(500);
        while (draftDetailList.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            Row row = draftDetailList.next();
            map.put("FTAXACCOUNTSERIALNO", row.getString("FTAXACCOUNTSERIALNO"));
            map.put("FORGID", row.getString("FORGID"));
            map.put("FSUBORG", row.getString("FSUBORG"));
            map.put("FCUSTOM_DECLARATION_NO", row.getString("FCUSTOM_DECLARATION_NO"));
            map.put("FTAXPERIOD", row.getString("FTAX_PERIOD"));
            map.put("FTAXAMOUNT", row.getString("FEFFECTIVE_TAX_AMOUNT"));
            map.put("FAMOUNT", row.getString("FUNIT_PRICE"));
            draftDetailListSumList.add(map);
        }
        return draftDetailListSumList;
    }
}

