/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.Base39Coder;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import org.apache.commons.collections.CollectionUtils;

public class DeductionInvoiceTypeUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            result.setSuccess(true);
            StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u66f4\u65b0\u51cf\u514d\u7a0e\u53f0\u8d26\u53d6\u6570\u89c4\u5219\u53d1\u7968\u7c7b\u578b\u8fc7\u7a0b", (String)"DeductionInvoiceTypeUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
            Map<String, String> invoiceTypeMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("id")));
            Map<String, String> invoiceTypeNameMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("number"), o -> o.getString("name")));
            this.dealDeductionData(invoiceTypeMap, invoiceTypeNameMap);
            result.setLog(ResManager.loadKDString((String)message.toString(), (String)"InvoiceTypeUpgradeService_10", (String)"DeductionInvoiceTypeUpgradeService_1", (Object[])new Object[0]));
            return result;
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
            return result;
        }
    }

    private void dealDeductionData(Map<String, String> invoiceTypeMap, Map<String, String> invoiceTypeNameMap) {
        QFilter qFilter = new QFilter("entryentity.filtercondition", "like", (Object)ResManager.loadKDString((String)"%\u53d1\u7968\u7c7b\u578b%", (String)"DeductionInvoiceTypeUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
        DynamicObject[] incomeObjects = BusinessDataServiceHelper.load((String)"tcvat_rule_deduction", (String)"id,entryentity.filtercondition,entryentity.conditionjson", (QFilter[])new QFilter[]{qFilter});
        if (incomeObjects != null && incomeObjects.length > 0) {
            Arrays.stream(incomeObjects).forEach(o -> {
                DynamicObjectCollection dynamicObjectCollection = o.getDynamicObjectCollection("entryentity");
                if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                    this.dealEntryData(invoiceTypeMap, dynamicObjectCollection, "filtercondition", "conditionjson", invoiceTypeNameMap);
                }
            });
            SaveServiceHelper.update((DynamicObject[])incomeObjects);
        }
    }

    private void dealEntryData(Map<String, String> invoiceTypeMap, DynamicObjectCollection dynamicObjectCollection, String filterConditionFieldName, String conditionJsonFieldName, Map<String, String> invoiceTypeNameMap) {
        dynamicObjectCollection.stream().forEach(e -> {
            String filterCondition = e.getString(filterConditionFieldName);
            if (StringUtils.isNotEmpty((CharSequence)filterCondition) && filterCondition.contains(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"DeductionInvoiceTypeUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]))) {
                String conditionJson = e.getString(conditionJsonFieldName);
                HashMap conditionMap = (HashMap)JsonUtil.fromJson((String)conditionJson, Map.class);
                List simpleFilterRows = (List)conditionMap.get("FilterRow");
                ArrayList types = new ArrayList();
                simpleFilterRows.forEach(s -> {
                    if ("type".equals(s.get("FieldName"))) {
                        s.put("FieldName", "baseinvoicetype.number");
                        ArrayList baseDataIds = new ArrayList();
                        List values = (List)s.get("Value");
                        values.stream().forEach(v -> {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("Id", Base39Coder.toString((long)IDService.get().genLongId()));
                            map.put("Value", (String)invoiceTypeMap.get(v.get("Value")));
                            types.add(invoiceTypeNameMap.get(v.get("Value")));
                            baseDataIds.add(map);
                        });
                        s.put("BaseDataIds", baseDataIds);
                    }
                });
                conditionMap.put("FilterRow", simpleFilterRows);
                e.set(conditionJsonFieldName, (Object)JsonUtil.toJson((Object)conditionMap));
                if (CollectionUtils.isNotEmpty(types)) {
                    String[] filterConditions = e.getString(filterConditionFieldName).split(ResManager.loadKDString((String)"  \u5e76\u4e14      ", (String)"DeductionInvoiceTypeUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                    ArrayList newFilterConditions = new ArrayList();
                    Arrays.asList(filterConditions).forEach(f -> {
                        if (f.contains(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"DeductionInvoiceTypeUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]))) {
                            Object[] tempFilterConditions = f.split(" ");
                            tempFilterConditions[0] = ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u540d\u79f0", (String)"DeductionInvoiceTypeUpgradeService_5", (String)"taxc-tcvat", (Object[])new Object[0]);
                            tempFilterConditions[2] = String.join((CharSequence)";", types);
                            newFilterConditions.add(StringUtils.join((Object[])tempFilterConditions, (String)" "));
                        } else {
                            newFilterConditions.add(f);
                        }
                    });
                    if (CollectionUtils.isNotEmpty(newFilterConditions)) {
                        if (newFilterConditions.size() > 1) {
                            e.set(filterConditionFieldName, (Object)StringUtils.join((Object[])newFilterConditions.toArray(), (String)ResManager.loadKDString((String)"  \u5e76\u4e14      ", (String)"DeductionInvoiceTypeUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0])));
                        } else {
                            e.set(filterConditionFieldName, newFilterConditions.toArray()[0]);
                        }
                    }
                }
            }
        });
    }
}

