/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcvat.common.dto.update.RuleEntityDto;

public class DigitalElectricInvoiceTypeUpdate
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(DigitalElectricInvoiceTypeUpdate.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public void click(EventObject evt) {
        StringBuilder message = new StringBuilder("DigitalElectricInvoiceTypeUpdate update start\n");
        this.executeRuleInvoiceUpdate();
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("DigitalElectricInvoiceTypeUpdate update start\n");
        long l = System.currentTimeMillis();
        try {
            this.executeRuleInvoiceUpdate();
            message.append("\nDigitalElectricInvoiceTypeUpdate update complete ").append(System.currentTimeMillis() - l).append("ms");
        }
        catch (Exception e) {
            message.append(e.getStackTrace()).append(System.currentTimeMillis() - l).append("ms");
        }
        result.setLog(message.toString());
        return result;
    }

    private void executeRuleInvoiceUpdate() {
        ArrayList<RuleEntityDto> ruleEntityDtoList = new ArrayList<RuleEntityDto>();
        String targetContent = ResManager.loadKDString((String)"\u6570\u7535\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", (String)"DigitalElectricInvoiceTypeUpdate_0", (String)"taxc-tcvat", (Object[])new Object[0]);
        String sourceContent = ResManager.loadKDString((String)"%\u5168\u7535\u666e\u7968%", (String)"DigitalElectricInvoiceTypeUpdate_1", (String)"taxc-tcvat", (Object[])new Object[0]);
        RuleEntityDto qtbhsEntityDto = new RuleEntityDto("t_tcvat_rule_inc_qtbhs", "fconditionjson", "ffiltercondition", sourceContent, targetContent, "1163062995127970816");
        RuleEntityDto qtseEntityDto = new RuleEntityDto("t_tcvat_rule_inc_qtse", "fconditionjson", "ffiltercondition", sourceContent, targetContent, "1163062995127970816");
        RuleEntityDto entryEntityDto = new RuleEntityDto("t_tcvat_rule_entry", "ffconditionjson", "ffiltercondition", sourceContent, targetContent, "1163062995127970816");
        RuleEntityDto deductEntryEntityDto = new RuleEntityDto("t_tcvat_rule_deduct_entry", "ffconditionjson", "ffiltercondition", sourceContent, targetContent, "1407439936361095168");
        RuleEntityDto taxEntryEntityDto = new RuleEntityDto("t_tcvat_deduct_tax_entry", "fconditionjson", "ffiltercondition", sourceContent, targetContent, "1407439936361095168");
        RuleEntityDto numEntryEntityDto = new RuleEntityDto("t_tcvat_deduct_num_entry", "fconditionjson", "ffiltercondition", sourceContent, targetContent, "1407439936361095168");
        RuleEntityDto ruleEntryEntityDto = new RuleEntityDto("t_tcvat_rule_entry", "ffconditionjson", "ffiltercondition", sourceContent, targetContent, "1407464068331102208,1163062995127970816");
        String targetContent2 = ResManager.loadKDString((String)"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", (String)"DigitalElectricInvoiceTypeUpdate_2", (String)"taxc-tcvat", (Object[])new Object[0]);
        String sourceContent2 = ResManager.loadKDString((String)"%\u5168\u7535\u4e13\u7968%", (String)"DigitalElectricInvoiceTypeUpdate_3", (String)"taxc-tcvat", (Object[])new Object[0]);
        RuleEntityDto taxEntry2EntityDto = new RuleEntityDto("t_tcvat_deduct_tax_entry", "fconditionjson", "ffiltercondition", sourceContent2, targetContent2, "1407439936361095168");
        RuleEntityDto deductEntry2EntityDto = new RuleEntityDto("t_tcvat_rule_deduct_entry", "ffconditionjson", "ffiltercondition", sourceContent2, targetContent2, "1407439936361095168");
        RuleEntityDto numEntry2EntityDto = new RuleEntityDto("t_tcvat_deduct_num_entry", "fconditionjson", "ffiltercondition", sourceContent2, targetContent2, "1407439936361095168");
        RuleEntityDto ruleEntry2EntityDto = new RuleEntityDto("t_tcvat_rule_entry", "ffconditionjson", "ffiltercondition", sourceContent2, targetContent2, "1407464068331102208,1163062995127970816");
        ruleEntityDtoList.add(qtbhsEntityDto);
        ruleEntityDtoList.add(entryEntityDto);
        ruleEntityDtoList.add(qtseEntityDto);
        ruleEntityDtoList.add(deductEntryEntityDto);
        ruleEntityDtoList.add(taxEntryEntityDto);
        ruleEntityDtoList.add(numEntryEntityDto);
        ruleEntityDtoList.add(ruleEntryEntityDto);
        ruleEntityDtoList.add(deductEntry2EntityDto);
        ruleEntityDtoList.add(taxEntry2EntityDto);
        ruleEntityDtoList.add(numEntry2EntityDto);
        ruleEntityDtoList.add(ruleEntry2EntityDto);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        paramList.add(new Object[0]);
        for (RuleEntityDto dto : ruleEntityDtoList) {
            String selectSQL = String.format("select fid,%1$s,%2$s from %3$s where %4$s like '%5$s' and ftable in (%6$s);", dto.getConditionjsonField(), dto.getFilterconditionField(), dto.getTableName(), dto.getConditionjsonField(), dto.getSourceContent(), dto.getTableIds().replaceAll("\"", ""));
            List ruleEntityList = DBUtils.query((String)selectSQL);
            for (Map ruleEntityMap : ruleEntityList) {
                String fconditionjson = String.valueOf(ruleEntityMap.get(dto.getConditionjsonField().toUpperCase())).replace(dto.getSourceContent().replace("%", ""), dto.getTargetContent());
                String ffiltercondition = String.valueOf(ruleEntityMap.get(dto.getFilterconditionField().toUpperCase())).replace(dto.getSourceContent().replace("%", ""), dto.getTargetContent());
                ruleEntityMap.put(dto.getConditionjsonField().toUpperCase(), fconditionjson);
                ruleEntityMap.put(dto.getFilterconditionField().toUpperCase(), ffiltercondition);
                String updateSqL = String.format("update %1$s set %2$s = '%3$s' , %4$s = '%5$s' where %6$s like '%7$s' and fid in (%8$s);", dto.getTableName(), dto.getConditionjsonField(), ruleEntityMap.get(dto.getConditionjsonField().toUpperCase()), dto.getFilterconditionField(), ruleEntityMap.get(dto.getFilterconditionField().toUpperCase()), dto.getConditionjsonField(), dto.getSourceContent(), (Long)ruleEntityMap.get("FID"));
                DBUtils.executeBatch((String)updateSqL, paramList);
            }
        }
    }
}

