/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcvat.business.service.upgradeservice.ProjectInfoUpgradeService;

public class DraftYbnsrZlbUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ProjectInfoUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        String sql = "select fsbbid,fybxm,fjzjtxm from t_tcvat_zlb_ybnsr where fsbbid not in (select fsbbid from t_tcvat_zlb_ybnsr where fewblxh='34') and fewblxh='30'";
        String his = "select fcellid,fsbbid,ftargetvalue,fremark,fmodifytype,foriginalvalue,fmodifierfield,fmodifydatefield from t_tctb_declare_his where fsbbid not in (select fsbbid from t_tcvat_zlb_ybnsr where fewblxh='34') and fcellid ='tcvat_zlb_ybnsr_30_ybxm'";
        String updSql = "update t_tcvat_zlb_ybnsr set fewblxh='34' where fewblxh='31' and fsbbid not in (select t1.fsbbid from (select fsbbid from t_tcvat_zlb_ybnsr where fewblxh='34') t1)";
        this.addLog(INFO, sql);
        long l = System.currentTimeMillis();
        List preProjects = DBUtils.query((String)sql);
        long l1 = System.currentTimeMillis();
        this.addLog(INFO, String.format("The result size is %d, use time %d", preProjects.size(), l1 - l));
        this.addLog(INFO, his);
        l = System.currentTimeMillis();
        List hisProjects = DBUtils.query((String)his);
        l1 = System.currentTimeMillis();
        this.addLog(INFO, String.format("The his result size is %d, use time %d", hisProjects.size(), l1 - l));
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>(preProjects.size());
        for (Map preProject : preProjects) {
            Object fsbbid = preProject.get("FSBBID");
            Object fybxm = preProject.get("FYBXM");
            Object fzjztxm = preProject.get("FZJZTXM");
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_zlb_ybnsr");
            dyo.set("sbbid", fsbbid);
            dyo.set("ybxm", fybxm);
            dyo.set("jzjtxm", fzjztxm);
            dyo.set("ewblxh", (Object)"31");
            dyo.set("ewblname", (Object)ResManager.loadKDString((String)"\u5176\u4e2d\uff1a\u2460\u5206\u6b21\u9884\u7f34\u7a0e\u989d", (String)"DraftYbnsrZlbUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            saveObjs.add(dyo);
            DynamicObject dyo32 = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_zlb_ybnsr");
            dyo32.set("sbbid", fsbbid);
            dyo32.set("ybxm", (Object)BigDecimal.ZERO);
            dyo32.set("jzjtxm", (Object)BigDecimal.ZERO);
            dyo32.set("ewblxh", (Object)"32");
            saveObjs.add(dyo32);
            DynamicObject dyo33 = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_zlb_ybnsr");
            dyo33.set("sbbid", fsbbid);
            dyo33.set("ybxm", (Object)BigDecimal.ZERO);
            dyo33.set("jzjtxm", (Object)BigDecimal.ZERO);
            dyo33.set("ewblxh", (Object)"33");
            saveObjs.add(dyo33);
        }
        DynamicObject[] savHisObjs = (DynamicObject[])hisProjects.stream().map(m -> {
            DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"tctb_declare_his");
            Object fsbbid = m.get("FSBBID");
            Object ftargetvalue = m.get("FTARGETVALUE");
            Object fremark = m.get("FREMARK");
            Object fmodifytype = m.get("FMODIFYTYPE");
            Object foriginalvalue = m.get("FORIGINALVALUE");
            Object fmodifierfield = m.get("FMODIFIERFIELD");
            Object fmodifydatefield = m.get("FMODIFYDATEFIELD");
            dyo.set("cellid", (Object)"tcvat_zlb_ybnsr_31_ybxm");
            dyo.set("sbbid", fsbbid);
            dyo.set("targetvalue", ftargetvalue);
            dyo.set("remark", fremark);
            dyo.set("modifytype", fmodifytype);
            dyo.set("originalvalue", foriginalvalue);
            dyo.set("modifierfield", fmodifierfield);
            dyo.set("modifydatefield", fmodifydatefield);
            return dyo;
        }).toArray(DynamicObject[]::new);
        try (TXHandle h = TX.requiresNew();){
            try {
                this.addLog(INFO, updSql);
                l = System.currentTimeMillis();
                DBUtils.execute((String)updSql);
                l1 = System.currentTimeMillis();
                this.addLog(INFO, String.format("The result, use time %d", l1 - l));
                if (saveObjs.size() > 0) {
                    long l4 = System.currentTimeMillis();
                    this.addLog(INFO, String.format("Start insert zlb size is %d", saveObjs.size()));
                    SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
                    long lx = System.currentTimeMillis();
                    this.addLog(INFO, String.format("insert zlb use time %d", lx - l4));
                }
                if (savHisObjs.length > 0) {
                    long l4 = System.currentTimeMillis();
                    this.addLog(INFO, String.format("Start insert his size is %d", savHisObjs.length));
                    SaveServiceHelper.save((DynamicObject[])savHisObjs);
                    long lx = System.currentTimeMillis();
                    this.addLog(INFO, String.format("insert his use time %d", lx - l4));
                }
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error(ERROR_INFO, t);
                throw t;
            }
        }
    }
}

