/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class HZRateToDecimalUpgradeFixService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(HZRateToDecimalUpgradeFixService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "HZRateToDecimalUpgradeFixService DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("HZRateToDecimalUpgradeFixService DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        boolean isExist;
        String selectTemplateid = "select fid from t_bdtaxr_template_main  where fnumber in (%s)";
        String selectFb5UpdateFid = "select fid from t_tctb_declare_main where fnsrtype in ('zzsybnsr_hz_zjg','zzsybnsr_ybhz','zzsybnsr_yz_zjg','zzsybnsr_yz_fzjg')";
        String selectFpUpdateFid = "select fid from t_tctb_declare_main where fnsrtype in ('zzsybnsr_ybhz') or ftemplateid in (%s)";
        String selectEjfpUpdateFid = "select fid from t_tctb_declare_main where ftemplateid in (%s)";
        String selectNeedUpdateFid = "select distinct fsbbid from t_tcvat_sb_fjsf where fsl is not null and fsl > 1";
        String updateFb5TcvatSbFjsf = "update t_tcvat_sb_fjsf set fsl = fsl / 100,fjzbl = fjzbl / 100 where fsbbid in (%s)";
        String updateFpTcvatYbqyhzsbFpb = "update t_tcvat_ybqyhzsb_fpb set ffixratio = ffixratio /100 ,flwfpbl = flwfpbl / 100,fjzjtfpbl = fjzjtfpbl / 100,fysfwfpbl = fysfwfpbl / 100,fysfwjzjtfpbl = fysfwjzjtfpbl / 100 where fsbbid in (%s)";
        String updateFpTcvatYbqyhzsbFzjg = "update t_tcvat_ybqyhzsb_fzjg set ffpbl = ffpbl / 100,fjzjtfpbl = fjzjtfpbl / 100,fysfwfpbl = fysfwfpbl / 100,fysfwjzjtfpbl = fysfwjzjtfpbl / 100 where fsbbid in (%s)";
        String updateEjfpTcvatYbhzYzZfjgfpb = "update t_tcvat_ybhz_yz_zfjgfpb set ffpbl = ffpbl / 100,ffpl = ffpl / 100 where fsbbid in (%s)";
        DBRoute dbRoute = DBRoute.of((String)"taxc");
        boolean bl = isExist = DB.exitsTable((DBRoute)dbRoute, (String)"t_tctb_declare_main") && DB.exitsTable((DBRoute)dbRoute, (String)"t_bdtaxr_template_main") && DB.exitsTable((DBRoute)dbRoute, (String)"t_tcvat_sb_fjsf") && DB.exitsTable((DBRoute)dbRoute, (String)"t_tcvat_ybqyhzsb_fpb") && DB.exitsTable((DBRoute)dbRoute, (String)"t_tcvat_ybqyhzsb_fzjg") && DB.exitsTable((DBRoute)dbRoute, (String)"t_tcvat_ybhz_yz_zfjgfpb");
        if (!isExist) {
            LOGGER.error("any table not exist!");
            this.addLog(ERROR, "any table not exist!");
            return;
        }
        List<String> shandongTemplateIds = this.getIds(this.getSql(selectTemplateid, Arrays.asList("'VAT-HOYZ-202201-SHANDONG'", "'VAT-BOYZ-202201-SHANDONG'")));
        List<String> shandongFzjgTemplateIds = this.getIds(this.getSql(selectTemplateid, Collections.singletonList("'VAT-BOYZ-202201-SHANDONG'")));
        List<String> fb5UpdateDeclareIds = this.getIds(selectFb5UpdateFid);
        List<String> fpUpdateDeclareIds = this.getIds(this.getSql(selectFpUpdateFid, shandongFzjgTemplateIds));
        List<String> ejfpUpdateDeclareIds = this.getIds(this.getSql(selectEjfpUpdateFid, shandongTemplateIds));
        List<String> needUpdateDeclareIds = this.get(selectNeedUpdateFid, "FSBBID");
        if (CollectionUtils.isEmpty(needUpdateDeclareIds)) {
            return;
        }
        fb5UpdateDeclareIds.retainAll(needUpdateDeclareIds);
        fpUpdateDeclareIds.retainAll(needUpdateDeclareIds);
        ejfpUpdateDeclareIds.retainAll(needUpdateDeclareIds);
        try (TXHandle h = TX.requiresNew();){
            try {
                List partition;
                if (!CollectionUtils.isEmpty(fb5UpdateDeclareIds)) {
                    partition = Lists.partition(fb5UpdateDeclareIds, (int)500);
                    for (List ids : partition) {
                        DBUtils.execute((String)this.getSql(updateFb5TcvatSbFjsf, ids));
                    }
                }
                if (!CollectionUtils.isEmpty(fpUpdateDeclareIds)) {
                    partition = Lists.partition(fpUpdateDeclareIds, (int)500);
                    for (List ids : partition) {
                        DBUtils.execute((String)this.getSql(updateFpTcvatYbqyhzsbFpb, ids));
                        DBUtils.execute((String)this.getSql(updateFpTcvatYbqyhzsbFzjg, ids));
                    }
                }
                if (!CollectionUtils.isEmpty(ejfpUpdateDeclareIds)) {
                    partition = Lists.partition(ejfpUpdateDeclareIds, (int)500);
                    for (List ids : partition) {
                        DBUtils.execute((String)this.getSql(updateEjfpTcvatYbhzYzZfjgfpb, ids));
                    }
                }
            }
            catch (Exception e) {
                this.addLog(ERROR, "HZRateToDecimalUpgradeFixService DATA UPGRADE FAIL");
                LOGGER.error("HZRateToDecimalUpgradeFixService DATA UPGRADE FAIL");
                this.addLog(ERROR, e.toString());
                LOGGER.error((Throwable)e);
                h.markRollback();
            }
        }
    }

    private String getSql(String sql, List<String> params) {
        return String.format(sql, String.join((CharSequence)",", params));
    }

    private List<String> getIds(String sql) {
        return this.get(sql, "FID");
    }

    private List<String> get(String sql, String field) {
        List resultList = DBUtils.query((String)sql);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new ArrayList<String>();
        }
        return resultList.stream().map(r -> "'" + r.get(field) + "'").collect(Collectors.toList());
    }
}

