/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class IncomeEntryentityconfjsonUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(IncomeEntryentityconfjsonUpgradeService.class);
    public static final String T_TCVAT_RULE_INCOME = "t_tcvat_rule_income";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        boolean isExist = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)T_TCVAT_RULE_INCOME);
        if (!isExist) {
            this.addLog(ERROR, String.format("The %s is not exist!", T_TCVAT_RULE_INCOME));
            return;
        }
        Map<String, String> taxrateMap = this.getTaxRateCollection();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        List<Map<String, Object>> ruleCollection = this.getRuleCollection();
        if (null != ruleCollection && ruleCollection.size() > 0) {
            for (Map<String, Object> map : ruleCollection) {
                String ftaxrateid = String.valueOf(map.get("FTAXRATEID"));
                String fentryid = String.valueOf(map.get("FENTRYID"));
                String taxrate = taxrateMap.get(ftaxrateid);
                Object[] objects = StringUtil.isNotBlank((CharSequence)taxrate) ? new Object[]{taxrate, Long.valueOf(fentryid)} : new Object[]{"0.00", Long.valueOf(fentryid)};
                paramList.add(objects);
            }
            if (paramList.size() > 0) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        DBUtils.executeBatch((String)"update t_tcvat_rule_entry set fentryentityconf='rate', fentryentityconfjson=? where fentryid=?;", paramList);
                    }
                    catch (Exception e) {
                        LOGGER.error((Throwable)e);
                        h.markRollback();
                    }
                }
            }
        }
    }

    public List<Map<String, Object>> getRuleCollection() {
        String sql = "select t1.ftaxrateid,t2.fentryid from t_tcvat_rule_income t1 left join t_tcvat_rule_entry t2 on t1.fid = t2.fid where fentryentityconfjson='' or fentryentityconfjson=' ' or fentryentityconfjson=null;";
        List query = DBUtils.query((String)sql);
        return query;
    }

    public Map<String, String> getTaxRateCollection() {
        String sql = "select fid,fnumber from t_tpo_tcvat_taxrates";
        List query = DBUtils.query((String)sql);
        Map<String, String> map = query.stream().collect(Collectors.toMap(k -> String.valueOf(k.get("FID")), v -> {
            String number = (String)v.get("FNUMBER");
            BigDecimal rate = BigDecimalUtil.toBigDecimal((Object)number.replace("%", "")).divide(BigDecimalUtil.toBigDecimal((Object)100));
            return rate.toString();
        }, (m, n) -> m));
        return map;
    }
}

