/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class IncomeRuleInvoiceentityUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(IncomeRuleInvoiceentityUpgradeService.class);
    public static final String T_TCVAT_INCOME_ENTRY = "t_tcvat_income_entry";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        boolean isExist = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)T_TCVAT_INCOME_ENTRY);
        if (!isExist) {
            this.addLog(ERROR, "T_TCVAT_INCOME_ENTRY Table or Column not exist !");
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        List<Map<String, Object>> invoiceentity = this.getIncomeInvoiceentity();
        if (null != invoiceentity && invoiceentity.size() > 0) {
            for (Map<String, Object> map : invoiceentity) {
                String fentryid = String.valueOf(map.get("FENTRYID"));
                String ffiltercondition = String.valueOf(map.get("FFILTERCONDITION"));
                String fconditionjson = String.valueOf(map.get("FCONDITIONJSON"));
                String ftable = String.valueOf(map.get("FTABLE12"));
                long famountfield = this.getAmountField(ftable);
                List<String> condition = this.condition(ftable, ffiltercondition, fconditionjson);
                Object[] objects = new Object[]{condition.get(0), condition.get(1), famountfield, Long.valueOf(fentryid)};
                paramList.add(objects);
            }
        }
        if (paramList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DBUtils.executeBatch((String)"update t_tcvat_income_entry set ffiltercondition=?, fconditionjson=?, famountfield12=?,fdatatype12='zjqs',fdatadirection12='positive' where fentryid=?;", paramList);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    h.markRollback();
                }
            }
        }
    }

    public long getAmountField(String table) {
        if ("1543335746595744768".equals(table)) {
            return 1543335746671242291L;
        }
        if ("1163062995127970816".equals(table)) {
            return 1163062995136359509L;
        }
        return 0L;
    }

    public List<Map<String, Object>> getIncomeInvoiceentity() {
        String sql = "select fentryid, ffiltercondition, fconditionjson,ftable12 from t_tcvat_income_entry where fdatatype12 = '' or fdatatype12 = ' ' or fdatatype12 is null;";
        List query = DBUtils.query((String)sql);
        return query;
    }

    public List<String> condition(String table, String ffiltercondition, String fconditionjson) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtil.isNotBlank((CharSequence)ffiltercondition)) {
            String str = "";
            if ("1163062995127970816".equals(table)) {
                ffiltercondition = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u5728\u2026\u2026\u4e2d \u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968;\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  \u5e76\u4e14    %s", (String)"TcvatIncomeInvoiceUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]), ffiltercondition);
                str = "{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"961639304377984000\",\"Id\":\"3QKIGEK3=SEJ\"},{\"_Type_\":\"FilterValue\",\"Value\":\"961640097369875456\",\"Id\":\"3QKIGEK38PMS\"},{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"3QKIGEK3=SEK\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\",\"Id\":\"3QKIGEK38PMQ\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\",\"Id\":\"3QKIGEK3=SEI\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"3QKIGEK38PMR\"}],\"CompareType\":\"17\",\"Id\":\"3QKIGEK3=SEH\",\"Logic\":\"0\",\"FieldName\":\"baseinvoicetype.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3QKIGEK3=SEL\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3QKIGEK38PMU\"}],\"CompareType\":\"17\",\"Id\":\"3QKIGEK38PMT\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"},";
            } else if ("1543335746595744768".equals(table)) {
                ffiltercondition = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  \u5e76\u4e14            %s", (String)"TcvatIncomeInvoiceUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]), ffiltercondition);
                str = "{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3QRZOZ8Z3HB+\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3QRZOZ8Z5KT0\"}],\"CompareType\":\"17\",\"Id\":\"3QRZOZ8Z5KT/\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"},";
            }
            String str1 = fconditionjson.substring(0, fconditionjson.indexOf("[") + 1);
            String str2 = fconditionjson.substring(fconditionjson.indexOf("[") + 1);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(str1);
            stringBuilder.append(str);
            stringBuilder.append(str2);
            fconditionjson = stringBuilder.toString();
        } else if ("1163062995127970816".equals(table)) {
            ffiltercondition = ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b.\u540d\u79f0 \u5728\u2026\u2026\u4e2d \u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968;\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968;\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09  \u5e76\u4e14            \u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  ", (String)"TcvatIncomeInvoiceUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]);
            fconditionjson = "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"961639304377984000\",\"Id\":\"3PKLSCPZ04=T\"},{\"_Type_\":\"FilterValue\",\"Value\":\"961640097369875456\",\"Id\":\"3PKLSCPZ272K\"},{\"_Type_\":\"FilterValue\",\"Value\":\"1376129725579325440\",\"Id\":\"3PKLSCPZ04=U\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\",\"Id\":\"3PKLSCPZ272I\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\",\"Id\":\"3PKLSCPZ04=S\"},{\"_Type_\":\"FilterValue\",\"Value\":\"\u6570\u7535\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09\",\"Id\":\"3PKLSCPZ272J\"}],\"CompareType\":\"17\",\"Id\":\"3PKLSCPZ04=R\",\"Logic\":\"0\",\"FieldName\":\"baseinvoicetype.name\"},{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3PKLSCPZ04=V\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3PKLSCPZ272M\"}],\"CompareType\":\"17\",\"Id\":\"3PKLSCPZ272L\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"}]}";
        } else if ("1543335746595744768".equals(table)) {
            ffiltercondition = ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001 \u5728\u2026\u2026\u4e2d \u6b63\u5e38;\u7ea2\u51b2  ", (String)"TcvatIncomeInvoiceUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]);
            fconditionjson = "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"0\",\"Id\":\"3QS+AHVRXY4U\"},{\"_Type_\":\"FilterValue\",\"Value\":\"3\",\"Id\":\"3QS+AHVRVUOU\"}],\"CompareType\":\"17\",\"Id\":\"3QS+AHVRVUOT\",\"Logic\":\"0\",\"FieldName\":\"invoicestatus\"}]}";
        }
        result.add(ffiltercondition);
        result.add(fconditionjson);
        return result;
    }
}

