/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;

public class InvoiceProjectUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(InvoiceProjectUpgradeService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() throws Exception {
        ArrayList<Long> specialIds = new ArrayList<Long>();
        ArrayList<Long> ordinaryIds = new ArrayList<Long>();
        HashMap<Long, BigDecimal> specialMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> ordinaryMap = new HashMap<Long, BigDecimal>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"tcvat_prepay_application", (String)"deductentry.dinvoiceid as dinvoiceid,deductentry.dinvoicetype as dinvoicetype,deductentry.dcurrentdeduct as dcurrentdeduct", (QFilter[])new QFilter[0], (String)"deductentry.dissuetime");
        DataSet rows = dataSet.executeSql("select dinvoiceid, dinvoicetype, sum(dcurrentdeduct) as dcurrentdeduct group by dinvoiceid,dinvoicetype");
        while (rows.hasNext()) {
            Row next = rows.next();
            Long dinvoiceid = next.getLong("dinvoiceid");
            BigDecimal dcurrentdeduct = next.getBigDecimal("dcurrentdeduct");
            String dinvoicetype = next.getString("dinvoicetype");
            if ("961639304377984000".equals(dinvoicetype) || "961640097369875456".equals(dinvoicetype)) {
                specialIds.add(dinvoiceid);
                specialMap.put(dinvoiceid, dcurrentdeduct);
            }
            if (!"961634333825754112".equals(dinvoicetype) && !"961639799666521088".equals(dinvoicetype)) continue;
            ordinaryIds.add(dinvoiceid);
            ordinaryMap.put(dinvoiceid, dcurrentdeduct);
        }
        rows.close();
        dataSet.close();
        QFilter specialFilter = new QFilter("id", "in", specialIds);
        QFilter ordinaryFilter = new QFilter("id", "in", ordinaryIds);
        DynamicObject[] specialArray = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"id,total_amount,total_deduct,avail_deduct,current_deduct,remain_deduct", (QFilter[])new QFilter[]{specialFilter});
        DynamicObject[] ordinaryArray = BusinessDataServiceHelper.load((String)"rim_inv_ordinary", (String)"id,total_amount,total_deduct,avail_deduct,current_deduct,remain_deduct", (QFilter[])new QFilter[]{ordinaryFilter});
        this.changedValue(specialArray, specialMap);
        this.changedValue(ordinaryArray, ordinaryMap);
        QFilter totaldeductFilter = new QFilter("total_deduct", "!=", (Object)BigDecimal.ZERO);
        QFilter specialIdFilter = new QFilter("id", "not in", specialIds);
        QFilter ordinaryIdFilter = new QFilter("id", "not in", ordinaryIds);
        DynamicObject[] specialArrayObject = BusinessDataServiceHelper.load((String)"rim_inv_special", (String)"id,total_amount,total_deduct,avail_deduct,current_deduct,remain_deduct", (QFilter[])new QFilter[]{totaldeductFilter, specialIdFilter});
        DynamicObject[] ordinaryArrayObject = BusinessDataServiceHelper.load((String)"rim_inv_ordinary", (String)"id,total_amount,total_deduct,avail_deduct,current_deduct,remain_deduct", (QFilter[])new QFilter[]{totaldeductFilter, ordinaryIdFilter});
        this.changedValue(specialArrayObject);
        this.changedValue(ordinaryArrayObject);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject[])specialArray);
                SaveServiceHelper.update((DynamicObject[])ordinaryArray);
                SaveServiceHelper.update((DynamicObject[])specialArrayObject);
                SaveServiceHelper.update((DynamicObject[])ordinaryArrayObject);
            }
            catch (Exception e) {
                h.markRollback();
                throw new Exception(e);
            }
        }
    }

    private void changedValue(DynamicObject[] arrayObject, Map<Long, BigDecimal> dateMap) {
        for (int i = 0; i < arrayObject.length; ++i) {
            BigDecimal currentDeduct = dateMap.get(arrayObject[i].getLong("id"));
            BigDecimal totalAmount = arrayObject[i].getBigDecimal("total_amount");
            arrayObject[i].set("total_deduct", (Object)currentDeduct);
            arrayObject[i].set("avail_deduct", (Object)totalAmount.subtract(currentDeduct));
            arrayObject[i].set("current_deduct", (Object)BigDecimal.ZERO);
            arrayObject[i].set("remain_deduct", (Object)totalAmount.subtract(currentDeduct));
        }
    }

    private void changedValue(DynamicObject[] arrayObject) {
        for (int i = 0; i < arrayObject.length; ++i) {
            arrayObject[i].set("total_deduct", (Object)BigDecimal.ZERO);
            arrayObject[i].set("avail_deduct", (Object)BigDecimal.ZERO);
            arrayObject[i].set("current_deduct", (Object)BigDecimal.ZERO);
            arrayObject[i].set("remain_deduct", (Object)BigDecimal.ZERO);
        }
    }
}

