/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class JzjtJxseRuleUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final String T_TCVAT_RULE_JZJT_JXSE = "t_tcvat_rule_jzjt_jxse";
    private static final String T_TCVAT_RULE_JZJT_JXSE_L = "t_tcvat_rule_jzjt_jxse_l";
    private static final String T_TCVAT_RULE_JZJT_ENTJ = "t_tcvat_rule_jzjt_entj";
    private static final String T_TCVAT_RULE_JZJT_ENTN = "t_tcvat_rule_jzjt_entn";
    private Log LOGGER = LogFactory.getLog(JzjtJxseRuleUpgradeService.class);
    private String TAXC = "taxc";
    private static final String insertMainTable_SYNC_SQL = "INSERT INTO t_tcvat_all_rule_config (fid, fnumber, fname, fmasterid, forg, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fgroupid, frulepurpose, fruletype, fissystem, ftaxationid, ftaxrateid, frollouttype, fjzjt, fdifftype, fperpreproduct, freductiontype, fdeducttype, fmdtype, ftaxpayertype, fprepayproject, fwfhfzclx, frulename, fcpmc, frate, fhyncp, fylfl, frefundtype, fsign, fdhzsfs,  fjzjtlx) VALUES(?, ?, ?, ?, ?, 'A', 0, 0, '1', '2024-05-23 00:00:00.000', '2024-05-23 00:00:00.000', 1952160271401603072, ',nssb,sjjt,', 'private', '1', 0, 0, 0, ' ', 0, 0, ' ', 0, ' ', 'ybnsr', 0, ' ', 0, 0, ' ', 0, ' ', 0, ' ', ' ', ?);";
    private static final String insertMainTable_SYNC_LANG_SQL = "INSERT INTO t_tcvat_all_rule_config_l (fid,fpkid,flocaleid,fname) VALUES (?,?,?,?);";
    private static final String insertMainTable_SQL = "INSERT INTO t_tcvat_rule_jzjt_jxse (fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,frulepurpose,fissystem,ftaxpayertype,fjzjtlx) VALUES (?,?,?,'A',0,0,'1','2024-05-23 00:00:00.000','2024-05-23 00:00:00.000',?,'private',?,',nssb,sjjt,','1','ybnsr',?)";
    private static final String insertMainTable_LANG_SQL = "INSERT INTO t_tcvat_rule_jzjt_jxse_l (fid,fpkid,flocaleid,fname) VALUES (?,?,?,?);";
    private static final String insertMainTable_ENTRY_SQL = "INSERT INTO t_tcvat_rule_jzjt_entj (fid,fentryid,fseq,fdatadirection,fbizname,fdatatype,famountfield,ftable,fabsolute,fvatrate,fconditionjson,ffiltercondition) VALUES (?,?,1,'positive',?,'zjqs',1956445991037303811,1956445990735313920,'0',0.0000,'{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"4\",\"Id\":\"44B/W7RA20D0\"}],\"CompareType\":\"105\",\"Id\":\"44B/W7RA66MU\",\"Logic\":\"0\",\"FieldName\":\"consumertype\"}]}',?);";
    private static final String insertMainTable_ENTRY1_SQL = "INSERT INTO t_tcvat_rule_jzjt_entn (fid,fentryid,fseq,fbizname,ftable,famountfield,fabsolute,fdatatype,fdatadirection,fvatrate,fconditionjson,ffiltercondition) VALUES (?,?,1,?,1956445990735313920,1956445991037303811,'0','zjqs','positive',0.0000,'{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"5\",\"Id\":\"44B0+99JEON4\"}],\"CompareType\":\"105\",\"Id\":\"44B0+99JIUWY\",\"Logic\":\"0\",\"FieldName\":\"consumertype\"}]}',?);";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\uff1a\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u89c4\u5219\u9884\u7f6e\u5904\u7406\u6210\u529f\uff01", (String)"JzjtJxseRuleUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        try {
            this.LOGGER.info("\u5f00\u59cb\u6267\u884c\u589e\u503c\u7a0e\uff1a\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u89c4\u5219\u9884\u7f6e\u5904\u7406===>>>>>>");
            if (!DB.exitsTable((DBRoute)DBRoute.of((String)this.TAXC), (String)T_TCVAT_RULE_JZJT_JXSE) || !DB.exitsTable((DBRoute)DBRoute.of((String)this.TAXC), (String)"t_tctb_draft_main")) {
                result.setLog("Not exist t_tcvat_rule_jzjt_jxse or t_tctb_draft_main,no run process");
                return result;
            }
            this.LOGGER.info(">>>>>>\u5f00\u59cb\u9884\u7f6e");
            List<Long> allorg = this.queryAllTaxorg();
            String numbersql = "select fnumber,forgid from t_tcvat_rule_jzjt_jxse where fid > 0 order by fnumber desc;";
            List query = DBUtils.query((String)numbersql);
            String maxNumber = null;
            if (query != null && query.size() > 0) {
                maxNumber = (String)((Map)query.get(0)).get("FNUMBER");
            }
            HashSet<String> existnumbers = query == null ? new HashSet<String>(16) : query.stream().map(a -> (String)a.get("FNUMBER")).collect(Collectors.toSet());
            HashSet existOrgids = query == null ? new HashSet(16) : query.stream().map(a -> (Long)a.get("FORGID")).collect(Collectors.toSet());
            allorg.removeIf(a -> existOrgids.contains(a));
            List partition = Lists.partition(allorg, (int)200);
            for (List orgids : partition) {
                maxNumber = this.insertRules(orgids, maxNumber, existnumbers);
            }
            this.updateMaxSerialNo(maxNumber);
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u89c4\u5219\u9884\u7f6e\u5904\u7406\u5931\u8d25\uff01", (String)"JzjtJxseRuleUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.LOGGER.error("JzjtJxseRuleUpgradeService FAILURE", (Throwable)e);
        }
        return result;
    }

    private void updateMaxSerialNo(String maxNumber) {
        try {
            String[] split;
            Object serialNo = Integer.valueOf(0);
            Object[] par = new Object[2];
            String fid = DB.genStringId((String)"t_cr_intermitno");
            if (maxNumber != null) {
                split = maxNumber.split("-");
                String suffix = split.length == 4 ? split[3] : "000000";
                serialNo = Integer.valueOf(suffix);
            }
            split = serialNo;
            serialNo = serialNo.intValue() + 1;
            Integer n = serialNo;
            List query = DBUtils.query((String)"sys", (String)"SELECT fid,fcoderuleid,fserial FROM t_cr_intermitno WHERE fcoderuleid ='43T71Z2C5V/L'");
            if (query != null && query.size() > 0) {
                fid = ((Map)query.get(0)).get("FID");
                par[0] = serialNo;
                par[1] = fid;
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)"update t_cr_intermitno set fserial= ? where fid=? ", (Object[])par);
            } else {
                par[0] = fid;
                par[1] = serialNo;
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)"INSERT INTO t_cr_intermitno (fid,fcoderuleid,fseqsegmententryid,fsortitemvalue,fserial,fcreatorid,fcreatetime,fmodifierid,fmodifytime) VALUES (?,'43T71Z2C5V/L',' ','_split_',?,1370985810567965696,'2024-06-12 00:00:00.000',1370985810567965696,'2024-06-12 00:00:00.000');", (Object[])par);
            }
        }
        catch (Exception e) {
            this.LOGGER.error("JzjtJxseRuleUpgradeService updateMaxSerialNo", (Throwable)e);
        }
    }

    private String insertRules(List<Long> orgids, String maxNumber, Set<String> existnumbers) {
        String jzjtname = ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d", (String)"JzjtJxseRuleUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]);
        String jzjtnametw = ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u9032\u9805\u7a05\u984d", (String)"JzjtJxseRuleUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]);
        String wfhfname = ResManager.loadKDString((String)"\u65e0\u6cd5\u5212\u5206\u7684\u8fdb\u9879\u7a0e\u989d", (String)"JzjtJxseRuleUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0]);
        String wfhfnametw = ResManager.loadKDString((String)"\u7121\u6cd5\u5283\u5206\u7684\u9032\u9805\u7a05\u984d", (String)"JzjtJxseRuleUpgradeService_5", (String)"taxc-tcvat", (Object[])new Object[0]);
        String jzjtjson = ResManager.loadKDString((String)"\u7528\u9014\u6807\u8bc6 \u7b49\u4e8e \u5373\u5f81\u5373\u9000\u6807\u8bc6  ", (String)"JzjtJxseRuleUpgradeService_6", (String)"taxc-tcvat", (Object[])new Object[0]);
        String wfhfjson = ResManager.loadKDString((String)"\u7528\u9014\u6807\u8bc6 \u7b49\u4e8e \u65e0\u6cd5\u5212\u5206\u6807\u8bc6  ", (String)"JzjtJxseRuleUpgradeService_7", (String)"taxc-tcvat", (Object[])new Object[0]);
        String curMaxNumber = maxNumber == null ? "" : maxNumber;
        ArrayList<Object[]> paramList0 = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramList01 = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramList1 = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramList2 = new ArrayList<Object[]>(16);
        ArrayList<Object[]> paramList3 = new ArrayList<Object[]>(16);
        int size = orgids.size();
        long[] ids = DB.genLongIds((String)T_TCVAT_RULE_JZJT_JXSE, (int)size);
        String[] ids1 = DB.genStringIds((String)T_TCVAT_RULE_JZJT_JXSE_L, (int)(size * 2));
        long[] ids2 = DB.genLongIds((String)T_TCVAT_RULE_JZJT_ENTJ, (int)size);
        for (int i = 0; i < size; ++i) {
            String newMaxNumber;
            Long orgid = orgids.get(i);
            curMaxNumber = newMaxNumber = this.createNumber(orgid, curMaxNumber, existnumbers);
            existnumbers.add(newMaxNumber);
            paramList0.add(new Object[]{ids[i], newMaxNumber, jzjtname, ids[i], orgid, "jzjt"});
            paramList.add(new Object[]{ids[i], newMaxNumber, jzjtname, ids[i], orgid, "jzjt"});
            paramList01.add(new Object[]{ids[i], ids1[i], "zh_CN", jzjtname});
            paramList01.add(new Object[]{ids[i], ids1[i + size], "zh_TW", jzjtnametw});
            paramList1.add(new Object[]{ids[i], ids1[i], "zh_CN", jzjtname});
            paramList1.add(new Object[]{ids[i], ids1[i + size], "zh_TW", jzjtnametw});
            paramList2.add(new Object[]{ids[i], ids2[i], jzjtname, jzjtjson});
        }
        ids = DB.genLongIds((String)T_TCVAT_RULE_JZJT_JXSE, (int)size);
        ids1 = DB.genStringIds((String)T_TCVAT_RULE_JZJT_JXSE_L, (int)(size * 2));
        long[] ids3 = DB.genLongIds((String)T_TCVAT_RULE_JZJT_ENTN, (int)size);
        for (int i = 0; i < size; ++i) {
            String newMaxNumber;
            Long orgid = orgids.get(i);
            curMaxNumber = newMaxNumber = this.createNumber(orgid, curMaxNumber, existnumbers);
            existnumbers.add(newMaxNumber);
            paramList0.add(new Object[]{ids[i], newMaxNumber, wfhfname, ids[i], orgid, "wfhf"});
            paramList.add(new Object[]{ids[i], newMaxNumber, wfhfname, ids[i], orgid, "wfhf"});
            paramList01.add(new Object[]{ids[i], ids1[i], "zh_CN", wfhfname});
            paramList01.add(new Object[]{ids[i], ids1[i + size], "zh_TW", wfhfnametw});
            paramList1.add(new Object[]{ids[i], ids1[i], "zh_CN", wfhfname});
            paramList1.add(new Object[]{ids[i], ids1[i + size], "zh_TW", wfhfnametw});
            paramList3.add(new Object[]{ids[i], ids3[i], wfhfname, wfhfjson});
        }
        try (TXHandle h = TX.requiresNew((String)"JzjtJxseRuleUpgradeService");){
            try {
                if (EmptyCheckUtils.isNotEmpty(paramList0)) {
                    DBUtils.executeBatch((String)"taxc", (String)insertMainTable_SYNC_SQL, paramList0);
                }
                if (EmptyCheckUtils.isNotEmpty(paramList01)) {
                    DBUtils.executeBatch((String)"taxc", (String)insertMainTable_SYNC_LANG_SQL, paramList01);
                }
                if (EmptyCheckUtils.isNotEmpty(paramList)) {
                    DBUtils.executeBatch((String)"taxc", (String)insertMainTable_SQL, paramList);
                }
                if (EmptyCheckUtils.isNotEmpty(paramList1)) {
                    DBUtils.executeBatch((String)"taxc", (String)insertMainTable_LANG_SQL, paramList1);
                }
                if (EmptyCheckUtils.isNotEmpty(paramList2)) {
                    DBUtils.executeBatch((String)"taxc", (String)insertMainTable_ENTRY_SQL, paramList2);
                }
                if (EmptyCheckUtils.isNotEmpty(paramList3)) {
                    DBUtils.executeBatch((String)"taxc", (String)insertMainTable_ENTRY1_SQL, paramList3);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                this.LOGGER.error("save error", e);
                throw e;
            }
        }
        return curMaxNumber;
    }

    private String createNumber(Long orgid, String maxNumber, Set<String> existnumbers) {
        String prefix = "VAT-RULE-JZJT-";
        String[] split = maxNumber.split("-");
        String suffix = split.length == 4 ? split[3] : "000000";
        String number = "";
        while (existnumbers.contains(number = prefix + this.getNumberAdd(suffix))) {
        }
        return number;
    }

    private String getNumberAdd(String suffix) {
        Integer integer = 0;
        try {
            integer = Integer.valueOf(suffix);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        integer = integer + 1;
        String text = integer.toString();
        int length = text.length();
        for (int i = 0; i < 6 - length; ++i) {
            text = "0" + text;
        }
        return text;
    }

    private List<Long> queryAllTaxorg() {
        String numbersql = "select distinct forgid from t_tctb_draft_main where ftemplatetype in ('draft_zzsybnsr_yz_zjg','draft_zzsybnsr_hz_zjg','draft_zzsybnsr_ybhz','draft_zzsybnsr');";
        List query = DBUtils.query((String)numbersql);
        List<Long> orgs = query.stream().map(a -> (Long)a.get("FORGID")).collect(Collectors.toList());
        return orgs;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return this.LOGGER;
    }
}

