/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.tcvat.common.util.UUID;

public class JzjtJxseYbnsrDraftUpgradeService
extends AbstractUpgradeFormPlugin {
    private Log LOGGER = LogFactory.getLog(JzjtJxseYbnsrDraftUpgradeService.class);
    private String TAXC = "taxc";
    private static final String TCVAT_DEDUCTION_SUMMARY = "tcvat_deduction_summary";
    private static final String TCVAT_DEDUCTION_SUMMARY_SJJT = "tcvat_deduction_sum_sjjt";
    public static final String TCVAT_DRAFT_EDIT = "tcvat_draft_edit";
    public static final String TCVAT_QUERY_YBNSR = "tcvat_query_ybnsr";
    public static final String TCVAT_DEDUCT_INPUT_AUTH = "tcvat_deduct_input_auth";
    private static final String T_TCVAT_DEDUCTION_SUMMARY = "t_tcvat_deduction_summary";
    private static final String T_TCVAT_DEDUCTION_SUMMARY_SJJT = "t_tcvat_deduction_sum_jt";
    private static final String T_TCVAT_JZJT_JXSE_SUMMARY = "t_tcvat_jzjt_jxse_summary";
    private static final String T_TCVAT_JZJT_JXSE_SUMMARY_SJJT = "t_tcvat_jzjt_jxse_sum_sj";
    private static final String QUERY_TIGHT_RANGE_DRAFT = "select distinct a.forgid  as forgid,a.fdeadline  as fdeadline,a.ftaxperiod  as ftaxperiod from %s a  left join %s b on a.forgid =b.forgid and a.ftaxperiod =b.ftaxperiod  and a.fdeadline =b.fdeadline  where b.fid is null and a.forgid > 0 and (a.ftaxperiod !=' ' and a.ftaxperiod is not null) and (a.fdeadline !=' ' and a.fdeadline is not null)";
    private static final String QUERY_JZJT_JXSE_DRAFT = "SELECT distinct forgid,fdeadline,ftaxperiod FROM %s WHERE forgid in (%s)";
    private static final String INSERTMAINTABLE_SQL = "INSERT INTO %s (fid,forgid,fserialno,fruleid,ftaxperiod,fdeadline,fbizname,fjzjtlx,finputtax,fjzjtamount,famountsum,fsplitrate,fjzjtjxtax,fcreaterid,fmodifierid) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\uff1a\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e95\u7a3f\u5347\u7ea7\u5904\u7406\u6210\u529f\uff01", (String)"JzjtJxseDraftUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        try {
            this.LOGGER.info("\u5f00\u59cb\u6267\u884c\u589e\u503c\u7a0e\uff1a\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e95\u7a3f\u5347\u7ea7\u5904\u7406===>>>>>>");
            List<String> tables = Arrays.asList(T_TCVAT_DEDUCTION_SUMMARY, T_TCVAT_DEDUCTION_SUMMARY_SJJT, T_TCVAT_JZJT_JXSE_SUMMARY, T_TCVAT_JZJT_JXSE_SUMMARY_SJJT);
            for (String table : tables) {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)this.TAXC), (String)table)) continue;
                result.setLog("Not exist table,no run process," + JsonUtil.toJson(tables));
                return result;
            }
            List<String> metas = Arrays.asList(TCVAT_DEDUCTION_SUMMARY, TCVAT_DRAFT_EDIT, TCVAT_QUERY_YBNSR, TCVAT_DEDUCT_INPUT_AUTH, TCVAT_DEDUCTION_SUMMARY_SJJT);
            for (String meta : metas) {
                if (this.metaIsExist(meta).booleanValue()) continue;
                this.LOGGER.info(">>>>>>\u5143\u6570\u636e\u4e0d\u5b58\u5728");
                result.setLog("Not exist metadata,no run process," + JsonUtil.toJson(metas));
                return result;
            }
            this.LOGGER.info(">>>>>>\u5f00\u59cb\u5347\u7ea7");
            this.update(T_TCVAT_JZJT_JXSE_SUMMARY, T_TCVAT_DEDUCTION_SUMMARY, TCVAT_DEDUCTION_SUMMARY);
            this.update(T_TCVAT_JZJT_JXSE_SUMMARY_SJJT, T_TCVAT_DEDUCTION_SUMMARY_SJJT, TCVAT_DEDUCTION_SUMMARY_SJJT);
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e95\u7a3f\u5347\u7ea7\u5904\u7406\u5931\u8d25\uff01", (String)"JzjtJxseDraftUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.LOGGER.error("JzjtJxseDraftUpgradeService FAILURE", (Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(this.getStackTraceMessage(e));
        }
        return result;
    }

    private void update(String jzjtDraftTable, String deductionDraftTable, String deductionSummaryKey) {
        List<Map<String, Object>> range = JzjtJxseYbnsrDraftUpgradeService.query("taxc", String.format(QUERY_TIGHT_RANGE_DRAFT, deductionDraftTable, jzjtDraftTable));
        if (range.size() == 0) {
            return;
        }
        Map<Long, List<Map<String, Object>>> rangeGroup = range.stream().collect(Collectors.groupingBy(a -> (Long)a.get("FORGID")));
        ArrayList<Long> orgs = new ArrayList<Long>(rangeGroup.keySet());
        List partition = Lists.partition(orgs, (int)50);
        for (List orgPart : partition) {
            this.batchUpdate(orgPart, rangeGroup, jzjtDraftTable, deductionDraftTable, deductionSummaryKey);
        }
    }

    private void batchUpdate(List<Long> orgPart, Map<Long, List<Map<String, Object>>> rangeGroup, String jzjtDraftTable, String deductionDraftTable, String deductionSummaryKey) {
        String jzjtBizname = ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u7684\u8fdb\u9879\u7a0e\u989d", (String)"JzjtJxseDraftUpgradeService_2", (String)"taxc-tcvat", (Object[])new Object[0]);
        String wfhfBizname = ResManager.loadKDString((String)"\u65e0\u6cd5\u5212\u5206\u7684\u8fdb\u9879\u7a0e\u989d", (String)"JzjtJxseDraftUpgradeService_3", (String)"taxc-tcvat", (Object[])new Object[0]);
        String sgtzBizname = ResManager.loadKDString((String)"\u624b\u5de5\u8c03\u6574", (String)"JzjtJxseDraftUpgradeService_4", (String)"taxc-tcvat", (Object[])new Object[0]);
        Set ftaxperiod = orgPart.stream().flatMap(a -> ((List)rangeGroup.get(a)).stream()).map(a -> a.get("FTAXPERIOD")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgPart), new QFilter("taxperiod", "in", ftaxperiod)};
        DynamicObjectCollection deductionDrafts = QueryServiceHelper.query((String)deductionSummaryKey, (String)"org,taxperiod,deadline,serialno,type,deductiontype,count,amount,taxamount,inputtaxamount,description", (QFilter[])filters);
        if (deductionDrafts.size() == 0) {
            return;
        }
        Map<String, List<DynamicObject>> deductionGroup = deductionDrafts.stream().collect(Collectors.groupingBy(a -> a.get("org") + "_" + a.get("deadline") + "_" + a.get("taxperiod")));
        String orgstr = orgPart.stream().map(a -> a.toString()).collect(Collectors.joining(","));
        List<Map<String, Object>> jzjtDgList = JzjtJxseYbnsrDraftUpgradeService.query("taxc", String.format(QUERY_JZJT_JXSE_DRAFT, jzjtDraftTable, orgstr));
        Map<String, List<Map>> jzjtGroup = jzjtDgList.stream().collect(Collectors.groupingBy(a -> a.get("FORGID") + "_" + a.get("FDEADLINE") + "_" + a.get("FTAXPERIOD")));
        ArrayList<Object[]> paramList0 = new ArrayList<Object[]>(256);
        for (Map.Entry<String, List<DynamicObject>> entry : deductionGroup.entrySet()) {
            List<DynamicObject> jxdkDrafts;
            BigDecimal inputtaxamountSum;
            String key = entry.getKey();
            if (jzjtGroup.containsKey(key) || (inputtaxamountSum = (jxdkDrafts = entry.getValue()).stream().map(a -> a.getBigDecimal("inputtaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) == 0) continue;
            Set serialno = jxdkDrafts.stream().map(a -> a.getString("serialno")).collect(Collectors.toSet());
            DynamicObjectCollection detailDatas = QueryServiceHelper.query((String)TCVAT_DEDUCT_INPUT_AUTH, (String)"org,consumertype,currentsigntaxamount,jzjtxse,jzjsjxse,xsehe,hfbl", (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", serialno)});
            BigDecimal wfhfJxse = BigDecimal.ZERO;
            BigDecimal wfhfJzjtJxse = BigDecimal.ZERO;
            BigDecimal jzjtJzjtJxse = BigDecimal.ZERO;
            DynamicObject wfhfOne = null;
            for (DynamicObject detailData : detailDatas) {
                String consumertype = detailData.getString("consumertype");
                if ("5".equals(consumertype)) {
                    wfhfJxse = wfhfJxse.add(detailData.getBigDecimal("currentsigntaxamount"));
                    wfhfJzjtJxse = wfhfJzjtJxse.add(detailData.getBigDecimal("jzjsjxse"));
                    wfhfOne = detailData;
                    continue;
                }
                if (!"4".equals(consumertype)) continue;
                jzjtJzjtJxse = jzjtJzjtJxse.add(detailData.getBigDecimal("jzjsjxse"));
            }
            BigDecimal adjAmount = inputtaxamountSum.subtract(wfhfJzjtJxse).subtract(jzjtJzjtJxse);
            long[] ids = DB.genLongIds((String)jzjtDraftTable, (int)3);
            Object org = jxdkDrafts.get(0).get("org");
            Object taxperiod = jxdkDrafts.get(0).get("taxperiod");
            Object deadline = jxdkDrafts.get(0).get("deadline");
            String uuid = UUID.randomUUID();
            paramList0.add(new Object[]{ids[0], org, uuid, 0L, taxperiod, deadline, jzjtBizname, "jzjt", jzjtJzjtJxse, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, jzjtJzjtJxse, 0L, 0L});
            String uuid1 = UUID.randomUUID();
            BigDecimal jzjtxse = wfhfOne != null ? wfhfOne.getBigDecimal("jzjtxse") : BigDecimal.ZERO;
            BigDecimal xsehe = wfhfOne != null ? wfhfOne.getBigDecimal("xsehe") : BigDecimal.ZERO;
            BigDecimal hfbl = wfhfOne != null ? wfhfOne.getBigDecimal("hfbl") : BigDecimal.ZERO;
            paramList0.add(new Object[]{ids[1], org, uuid1, 0L, taxperiod, deadline, wfhfBizname, "wfhf", wfhfJxse, jzjtxse, xsehe, hfbl, wfhfJzjtJxse, 0L, 0L});
            String uuid2 = UUID.randomUUID();
            paramList0.add(new Object[]{ids[2], org, uuid2, 0L, taxperiod, deadline, sgtzBizname, "jzjt", adjAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, adjAmount, 0L, 0L});
        }
        try (TXHandle h = TX.requiresNew((String)"JzjtJxseYbnsrDraftUpgradeService");){
            try {
                if (EmptyCheckUtils.isNotEmpty(paramList0)) {
                    String sql = String.format(INSERTMAINTABLE_SQL, jzjtDraftTable);
                    DBUtils.executeBatch((String)"taxc", (String)sql, paramList0);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                this.LOGGER.error("save error", e);
                throw e;
            }
        }
    }

    public static List<Map<String, Object>> query(String dbKey, String sql) {
        ArrayList<Map<String, Object>> list = new ArrayList(10);
        try (TXHandle h = TX.required();){
            try {
                list = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, rs -> {
                    ArrayList list1 = new ArrayList(16);
                    while (rs.next()) {
                        HashMap<String, Object> hm = new HashMap<String, Object>();
                        hm.put("FORGID", rs.getLong("FORGID"));
                        hm.put("FDEADLINE", rs.getString("FDEADLINE"));
                        hm.put("FTAXPERIOD", rs.getString("FTAXPERIOD"));
                        list1.add(hm);
                    }
                    return list1;
                });
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        return list;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return this.LOGGER;
    }
}

