/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class PeriodDateDraftUpgradeService
extends AbstractUpgradeFormPlugin {
    public static final String T_TCVAT_INCOME_SUM_SJJT = "t_tcvat_income_sum_sjjt";
    public static final String T_TCVAT_DEDUCTION_SUM_JT = "t_tcvat_deduction_sum_jt";
    public static final String T_TCVAT_ROLL_OUT_SUM_SJJT = "t_tcvat_roll_out_sum_sjjt";
    public static final String T_TCVAT_INCOME_ADD_TEM_JT = "t_tcvat_income_add_tem_jt";
    public static final String T_TCVAT_TAXREDUC_SUM_SJJT = "t_tcvat_taxreduc_sum_sjjt";
    public static final String FTAXPERIODDATE = "ftaxperioddate";
    public static final String FDEDUCTIONTYPEBASE = "fdeductiontypebase";
    public static final String TAXC = "taxc";
    private Log LOGGER = LogFactory.getLog(PeriodDateDraftUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog("PeriodDateDraftUpgradeService start");
        try (TXHandle h = TX.required();){
            try {
                List<Object[]> paramList2;
                List<Object[]> paramList;
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TCVAT_INCOME_SUM_SJJT, (String)FTAXPERIODDATE) && (paramList = this.getParamList(T_TCVAT_INCOME_SUM_SJJT)).size() > 0) {
                    DBUtils.executeBatch((String)"update t_tcvat_income_sum_sjjt set ftaxperioddate=? where fid =?;", paramList);
                }
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TCVAT_DEDUCTION_SUM_JT, (String)FTAXPERIODDATE) && (paramList = this.getParamList(T_TCVAT_DEDUCTION_SUM_JT)).size() > 0) {
                    DBUtils.executeBatch((String)"update t_tcvat_deduction_sum_jt set ftaxperioddate=? where fid =?;", paramList);
                }
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TCVAT_DEDUCTION_SUM_JT, (String)FDEDUCTIONTYPEBASE) && (paramList2 = this.getParamList2(T_TCVAT_DEDUCTION_SUM_JT)).size() > 0) {
                    DBUtils.executeBatch((String)"update t_tcvat_deduction_sum_jt set fdeductiontypebase =? where fid =?;", paramList2);
                }
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TCVAT_ROLL_OUT_SUM_SJJT, (String)FTAXPERIODDATE) && (paramList = this.getParamList(T_TCVAT_ROLL_OUT_SUM_SJJT)).size() > 0) {
                    DBUtils.executeBatch((String)"update t_tcvat_roll_out_sum_sjjt set ftaxperioddate=? where fid =?;", paramList);
                }
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TCVAT_INCOME_ADD_TEM_JT, (String)FTAXPERIODDATE) && (paramList = this.getParamList(T_TCVAT_INCOME_ADD_TEM_JT)).size() > 0) {
                    DBUtils.executeBatch((String)"update t_tcvat_income_add_tem_jt set ftaxperioddate=? where fid =?;", paramList);
                }
                if (DB.existColumn((DBRoute)DBRoute.of((String)TAXC), (String)T_TCVAT_TAXREDUC_SUM_SJJT, (String)FTAXPERIODDATE) && (paramList = this.getParamList(T_TCVAT_TAXREDUC_SUM_SJJT)).size() > 0) {
                    DBUtils.executeBatch((String)"update t_tcvat_taxreduc_sum_sjjt set ftaxperioddate=? where fid =?;", paramList);
                }
            }
            catch (Throwable t) {
                result.setLog("PeriodDateDraftUpgradeService FAILURE!!!");
                this.LOGGER.error("PeriodDateDraftUpgradeService FAILURE", t);
                result.setSuccess(false);
                result.setErrorInfo(this.getStackTraceMessage(t));
                h.markRollback();
            }
        }
        return result;
    }

    public List<Object[]> getParamList(String entityName) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        List query = DBUtils.query((String)("select FID,FTAXPERIOD from " + entityName + " where ftaxperioddate is null;"));
        if (!CollectionUtils.isEmpty((Collection)query)) {
            for (Map map : query) {
                Object id = map.get("FID");
                String taxPeriod = (String)map.get("FTAXPERIOD");
                Date date = StringUtil.isNotEmpty((CharSequence)taxPeriod) && taxPeriod.matches("\\d{4}-\\d{2}") ? DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate2((String)taxPeriod, (String)"yyyy-MM")) : null;
                paramList.add(new Object[]{date, id});
            }
        }
        return paramList;
    }

    public List<Object[]> getParamList2(String entityName) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        List query = DBUtils.query((String)("select FID,FDEDUCTIONTYPE from " + entityName + " where fdeductiontypebase is null;"));
        if (!CollectionUtils.isEmpty((Collection)query)) {
            for (Map map : query) {
                Object id = map.get("FID");
                String deductiontype = (String)map.get("FDEDUCTIONTYPE");
                Long deductiontypebase = StringUtil.isNotEmpty((CharSequence)deductiontype) && StringUtil.isNumeric((String)deductiontype) ? Long.parseLong(deductiontype) : 0L;
                paramList.add(new Object[]{deductiontypebase, id});
            }
        }
        return paramList;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return this.LOGGER;
    }
}

