/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;

public class PrepayInInvoiceSplitUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PrepayInInvoiceSplitUpgradeService.class);
    private static final String TIL_IN_INVOICE_PROJECT = "til_in_invoice_project";
    private static final String RIM_INV_ORDINARY = "rim_inv_ordinary";
    private static final String RIM_INV_SPECIAL = "rim_inv_special";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        for (String number : Arrays.asList(TIL_IN_INVOICE_PROJECT, RIM_INV_ORDINARY, RIM_INV_SPECIAL)) {
            Boolean isExist = this.metaIsExist(number);
            if (isExist.booleanValue()) continue;
            this.addLog(ERROR, String.format("The %s is not exist!", number));
            return;
        }
        QFilter q1 = new QFilter("split", "not like", (Object)"updated%");
        QFilter q2 = new QFilter("baseinvoicetype.number", "in", Arrays.asList("1", "2", "3", "4"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)TIL_IN_INVOICE_PROJECT, (String)"split,invoiceid", (QFilter[])new QFilter[]{q1, q2});
        Map<Long, String> collect = Arrays.stream(load).collect(Collectors.toMap(e -> Long.valueOf(e.getString("invoiceid")), e -> e.getString("split"), (k1, k2) -> k1));
        Set<Long> invoiceids = collect.keySet();
        DynamicObject[] ordinaryInvoices = BusinessDataServiceHelper.load((String)RIM_INV_ORDINARY, (String)"id,split", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceids)});
        DynamicObject[] specialInvoices = BusinessDataServiceHelper.load((String)RIM_INV_SPECIAL, (String)"id,split", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceids)});
        Arrays.stream(ordinaryInvoices).forEach(e -> e.set("split", collect.get(e.getLong("id")) != null ? collect.get(e.getLong("id")) : " "));
        Arrays.stream(specialInvoices).forEach(e -> e.set("split", collect.get(e.getLong("id")) != null ? collect.get(e.getLong("id")) : " "));
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])ordinaryInvoices);
                SaveServiceHelper.save((DynamicObject[])specialInvoices);
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }
}

