/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;

public class PrepayInInvoiceUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PrepayInInvoiceUpgradeService.class);
    private static final String ENTITY_INVOICE_PROJECT = "til_in_invoice_project";
    private static final String RIM_INVOICE = "rim_invoice";
    private static final String RIM_INV_ORDINARY = "rim_inv_ordinary";
    private static final String RIM_INV_SPECIAL = "rim_inv_special";
    private static final String RIM_INV_ELECTRIC = "rim_inv_electric";
    private static final int PAGE_SIZE = 300;

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        for (String number : Arrays.asList(ENTITY_INVOICE_PROJECT, RIM_INVOICE, RIM_INV_ORDINARY, RIM_INV_SPECIAL, RIM_INV_ELECTRIC)) {
            Boolean isExist = this.metaIsExist(number);
            if (isExist.booleanValue()) continue;
            this.addLog(ERROR, String.format("The %s is not exist!", number));
            return;
        }
        this.saveData(RIM_INV_ORDINARY, "1", "3");
        this.saveData(RIM_INV_SPECIAL, "2", "4");
        this.saveData(RIM_INV_ELECTRIC, "26", "27");
    }

    public DynamicObject[] getCollection(Long lastId, String number1, String number2) {
        QFilter q1 = new QFilter("baseinvoicetype.number", "in", Arrays.asList(number1, number2));
        QFilter q2 = new QFilter("split", "not in", Arrays.asList("updated", "updatedtrue", "updatedfalse"));
        QFilter q3 = new QFilter("id", ">", (Object)lastId);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY_INVOICE_PROJECT, (String)"split,invoiceid,project,project.baseproject", (QFilter[])new QFilter[]{q1, q2, q3}, (String)"id", (int)0, (int)300);
        return load;
    }

    public void saveData(String entity, String number1, String number2) {
        DynamicObject[] relationCollection = this.getCollection(0L, number1, number2);
        while (relationCollection.length > 0) {
            Map<Long, Long> invoiceProjectMap = Arrays.stream(relationCollection).collect(Collectors.toMap(e -> Long.valueOf(e.getString("invoiceid") == null ? "0" : e.getString("invoiceid")), e -> e.getDynamicObject("project").getDynamicObject("baseproject").getLong("id"), (k1, k2) -> k1));
            DynamicObjectCollection subentity = QueryServiceHelper.query((String)entity, (String)"id,serial_no", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceProjectMap.keySet())});
            Map<String, Long> serialProjectMap = subentity.stream().collect(Collectors.toMap(e -> e.getString("serial_no"), e -> (Long)invoiceProjectMap.get(e.getLong("id"))));
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)RIM_INVOICE, (String)"project,serial_no", (QFilter[])new QFilter[]{new QFilter("serial_no", "in", serialProjectMap.keySet()).and("project", "=", (Object)0L)});
            Arrays.stream(invoices).forEach(e -> e.set("project", serialProjectMap.get(e.getString("serial_no"))));
            Arrays.stream(relationCollection).forEach(e -> e.set("split", (Object)("updated" + e.getString("split"))));
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])invoices);
                    SaveServiceHelper.save((DynamicObject[])relationCollection);
                }
                catch (Exception e2) {
                    h.markRollback();
                    this.addLog(ERROR, String.format("%s update error! %s", entity, e2));
                }
            }
            if (relationCollection.length != 300) break;
            Long lastId = relationCollection[relationCollection.length - 1].getLong("id");
            relationCollection = this.getCollection(lastId, number1, number2);
        }
    }
}

