/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.id.Base39Coder;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class PrepayProjectRuleUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PrepayProjectRuleUpgradeService.class);
    private static final String TCVAT_INVOICE_SIGN_BILL = "tcvat_invoice_sign_bill";
    private static final String TCVAT_PREPAY_PROJECT_INFO = "tcvat_prepay_project_info";
    private static final String TCVAT_RULE_PREPAY = "tcvat_rule_prepay";
    private static final int PAGE_SIZE = 100;

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public DynamicObject[] getCollection(Long lastId) {
        QFilter q1 = new QFilter("deductionentry.deductiontable.entityname", "=", (Object)TCVAT_INVOICE_SIGN_BILL);
        QFilter q2 = new QFilter("id", ">", (Object)lastId);
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)TCVAT_RULE_PREPAY, (String)"deductionentry.deductionbizname,deductionentry.deductiontable,deductionentry.deductionamountfield,deductionentry.deductionconditionjson,deductionentry.deductionfiltercondition", (QFilter[])new QFilter[]{q1, q2}, (String)"id", (int)0, (int)100);
        return rules;
    }

    public void update() {
        for (String string : Arrays.asList(TCVAT_INVOICE_SIGN_BILL, TCVAT_RULE_PREPAY, TCVAT_PREPAY_PROJECT_INFO)) {
            Boolean isExist = this.metaIsExist(string);
            if (isExist.booleanValue()) continue;
            this.addLog(ERROR, String.format("The %s is not exist!", string));
            return;
        }
        DynamicObject[] rules = this.getCollection(0L);
        while (rules.length > 0) {
            for (DynamicObject rule : rules) {
                DynamicObjectCollection deductionentry = (DynamicObjectCollection)rule.get("deductionentry");
                for (DynamicObject dynamicObject : deductionentry) {
                    String tableName = ((DynamicObject)dynamicObject.get("deductiontable")).getString("name");
                    if (!TCVAT_INVOICE_SIGN_BILL.equals(tableName)) continue;
                    this.addLog(INFO, String.format("update %s now", dynamicObject.get("deductionbizname")));
                    String deductionconditionjson = dynamicObject.getString("deductionconditionjson");
                    if (deductionconditionjson != null && deductionconditionjson.contains("splitsign")) {
                        this.addLog(INFO, String.format("%s filtercondition contains [splitsign], please modify manually", dynamicObject.get("deductionbizname")));
                        continue;
                    }
                    dynamicObject.set("deductiontable", (Object)1490547858053954560L);
                    long amount = ((DynamicObject)dynamicObject.get("deductionamountfield")).getLong("id");
                    if (1033955201188402182L == amount) {
                        dynamicObject.set("deductionamountfield", (Object)1490547858506937356L);
                    } else if (1033955201188402183L == amount) {
                        dynamicObject.set("deductionamountfield", (Object)1490547858506937357L);
                    } else if (1033955201188402184L == amount) {
                        dynamicObject.set("deductionamountfield", (Object)1490547858506937358L);
                    }
                    HashMap<String, String> jsonMap = this.replaceFilter(deductionconditionjson);
                    dynamicObject.set("deductionconditionjson", (Object)jsonMap.get("deductionconditionjson"));
                    dynamicObject.set("deductionfiltercondition", (Object)jsonMap.get("deductionfiltercondition"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])rules);
            if (rules.length != 100) break;
            Long l = rules[rules.length - 1].getLong("id");
            rules = this.getCollection(l);
        }
    }

    public HashMap<String, String> replaceFilter(String json) {
        if (StringUtil.isBlank((CharSequence)json)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("deductionconditionjson", "");
            map.put("deductionfiltercondition", "");
            return map;
        }
        json = json.replace("invoicecode", "invoice_code").replace("invoiceno", "invoice_no").replace("salername", "saler_name").replace("salertaxno", "saler_tax_no").replace("authenticateflag", "authenticate_flag").replace("taxperiod", "tax_period").replace("deductionpurpose", "deduction_purpose").replace("baseinvoicetype", "invoice_type").replace("projectid", "project");
        JSONObject conditionjJson = JSONObject.parseObject((String)json);
        JSONArray filterRowArr = conditionjJson.getJSONArray("FilterRow");
        for (int i = 0; i < filterRowArr.size(); ++i) {
            JSONObject jsonObject = filterRowArr.getJSONObject(i);
            String fieldName = jsonObject.getString("FieldName");
            if ("project.number".equals(fieldName) || "project.name".equals(fieldName)) {
                String item = fieldName.replace("project.", "");
                this.adjuestProject(jsonObject, item);
                continue;
            }
            if (!"tax_period".equals(fieldName)) continue;
            this.adjustPeriod(jsonObject);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("deductionconditionjson", conditionjJson.toJSONString());
        map.put("deductionfiltercondition", this.buildFilterCondition(filterRowArr));
        return map;
    }

    public void adjustPeriod(JSONObject jsonObject) {
        JSONArray value = jsonObject.getJSONArray("Value");
        for (Object val : value) {
            if ("".equals(((JSONObject)val).getString("Value"))) continue;
            String dateStr = ((JSONObject)val).getString("Value") + "-01";
            try {
                DateUtils.stringToDate((String)dateStr, (String)"yyyy-MM-dd");
                ((JSONObject)val).put("Value", (Object)dateStr);
            }
            catch (Exception e) {
                ((JSONObject)val).put("Value", (Object)"2000-01-01");
                LOGGER.error((Throwable)e);
            }
        }
    }

    public void adjuestProject(JSONObject jsonObject, String item) {
        JSONArray basedatas = jsonObject.getJSONArray("BaseDataIds");
        if (null != basedatas) {
            ArrayList<Long> projectList = new ArrayList<Long>();
            for (int j = 0; j < basedatas.size(); ++j) {
                JSONObject basedata = basedatas.getJSONObject(j);
                projectList.add(Long.valueOf(basedata.getString("Value")));
            }
            DynamicObject[] query = BusinessDataServiceHelper.load((String)TCVAT_PREPAY_PROJECT_INFO, (String)"baseproject,baseproject.number,baseproject.name", (QFilter[])new QFilter[]{new QFilter("id", "in", projectList)});
            JSONArray baseDataArr = new JSONArray();
            JSONArray valueArr = new JSONArray();
            String finalItem = item;
            Arrays.stream(query).forEach(e -> {
                JSONObject baseDataObj = new JSONObject();
                baseDataObj.put("_Type_", (Object)"FilterValue");
                baseDataObj.put("Value", (Object)String.valueOf(e.getDynamicObject("baseproject").getLong("id")));
                baseDataObj.put("Id", (Object)Base39Coder.toString((long)IDService.get().genLongId()));
                baseDataArr.add((Object)baseDataObj);
                JSONObject valueObj = new JSONObject();
                valueObj.put("_Type_", (Object)"FilterValue");
                valueObj.put("Value", (Object)e.getDynamicObject("baseproject").getString(finalItem));
                valueObj.put("Id", (Object)Base39Coder.toString((long)IDService.get().genLongId()));
                valueArr.add((Object)valueObj);
            });
            jsonObject.put("BaseDataIds", (Object)baseDataArr);
            jsonObject.put("Value", (Object)valueArr);
        }
    }

    private String buildFilterCondition(JSONArray filterRowArr) {
        int size = filterRowArr.size();
        if (size == 0) {
            return "";
        }
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = filterRowArr.getJSONObject(i);
            String fieldName = jsonObject.getString("FieldName");
            String logicCode = jsonObject.getString("Logic");
            String rightBracket = jsonObject.getString("RightBracket");
            String leftBracket = jsonObject.getString("LeftBracket");
            String compareType = jsonObject.getString("CompareType");
            JSONArray value = jsonObject.getJSONArray("Value");
            JSONArray baseDataIds = jsonObject.getJSONArray("BaseDataIds");
            ArrayList<FilterValue> filterList = new ArrayList<FilterValue>();
            for (Object val : value) {
                FilterValue filterValue = new FilterValue();
                filterValue.setId(((JSONObject)val).getString("Id"));
                filterValue.setValue((Object)((JSONObject)val).getString("Value"));
                filterList.add(filterValue);
            }
            SimpleFilterRow row = new SimpleFilterRow(leftBracket, compareType, fieldName, rightBracket, logicCode, filterList);
            if (null != baseDataIds) {
                ArrayList<FilterValue> baseFilterList = new ArrayList<FilterValue>();
                for (Object val : baseDataIds) {
                    FilterValue filterValue = new FilterValue();
                    filterValue.setId(((JSONObject)val).getString("Id"));
                    filterValue.setValue((Object)((JSONObject)val).getString("Value"));
                    baseFilterList.add(filterValue);
                }
                row.setBaseDataIds(baseFilterList);
            }
            filterRow.add(row);
        }
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.setFilterRow(filterRow);
        filterCondition.createMetaData();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getFilter();
    }
}

