/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class RimInvoiceJzjtDeductPeriodUpdateService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(RimInvoiceJzjtDeductPeriodUpdateService.class);

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public void click(EventObject evt) {
        StringBuilder message = new StringBuilder("RimInvoiceJzjtDeductPeriodUpdateService update start\n");
        this.executeRimInvoiceJzjtDeductPeriodUpdate();
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("RimInvoiceJzjtDeductPeriodUpdateService update start\n");
        long l = System.currentTimeMillis();
        try {
            if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_invoice_sign")) {
                this.executeRimInvoiceJzjtDeductPeriodUpdate();
            }
            message.append("\nRimInvoiceJzjtDeductPeriodUpdateService update complete ").append(System.currentTimeMillis() - l).append("ms");
        }
        catch (Exception e) {
            message.append(e.getStackTrace()).append(System.currentTimeMillis() - l).append("ms");
        }
        result.setLog(message.toString());
        return result;
    }

    private void executeRimInvoiceJzjtDeductPeriodUpdate() {
        String selectSQL = "select ftaxperiod,fid from t_tcvat_invoice_sign where ftaxperiod is not null and ftaxperiod != '' and ftaxperiod != ' ' and fdeductperiod is null;";
        List tcvatInvoiceSignList = DBUtils.query((String)selectSQL);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(tcvatInvoiceSignList.size());
        for (Map invoiceMap : tcvatInvoiceSignList) {
            paramList.add(new Object[]{DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)(invoiceMap.get("FTAXPERIOD") + "-01"))), invoiceMap.get("FID")});
        }
        if (paramList.size() > 0) {
            String updateSqL = "update t_tcvat_invoice_sign set fdeductperiod = ? where fid = ?;";
            DBUtils.executeBatch((String)updateSqL, paramList);
        }
    }
}

