/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class RuleConfigSynUpgradeService
implements IUpgradeService {
    private Log LOGGER = LogFactory.getLog(RuleConfigSynUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("RuleConfigSynUpgradeService update start");
        long l = System.currentTimeMillis();
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_all_rule_config")) {
            String query = "select fid from t_tcvat_all_rule_config;";
            DataSet data = DB.queryDataSet((String)"RuleConfigSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)query);
            if (data.copy().count("FID", false) > 0) {
                message.append("plan is updated");
                result.setLog(message.toString());
                data.close();
                return result;
            }
            data.close();
            String clearTable = "delete from t_tcvat_all_rule_config;";
            String clearTable_l = "delete from t_tcvat_all_rule_config_l;";
            String clearTable_2 = "delete from t_tcvat_rule_wkpsr_l;";
            DBUtils.execute((String)clearTable);
            DBUtils.execute((String)clearTable_l);
            DBUtils.execute((String)clearTable_2);
            try {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_income")) {
                    this.synIncomeRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_rollout")) {
                    this.synRolloutRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_deduct")) {
                    this.synDeductRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_diff")) {
                    this.synDiffRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_perpre")) {
                    this.synPerpreRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_deduction")) {
                    this.synDeductionRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_mdts")) {
                    this.synMdtsRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_prepay")) {
                    this.synPerpayRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_apportion")) {
                    this.synApportionRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_wkpsr")) {
                    this.synWkpsrRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_ncp_product_rule")) {
                    this.synProductRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_ncp_rule")) {
                    this.synNcpRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_refund")) {
                    this.synRefundRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_incproj")) {
                    this.synIncprojRuleToSbxConfig(message);
                }
                if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_rule_outproj")) {
                    this.synOutprojRuleToSbxConfig(message);
                }
            }
            catch (Exception e) {
                result.setLog("rule update fail");
                this.LOGGER.error("RuleConfigSynUpgradeService FAILURE", (Throwable)e);
            }
        }
        message.append("\nRuleConfigSynUpgradeService update complete ").append(System.currentTimeMillis() - l).append("ms");
        result.setLog(message.toString());
        return result;
    }

    private void synIncomeRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,ftaxationid,ftaxrateid,fjzjt,ftaxpayertype,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,ftaxationid,ftaxrateid,fjzjt,ftaxpayertype,1870263476069751808,'0' from t_tcvat_rule_income;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_income_l;";
        DBUtils.execute((String)updateName);
        message.append("synIncomeRuleToSbxConfig update sucess");
    }

    private void synRolloutRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,fjzjt,ftaxpayertype,frollouttype,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,fjzjt,ftaxpayertype,frollouttype,1870265525532515328,'0' from t_tcvat_rule_rollout;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_rollout_l;";
        DBUtils.execute((String)updateName);
        message.append("synRolloutRuleToSbxConfig update sucess");
    }

    private void synDeductRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,fjzjt,ftaxpayertype,fdeducttype,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,fjzjt,ftaxpayertype,fdeducttype,1870264820906220544,fissystem from t_tcvat_rule_deduct;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_deduct_l;";
        DBUtils.execute((String)updateName);
        message.append("synDeductRuleToSbxConfig update sucess");
    }

    private void synDiffRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,ftaxpayertype,fdifftype,fjzjt,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,ftaxpayertype,fdifftype,fjzjt,1870264280101051392,'0' from t_tcvat_rule_diff;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_diff_l;";
        DBUtils.execute((String)updateName);
        message.append("synDiffRuleToSbxConfig update sucess");
    }

    private void synPerpreRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,ftaxpayertype,fperpreproduct,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,ftaxpayertype,fperpreproduct,1870265821113505792,fissystem from t_tcvat_rule_perpre;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_perpre_l;";
        DBUtils.execute((String)updateName);
        message.append("synPerpreRuleToSbxConfig update sucess");
    }

    private void synDeductionRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,ftaxpayertype,freductiontype,fgroupid) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,ftaxpayertype,freductiontype,1870266078643771392 from t_tcvat_rule_deduction;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_deduction_l;";
        DBUtils.execute((String)updateName);
        message.append("synDeductionRuleToSbxConfig update sucess");
    }

    private void synMdtsRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forg,ftaxpayertype,fmdtype,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,frulepurpose,fruletype,forgid,ftaxpayertype,fmdtype,1870266309020112896,fissystem from t_tcvat_rule_mdts;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_mdts_l;";
        DBUtils.execute((String)updateName);
        message.append("synMdtsRuleToSbxConfig update sucess");
    }

    private void synPerpayRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,ftaxpayertype,fprepayproject,ftaxrateid,fgroupid) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,ftaxpayertype,fprepayproject,ftaxrateid,1889922790833095680 from t_tcvat_rule_prepay;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_prepay_l;";
        DBUtils.execute((String)updateName);
        message.append("synMdtsRuleToSbxConfig update sucess");
    }

    private void synApportionRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,ftaxpayertype,fwfhfzclx,fgroupid) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,ftaxpayertype,fwfhfzclx,1890543755803520000 from t_tcvat_rule_apportion;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_apportion_l;";
        DBUtils.execute((String)updateName);
        message.append("synApportionRuleToSbxConfig update sucess");
    }

    private void synWkpsrRuleToSbxConfig(StringBuilder message) {
        String sql = "select fid,frulename from t_tcvat_rule_wkpsr";
        DataSet data = DB.queryDataSet((String)"RuleConfigSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)sql);
        if (data.isEmpty()) {
            data.close();
            return;
        }
        String ruleNameUpdateSql = "insert into t_tcvat_rule_wkpsr_l(fpkid, fid, flocaleid, fname) select concat(fpkid,'1'), fid, flocaleid, fname from t_tcvat_rule_income_l where fid in (select frulename from t_tcvat_rule_wkpsr);";
        DBUtils.execute((String)ruleNameUpdateSql);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        while (data.hasNext()) {
            Row row = data.next();
            paramList.add(new Object[]{row.getLong("FID"), row.getLong("FRULENAME")});
        }
        data.close();
        DBUtils.executeBatch((String)"update t_tcvat_rule_wkpsr_l set  fid = ? where fid =?;", paramList);
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,ftaxpayertype,frulename,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,ftaxpayertype,frulename,1890632930188217344,'0' from t_tcvat_rule_wkpsr;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_wkpsr_l;";
        DBUtils.execute((String)updateName);
        message.append("synWkpsrRuleToSbxConfig update sucess");
    }

    private void synProductRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,frulepurpose,fcpmc,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,frulepurpose,fcpmc,1891260790015877120,fissystem from t_tcvat_ncp_product_rule;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_ncp_product_rule_l;";
        DBUtils.execute((String)updateName);
        message.append("synProductRuleToSbxConfig update sucess");
    }

    private void synNcpRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,frulepurpose,fhyncp,fylfl,fgroupid,fissystem) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,frulepurpose,fhyncp,fylfl,1891260951278477312,fissystem from t_tcvat_ncp_rule;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_ncp_rule_l;";
        DBUtils.execute((String)updateName);
        message.append("synNcpRuleToSbxConfig update sucess");
    }

    private void synRefundRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,frulepurpose,fissystem,frefundtype,fgroupid) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,frulepurpose,fissystem,frefundtype,1891379881984783360 from t_tcvat_rule_refund;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_refund_l;";
        DBUtils.execute((String)updateName);
        message.append("synRefundRuleToSbxConfig update sucess");
    }

    private void synIncprojRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = "insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,fissystem,fsign,fgroupid) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forgid,fissystem,fsign,1891408507782290432 from t_tcvat_rule_incproj;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_incproj_l;";
        DBUtils.execute((String)updateName);
        message.append("synIncprojRuleToSbxConfig update sucess");
    }

    private void synOutprojRuleToSbxConfig(StringBuilder message) {
        String ruleUpdateSql = " insert into t_tcvat_all_rule_config(fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,fissystem,fsign,fgroupid) select fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,fruletype,forg,fissystem,fsign,1891408824250915840 from t_tcvat_rule_outproj;";
        DBUtils.execute((String)ruleUpdateSql);
        String updateName = "INSERT INTO t_tcvat_all_rule_config_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fid, flocaleid, fname FROM t_tcvat_rule_outproj_l;";
        DBUtils.execute((String)updateName);
        message.append("synOutprojRuleToSbxConfig update sucess");
    }
}

