/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class SharePlanSynUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String clearTable_org;
        String clearTable_rule;
        String clearTable_l;
        String clearTable;
        DataSet data;
        String query;
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        StringBuilder message = new StringBuilder("SharePlanSynUpgradeService update start");
        long l = System.currentTimeMillis();
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_sbx_shareplan") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_sharingplan")) {
            query = "select fid from t_tcvat_sbx_shareplan;";
            data = DB.queryDataSet((String)"SharePlanSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)query);
            if (!data.isEmpty()) {
                message.append("plan is updated");
                result.setLog(message.toString());
                data.close();
                return result;
            }
            data.close();
            clearTable = "delete from t_tcvat_sbx_shareplan;";
            clearTable_l = "delete from t_tcvat_sbx_shareplan_l;";
            clearTable_rule = "delete from t_tcvat_sbx_shareplan_rul;";
            clearTable_org = "delete from t_tcvat_sbx_shareplan_org;";
            DBUtils.execute((String)clearTable);
            DBUtils.execute((String)clearTable_l);
            DBUtils.execute((String)clearTable_rule);
            DBUtils.execute((String)clearTable_org);
            this.synPlanToSbxConfig(message);
        }
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_prepay_shareplan") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_preshareplan_edit")) {
            query = "select fid from t_tcvat_prepay_shareplan;";
            data = DB.queryDataSet((String)"SharePlanSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)query);
            if (!data.isEmpty()) {
                message.append("plan is updated");
                result.setLog(message.toString());
                data.close();
                return result;
            }
            data.close();
            clearTable = "delete from t_tcvat_prepay_shareplan;";
            clearTable_l = "delete from t_tcvat_prepay_shareplan_l;";
            clearTable_rule = "delete from t_tcvat_perpay_share_pri;";
            clearTable_org = "delete from t_tcvat_perpay_share_rule;";
            DBUtils.execute((String)clearTable);
            DBUtils.execute((String)clearTable_l);
            DBUtils.execute((String)clearTable_rule);
            DBUtils.execute((String)clearTable_org);
            this.synPrepayPlanToSbxConfig(message);
        }
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_tz_shareplan") && DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tcvat_tzshareplan_edit")) {
            query = "select fid from t_tcvat_tz_shareplan;";
            data = DB.queryDataSet((String)"SharePlanSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)query);
            if (!data.isEmpty()) {
                message.append("plan is updated");
                result.setLog(message.toString());
                data.close();
                return result;
            }
            data.close();
            clearTable = "delete from t_tcvat_tz_shareplan;";
            clearTable_l = "delete from t_tcvat_tz_shareplan_l;";
            clearTable_rule = "delete from t_tcvat_tz_shareplan_rule;";
            clearTable_org = "delete from t_tcvat_tz_shareplan_org;";
            DBUtils.execute((String)clearTable);
            DBUtils.execute((String)clearTable_l);
            DBUtils.execute((String)clearTable_rule);
            DBUtils.execute((String)clearTable_org);
            this.synTzPlanToSbxConfig(message);
        }
        message.append("\nSharePlanSynUpgradeService update complete ").append(System.currentTimeMillis() - l).append("ms");
        result.setLog(message.toString());
        return result;
    }

    private void synPlanToSbxConfig(StringBuilder message) {
        String updatePlan = "insert into t_tcvat_sbx_shareplan (fid,fcreateorgid,ftaxpayertype,fautoshar,fcreatetime,fcreatorid,fmodifierid,fmodifytime,fmasterid) select s.fentryid ,e.forgid,s.ftaxpayertype,s.fautoshar,s.fcreatetime,s.fcreatorid,fmodifierid,fmodifytime,fmasterid from t_tcvat_sharingplan_edit e inner join t_tcvat_sharingplan s on e.fid = s.fid and s.ftaxpayertype != ' ';";
        DBUtils.execute((String)updatePlan);
        String updateName = "INSERT INTO t_tcvat_sbx_shareplan_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fentryid, flocaleid, fname FROM t_tcvat_sharingplan_l;";
        DBUtils.execute((String)updateName);
        String updatePlanOrg = "insert into t_tcvat_sbx_shareplan_org (fid,forg,fentryid,fseq) select fentryid,forgid,fdetailid,fseq from t_tcvat_sharingplan_orgs;";
        DBUtils.execute((String)updatePlanOrg);
        String updatePlanRule = "insert into t_tcvat_sbx_shareplan_rul (fid,frule,fentryid,fseq) select fentryid,fruleid,fdetailid,fseq from t_tcvat_sharingplan_rules;";
        DBUtils.execute((String)updatePlanRule);
        String sql = "select fentryid from t_tcvat_sharingplan";
        DataSet data = DB.queryDataSet((String)"SharePlanSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)sql);
        if (data.isEmpty()) {
            data.close();
            return;
        }
        int index = 1;
        while (data.hasNext()) {
            Row row = data.next();
            String number = String.format("VAT-GXSB-%06d", index);
            DBUtils.execute((String)("update t_tcvat_sbx_shareplan set fnumber = '" + number + "' where fid =" + row.getLong("FENTRYID") + ";"));
            ++index;
        }
        data.close();
        message.append("sbx  SharePlanSynUpgradeService update sucess");
    }

    private void synPrepayPlanToSbxConfig(StringBuilder message) {
        String updatePlan = "insert into t_tcvat_prepay_shareplan (fid) select fentryid from t_tcvat_preshareplan;";
        DBUtils.execute((String)updatePlan);
        String updateName = "INSERT INTO t_tcvat_prepay_shareplan_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fentryid, flocaleid, fname FROM t_tcvat_preshareplan_l;";
        DBUtils.execute((String)updateName);
        String updatePlanProject = "insert into t_tcvat_perpay_share_pri (fid,fentryid,fseq,fprepayproject) select fentryid,fdetailid,fseq,fprepayproject from t_tcvat_preshareplan_prj;";
        DBUtils.execute((String)updatePlanProject);
        String updatePlanRule = "insert into t_tcvat_perpay_share_rule (fid,fentryid,fseq,frule) select fentryid ,fdetailid ,fseq ,fruleid from t_tcvat_preshareplan_rule;";
        DBUtils.execute((String)updatePlanRule);
        String leftPlan = "select fid,fentryid,fcreatetime from t_tcvat_preshareplan";
        DataSet leftPlanData = DB.queryDataSet((String)"synPrepayPlanToSbxConfig", (DBRoute)DBRoute.of((String)"taxc"), (String)leftPlan);
        if (leftPlanData.isEmpty()) {
            leftPlanData.close();
            return;
        }
        HashMap<String, String> fentryidToFid = new HashMap<String, String>(leftPlanData.copy().count("FENTRYID", false));
        HashMap<String, Date> fentryidToFcreatetime = new HashMap<String, Date>(leftPlanData.copy().count("FENTRYID", false));
        while (leftPlanData.hasNext()) {
            Row row = leftPlanData.next();
            fentryidToFid.put(row.getString("FENTRYID"), row.getString("FID"));
            fentryidToFcreatetime.put(row.getString("FENTRYID"), row.getDate("fcreatetime"));
        }
        leftPlanData.close();
        String mainPlan = "select fid,forgid from t_tcvat_preshareplan_edit";
        DataSet mainPlanData = DB.queryDataSet((String)"synPrepayPlanToSbxConfig", (DBRoute)DBRoute.of((String)"taxc"), (String)mainPlan);
        if (mainPlanData.isEmpty()) {
            mainPlanData.close();
            return;
        }
        HashMap<String, String> idToForgidMap = new HashMap<String, String>(mainPlanData.copy().count("fid", true));
        while (mainPlanData.hasNext()) {
            Row row = mainPlanData.next();
            idToForgidMap.put(row.getString("FID"), row.getString("FORGID"));
        }
        mainPlanData.close();
        String mainPlan_l = "select fid,fname from t_tcvat_prepay_shareplan_l";
        DataSet mainPlan_l_Data = DB.queryDataSet((String)"synPrepayPlanToSbxConfig", (DBRoute)DBRoute.of((String)"taxc"), (String)mainPlan_l);
        if (mainPlan_l_Data.isEmpty()) {
            mainPlan_l_Data.close();
            return;
        }
        HashMap<String, String> idToFNameMap = new HashMap<String, String>(mainPlan_l_Data.copy().count("fid", true));
        while (mainPlan_l_Data.hasNext()) {
            Row row = mainPlan_l_Data.next();
            idToFNameMap.put(row.getString("FID"), row.getString("FNAME"));
        }
        mainPlan_l_Data.close();
        int index = 1;
        for (Map.Entry entry : fentryidToFid.entrySet()) {
            String orgId = (String)idToForgidMap.get(entry.getValue());
            String number = String.format("VAT-GXYJ-%06d", index);
            DBUtils.execute((String)("update t_tcvat_prepay_shareplan set  fcreateorg = " + Long.valueOf(orgId) + ",fname = '" + (String)idToFNameMap.get(entry.getKey()) + "',fstatus = 'C',fenable = '1',fmasterid = " + Long.valueOf((String)entry.getKey()) + ",fcreatetime = '" + fentryidToFcreatetime.get(entry.getKey()) + "' ,fnumber = '" + number + "' where fid = " + Long.valueOf((String)entry.getKey()) + ";"));
            ++index;
        }
        String shareProjectSql = "select fentryid,fprepayproject from t_tcvat_perpay_share_pri";
        DataSet shareProjectData = DB.queryDataSet((String)"synPrepayPlanToSbxConfig", (DBRoute)DBRoute.of((String)"taxc"), (String)shareProjectSql);
        if (shareProjectData.isEmpty()) {
            shareProjectData.close();
            return;
        }
        ArrayList<Long> prepayProjectId = new ArrayList<Long>(shareProjectData.copy().count("FENTRYID", false));
        while (shareProjectData.hasNext()) {
            Row row = shareProjectData.next();
            prepayProjectId.add(row.getLong("FPREPAYPROJECT"));
        }
        shareProjectData.close();
        String prepayProjectSql = "select fid,forg from t_tcvat_prepay_project where fid in (" + StringUtil.join(prepayProjectId, (String)",") + ")";
        List prepayProjectList = DBUtils.query((String)prepayProjectSql);
        for (Map prepayProject : prepayProjectList) {
            DBUtils.execute((String)("update t_tcvat_perpay_share_pri set  forg = " + prepayProject.get("FORG") + " where fprepayproject =" + prepayProject.get("FID") + ";"));
        }
        message.append("sbx  SharePlanSynUpgradeService update sucess");
    }

    private void synTzPlanToSbxConfig(StringBuilder message) {
        String updatePlan = "insert into t_tcvat_tz_shareplan (fid,fcreateorgid,ftaxpayertype,fcreatetime) select s.fentryid ,e.forgid,s.ftaxpayertype,s.fcreatetime from t_tcvat_tzshareplan_edit e inner join t_tcvat_tzsharingplan s on e.fid = s.fid and s.ftaxpayertype != ' ';";
        DBUtils.execute((String)updatePlan);
        String updateName = "INSERT INTO t_tcvat_tz_shareplan_l (fpkid, fid, flocaleid, fname) SELECT fpkid, fentryid, flocaleid, fname FROM t_tcvat_tzsharingplan_l;";
        DBUtils.execute((String)updateName);
        String updatePlanRule = "INSERT INTO t_tcvat_tz_shareplan_rule (fid, fentryid, fseq, frule) select fentryid, fdetailid, fseq, fruleid from t_tcvat_tzshareplan_rules;";
        DBUtils.execute((String)updatePlanRule);
        String updatePlanOrg = "INSERT INTO t_tcvat_tz_shareplan_org (fid, fentryid, fseq, forg) select fentryid, fdetailid, fseq, forgid from t_tcvat_tzshareplan_orgs;";
        DBUtils.execute((String)updatePlanOrg);
        String sql = "select fid from t_tcvat_tz_shareplan";
        DataSet data = DB.queryDataSet((String)"SharePlanSynUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)sql);
        if (data.isEmpty()) {
            data.close();
            return;
        }
        int index = 1;
        while (data.hasNext()) {
            Row row = data.next();
            String number = String.format("VAT-GXTZ-%06d", index);
            DBUtils.execute((String)("update t_tcvat_tz_shareplan set  fnumber = '" + number + "' where fid =" + row.getLong("FID") + ";"));
            ++index;
        }
        data.close();
        message.append("sbx  SharePlanSynUpgradeService update sucess");
    }
}

