/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcvat.business.service.jzjt.JzjtService;

public class TaxRefundApplyUpgradeService
extends AbstractUpgradeFormPlugin {
    private Log LOGGER = LogFactory.getLog(TaxRefundApplyUpgradeService.class);
    private String TAXC = "taxc";
    private JzjtService jzjtService = new JzjtService();
    private Map<Long, Long> taxoffices = new HashMap<Long, Long>();

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\uff1a\u7559\u62b5\u9000\u7a0e\u9000\u7a0e\u7533\u8bf7\u8868\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5904\u7406\u6210\u529f\uff01", (String)"TaxRefundApplyUpgradeService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        try {
            this.LOGGER.info("\u5f00\u59cb\u6267\u884c\u589e\u503c\u7a0e\uff1a\u7559\u62b5\u9000\u7a0e\u9000\u7a0e\u7533\u8bf7\u8868\u5386\u53f2\u6570\u636e\u5347\u7ea7===>>>>>>");
            if (!(DB.exitsTable((DBRoute)DBRoute.of((String)this.TAXC), (String)"t_tpo_tax_refund_info") && DB.exitsTable((DBRoute)DBRoute.of((String)this.TAXC), (String)"t_tcvat_refund_apply") && DB.exitsTable((DBRoute)DBRoute.of((String)this.TAXC), (String)"t_tpo_declare_main_tsd"))) {
                return result;
            }
            if (this.isRefundUpdated()) {
                this.LOGGER.info("\u5b58\u5728\u9700\u8981\u5347\u7ea7\u7684\u7559\u62b5\u9000\u7a0e\u9000\u7a0e\u7533\u8bf7\u8868\u5386\u53f2\u6570\u636e===>>>>>>");
                String query = "select d.fskssqq,d.fskssqz,d.forgid,d.fbillno,a.fbqsqthdclldse,a.fbqsqthdzlldse,a.fbljd from t_tpo_declare_main_tsd d inner join t_tcvat_refund_apply a on d.fid = a.fid where ftemplatetype = 'tcvat_taxrefund' and ftaxtype = '0' and fbillstatus = 'C' and a.fbljd in ('ysq','yts');";
                DataSet dataSet = DBUtils.queryDataSet((String)"TaxRefundApplyUpgradeService", (String)query, null);
                ArrayList<Object[]> insertParams = new ArrayList<Object[]>(32);
                this.taxoffices = new HashMap<Long, Long>();
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    Object[] objects = this.dealParams(next);
                    insertParams.add(objects);
                }
                dataSet.close();
                this.LOGGER.info("\u5b58\u5728\u9700\u8981\u5347\u7ea7\u7684\u7559\u62b5\u9000\u7a0e\u9000\u7a0e\u7533\u8bf7\u8868\u5386\u53f2\u6570\u636e\u4e2a\u6570\u4e3a" + insertParams.size());
                String insert = "INSERT INTO t_tpo_tax_refund_info (fid,forgid,fbillno,fbillstatus,fmodifytime,fcreatetime,fstartdate,fenddate,ftaxcategory,fcurrency,ftaxoffice,frefundableamount,factualrefundamount,fdeclaretype,fdeclarenum,fdatasource,ftaxrefundstatus,fisvoucher) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?); ";
                int insertNum = CollectionUtils.isNotEmpty(insertParams) ? DBUtils.executeBatch((String)insert, insertParams).length : 0;
                this.LOGGER.info("\u6210\u529f\u5347\u7ea7\u7684\u7559\u62b5\u9000\u7a0e\u9000\u7a0e\u7533\u8bf7\u8868\u5386\u53f2\u6570\u636e\u4e2a\u6570\u4e3a" + insertNum);
            }
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u7559\u62b5\u9000\u7a0e\u9000\u7a0e\u7533\u8bf7\u8868\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5931\u8d25\uff01", (String)"TaxRefundApplyUpgradeService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            this.LOGGER.error("TaxRefundApplyUpgradeService FAILURE", (Throwable)e);
        }
        return result;
    }

    private Object[] dealParams(Row next) {
        boolean isYts = "yts".equals(next.getString("fbljd"));
        BigDecimal actualrefundamount = BigDecimal.ZERO;
        BigDecimal fbqsqthdclldse = next.getBigDecimal("fbqsqthdclldse");
        BigDecimal fbqsqthdzlldse = next.getBigDecimal("fbqsqthdzlldse");
        BigDecimal refundableamount = fbqsqthdclldse.add(fbqsqthdzlldse).setScale(10, 4);
        if (isYts) {
            actualrefundamount = refundableamount;
        }
        String fbillno = DeclareServiceHelper.generateSBBNo((String)"tpo_tax_refund_info", (String)String.valueOf(next.getLong("forgid")));
        String fbillstatus = "C";
        Date fmodifytime = new Date();
        Date fcreatetime = new Date();
        Date fstartdate = next.getDate("fskssqq");
        Date fenddate = next.getDate("fskssqz");
        Long ftaxcategory = 1L;
        Long fcurrency = 1L;
        Long ftaxoffice = this.getTaxoffice(next.getLong("forgid"));
        BigDecimal frefundableamount = refundableamount;
        BigDecimal factualrefundamount = actualrefundamount;
        String fdeclaretype = "tcvat_taxrefund";
        String fdeclarenum = next.getString("fbillno");
        String fdatasource = "0";
        String ftaxrefundstatus = isYts ? "1" : "0";
        String fisvoucher = "0";
        Long fid = DBUtils.getLongId((String)"t_tpo_tax_refund_info");
        Long forgid = next.getLong("forgid");
        return new Object[]{fid, forgid, fbillno, fbillstatus, fmodifytime, fcreatetime, fstartdate, fenddate, ftaxcategory, fcurrency, ftaxoffice, frefundableamount, factualrefundamount, fdeclaretype, fdeclarenum, fdatasource, ftaxrefundstatus, fisvoucher};
    }

    private Long getTaxoffice(Long orgid) {
        Long taxoffice = this.taxoffices.get(orgid);
        if (Objects.isNull(taxoffice)) {
            taxoffice = this.jzjtService.getTaxoffice(orgid);
            this.taxoffices.put(orgid, taxoffice);
        }
        return taxoffice;
    }

    private boolean isRefundUpdated() {
        String isExists = "select fid from t_tpo_tax_refund_info where fdeclaretype = 'tcvat_taxrefund';";
        return CollectionUtils.isEmpty((Collection)DBUtils.query((String)isExists));
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return this.LOGGER;
    }
}

