/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.upgradeservice;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.Button;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import org.apache.commons.lang.StringUtils;

public class TcvatDeclareUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TcvatDeclareUpgradeService.class);
    private static final String YBNSR_ZB = "tcvat_ybnsr_zb";
    private static final String XGMNSR_ZB = "tcvat_xgm_zb";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TAX_TYPES = "taxtypes";
    private static final String BQDYBTSE = "bqdybtse";
    private static final String SJJE = "sjje";
    private static final String QJJE = "qjje";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"deletefjsf"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        if (Objects.equals("deletefjsf", source.getKey())) {
            this.deletefjsf();
        }
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        for (String number : Arrays.asList("tcvat_zzs_declare_list", XGMNSR_ZB, YBNSR_ZB, "tcvat_sb_fjsf")) {
            Boolean isExist = this.metaIsExist(number);
            if (isExist.booleanValue()) continue;
            this.addLog(ERROR, String.format("The %s is not exist!", number));
            return;
        }
        DynamicObject[] reportCollection = this.queryAllReport();
        List<String> sbbidList = Arrays.stream(reportCollection).map(r -> r.getString("id")).collect(Collectors.toList());
        Map<String, DynamicObject> ybnsrZBMap = this.YbnsrZBMap(sbbidList);
        Map<String, DynamicObject> xgmZBMap = this.xgmZBMap(sbbidList);
        Map<String, Map<String, Object>> payRecordMap = this.payRecordMap(sbbidList);
        this.addNewData(ybnsrZBMap, xgmZBMap, payRecordMap, reportCollection);
        this.save(reportCollection);
        this.deletefjsf();
    }

    private void deletefjsf() {
        QFilter qFilter = new QFilter("skssqq", ">=", (Object)DateUtils.stringToDate((String)"2021-07-01")).and("type", "in", Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz"));
        DynamicObject[] reportCollection = BusinessDataServiceHelper.load((String)"tcvat_zzs_declare_list", (String)"id", (QFilter[])new QFilter[]{qFilter});
        List sbbidList = Arrays.stream(reportCollection).map(r -> r.getLong("id")).collect(Collectors.toList());
        String deletefjsf = "delete from  t_tctb_declare_entry where  fid in (" + StringUtils.join(sbbidList, (String)",") + ") and ftaxtype = '2' ";
        DBUtils.execute((String)deletefjsf);
    }

    private DynamicObject[] queryAllReport() {
        Date date = DateUtils.stringToDate((String)"2021-07-01");
        QFilter qFilter1 = new QFilter("skssqq", ">=", (Object)date).and("type", "in", Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz")).and("entryentity.taxtypes", "in", Arrays.asList("3", "4", "5"));
        DynamicObjectCollection reportCollection = QueryServiceHelper.query((String)"tcvat_zzs_declare_list", (String)"id", (QFilter[])new QFilter[]{qFilter1});
        List sbbidList = reportCollection.stream().map(r -> r.getLong("id")).distinct().collect(Collectors.toList());
        QFilter qFilter = new QFilter("skssqq", ">=", (Object)date).and("type", "in", Arrays.asList("zzsybnsr", "zzsxgmnsr", "zzsybnsr_ybhz")).and("id", "not in", sbbidList);
        DynamicObject[] reportCollection2 = BusinessDataServiceHelper.load((String)"tcvat_zzs_declare_list", (String)MetadataUtil.getAllSubFieldString((String)"tcvat_zzs_declare_list"), (QFilter[])new QFilter[]{qFilter});
        return reportCollection2;
    }

    private Map<String, DynamicObject> YbnsrZBMap(List<String> sbbidList) {
        QFilter ybnsrFilter = new QFilter("ewblxh", "=", (Object)"1").and("sbbid", "in", sbbidList);
        DynamicObjectCollection ybnsrZB = QueryServiceHelper.query((String)YBNSR_ZB, (String)"sbbid,cswhjssbqybtse,jyffjbqybtsfe,dfjyfjbqybtsfe", (QFilter[])ybnsrFilter.toArray());
        return ybnsrZB.stream().collect(Collectors.toMap(k -> k.getString("sbbid"), v -> v, (k1, k2) -> k1));
    }

    private Map<String, DynamicObject> xgmZBMap(List<String> sbbidList) {
        QFilter xgmFilter = new QFilter("ewblxh", "=", (Object)"5").and("sbbid", "in", sbbidList);
        DynamicObjectCollection xgmZB = QueryServiceHelper.query((String)XGMNSR_ZB, (String)"sbbid,cswhjssbqybtse,jyffjbqybtsfe,dfjyfjbqybtsfe", (QFilter[])xgmFilter.toArray());
        return xgmZB.stream().collect(Collectors.toMap(k -> k.getString("sbbid"), v -> v, (k1, k2) -> k1));
    }

    private Map<String, Map<String, Object>> payRecordMap(List<String> sbbidList) {
        String QUERY_SQL = "select fssbbid ,ftaxtype,sum(fsjje) as fsjje,sum(fsyqjje) as fsyqjje from t_bdtaxr_pay_record where ftaxtype in ('cswhjss', 'jyffj', 'dfjyfj') and fssbbid in ('" + StringUtils.join(sbbidList, (String)"','") + "') group by fssbbid ,ftaxtype;";
        List query = DBUtils.query((String)QUERY_SQL);
        Map<String, Map<String, Object>> fsjje = query.stream().collect(Collectors.toMap(k -> (String)k.get("FSSBBID") + (String)k.get("FTAXTYPE"), v -> v, (k1, k2) -> k1));
        return fsjje;
    }

    private void addNewData(Map<String, DynamicObject> ybnsrZBMap, Map<String, DynamicObject> xgmZBMap, Map<String, Map<String, Object>> payRecordMap, DynamicObject[] reportCollection) {
        for (DynamicObject report : reportCollection) {
            String sbbid = report.getString("id");
            DynamicObject zbObject = "zzsxgmnsr".equals(report.getString("type")) ? xgmZBMap.get(sbbid) : ybnsrZBMap.get(sbbid);
            String declarestatus = report.getString("declarestatus");
            String paystatus = report.getString("paystatus");
            BigDecimal sjje3 = BigDecimal.ZERO;
            BigDecimal qjje3 = BigDecimal.ZERO;
            BigDecimal sjje4 = BigDecimal.ZERO;
            BigDecimal qjje4 = BigDecimal.ZERO;
            BigDecimal sjje5 = BigDecimal.ZERO;
            BigDecimal qjje5 = BigDecimal.ZERO;
            if ("declared".equals(declarestatus)) {
                if ("paid".equals(paystatus)) {
                    sjje3 = null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("cswhjssbqybtse");
                    sjje4 = null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("jyffjbqybtsfe");
                    BigDecimal bigDecimal = sjje5 = null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("dfjyfjbqybtsfe");
                }
                if ("partpaid".equals(paystatus)) {
                    Map<String, Object> cswhjss = payRecordMap.get(sbbid + "cswhjss");
                    Map<String, Object> jyffj = payRecordMap.get(sbbid + "jyffj");
                    Map<String, Object> dfjyfj = payRecordMap.get(sbbid + "dfjyfj");
                    sjje3 = null == cswhjss ? BigDecimal.ZERO : (BigDecimal)cswhjss.get("FSJJE");
                    sjje4 = null == jyffj ? BigDecimal.ZERO : (BigDecimal)jyffj.get("FSJJE");
                    sjje5 = null == dfjyfj ? BigDecimal.ZERO : (BigDecimal)dfjyfj.get("FSJJE");
                    qjje3 = null == cswhjss ? BigDecimal.ZERO : (BigDecimal)cswhjss.get("FSYQJJE");
                    qjje4 = null == jyffj ? BigDecimal.ZERO : (BigDecimal)jyffj.get("FSYQJJE");
                    BigDecimal bigDecimal = qjje5 = null == dfjyfj ? BigDecimal.ZERO : (BigDecimal)dfjyfj.get("FSYQJJE");
                }
                if (!"paid".equals(paystatus) && !"partpaid".equals(paystatus)) {
                    qjje3 = null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("cswhjssbqybtse");
                    qjje4 = null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("jyffjbqybtsfe");
                    qjje5 = null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("dfjyfjbqybtsfe");
                }
            }
            DynamicObjectCollection entryObject = report.getDynamicObjectCollection(ENTRY_ENTITY);
            DynamicObject object3 = entryObject.addNew();
            object3.set(TAX_TYPES, (Object)"3");
            object3.set(BQDYBTSE, (Object)(null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("cswhjssbqybtse")));
            object3.set(SJJE, (Object)sjje3);
            object3.set(QJJE, (Object)qjje3);
            DynamicObject object4 = entryObject.addNew();
            object4.set(TAX_TYPES, (Object)"4");
            object4.set(BQDYBTSE, (Object)(null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("jyffjbqybtsfe")));
            object4.set(SJJE, (Object)sjje4);
            object4.set(QJJE, (Object)qjje4);
            DynamicObject object5 = entryObject.addNew();
            object5.set(TAX_TYPES, (Object)"5");
            object5.set(BQDYBTSE, (Object)(null == zbObject ? BigDecimal.ZERO : zbObject.getBigDecimal("dfjyfjbqybtsfe")));
            object5.set(SJJE, (Object)sjje5);
            object5.set(QJJE, (Object)qjje5);
        }
    }

    private void save(DynamicObject[] reportCollection) {
        try (TXHandle h = TX.requiresNew();){
            try {
                List result = Arrays.stream(reportCollection).collect(Collectors.toList());
                List partition = Lists.partition(result, (int)100);
                for (List objectList : partition) {
                    SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[objectList.size()]));
                }
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error(ERROR_INFO, t);
                throw new RuntimeException(t);
            }
        }
    }
}

