/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.zlb;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;

public class YbhzZlbCalculateService {
    private static final Log LOGGER = LogFactory.getLog(YbhzZlbCalculateService.class);
    private static final String TCVAT_YBHZ_ZLB_HTB = "tcvat_ybhz_zlb_htb";
    private static final String TCVAT_YBHZ_ZLB_HJB = "tcvat_ybhz_zlb_hjb";
    private static final String TCVAT_YBHZ_ZLB_SEHF = "tcvat_ybhz_zlb_sehf";
    private static final String TCVAT_YBHZ_ZLB_JGFPB = "tcvat_ybhz_zlb_jgfpb";
    private static final String TCVAT_ZLB_APPORTBILL = "tcvat_zlb_apportbill";
    private static final String TCVAT_ZLB_YZ_APPORTION = "tcvat_zlb_yz_apportion";
    private static final String TCVAT_YBHZ_YZ_TAXRATE_DET = "tcvat_ybhz_yz_taxrate_det";
    private static final String TCVAT_YBHZ_YZ_EJJGSEFT = "tcvat_zlb_yz_ejjgseft";
    private static final String TCVAT_ZLB_ZZSYBNSR_YBHZ = "tcvat_zlb_zzsybnsr_ybhz";
    private static final String TCVAT_ZLB_YZ_SHARE_RATIO = "tcvat_zlb_yz_share_ratio";
    private static final BigDecimal handred = new BigDecimal(100);
    private static final String TCVAT_HZ_ACCOUNT_SUMMARY = "tcvat_hz_account_summary";
    private static final String TCTB_ORG_GROUP_LATEST = "tctb_org_group_latest";
    private static String[] hjColumn = new String[]{"xssr", "jzjtxssr", "ysfwxssr", "ysfwjzjtxssr", "fpbl", "jzjtfpbl", "ysfwfpbl", "ysfwjzjtfpbl", "fpse", "jzjtfpse", "ysfwfpse", "ysfwjzjtfpse", "pbsehj"};
    private static String[] blColumn = new String[]{"fpbl", "jzjtfpbl", "ysfwfpbl", "ysfwjzjtfpbl"};
    private static String[] seColumn = new String[]{"fpse", "jzjtfpse", "ysfwfpse", "ysfwjzjtfpse"};
    private static String[] srColumn = new String[]{"xssr", "jzjtxssr", "ysfwxssr", "ysfwjzjtxssr"};

    public static boolean calculateSefpZlb(Map<String, String> queryData, String orgid, String startdate, String enddate, String taxpayerType) {
        DynamicObject orgGroup = YbhzZlbCalculateService.getOrgGroup(orgid, startdate, enddate);
        String fpxssrfw = orgGroup.getString("fpxssrfw");
        String ybtsehffs = orgGroup.getString("ybtsehffs");
        BigDecimal fpxssrhj = BigDecimal.ZERO;
        BigDecimal row26 = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#26#ybxm", "tcvat_zlb_zzsybnsr_ybhz#26#jzjtxm"}));
        BigDecimal oneTwo = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#1#ybxm", "tcvat_zlb_zzsybnsr_ybhz#1#jzjtxm", "tcvat_zlb_zzsybnsr_ybhz#2#ybxm", "tcvat_zlb_zzsybnsr_ybhz#2#jzjtxm"}));
        if (Objects.equals("1", fpxssrfw)) {
            fpxssrhj = oneTwo;
        } else if (Objects.equals("2", fpxssrfw)) {
            fpxssrhj = row26.compareTo(BigDecimal.ZERO) == 0 ? YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#2#ybxm", "tcvat_zlb_zzsybnsr_ybhz#2#jzjtxm"})) : oneTwo;
        }
        BigDecimal ybtsehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#31#ybxm", "tcvat_zlb_zzsybnsr_ybhz#31#jzjtxm"}));
        BigDecimal jxsjdksehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#14#ybxm", "tcvat_zlb_zzsybnsr_ybhz#14#jzjtxm", "tcvat_zlb_zzsybnsr_ybhz#19#ybxm", "tcvat_zlb_zzsybnsr_ybhz#19#jzjtxm"}));
        BigDecimal jzsehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#24#ybxm", "tcvat_zlb_zzsybnsr_ybhz#24#jzjtxm"}));
        boolean isJyjs = Objects.equals(fpxssrfw, "2") && row26.compareTo(BigDecimal.ZERO) == 0;
        Map<String, List<DynamicObject>> ybtsehfMap = YbhzZlbCalculateService.buildYbtsehf(orgid, startdate, enddate, isJyjs, ybtsehffs, fpxssrhj, ybtsehj, jxsjdksehj, jzsehj, taxpayerType);
        List hbtbList = ybtsehfMap.getOrDefault("htb", new ArrayList(0));
        List ybtsehfList = ybtsehfMap.getOrDefault("sehfb", new ArrayList(0));
        String zfjgsefpfs = orgGroup.getString("zfjgsefpfs");
        BigDecimal ybhwsehj = BigDecimal.ZERO;
        BigDecimal ybhwjzjtsehj = BigDecimal.ZERO;
        BigDecimal ysfwsehj = BigDecimal.ZERO;
        BigDecimal ysfwjzjtsehj = BigDecimal.ZERO;
        if ("4".equals(zfjgsefpfs)) {
            if (fpxssrhj != null && fpxssrhj.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal xssrHj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "0")).map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                ybhwsehj = xssrHj.multiply(ybtsehj).divide(fpxssrhj, 2, RoundingMode.HALF_UP);
                BigDecimal jzjtXssrHj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "1")).map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                ybhwjzjtsehj = jzjtXssrHj.multiply(ybtsehj).divide(fpxssrhj, 2, RoundingMode.HALF_UP);
                BigDecimal ysxssrhj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "0")).map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                ysfwsehj = ysxssrhj.multiply(ybtsehj).divide(fpxssrhj, 2, RoundingMode.HALF_UP);
                BigDecimal ysjzjtxxsrhj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "1")).map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                ysfwjzjtsehj = ysjzjtxxsrhj.multiply(ybtsehj).divide(fpxssrhj, 2, RoundingMode.HALF_UP);
            }
        } else {
            ybhwsehj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "0")).map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            ybhwjzjtsehj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "1")).map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            ysfwsehj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "0")).map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            ysfwjzjtsehj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "1")).map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        List<DynamicObject> zjgfpList = YbhzZlbCalculateService.buildZjgfp(orgid, startdate, enddate, hbtbList, ybtsehfList, orgGroup, ybhwsehj, ybhwjzjtsehj, ysfwsehj, ysfwjzjtsehj, taxpayerType);
        DynamicObject hjObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_YBHZ_ZLB_HJB));
        hjObject.set("fpxssrhj", (Object)fpxssrhj);
        hjObject.set("ybtsehj", (Object)ybtsehj);
        hjObject.set("jxsjdksehj", (Object)jxsjdksehj);
        hjObject.set("jzsehj", (Object)jzsehj);
        hjObject.set("ybhwjlwsehj", (Object)ybhwsehj);
        hjObject.set("ybhwjlwsehjjzjt", (Object)ybhwjzjtsehj);
        hjObject.set("ysfwsehj", (Object)ysfwsehj);
        hjObject.set("ysfwsehjjzjt", (Object)ysfwjzjtsehj);
        hjObject.set("org", (Object)Long.parseLong(orgid));
        Date start = DateUtils.stringToDate((String)startdate);
        Date end = DateUtils.stringToDate((String)enddate);
        hjObject.set("startdate", (Object)start);
        hjObject.set("enddate", (Object)end);
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            YbhzZlbCalculateService.deleteData(Long.parseLong(orgid), DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate));
            if (ybtsehfList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])ybtsehfList.toArray(new DynamicObject[ybtsehfList.size()]));
            }
            if (hbtbList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])hbtbList.toArray(new DynamicObject[hbtbList.size()]));
            }
            if (zjgfpList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])zjgfpList.toArray(new DynamicObject[zjgfpList.size()]));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hjObject});
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            try {
                h.markRollback();
                LOGGER.error(t);
                throw new RuntimeException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static boolean calculateSkftZlb(Map<String, String> queryData, String orgid, String startdate, String enddate, String taxPayerType) {
        Date skssqq = DateUtils.stringToDate((String)startdate);
        Date skssqz = DateUtils.stringToDate((String)enddate);
        long orgId = Long.parseLong(orgid);
        List<DynamicObject> taxApportionList = YbhzZlbCalculateService.packageApportData(queryData, orgid, taxPayerType, skssqq, skssqz);
        if (CollectionUtils.isEmpty(taxApportionList)) {
            return false;
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            QFilter filter = new QFilter("org", "=", (Object)orgId).and("startdate", "=", (Object)skssqq).and("enddate", "=", (Object)skssqz);
            DeleteServiceHelper.delete((String)TCVAT_ZLB_APPORTBILL, (QFilter[])filter.toArray());
            SaveServiceHelper.save((DynamicObject[])taxApportionList.toArray(new DynamicObject[0]));
            boolean bl = true;
            return bl;
        }
        catch (Exception t) {
            try {
                h.markRollback();
                LOGGER.error((Throwable)t);
                throw new RuntimeException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static List<DynamicObject> packageApportData(Map<String, String> queryData, String orgid, String taxPayerType, Date skssqq, Date skssqz) {
        QFilter skssqFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        DynamicObject policyObj = TcvatDraftService.loadPolicyConfirm("nssb", taxPayerType, TcvatDraftService.getDraftTemplateType("nssb", taxPayerType), orgid, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        if (policyObj == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection hzentry = policyObj.getDynamicObjectCollection("hzentryentity");
        List<DynamicObject> collect = hzentry.stream().filter(e -> "2".equals(e.getString("levelname"))).collect(Collectors.toList());
        DynamicObject orgGroup = OrgUtils.getOrgDeclarePlan((Long)Long.parseLong(orgid), (Date)skssqq, (Date)skssqz);
        Map<Long, List<DynamicObject>> orgSubMap = orgGroup.getDynamicObjectCollection("orgrow").stream().collect(Collectors.groupingBy(e -> e.getLong("parentid.id")));
        ArrayList<DynamicObject> taxApportionList = new ArrayList<DynamicObject>(hzentry.size());
        if ("1".equals(policyObj.getString("prelevyrate"))) {
            YbhzZlbCalculateService.packageGDApportList(queryData, orgid, taxPayerType, skssqq, skssqz, taxApportionList, skssqFilter, policyObj.getBigDecimal("fixedratio"), collect, orgSubMap);
        }
        if ("2".equals(policyObj.getString("prelevyrate"))) {
            YbhzZlbCalculateService.packageLJApportList(queryData, orgid, taxPayerType, skssqq, skssqz, taxApportionList, skssqFilter, collect, orgSubMap);
        }
        return taxApportionList;
    }

    public static boolean calculateYzcs(Map<String, String> queryData, String orgid, String startdate, String enddate, String taxPayerType) {
        DynamicObject[] skftbArray;
        Date skssqq = DateUtils.stringToDate((String)startdate);
        Date skssqz = DateUtils.stringToDate((String)enddate);
        long orgId = Long.parseLong(orgid);
        DynamicObject policyObj = TcvatDraftService.loadPolicyConfirm("nssb", taxPayerType, TcvatDraftService.getDraftTemplateType("nssb", taxPayerType), orgid, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        if (policyObj == null) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCVAT_YBHZ_YZ_TAXRATE_DET);
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("startdate", (Object)DateUtils.stringToDate((String)startdate));
        dynamicObject.set("enddate", (Object)DateUtils.stringToDate((String)enddate));
        QFilter filter = new QFilter("org", "=", (Object)orgId).and("startdate", "=", (Object)skssqq).and("enddate", "=", (Object)skssqz);
        BigDecimal ybxm = StringUtil.isNotBlank((CharSequence)queryData.get("tcvat_zlb_zzsybnsr_ybhz#5#ybxm")) ? BigDecimalUtil.toBigDecimal((Object)queryData.get("tcvat_zlb_zzsybnsr_ybhz#5#ybxm")) : BigDecimal.ZERO;
        BigDecimal jzjtxm = StringUtil.isNotBlank((CharSequence)queryData.get("tcvat_zlb_zzsybnsr_ybhz#5#jzjtxm")) ? BigDecimalUtil.toBigDecimal((Object)queryData.get("tcvat_zlb_zzsybnsr_ybhz#5#jzjtxm")) : BigDecimal.ZERO;
        BigDecimal zlbAmount = BigDecimalUtil.addObject((Object)ybxm, (Object)jzjtxm);
        DynamicObject lastDetailParam = null;
        if (DateUtils.getMonthOfDate((Date)skssqq) != 1) {
            lastDetailParam = QueryServiceHelper.queryOne((String)TCVAT_YBHZ_YZ_TAXRATE_DET, (String)"zjgdqqbljxse, zjgsqqbljxse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("startdate", "=", (Object)DateUtils.addMonth((Date)skssqq, (int)-1)), new QFilter("enddate", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)skssqz, (int)-1))))});
        }
        BigDecimal lastAmount = lastDetailParam != null ? lastDetailParam.getBigDecimal("zjgdqqbljxse") : BigDecimal.ZERO;
        dynamicObject.set("zjgsqqbljxse", (Object)lastAmount);
        dynamicObject.set("zjgdqqbljxse", (Object)lastAmount.add(zlbAmount));
        DynamicObjectCollection hzentryentity = policyObj.getDynamicObjectCollection("hzentryentity");
        Map<Long, String> map = hzentryentity.stream().collect(Collectors.toMap(k -> k.getDynamicObject("assignorg").getLong("id"), v -> v.getString("issuesbb"), (m, n) -> m));
        BigDecimal ynsehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#29#ybxm", "tcvat_zlb_zzsybnsr_ybhz#29#jzjtxm"}));
        for (DynamicObject skftb : skftbArray = BusinessDataServiceHelper.load((String)TCVAT_ZLB_APPORTBILL, (String)"id,org,suborg,dqxse,declaretype,ljxse,jsbl,ynse,startdate,enddate", (QFilter[])new QFilter[]{filter})) {
            String issuesbb = map.get(skftb.getDynamicObject("suborg").getLong("id"));
            if (issuesbb != null && "true".equals(issuesbb) && BigDecimal.ZERO.compareTo(lastAmount.add(zlbAmount)) != 0) {
                BigDecimal rate = skftb.getBigDecimal("ljxse").divide(lastAmount.add(zlbAmount), 10, RoundingMode.HALF_UP);
                skftb.set("jsbl", (Object)rate);
                skftb.set("ynse", (Object)ynsehj.multiply(rate).setScale(2, RoundingMode.HALF_UP));
                continue;
            }
            skftb.set("jsbl", (Object)BigDecimal.ZERO.setScale(10, RoundingMode.HALF_UP).toPlainString());
            skftb.set("ynse", (Object)BigDecimal.ZERO.setScale(2));
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DeleteServiceHelper.delete((String)TCVAT_YBHZ_YZ_TAXRATE_DET, (QFilter[])filter.toArray());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            SaveServiceHelper.save((DynamicObject[])skftbArray);
            int n2 = 1;
            return n2 != 0;
        }
        catch (Exception t) {
            try {
                h.markRollback();
                LOGGER.error((Throwable)t);
                throw new RuntimeException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void packageLJApportList(Map<String, String> queryData, String orgid, String taxPayerType, Date skssqq, Date skssqz, List<DynamicObject> taxApportionList, QFilter skssqFilter, List<DynamicObject> hzentryentity, Map<Long, List<DynamicObject>> orgSubMap) {
        BigDecimal ljxseSum = BigDecimal.ZERO;
        DynamicObjectCollection preApportList = YbhzZlbCalculateService.doQueryPreApport(orgid, skssqq, skssqz);
        Map<Long, BigDecimal> preApportMap = preApportList.stream().collect(Collectors.toMap(a -> a.getLong("suborg"), a -> a.getBigDecimal("ljxse")));
        Map<Long, String> issueSbbmap = hzentryentity.stream().collect(Collectors.toMap(k -> k.getDynamicObject("assignorg").getLong("id"), v -> v.getString("issuesbb"), (m, n) -> m));
        for (DynamicObject entry : hzentryentity) {
            DynamicObject dyo = YbhzZlbCalculateService.packageApport(orgid, taxPayerType, skssqq, skssqz, skssqFilter, entry, entry.getString("hzdeclaretype"), orgSubMap);
            BigDecimal preLjxse = preApportMap.get(dyo.getLong("suborg"));
            BigDecimal ljxse = dyo.getBigDecimal("dqxse").add(preLjxse != null ? preLjxse : BigDecimal.ZERO);
            dyo.set("ljxse", (Object)ljxse);
            ljxseSum = ljxseSum.add(ljxse);
            taxApportionList.add(dyo);
        }
        BigDecimal ynsehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#29#ybxm", "tcvat_zlb_zzsybnsr_ybhz#29#jzjtxm"}));
        for (DynamicObject obj : taxApportionList) {
            long id = obj.getLong("suborg");
            if (issueSbbmap.get(id) != null && "true".equals(issueSbbmap.get(id))) {
                BigDecimal ljxse = obj.getBigDecimal("ljxse");
                BigDecimal jsbl = ljxseSum.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ljxse.divide(ljxseSum, 10, 4);
                obj.set("jsbl", (Object)jsbl);
                obj.set("ynse", (Object)ynsehj.multiply(jsbl).setScale(2, 4));
                continue;
            }
            obj.set("jsbl", (Object)BigDecimal.ZERO);
            obj.set("ynse", (Object)BigDecimal.ZERO);
        }
    }

    private static DynamicObjectCollection doQueryPreApport(String orgid, Date skssqq, Date skssqz) {
        if (DateUtils.getMonthOfDate((Date)skssqq) == 1) {
            return new DynamicObjectCollection();
        }
        return QueryServiceHelper.query((String)TCVAT_ZLB_APPORTBILL, (String)"org,suborg,declaretype,dqxse,ljxse,jsbl,ynse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgid)), new QFilter("startdate", "=", (Object)DateUtils.getMinDateBeforeSomeMonth((Date)skssqq, (int)-1)), new QFilter("enddate", "=", (Object)DateUtils.getMaxDateBeforeSomeMonth((Date)skssqz, (int)-1))});
    }

    private static void packageGDApportList(Map<String, String> queryData, String orgid, String taxPayerType, Date skssqq, Date skssqz, List<DynamicObject> taxApportionList, QFilter skssqFilter, BigDecimal jsbl, List<DynamicObject> hzentryentity, Map<Long, List<DynamicObject>> orgSubMap) {
        for (DynamicObject entry : hzentryentity) {
            String declareType = entry.getString("hzdeclaretype");
            DynamicObject dyo = YbhzZlbCalculateService.packageApport(orgid, taxPayerType, skssqq, skssqz, skssqFilter, entry, declareType, orgSubMap);
            boolean issuesbb = entry.getBoolean("issuesbb");
            if (issuesbb) {
                dyo.set("jsbl", (Object)jsbl);
            } else {
                dyo.set("jsbl", (Object)BigDecimal.ZERO);
            }
            dyo.set("ynse", (Object)BigDecimal.ZERO);
            BigDecimal ynsehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#29#ybxm", "tcvat_zlb_zzsybnsr_ybhz#29#jzjtxm"}));
            if (BigDecimal.ZERO.compareTo(ynsehj) < 0) {
                BigDecimal ynse = dyo.getBigDecimal("dqxse").multiply(jsbl).setScale(2, RoundingMode.HALF_UP);
                dyo.set("ynse", (Object)ynse);
            }
            taxApportionList.add(dyo);
        }
    }

    private static DynamicObject packageApport(String orgid, String taxPayerType, Date skssqq, Date skssqz, QFilter skssqFilter, DynamicObject entry, String declareType, Map<Long, List<DynamicObject>> orgSubMap) {
        QFilter suborgFilter;
        long subOrgId = entry.getDynamicObject("assignorg").getDynamicObject("org").getLong("id");
        DynamicObject dyo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_ZLB_APPORTBILL));
        dyo.set("org", (Object)orgid);
        dyo.set("suborg", (Object)subOrgId);
        dyo.set("startdate", (Object)skssqq);
        dyo.set("enddate", (Object)skssqz);
        dyo.set("declaretype", (Object)declareType);
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", (Object)taxPayerType);
        List<DynamicObject> thirdOrg = orgSubMap.get(subOrgId);
        if (thirdOrg == null || thirdOrg.isEmpty()) {
            suborgFilter = new QFilter("suborg", "=", (Object)subOrgId);
        } else {
            List orgIds = thirdOrg.stream().map(e -> e.getLong("orgid.id")).collect(Collectors.toList());
            orgIds.add(subOrgId);
            suborgFilter = new QFilter("suborg", "in", orgIds);
        }
        DynamicObject dqxseSum = QueryServiceHelper.queryOne((String)TCVAT_HZ_ACCOUNT_SUMMARY, (String)"sum(taxamount) as dqxse", (QFilter[])new QFilter[]{suborgFilter, skssqFilter, taxpayertypeFilter});
        BigDecimal dqxse = dqxseSum != null ? dqxseSum.getBigDecimal("dqxse") : BigDecimal.ZERO;
        dyo.set("dqxse", (Object)dqxse);
        return dyo;
    }

    public static void deleteData(Long org, Date start, Date end) {
        QFilter and = new QFilter("org", "=", (Object)org).and("startdate", "=", (Object)start).and("enddate", "=", (Object)end);
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)TCVAT_YBHZ_ZLB_HJB, (QFilter[])and.toArray());
                DeleteServiceHelper.delete((String)TCVAT_YBHZ_ZLB_HTB, (QFilter[])and.toArray());
                DeleteServiceHelper.delete((String)TCVAT_YBHZ_ZLB_SEHF, (QFilter[])and.toArray());
                DeleteServiceHelper.delete((String)TCVAT_YBHZ_ZLB_JGFPB, (QFilter[])and.toArray());
                DeleteServiceHelper.delete((String)TCVAT_ZLB_APPORTBILL, (QFilter[])and.toArray());
                DeleteServiceHelper.delete((String)TCVAT_ZLB_YZ_APPORTION, (QFilter[])and.toArray());
                DeleteServiceHelper.delete((String)TCVAT_ZLB_YZ_SHARE_RATIO, (QFilter[])and.toArray());
                DeleteServiceHelper.delete((String)TCVAT_YBHZ_YZ_TAXRATE_DET, (QFilter[])and.toArray());
                DeleteServiceHelper.delete((String)TCVAT_YBHZ_YZ_EJJGSEFT, (QFilter[])and.toArray());
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error(t);
                throw new RuntimeException(t);
            }
        }
    }

    public static boolean updateSefpZlb(Map<String, String> queryData, String orgid, String startdate, String enddate, String taxpayerType) {
        return YbhzZlbCalculateService.calculateSefpZlb(queryData, orgid, startdate, enddate, taxpayerType);
    }

    public static boolean updateSefpZlb(Map<String, String> queryData, String orgid, String startdate, String enddate, String column, Map<String, BigDecimal> values, String taxpayerType) {
        BigDecimal ynse;
        DynamicObject updateObj;
        if (EmptyCheckUtils.isEmpty(values)) {
            return false;
        }
        DynamicObject orgGroup = YbhzZlbCalculateService.getOrgGroup(orgid, startdate, enddate);
        String fpxssrfw = orgGroup.getString("fpxssrfw");
        BigDecimal fpxssrhj = BigDecimal.ZERO;
        BigDecimal oneTwo = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#1#ybxm", "tcvat_zlb_zzsybnsr_ybhz#1#jzjtxm", "tcvat_zlb_zzsybnsr_ybhz#2#ybxm", "tcvat_zlb_zzsybnsr_ybhz#2#jzjtxm"}));
        if (Objects.equals("1", fpxssrfw)) {
            fpxssrhj = oneTwo;
        } else if (Objects.equals("2", fpxssrfw)) {
            BigDecimal sum = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#26#ybxm", "tcvat_zlb_zzsybnsr_ybhz#26#jzjtxm"}));
            fpxssrhj = sum.compareTo(BigDecimal.ZERO) != 0 ? oneTwo : YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#2#ybxm", "tcvat_zlb_zzsybnsr_ybhz#2#jzjtxm"}));
        }
        BigDecimal ybtsehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#31#ybxm", "tcvat_zlb_zzsybnsr_ybhz#31#jzjtxm"}));
        BigDecimal jxsjdksehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#14#ybxm", "tcvat_zlb_zzsybnsr_ybhz#14#jzjtxm", "tcvat_zlb_zzsybnsr_ybhz#19#ybxm", "tcvat_zlb_zzsybnsr_ybhz#19#jzjtxm"}));
        BigDecimal jzsehj = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#24#ybxm", "tcvat_zlb_zzsybnsr_ybhz#24#jzjtxm"}));
        long org = Long.parseLong(orgid);
        Date start = DateUtils.stringToDate((String)startdate);
        Date end = DateUtils.stringToDate((String)enddate);
        QFilter and = new QFilter("org", "=", (Object)org).and("startdate", "=", (Object)start).and("enddate", "=", (Object)end);
        DynamicObject[] seqx_ascs1 = BusinessDataServiceHelper.load((String)TCVAT_YBHZ_ZLB_HTB, (String)"suborg,type,taxmethod,taxmethodtype,jzjt,amount,taxamount,dktaxamount,ynse,jzse,ybtse,org,startdate,enddate,seqx,id", (QFilter[])new QFilter[]{and}, (String)"seqx asc");
        List<DynamicObject> hbtbList = Arrays.stream(seqx_ascs1).collect(Collectors.toList());
        DynamicObject[] seqx_ascs = BusinessDataServiceHelper.load((String)TCVAT_YBHZ_ZLB_SEHF, (String)"suborg,jzjt,type,taxmethod,amount,taxamount,dktaxamount,ynse,jzse,ybtse,org,startdate,enddate,seqx,id", (QFilter[])new QFilter[]{and}, (String)"seqx asc");
        List<DynamicObject> ybtsehfList = Arrays.stream(seqx_ascs).collect(Collectors.toList());
        Map<String, DynamicObject> seqxMap = ybtsehfList.stream().collect(Collectors.toMap(a -> a.getString("seqx"), b -> b, (m, n) -> n));
        for (Map.Entry<String, BigDecimal> entry : values.entrySet()) {
            String seqx = entry.getKey();
            updateObj = seqxMap.get(seqx);
            if (updateObj == null) continue;
            updateObj.set(column, (Object)entry.getValue());
        }
        if (column.equals("dktaxamount")) {
            for (DynamicObject updateObj2 : ybtsehfList) {
                if (!Objects.equals(updateObj2.getString("taxmethod"), "1")) continue;
                ynse = updateObj2.getBigDecimal("taxamount").subtract(updateObj2.getBigDecimal("dktaxamount"));
                updateObj2.set("ynse", (Object)ynse);
            }
            BigDecimal ynsehj = ybtsehfList.stream().map(a -> a.getBigDecimal("ynse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal jzse11 = BigDecimal.ZERO;
            for (int i = 0; i < ybtsehfList.size(); ++i) {
                updateObj = (DynamicObject)ybtsehfList.get(i);
                BigDecimal ynse2 = updateObj.getBigDecimal("ynse");
                BigDecimal jzse = ynsehj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ynse2.multiply(jzsehj).divide(ynsehj, 2, 4);
                updateObj.set("jzse", (Object)jzse);
                updateObj.set("ybtse", (Object)ynse2.subtract(jzse));
                if (i == ybtsehfList.size() - 1) {
                    updateObj.set("jzse", (Object)jzsehj.subtract(jzse11));
                    continue;
                }
                jzse11 = jzse11.add(jzse);
            }
        } else if (column.equals("jzse")) {
            for (DynamicObject updateObj2 : ybtsehfList) {
                ynse = updateObj2.getBigDecimal("ynse");
                BigDecimal jzse = updateObj2.getBigDecimal("jzse");
                updateObj2.set("ybtse", (Object)ynse.subtract(jzse));
            }
        }
        BigDecimal ybhwsehj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "0")).map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ybhwjzjtsehj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "1")).map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ysfwsehj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "0")).map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ysfwjzjtsehj = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "1")).map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<DynamicObject> zjgfpList = YbhzZlbCalculateService.buildZjgfp(orgid, startdate, enddate, hbtbList, ybtsehfList, orgGroup, ybhwsehj, ybhwjzjtsehj, ysfwsehj, ysfwjzjtsehj, taxpayerType);
        DynamicObject hjObject = BusinessDataServiceHelper.loadSingle((String)TCVAT_YBHZ_ZLB_HJB, (String)"fpxssrhj,ybtsehj,jxsjdksehj,jzsehj,ybhwjlwsehj,ybhwjlwsehjjzjt,ysfwsehj,ysfwsehjjzjt,org,startdate,enddate,id", (QFilter[])and.toArray());
        if (hjObject == null) {
            return false;
        }
        hjObject.set("fpxssrhj", (Object)fpxssrhj);
        hjObject.set("ybtsehj", (Object)ybtsehj);
        hjObject.set("jxsjdksehj", (Object)jxsjdksehj);
        hjObject.set("jzsehj", (Object)jzsehj);
        hjObject.set("ybhwjlwsehj", (Object)ybhwsehj);
        hjObject.set("ybhwjlwsehjjzjt", (Object)ybhwjzjtsehj);
        hjObject.set("ysfwsehj", (Object)ysfwsehj);
        hjObject.set("ysfwsehjjzjt", (Object)ysfwjzjtsehj);
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            if (ybtsehfList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])ybtsehfList.toArray(new DynamicObject[ybtsehfList.size()]));
            }
            if (zjgfpList.size() > 0) {
                DeleteServiceHelper.delete((String)TCVAT_YBHZ_ZLB_JGFPB, (QFilter[])and.toArray());
                SaveServiceHelper.save((DynamicObject[])zjgfpList.toArray(new DynamicObject[zjgfpList.size()]));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hjObject});
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            try {
                h.markRollback();
                LOGGER.error(t);
                throw new RuntimeException(t);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static List<DynamicObject> buildZjgfp(String orgid, String startdate, String enddate, List<DynamicObject> hbtbList, List<DynamicObject> ybtsehfList, DynamicObject orgGroup, BigDecimal ybhwsehj, BigDecimal ybhwjzjtsehj, BigDecimal ysfwsehj, BigDecimal ysfwjzjtsehj, String taxpayerType) {
        Date start = DateUtils.stringToDate((String)startdate);
        Date end = DateUtils.stringToDate((String)enddate);
        String zfjgsefpfs = orgGroup.getString("zfjgsefpfs");
        boolean blwccl = "0".equals(orgGroup.getString("blwccl"));
        DynamicObjectCollection orgrow = orgGroup.getDynamicObjectCollection("orgrow");
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(orgrow.size());
        for (DynamicObject orgGroupObject : orgrow) {
            Object cuOrg = orgGroupObject.get("orgid");
            DynamicObject fpObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_YBHZ_ZLB_JGFPB));
            fpObj.set("org", (Object)Long.parseLong(orgid));
            fpObj.set("startdate", (Object)start);
            fpObj.set("enddate", (Object)end);
            fpObj.set("suborg", cuOrg);
            fpObj.set("suborgname", orgGroupObject.get("orgname"));
            fpObj.set("declaration", (Object)(Objects.equals(orgid, orgGroupObject.getString("orgid.id")) ? "2" : "3"));
            resultList.add(fpObj);
        }
        switch (zfjgsefpfs) {
            case "1": {
                YbhzZlbCalculateService.asrblfp(resultList, hbtbList, ybhwsehj, ybhwjzjtsehj, ysfwsehj, ysfwjzjtsehj, blwccl);
                break;
            }
            case "2": {
                YbhzZlbCalculateService.agdblfp(resultList, orgGroup, ybtsehfList, ybhwsehj, ybhwjzjtsehj, ysfwsehj, ysfwjzjtsehj);
                break;
            }
            case "3": {
                YbhzZlbCalculateService.azzzjqdse(resultList, ybtsehfList, ybhwsehj, ybhwjzjtsehj, ysfwsehj, ysfwjzjtsehj);
                break;
            }
            case "4": {
                BigDecimal zjggdbl = orgGroup.getBigDecimal("zjggdbl");
                YbhzZlbCalculateService.azjggdblfzjgxssrblfp(resultList, hbtbList, ybhwsehj, ybhwjzjtsehj, ysfwsehj, ysfwjzjtsehj, zjggdbl);
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u7ec4\u7ec7\u542f\u7528\u7684\u6c47\u603b\u65b9\u6848-\u603b\u5206\u673a\u6784\u7a0e\u989d\u5206\u914d\u65b9\u5f0f\uff0c\u672a\u914d\u7f6e\u3002", (String)"YbhzZlbCalculateService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
        resultList.sort(Comparator.comparing(a -> a.getString("declaration")));
        YbhzZlbCalculateService.setSeq(resultList, "seqx");
        return resultList;
    }

    private static void azzzjqdse(List<DynamicObject> resultList, List<DynamicObject> ybtsehfList, BigDecimal ybhwsehj, BigDecimal ybhwjzjtsehj, BigDecimal ysfwsehj, BigDecimal ysfwjzjtsehj) {
        List collect = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "0")).collect(Collectors.toList());
        BigDecimal xssr1 = collect.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List collect2 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "1")).collect(Collectors.toList());
        BigDecimal jzjtxssr1 = collect2.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List collect3 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "0")).collect(Collectors.toList());
        BigDecimal ysfwxssr1 = collect3.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List collect4 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "1")).collect(Collectors.toList());
        BigDecimal ysfwjzjtxssr1 = collect4.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, BigDecimal> hjMap = new HashMap<String, BigDecimal>(16);
        int size = resultList.size();
        for (int i = 0; i < resultList.size(); ++i) {
            DynamicObject fpObj = resultList.get(i);
            String cuOrg = fpObj.getString("suborg.id");
            Predicate<DynamicObject> predicate = a -> Objects.equals(a.getString("suborg"), cuOrg) || Objects.equals(a.getString("suborg.id"), cuOrg);
            List seCollect1 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "0")).filter(predicate).collect(Collectors.toList());
            BigDecimal fpse = seCollect1.stream().map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List secollect2 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "1")).filter(predicate).collect(Collectors.toList());
            BigDecimal jzjtfpse = secollect2.stream().map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List secollect3 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "0")).filter(predicate).collect(Collectors.toList());
            BigDecimal ysfwfpse = secollect3.stream().map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List secollect4 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "1")).filter(predicate).collect(Collectors.toList());
            BigDecimal ysfwjzjtfpse = secollect4.stream().map(a -> a.getBigDecimal("ybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal fpbl = ybhwsehj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : fpse.multiply(handred).divide(ybhwsehj, 8, 4);
            BigDecimal jzjtfpbl = ybhwjzjtsehj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : jzjtfpse.multiply(handred).divide(ybhwjzjtsehj, 8, 4);
            BigDecimal ysfwfpbl = ysfwsehj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwfpse.multiply(handred).divide(ysfwsehj, 8, 4);
            BigDecimal ysfwjzjtfpbl = ysfwjzjtsehj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwjzjtfpse.multiply(handred).divide(ysfwjzjtsehj, 8, 4);
            BigDecimal xxsr = xssr1.multiply(fpbl).divide(handred, 2, 4);
            fpObj.set("xssr", (Object)xxsr);
            BigDecimal jzjtxssr = jzjtxssr1.multiply(jzjtfpbl).divide(handred, 2, 4);
            fpObj.set("jzjtxssr", (Object)jzjtxssr);
            BigDecimal ysfwxssr = ysfwxssr1.multiply(ysfwfpbl).divide(handred, 2, 4);
            fpObj.set("ysfwxssr", (Object)ysfwxssr);
            BigDecimal ysfwjzjtxssr = ysfwjzjtxssr1.multiply(ysfwjzjtfpbl).divide(handred, 2, 4);
            fpObj.set("ysfwjzjtxssr", (Object)ysfwjzjtxssr);
            fpObj.set("fpbl", (Object)fpbl);
            fpObj.set("jzjtfpbl", (Object)jzjtfpbl);
            fpObj.set("ysfwfpbl", (Object)ysfwfpbl);
            fpObj.set("ysfwjzjtfpbl", (Object)ysfwjzjtfpbl);
            fpObj.set("fpse", (Object)fpse);
            fpObj.set("jzjtfpse", (Object)jzjtfpse);
            fpObj.set("ysfwfpse", (Object)ysfwfpse);
            fpObj.set("ysfwjzjtfpse", (Object)ysfwjzjtfpse);
            BigDecimal pbsehj = fpse.add(jzjtfpse).add(ysfwfpse).add(ysfwjzjtfpse);
            fpObj.set("pbsehj", (Object)pbsehj);
            if (i == size - 1) {
                HashMap<String, BigDecimal> srHjMap = new HashMap<String, BigDecimal>();
                srHjMap.put("xssr", xssr1);
                srHjMap.put("jzjtxssr", jzjtxssr1);
                srHjMap.put("ysfwxssr", ysfwxssr1);
                srHjMap.put("ysfwjzjtxssr", ysfwjzjtxssr1);
                YbhzZlbCalculateService.dealSrWc(hjMap, fpObj, srHjMap);
                YbhzZlbCalculateService.dealBlWc(hjMap, fpObj);
                continue;
            }
            YbhzZlbCalculateService.addHj(hjMap, fpObj);
        }
    }

    private static void dealBlWc(Map<String, BigDecimal> hjMap, DynamicObject fpObj) {
        for (String s : blColumn) {
            BigDecimal hjbl = hjMap.getOrDefault(s, BigDecimal.ZERO);
            if (hjbl.compareTo(BigDecimal.ZERO) == 0) {
                fpObj.set(s, (Object)BigDecimal.ZERO);
                continue;
            }
            fpObj.set(s, (Object)handred.subtract(hjbl));
        }
    }

    private static void dealSrWc(Map<String, BigDecimal> hjMap, DynamicObject fpObj, HashMap<String, BigDecimal> srHjMap) {
        for (String s : srColumn) {
            if (srHjMap.get(s) == null) continue;
            BigDecimal subtract = srHjMap.get(s).subtract(hjMap.getOrDefault(s, BigDecimal.ZERO));
            fpObj.set(s, (Object)subtract);
        }
    }

    private static void dealSeWc(Map<String, BigDecimal> hjMap, DynamicObject fpObj, HashMap<String, BigDecimal> seHjMap) {
        for (String s : seColumn) {
            if (seHjMap.get(s) == null) continue;
            BigDecimal subtract = seHjMap.get(s).subtract(hjMap.getOrDefault(s, BigDecimal.ZERO));
            fpObj.set(s, (Object)subtract);
        }
    }

    private static void addHj(Map<String, BigDecimal> hjMap, DynamicObject fpObj) {
        DataEntityPropertyCollection properties = fpObj.getDynamicObjectType().getProperties();
        for (String s : hjColumn) {
            if (!properties.containsKey((Object)s)) continue;
            hjMap.put(s, hjMap.getOrDefault(s, BigDecimal.ZERO).add(fpObj.getBigDecimal(s)));
        }
    }

    private static void agdblfp(List<DynamicObject> resultList, DynamicObject orgGroup, List<DynamicObject> ybtsehfList, BigDecimal ybhwsehj, BigDecimal ybhwjzjtsehj, BigDecimal ysfwsehj, BigDecimal ysfwjzjtsehj) {
        DynamicObjectCollection fpcsCollection = orgGroup.getDynamicObjectCollection("entryentity");
        Map<String, DynamicObject> orgMap = fpcsCollection.stream().collect(Collectors.toMap(a -> a.getString("org.id"), b -> b, (m, n) -> m));
        List collect = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "0")).collect(Collectors.toList());
        BigDecimal xssr1 = collect.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List collect2 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "1")).collect(Collectors.toList());
        BigDecimal jzjtxssr1 = collect2.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List collect3 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "0")).collect(Collectors.toList());
        BigDecimal ysfwxssr1 = collect3.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        List collect4 = ybtsehfList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "1")).collect(Collectors.toList());
        BigDecimal ysfwjzjtxssr1 = collect4.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<String, BigDecimal> hjMap = new HashMap<String, BigDecimal>(16);
        int size = resultList.size();
        for (int i = 0; i < resultList.size(); ++i) {
            DynamicObject fpObj = resultList.get(i);
            String cuOrg = fpObj.getString("suborg.id");
            DynamicObject orgrow = orgMap.get(cuOrg);
            BigDecimal fpbl = orgrow == null ? BigDecimal.ZERO : orgrow.getBigDecimal("ybxmhwbl").multiply(handred).setScale(8, 4);
            BigDecimal jzjtfpbl = orgrow == null ? BigDecimal.ZERO : orgrow.getBigDecimal("jzjthwbl").multiply(handred).setScale(8, 4);
            BigDecimal ysfwfpbl = orgrow == null ? BigDecimal.ZERO : orgrow.getBigDecimal("ybxmysbl").multiply(handred).setScale(8, 4);
            BigDecimal ysfwjzjtfpbl = orgrow == null ? BigDecimal.ZERO : orgrow.getBigDecimal("jzjtysbl").multiply(handred).setScale(8, 4);
            fpObj.set("xssr", (Object)xssr1.multiply(fpbl).divide(handred, 2, 4));
            fpObj.set("jzjtxssr", (Object)jzjtxssr1.multiply(jzjtfpbl).divide(handred, 2, 4));
            fpObj.set("ysfwxssr", (Object)ysfwxssr1.multiply(ysfwfpbl).divide(handred, 2, 4));
            fpObj.set("ysfwjzjtxssr", (Object)ysfwjzjtxssr1.multiply(ysfwjzjtfpbl).divide(handred, 2, 4));
            fpObj.set("fpbl", (Object)fpbl);
            fpObj.set("jzjtfpbl", (Object)jzjtfpbl);
            fpObj.set("ysfwfpbl", (Object)ysfwfpbl);
            fpObj.set("ysfwjzjtfpbl", (Object)ysfwjzjtfpbl);
            BigDecimal fpse = ybhwsehj.multiply(fpbl).divide(handred, 2, 4);
            fpObj.set("fpse", (Object)fpse);
            BigDecimal jzjtfpse = ybhwjzjtsehj.multiply(jzjtfpbl).divide(handred, 2, 4);
            fpObj.set("jzjtfpse", (Object)jzjtfpse);
            BigDecimal ysfwfpse = ysfwsehj.multiply(ysfwfpbl).divide(handred, 2, 4);
            fpObj.set("ysfwfpse", (Object)ysfwfpse);
            BigDecimal ysfwjzjtfpse = ysfwjzjtsehj.multiply(ysfwjzjtfpbl).divide(handred, 2, 4);
            fpObj.set("ysfwjzjtfpse", (Object)ysfwjzjtfpse);
            fpObj.set("pbsehj", (Object)fpse.add(jzjtfpse).add(ysfwfpse).add(ysfwjzjtfpse));
            if (i == size - 1) {
                HashMap<String, BigDecimal> seHjMap = new HashMap<String, BigDecimal>();
                seHjMap.put("fpse", ybhwsehj);
                seHjMap.put("jzjtfpse", ybhwjzjtsehj);
                seHjMap.put("ysfwfpse", ysfwsehj);
                seHjMap.put("ysfwjzjtfpse", ysfwjzjtsehj);
                YbhzZlbCalculateService.dealSeWc(hjMap, fpObj, seHjMap);
                HashMap<String, BigDecimal> srHjMap = new HashMap<String, BigDecimal>();
                srHjMap.put("xssr", xssr1);
                srHjMap.put("jzjtxssr", jzjtxssr1);
                srHjMap.put("ysfwxssr", ysfwxssr1);
                srHjMap.put("ysfwjzjtxssr", ysfwjzjtxssr1);
                YbhzZlbCalculateService.dealSrWc(hjMap, fpObj, srHjMap);
                continue;
            }
            YbhzZlbCalculateService.addHj(hjMap, fpObj);
        }
    }

    private static void asrblfp(List<DynamicObject> resultList, List<DynamicObject> hbtbList, BigDecimal ybhwsehj, BigDecimal ybhwjzjtsehj, BigDecimal ysfwsehj, BigDecimal ysfwjzjtsehj, boolean blwccl) {
        for (DynamicObject fpObj : resultList) {
            String cuOrg = fpObj.getString("suborg.id");
            Predicate<DynamicObject> predicate = a -> Objects.equals(a.getString("suborg"), cuOrg) || Objects.equals(a.getString("suborg.id"), cuOrg);
            List collect = hbtbList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "0")).filter(predicate).collect(Collectors.toList());
            BigDecimal xssr = collect.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List collect2 = hbtbList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "1")).filter(predicate).collect(Collectors.toList());
            BigDecimal jzjtxssr = collect2.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List collect3 = hbtbList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "0")).filter(predicate).collect(Collectors.toList());
            BigDecimal ysfwxssr = collect3.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List collect4 = hbtbList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "1")).filter(predicate).collect(Collectors.toList());
            BigDecimal ysfwjzjtxssr = collect4.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            fpObj.set("xssr", (Object)xssr);
            fpObj.set("jzjtxssr", (Object)jzjtxssr);
            fpObj.set("ysfwxssr", (Object)ysfwxssr);
            fpObj.set("ysfwjzjtxssr", (Object)ysfwjzjtxssr);
        }
        BigDecimal xssr = BigDecimal.ZERO;
        BigDecimal jzjtxssr = BigDecimal.ZERO;
        BigDecimal ysfwxssr = BigDecimal.ZERO;
        BigDecimal ysfwjzjtxssr = BigDecimal.ZERO;
        for (DynamicObject object : resultList) {
            xssr = xssr.add(object.getBigDecimal("xssr"));
            jzjtxssr = jzjtxssr.add(object.getBigDecimal("jzjtxssr"));
            ysfwxssr = ysfwxssr.add(object.getBigDecimal("ysfwxssr"));
            ysfwjzjtxssr = ysfwjzjtxssr.add(object.getBigDecimal("ysfwjzjtxssr"));
        }
        HashMap<String, BigDecimal> hjMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, DynamicObject> maxBlMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> maxSeMap = new HashMap<String, DynamicObject>(16);
        int size = resultList.size();
        for (int i = 0; i < resultList.size(); ++i) {
            DynamicObject fpObj = resultList.get(i);
            BigDecimal xssr1 = fpObj.getBigDecimal("xssr") == null ? BigDecimal.ZERO : fpObj.getBigDecimal("xssr");
            BigDecimal jzjtxssr1 = fpObj.getBigDecimal("jzjtxssr") == null ? BigDecimal.ZERO : fpObj.getBigDecimal("jzjtxssr");
            BigDecimal ysfwxssr1 = fpObj.getBigDecimal("ysfwxssr") == null ? BigDecimal.ZERO : fpObj.getBigDecimal("ysfwxssr");
            BigDecimal ysfwjzjtxssr1 = fpObj.getBigDecimal("ysfwjzjtxssr") == null ? BigDecimal.ZERO : fpObj.getBigDecimal("ysfwjzjtxssr");
            BigDecimal fpbl = xssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : xssr1.multiply(handred).divide(xssr, 8, 4);
            BigDecimal jzjtfpbl = jzjtxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : jzjtxssr1.multiply(handred).divide(jzjtxssr, 8, 4);
            BigDecimal ysfwfpbl = ysfwxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwxssr1.multiply(handred).divide(ysfwxssr, 8, 4);
            BigDecimal ysfwjzjtfpbl = ysfwjzjtxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwjzjtxssr1.multiply(handred).divide(ysfwjzjtxssr, 8, 4);
            BigDecimal fpse = ybhwsehj.multiply(fpbl).divide(handred, 2, 4);
            BigDecimal jzjtfpse = ybhwjzjtsehj.multiply(jzjtfpbl).divide(handred, 2, 4);
            BigDecimal ysfwfpse = ysfwsehj.multiply(ysfwfpbl).divide(handred, 2, 4);
            BigDecimal ysfwjzjtfpse = ysfwjzjtsehj.multiply(ysfwjzjtfpbl).divide(handred, 2, 4);
            BigDecimal pbsehj = fpse.add(jzjtfpse).add(ysfwfpse).add(ysfwjzjtfpse);
            fpObj.set("fpbl", (Object)fpbl);
            fpObj.set("fpse", (Object)fpse);
            fpObj.set("jzjtfpbl", (Object)jzjtfpbl);
            fpObj.set("jzjtfpse", (Object)jzjtfpse);
            fpObj.set("ysfwfpbl", (Object)ysfwfpbl);
            fpObj.set("ysfwfpse", (Object)ysfwfpse);
            fpObj.set("ysfwjzjtfpbl", (Object)ysfwjzjtfpbl);
            fpObj.set("ysfwjzjtfpse", (Object)ysfwjzjtfpse);
            fpObj.set("pbsehj", (Object)pbsehj);
            if (blwccl) {
                if (fpObj.getString("suborg.id").equals(fpObj.getString("org"))) {
                    YbhzZlbCalculateService.setZjgBlMap(maxBlMap, fpObj, blColumn);
                }
            } else {
                YbhzZlbCalculateService.setMaxMap(maxBlMap, fpObj, blColumn);
            }
            YbhzZlbCalculateService.setMaxMap(maxSeMap, fpObj, seColumn);
            if (i == size - 1) {
                HashMap<String, BigDecimal> seHjMap = new HashMap<String, BigDecimal>();
                seHjMap.put("fpse", ybhwsehj);
                seHjMap.put("jzjtfpse", ybhwjzjtsehj);
                seHjMap.put("ysfwfpse", ysfwsehj);
                seHjMap.put("ysfwjzjtfpse", ysfwjzjtsehj);
                YbhzZlbCalculateService.addHj(hjMap, fpObj);
                YbhzZlbCalculateService.dealSeWc(hjMap, fpObj, maxSeMap, seHjMap);
                YbhzZlbCalculateService.dealBlWc(hjMap, fpObj, maxBlMap, handred);
                continue;
            }
            YbhzZlbCalculateService.addHj(hjMap, fpObj);
        }
    }

    private static void setZjgBlMap(Map<String, DynamicObject> zjgBlMap, DynamicObject fpObj, String[] column) {
        for (String s : column) {
            zjgBlMap.put(s, fpObj);
        }
    }

    private static void setMaxMap(Map<String, DynamicObject> maxBlMap, DynamicObject fpObj, String[] column) {
        for (String s : column) {
            DynamicObject dynamicObject = maxBlMap.get(s);
            if (dynamicObject != null && fpObj.getBigDecimal(s).compareTo(dynamicObject.getBigDecimal(s)) <= 0) continue;
            maxBlMap.put(s, fpObj);
        }
    }

    private static void dealBlWc(Map<String, BigDecimal> hjMap, DynamicObject fpObj, Map<String, DynamicObject> maxBlMap, BigDecimal total) {
        for (String s : blColumn) {
            BigDecimal hjbl = hjMap.getOrDefault(s, BigDecimal.ZERO);
            if (hjbl.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal diff = total.subtract(hjbl);
            DynamicObject dynamicObject = maxBlMap.getOrDefault(s, fpObj);
            BigDecimal bl = dynamicObject.getBigDecimal(s);
            dynamicObject.set(s, (Object)bl.add(diff));
        }
    }

    private static void dealSeWc(Map<String, BigDecimal> hjMap, DynamicObject fpObj, Map<String, DynamicObject> maxSeMap, Map<String, BigDecimal> seHjMap) {
        for (String s : seColumn) {
            BigDecimal hjse = hjMap.getOrDefault(s, BigDecimal.ZERO);
            if (hjse.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal diff = seHjMap.get(s).subtract(hjse);
            DynamicObject dynamicObject = maxSeMap.getOrDefault(s, fpObj);
            BigDecimal se = dynamicObject.getBigDecimal(s);
            dynamicObject.set(s, (Object)se.add(diff));
        }
    }

    private static void azjggdblfzjgxssrblfp(List<DynamicObject> resultList, List<DynamicObject> hbtbList, BigDecimal ybhwsehj, BigDecimal ybhwjzjtsehj, BigDecimal ysfwsehj, BigDecimal ysfwjzjtsehj, BigDecimal zjggdbl) {
        for (DynamicObject fpObj : resultList) {
            String cuOrg = fpObj.getString("suborg.id");
            Predicate<DynamicObject> predicate = a -> Objects.equals(a.getString("suborg"), cuOrg) || Objects.equals(a.getString("suborg.id"), cuOrg);
            List collect = hbtbList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "0")).filter(predicate).collect(Collectors.toList());
            BigDecimal xssr = collect.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List collect2 = hbtbList.stream().filter(a -> Objects.equals(a.getString("type"), "1") && Objects.equals(a.getString("jzjt"), "1")).filter(predicate).collect(Collectors.toList());
            BigDecimal jzjtxssr = collect2.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List collect3 = hbtbList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "0")).filter(predicate).collect(Collectors.toList());
            BigDecimal ysfwxssr = collect3.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            List collect4 = hbtbList.stream().filter(a -> Objects.equals(a.getString("type"), "2") && Objects.equals(a.getString("jzjt"), "1")).filter(predicate).collect(Collectors.toList());
            BigDecimal ysfwjzjtxssr = collect4.stream().map(a -> a.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            fpObj.set("xssr", (Object)xssr);
            fpObj.set("jzjtxssr", (Object)jzjtxssr);
            fpObj.set("ysfwxssr", (Object)ysfwxssr);
            fpObj.set("ysfwjzjtxssr", (Object)ysfwjzjtxssr);
        }
        BigDecimal xssr = BigDecimal.ZERO;
        BigDecimal jzjtxssr = BigDecimal.ZERO;
        BigDecimal ysfwxssr = BigDecimal.ZERO;
        BigDecimal ysfwjzjtxssr = BigDecimal.ZERO;
        for (DynamicObject object : resultList) {
            xssr = xssr.add(object.getBigDecimal("xssr"));
            jzjtxssr = jzjtxssr.add(object.getBigDecimal("jzjtxssr"));
            ysfwxssr = ysfwxssr.add(object.getBigDecimal("ysfwxssr"));
            ysfwjzjtxssr = ysfwjzjtxssr.add(object.getBigDecimal("ysfwjzjtxssr"));
        }
        HashMap<String, BigDecimal> hjMap = new HashMap<String, BigDecimal>(16);
        int size = resultList.size();
        for (int i = size - 1; i >= 0; --i) {
            DynamicObject fpObj = resultList.get(i);
            if (zjggdbl == null) {
                zjggdbl = BigDecimal.ZERO;
            }
            BigDecimal xssr1 = fpObj.getBigDecimal("xssr");
            BigDecimal fpbl = BigDecimal.ZERO;
            if (xssr1 != null) {
                fpbl = xssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : xssr1.multiply(handred.subtract(zjggdbl)).divide(xssr, 8, 4);
            }
            BigDecimal jzjtxssr1 = fpObj.getBigDecimal("jzjtxssr");
            BigDecimal jzjtfpbl = BigDecimal.ZERO;
            if (jzjtxssr1 != null) {
                jzjtfpbl = jzjtxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : jzjtxssr1.multiply(handred.subtract(zjggdbl)).divide(jzjtxssr, 8, 4);
            }
            BigDecimal ysfwxssr1 = fpObj.getBigDecimal("ysfwxssr");
            BigDecimal ysfwfpbl = BigDecimal.ZERO;
            if (ysfwxssr1 != null) {
                ysfwfpbl = ysfwxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwxssr1.multiply(handred.subtract(zjggdbl)).divide(ysfwxssr, 8, 4);
            }
            BigDecimal ysfwjzjtxssr1 = fpObj.getBigDecimal("ysfwjzjtxssr");
            BigDecimal ysfwjzjtfpbl = BigDecimal.ZERO;
            if (ysfwjzjtxssr1 != null) {
                ysfwjzjtfpbl = ysfwjzjtxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwjzjtxssr1.multiply(handred.subtract(zjggdbl)).divide(ysfwjzjtxssr, 8, 4);
            }
            BigDecimal fpse = ybhwsehj.multiply(fpbl).divide(handred, 2, 4);
            BigDecimal jzjtfpse = ybhwjzjtsehj.multiply(jzjtfpbl).divide(handred, 2, 4);
            BigDecimal ysfwfpse = ysfwsehj.multiply(ysfwfpbl).divide(handred, 2, 4);
            BigDecimal ysfwjzjtfpse = ysfwjzjtsehj.multiply(ysfwjzjtfpbl).divide(handred, 2, 4);
            BigDecimal pbsehj = fpse.add(jzjtfpse).add(ysfwfpse).add(ysfwjzjtfpse);
            fpObj.set("fpbl", (Object)fpbl);
            fpObj.set("fpse", (Object)fpse);
            fpObj.set("jzjtfpbl", (Object)jzjtfpbl);
            fpObj.set("jzjtfpse", (Object)jzjtfpse);
            fpObj.set("ysfwfpbl", (Object)ysfwfpbl);
            fpObj.set("ysfwfpse", (Object)ysfwfpse);
            fpObj.set("ysfwjzjtfpbl", (Object)ysfwjzjtfpbl);
            fpObj.set("ysfwjzjtfpse", (Object)ysfwjzjtfpse);
            fpObj.set("pbsehj", (Object)pbsehj);
            if (i == 0) {
                HashMap<String, BigDecimal> seHjMap = new HashMap<String, BigDecimal>();
                seHjMap.put("fpse", ybhwsehj);
                seHjMap.put("jzjtfpse", ybhwjzjtsehj);
                seHjMap.put("ysfwfpse", ysfwsehj);
                seHjMap.put("ysfwjzjtfpse", ysfwjzjtsehj);
                YbhzZlbCalculateService.dealSeWc(hjMap, fpObj, seHjMap);
                YbhzZlbCalculateService.dealBlWc(hjMap, fpObj);
                continue;
            }
            YbhzZlbCalculateService.addHj(hjMap, fpObj);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, List<DynamicObject>> buildYbtsehf(String orgid, String startdate, String enddate, boolean isJyjs, String ybtsehffs, BigDecimal fpxssrhj, BigDecimal ybtsehj, BigDecimal jxsjdksehj, BigDecimal jzsehj, String taxpayerType) {
        Map<String, List<DynamicObject>> collect;
        long org = Long.parseLong(orgid);
        Date start = DateUtils.stringToDate((String)startdate);
        Date end = DateUtils.stringToDate((String)enddate);
        QFilter and = new QFilter("org", "=", (Object)org).and("startdate", "=", (Object)start).and("enddate", "=", (Object)end).and("taxpayertype", "=", (Object)taxpayerType);
        QFilter qFilter = new QFilter("taxmethodtype", "not in", (Object)Lists.newArrayList((Object[])new String[]{"3", "19", "20"}));
        String fields = "org,serialno,businesstype,description,invoiceamount,accountingamount,businessamount,taxamount,taxmethod,taxmethodtype,taxrate,jzjt,taxreductioncode,taxreductionname,taxreductiontype,taxreductionid,suborg,declaretype,enddate,startdate,ruleid,taxpayertype,invoicetaxamount,totaltaxamount,pricetaxamount,specialtaxamount,specialinvoiceamount,otherinvoiceamount,othertaxamount,nonetaxamount,levelname,initaccountingamount,id,businesstype.mergecode,suborg.name as suborgname";
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCVAT_HZ_ACCOUNT_SUMMARY, (String)fields, (QFilter[])new QFilter[]{and, qFilter});
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(4);
        if (query.size() == 0) {
            return resultMap;
        }
        List<Object> dynamicObjectList = new ArrayList(query.size());
        for (int i = 0; i < query.size(); ++i) {
            void var23_23;
            String taxmethod;
            DynamicObject object = (DynamicObject)query.get(i);
            String mergcode = object.getString("businesstype.mergecode");
            if (StringUtil.isEmpty((CharSequence)mergcode)) continue;
            if (mergcode.startsWith("2") || mergcode.startsWith("1")) {
                String string = "1";
            } else {
                if (!mergcode.startsWith("3") && !mergcode.startsWith("4") && !mergcode.startsWith("5")) continue;
                String string = "2";
            }
            String taxmethodtype = object.getString("taxmethodtype");
            if (Objects.equals(taxmethodtype, "2")) {
                taxmethod = "1";
            } else {
                if (!Objects.equals(taxmethodtype, "4") && !Objects.equals(taxmethodtype, "5")) continue;
                taxmethod = "2";
            }
            DynamicObject htObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_YBHZ_ZLB_HTB));
            htObject.set("suborg", object.get("suborg"));
            htObject.set("type", (Object)var23_23);
            htObject.set("taxmethod", (Object)taxmethod);
            htObject.set("taxmethodtype", (Object)taxmethodtype);
            htObject.set("jzjt", object.get("jzjt"));
            htObject.set("org", (Object)org);
            htObject.set("startdate", (Object)start);
            htObject.set("enddate", (Object)end);
            htObject.set("amount", (Object)object.getBigDecimal("taxamount"));
            if (Objects.equals(taxmethod, "2")) {
                htObject.set("taxamount", (Object)BigDecimal.ZERO);
                htObject.set("ynse", (Object)object.getBigDecimal("totaltaxamount"));
            } else {
                htObject.set("taxamount", (Object)object.getBigDecimal("totaltaxamount"));
            }
            htObject.set("seqx", (Object)i);
            dynamicObjectList.add(htObject);
        }
        if (isJyjs) {
            dynamicObjectList = dynamicObjectList.stream().filter(a -> Objects.equals(a.getString("taxmethod"), "2")).sorted(Comparator.comparing(a -> a.getString("suborg"), Comparator.reverseOrder())).collect(Collectors.toList());
        }
        resultMap.put("htb", dynamicObjectList);
        if (Objects.equals(ybtsehffs, "1")) {
            collect = dynamicObjectList.stream().collect(Collectors.groupingBy(a -> a.getString("type") + "-" + a.getString("taxmethod") + "-" + a.getString("jzjt")));
        } else {
            Function<DynamicObject, String> getkey = a -> a.getString("type") + "-" + a.getString("taxmethod") + "-" + a.getString("jzjt") + "-" + a.getString("suborg");
            collect = dynamicObjectList.stream().collect(Collectors.groupingBy(getkey));
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dynamicObjectList.size());
        for (Map.Entry entry : collect.entrySet()) {
            List values = (List)entry.getValue();
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal taxamount = BigDecimal.ZERO;
            Object ynse = BigDecimal.ZERO;
            for (DynamicObject value : values) {
                amount = amount.add(value.getBigDecimal("amount"));
                taxamount = taxamount.add(value.getBigDecimal("taxamount"));
                ynse = ((BigDecimal)ynse).add(value.getBigDecimal("ynse"));
            }
            DynamicObject object = (DynamicObject)values.get(0);
            DynamicObject sehfObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_YBHZ_ZLB_SEHF));
            sehfObject.set("type", object.get("type"));
            sehfObject.set("taxmethod", object.get("taxmethod"));
            sehfObject.set("jzjt", object.get("jzjt"));
            sehfObject.set("org", (Object)org);
            sehfObject.set("startdate", (Object)start);
            sehfObject.set("enddate", (Object)end);
            sehfObject.set("amount", (Object)amount);
            sehfObject.set("taxamount", (Object)taxamount);
            sehfObject.set("suborg", object.get("suborg"));
            if (Objects.equals(ybtsehffs, "1")) {
                sehfObject.set("suborg", (Object)Long.parseLong("0"));
            }
            sehfObject.set("ynse", ynse);
            list.add(sehfObject);
        }
        BigDecimal xxselhj = list.stream().map(a -> a.getBigDecimal("taxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        long l = list.stream().filter(a -> Objects.equals(a.getString("taxmethod"), "1")).count();
        BigDecimal jxdkse12 = BigDecimal.ZERO;
        int count = 0;
        for (DynamicObject object : list) {
            BigDecimal dktaxamount = BigDecimal.ZERO;
            if (Objects.equals(object.getString("taxmethod"), "1")) {
                BigDecimal taxamount = object.getBigDecimal("taxamount");
                dktaxamount = (long)count == l - 1L ? jxsjdksehj.subtract(jxdkse12).setScale(2, 4) : (xxselhj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : taxamount.multiply(jxsjdksehj).divide(xxselhj, 2, 4));
                object.set("ynse", (Object)taxamount.subtract(dktaxamount).setScale(2, 4));
                jxdkse12 = jxdkse12.add(dktaxamount);
                ++count;
            }
            object.set("dktaxamount", (Object)dktaxamount);
        }
        if (Objects.equals(ybtsehffs, "1")) {
            list.sort(Comparator.comparing(a -> a.getString("type") + a.getString("jzjt"), Comparator.reverseOrder()));
        } else {
            list.sort(Comparator.comparing(a -> Objects.equals(orgid, a.getString("suborg")) + a.getString("suborg"), Comparator.reverseOrder()));
        }
        BigDecimal ynsehj = list.stream().map(a -> a.getBigDecimal("ynse")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal jzse11 = BigDecimal.ZERO;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal jzse;
            DynamicObject object = (DynamicObject)list.get(i);
            object.set("seqx", (Object)i);
            BigDecimal ynse = object.getBigDecimal("ynse");
            if (i == size - 1) {
                jzse = jzsehj.subtract(jzse11).setScale(2, 4);
            } else {
                jzse = ynsehj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ynse.multiply(jzsehj).divide(ynsehj, 2, 4);
                jzse11 = jzse11.add(jzse);
            }
            object.set("jzse", (Object)jzse);
            object.set("ybtse", (Object)ynse.subtract(jzse).setScale(2, 4));
        }
        resultMap.put("sehfb", list);
        return resultMap;
    }

    private static void setSeq(List<DynamicObject> resultList, String seqColumn) {
        for (int i = 0; i < resultList.size(); ++i) {
            resultList.get(i).set(seqColumn, (Object)i);
        }
    }

    private static BigDecimal getSum(Map<String, String> queryData, ArrayList<String> newArrayList) {
        BigDecimal result = BigDecimal.ZERO;
        for (String s : newArrayList) {
            String o = queryData.get(s);
            if (!StringUtil.isNotEmpty((CharSequence)o)) continue;
            result = result.add(new BigDecimal(o));
        }
        return result;
    }

    private static DynamicObject getOrgGroup(String orgid, String startdate, String enddate) {
        Date start = DateUtils.stringToDate((String)startdate);
        Date end = DateUtils.stringToDate((String)enddate);
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        QFilter orgidFilter = new QFilter("orgrow.orgid", "=", (Object)Long.valueOf(orgid));
        QFilter declaration = new QFilter("orgrow.declaration", "=", (Object)"2");
        QFilter typeFilter = new QFilter("taxtype", "=", (Object)"zzs");
        QFilter startFilter = new QFilter("effectdate", "<=", (Object)start);
        QFilter endFilter = new QFilter("invaliddate", "is null", null).or(new QFilter("invaliddate", ">=", (Object)end));
        DynamicObject orgGroup = QueryServiceHelper.queryOne((String)TCTB_ORG_GROUP_LATEST, (String)"id", (QFilter[])new QFilter[]{declaration, statusFilter, orgidFilter, typeFilter, startFilter, endFilter});
        if (orgGroup != null) {
            return BusinessDataServiceHelper.loadSingle((Object)orgGroup.get("id"), (String)TCTB_ORG_GROUP_LATEST);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7533\u62a5\u7ec4\u7ec7\u672a\u67e5\u8be2\u5230\u53ef\u7528\u7684\u6c47\u603b\u65b9\u6848\u3002", (String)"YbhzZlbCalculateService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    public static void calculateYZTaxApportionZlb(Map<String, String> valueMap, String orgid, String startdate, String enddate, String taxPayerType) {
        Date skssqq = DateUtils.stringToDate((String)startdate);
        Date skssqz = DateUtils.stringToDate((String)enddate);
        BigDecimal row26 = YbhzZlbCalculateService.getSum(valueMap, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#26#ybxm", "tcvat_zlb_zzsybnsr_ybhz#26#jzjtxm"}));
        BigDecimal row1 = YbhzZlbCalculateService.getSum(valueMap, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#1#ybxm", "tcvat_zlb_zzsybnsr_ybhz#1#jzjtxm"}));
        BigDecimal ratio = row1.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row26.divide(row1, 6, 4);
        DynamicObject shareRatio = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_ZLB_YZ_SHARE_RATIO));
        shareRatio.set("org", (Object)Long.parseLong(orgid));
        shareRatio.set("startdate", (Object)skssqq);
        shareRatio.set("enddate", (Object)skssqz);
        shareRatio.set("ynse", (Object)row26);
        shareRatio.set("ysxse", (Object)row1);
        shareRatio.set("fpbl", (Object)ratio);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        QFilter SkssqFilter = new QFilter("startdate", "=", (Object)skssqq).and(new QFilter("enddate", "=", (Object)skssqz));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", (Object)taxPayerType);
        DynamicObjectCollection incomeCollection = QueryServiceHelper.query((String)TCVAT_HZ_ACCOUNT_SUMMARY, (String)"org,suborg,levelname,declaretype,startdate,enddate,taxamount,totaltaxamount,taxmethodtype", (QFilter[])new QFilter[]{orgFilter, SkssqFilter, taxpayertypeFilter}, (String)"declaretype desc, suborg");
        Map<String, DynamicObject> collect = incomeCollection.stream().collect(Collectors.groupingBy(i -> i.getString("suborg"), Collectors.reducing(new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_HZ_ACCOUNT_SUMMARY)), (m, n) -> {
            DynamicObject object = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_HZ_ACCOUNT_SUMMARY));
            object.set("org", n.get("org"));
            object.set("suborg", n.get("suborg"));
            object.set("levelname", n.get("levelname"));
            object.set("declaretype", n.get("declaretype"));
            object.set("startdate", n.get("startdate"));
            object.set("enddate", n.get("enddate"));
            object.set("taxamount", (Object)m.getBigDecimal("taxamount"));
            object.set("totaltaxamount", (Object)m.getBigDecimal("totaltaxamount"));
            if ("2".equals(n.getString("taxmethodtype"))) {
                object.set("taxamount", (Object)m.getBigDecimal("taxamount").add(n.getBigDecimal("taxamount")));
                object.set("totaltaxamount", (Object)m.getBigDecimal("totaltaxamount"));
            }
            if ("4".equals(n.getString("taxmethodtype")) || "5".equals(n.getString("taxmethodtype"))) {
                object.set("totaltaxamount", (Object)m.getBigDecimal("totaltaxamount").add(n.getBigDecimal("totaltaxamount")));
                object.set("taxamount", (Object)m.getBigDecimal("taxamount"));
            }
            return object;
        })));
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(collect.size());
        BigDecimal rate = row1.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row26.divide(row1, 6, RoundingMode.HALF_UP);
        for (DynamicObject obj : collect.values()) {
            DynamicObject apportionObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_ZLB_YZ_APPORTION));
            apportionObject.set("suborg", (Object)obj.getLong("suborg"));
            apportionObject.set("org", obj.get("org"));
            apportionObject.set("levelname", obj.get("levelname"));
            apportionObject.set("declaretype", obj.get("declaretype"));
            apportionObject.set("startdate", obj.get("startdate"));
            apportionObject.set("enddate", obj.get("enddate"));
            BigDecimal taxamount = obj.getBigDecimal("taxamount");
            apportionObject.set("normaltaxsale", (Object)taxamount);
            BigDecimal normaltaxamount = taxamount.multiply(rate).setScale(2, RoundingMode.HALF_UP);
            if (Objects.nonNull(obj.get("levelname")) && "3".equals(obj.get("levelname"))) {
                apportionObject.set("normaltaxamount", (Object)normaltaxamount);
            }
            apportionObject.set("simpletaxamount", (Object)obj.getBigDecimal("totaltaxamount"));
            apportionObject.set("totaltaxamount", (Object)normaltaxamount.add(obj.getBigDecimal("totaltaxamount")));
            result.add(apportionObject);
        }
        YbhzZlbCalculateService.dealFzjgfpse(orgid, startdate, enddate, result, rate, row26);
        try (TXHandle h = TX.requiresNew();){
            try {
                QFilter filter = new QFilter("org", "=", (Object)Long.parseLong(orgid)).and("startdate", "=", (Object)skssqq).and("enddate", "=", (Object)skssqz);
                DeleteServiceHelper.delete((String)TCVAT_ZLB_YZ_SHARE_RATIO, (QFilter[])filter.toArray());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{shareRatio});
                DeleteServiceHelper.delete((String)TCVAT_ZLB_YZ_APPORTION, (QFilter[])filter.toArray());
                SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[result.size()]));
            }
            catch (Exception t) {
                h.markRollback();
                LOGGER.error((Throwable)t);
                throw new RuntimeException(t);
            }
        }
    }

    private static List<DynamicObject> dealFzjgfpse(String orgid, String startdate, String enddate, List<DynamicObject> result, BigDecimal rate, BigDecimal row26) {
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, Set> orgTreeMap = new HashMap<Long, Set>(16);
        DynamicObject orgGroup = YbhzZlbCalculateService.getOrgGroup(orgid, startdate, enddate);
        DynamicObjectCollection orgrow = orgGroup.getDynamicObjectCollection("orgrow");
        Set twoLevel = result.stream().filter(o -> "2".equals(o.getString("levelname"))).map(p -> p.getLong("suborg")).collect(Collectors.toSet());
        for (Long subid : twoLevel) {
            for (DynamicObject object : orgrow) {
                if (subid.longValue() != object.getLong("parentid.id")) continue;
                if (orgTreeMap.containsKey(subid)) {
                    Set longSet = (Set)orgTreeMap.get(subid);
                    longSet.add(object.getLong("orgid.id"));
                    orgTreeMap.put(subid, longSet);
                    continue;
                }
                orgTreeMap.put(subid, Sets.newHashSet((Object[])new Long[]{object.getLong("orgid.id")}));
            }
            if (orgTreeMap.containsKey(subid)) continue;
            orgTreeMap.put(subid, new HashSet());
        }
        BigDecimal twofpsesum = BigDecimal.ZERO;
        BigDecimal threefpsesum = BigDecimal.ZERO;
        for (Map.Entry one : orgTreeMap.entrySet()) {
            BigDecimal sumxse = BigDecimal.ZERO;
            BigDecimal threefpse = BigDecimal.ZERO;
            Long keyid = (Long)one.getKey();
            Set threekeyids = (Set)one.getValue();
            for (DynamicObject object : result) {
                if (keyid.longValue() == object.getLong("suborg")) {
                    sumxse = BigDecimalUtil.addObject((Object)sumxse, (Object)object.get("normaltaxsale"));
                    continue;
                }
                if (!threekeyids.contains(object.getLong("suborg"))) continue;
                sumxse = BigDecimalUtil.addObject((Object)sumxse, (Object)object.get("normaltaxsale"));
                threefpse = BigDecimalUtil.addObject((Object)threefpse, (Object)object.get("normaltaxamount"));
            }
            BigDecimal twofpse = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.multiplyObject((Object)rate, (Object)sumxse, (int)6), (Object)threefpse, (int)2);
            twofpsesum = BigDecimalUtil.addObject((Object)twofpsesum, (Object)twofpse);
            threefpsesum = BigDecimalUtil.addObject((Object)threefpsesum, (Object)threefpse);
            resultMap.put(keyid, twofpse);
        }
        BigDecimal onefpsesum = BigDecimalUtil.subtractObject((Object)row26, (Object)BigDecimalUtil.addObject((Object)twofpsesum, (Object)threefpsesum), (int)2);
        result.forEach(o -> {
            if ("1".equals(o.getString("levelname"))) {
                o.set("normaltaxamount", (Object)onefpsesum);
            } else if (resultMap.containsKey(o.getLong("suborg"))) {
                o.set("normaltaxamount", resultMap.get(o.getLong("suborg")));
            }
        });
        return result;
    }

    public static void calculateYZEjjgSeftZlb(Map<String, String> queryData, String draftId, String draftPurpose, String orgid, String startdate, String enddate, String taxPayerType) {
        if (queryData == null || StringUtil.isAnyBlank((CharSequence[])new CharSequence[]{draftId, draftPurpose, orgid, startdate, enddate, taxPayerType})) {
            return;
        }
        BigDecimal row31 = YbhzZlbCalculateService.getSum(queryData, Lists.newArrayList((Object[])new String[]{"tcvat_zlb_zzsybnsr_ybhz#31#ybxm", "tcvat_zlb_zzsybnsr_ybhz#31#jzjtxm"}));
        DynamicObject orgGroup = YbhzZlbCalculateService.getOrgGroup(orgid, startdate, enddate);
        Date start = DateUtils.stringToDate((String)startdate);
        Date end = DateUtils.stringToDate((String)enddate);
        DynamicObjectCollection orgrow = orgGroup.getDynamicObjectCollection("orgrow");
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>();
        HashMap<String, DynamicObject> subMap = new HashMap<String, DynamicObject>();
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(orgrow.size());
        YbhzZlbCalculateService.initData(orgrow, draftId, orgid, start, end, resultMap, subMap, resultList);
        YbhzZlbCalculateService.setXssr(subMap, orgid, start, end, taxPayerType);
        for (Map.Entry entry : resultMap.entrySet()) {
            List values = (List)entry.getValue();
            List suborgs = values.stream().map(v -> v.getLong("suborg")).collect(Collectors.toList());
            QFilter filter = new QFilter("suborg", "in", suborgs).and(new QFilter("startdate", "=", (Object)start)).and(new QFilter("enddate", "=", (Object)end));
            DynamicObjectCollection list = QueryServiceHelper.query((String)TCVAT_ZLB_YZ_APPORTION, (String)"suborg,levelname,declaretype,normaltaxsale,normaltaxamount,simpletaxamount,totaltaxamount", (QFilter[])new QFilter[]{filter}, (String)"levelname,suborg");
            BigDecimal normaltaxsaleHj = BigDecimal.ZERO;
            BigDecimal normaltaxamountHj = BigDecimal.ZERO;
            HashMap<String, BigDecimal> normalTaxAmountMap = new HashMap<String, BigDecimal>(list.size());
            for (DynamicObject dyo : list) {
                normaltaxsaleHj = normaltaxsaleHj.add(dyo.getBigDecimal("normaltaxsale"));
                BigDecimal normaltaxamount = dyo.getBigDecimal("normaltaxamount");
                normalTaxAmountMap.put(dyo.getString("suborg"), normaltaxamount);
                normaltaxamountHj = normaltaxamountHj.add(normaltaxamount);
            }
            BigDecimal xssr = BigDecimal.ZERO;
            BigDecimal jzjtxssr = BigDecimal.ZERO;
            BigDecimal ysfwxssr = BigDecimal.ZERO;
            BigDecimal ysfwjzjtxssr = BigDecimal.ZERO;
            for (DynamicObject object : values) {
                xssr = xssr.add(object.getBigDecimal("xssr"));
                jzjtxssr = jzjtxssr.add(object.getBigDecimal("jzjtxssr"));
                ysfwxssr = ysfwxssr.add(object.getBigDecimal("ysfwxssr"));
                ysfwjzjtxssr = ysfwjzjtxssr.add(object.getBigDecimal("ysfwjzjtxssr"));
            }
            HashMap<String, BigDecimal> hjMap = new HashMap<String, BigDecimal>(16);
            HashMap<String, DynamicObject> maxBlMap = new HashMap<String, DynamicObject>(16);
            for (int i = 0; i < values.size(); ++i) {
                DynamicObject value = (DynamicObject)values.get(i);
                BigDecimal xssr1 = value.getBigDecimal("xssr") == null ? BigDecimal.ZERO : value.getBigDecimal("xssr");
                BigDecimal jzjtxssr1 = value.getBigDecimal("jzjtxssr") == null ? BigDecimal.ZERO : value.getBigDecimal("jzjtxssr");
                BigDecimal ysfwxssr1 = value.getBigDecimal("ysfwxssr") == null ? BigDecimal.ZERO : value.getBigDecimal("ysfwxssr");
                BigDecimal ysfwjzjtxssr1 = value.getBigDecimal("ysfwjzjtxssr") == null ? BigDecimal.ZERO : value.getBigDecimal("ysfwjzjtxssr");
                BigDecimal fpbl = xssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : xssr1.divide(xssr, 10, 4);
                BigDecimal jzjtfpbl = jzjtxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : jzjtxssr1.divide(jzjtxssr, 10, 4);
                BigDecimal ysfwfpbl = ysfwxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwxssr1.divide(ysfwxssr, 10, 4);
                BigDecimal ysfwjzjtfpbl = ysfwjzjtxssr.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwjzjtxssr1.divide(ysfwjzjtxssr, 10, 4);
                value.set("fpbl", (Object)fpbl);
                value.set("jzjtfpbl", (Object)jzjtfpbl);
                value.set("ysfwfpbl", (Object)ysfwfpbl);
                value.set("ysfwjzjtfpbl", (Object)ysfwjzjtfpbl);
                if (BigDecimal.ZERO.compareTo(row31) >= 0) {
                    value.set("fpse", (Object)BigDecimal.ZERO);
                    value.set("jzjtfpse", (Object)BigDecimal.ZERO);
                    value.set("ysfwfpse", (Object)BigDecimal.ZERO);
                    value.set("ysfwjzjtfpse", (Object)BigDecimal.ZERO);
                } else {
                    value.set("fpse", (Object)(normaltaxsaleHj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : xssr1.multiply(normaltaxamountHj).divide(normaltaxsaleHj, 2, 4)));
                    value.set("jzjtfpse", (Object)(normaltaxsaleHj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : jzjtxssr1.multiply(normaltaxamountHj).divide(normaltaxsaleHj, 2, 4)));
                    value.set("ysfwfpse", (Object)(normaltaxsaleHj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwxssr1.multiply(normaltaxamountHj).divide(normaltaxsaleHj, 2, 4)));
                    value.set("ysfwjzjtfpse", (Object)(normaltaxsaleHj.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ysfwjzjtxssr1.multiply(normaltaxamountHj).divide(normaltaxsaleHj, 2, 4)));
                }
                YbhzZlbCalculateService.setMaxMap(maxBlMap, value, blColumn);
                YbhzZlbCalculateService.addHj(hjMap, value);
                YbhzZlbCalculateService.dealYZEjjgSeftSeWc(value, normalTaxAmountMap.getOrDefault(value.getString("suborg"), BigDecimal.ZERO));
                if (i != values.size() - 1) continue;
                YbhzZlbCalculateService.dealBlWc(hjMap, value, maxBlMap, BigDecimal.ONE);
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                QFilter and = new QFilter("org", "=", (Object)Long.parseLong(orgid)).and("startdate", "=", (Object)DateUtils.stringToDate((String)startdate)).and("enddate", "=", (Object)DateUtils.stringToDate((String)enddate));
                DeleteServiceHelper.delete((String)TCVAT_YBHZ_YZ_EJJGSEFT, (QFilter[])and.toArray());
                SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[0]));
            }
            catch (Exception t) {
                h.markRollback();
                LOGGER.error((Throwable)t);
                throw new RuntimeException(t);
            }
        }
    }

    private static void dealYZEjjgSeftSeWc(DynamicObject value, BigDecimal normaltaxamount) {
        BigDecimal diff = BigDecimal.ZERO;
        String maxSeField = "";
        BigDecimal hjse = BigDecimal.ZERO;
        BigDecimal maxSe = BigDecimal.ZERO;
        for (String s : seColumn) {
            BigDecimal se = value.getBigDecimal(s);
            hjse = hjse.add(se);
            if (se.compareTo(maxSe) <= 0) continue;
            maxSe = se;
            maxSeField = s;
        }
        if (hjse.compareTo(BigDecimal.ZERO) != 0) {
            diff = diff.add(normaltaxamount.subtract(hjse));
        }
        if (StringUtils.isNotBlank((CharSequence)maxSeField)) {
            value.set(maxSeField, (Object)value.getBigDecimal(maxSeField).add(diff));
        }
    }

    private static void initData(DynamicObjectCollection orgrow, String draftId, String orgid, Date start, Date end, Map<String, List<DynamicObject>> resultMap, Map<String, DynamicObject> subMap, List<DynamicObject> resultList) {
        for (DynamicObject orgGroupObject : orgrow) {
            String levelname = orgGroupObject.getString("levelname");
            if ("1".equals(levelname)) continue;
            String cuOrg = orgGroupObject.getString("orgid.id");
            DynamicObject fpObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCVAT_YBHZ_YZ_EJJGSEFT));
            fpObj.set("masterid", (Object)Long.parseLong(draftId));
            fpObj.set("org", (Object)Long.parseLong(orgid));
            fpObj.set("startdate", (Object)start);
            fpObj.set("enddate", (Object)end);
            fpObj.set("suborg", (Object)cuOrg);
            String parentId = orgGroupObject.getString("parentid.id");
            fpObj.set("levelname", orgGroupObject.get("levelname"));
            resultList.add(fpObj);
            if ("2".equals(levelname)) {
                parentId = cuOrg;
            }
            fpObj.set("parentid", (Object)parentId);
            subMap.put(cuOrg, fpObj);
            List list = resultMap.computeIfAbsent(parentId, s -> new ArrayList(orgrow.size()));
            list.add(fpObj);
        }
    }

    private static void setXssr(Map<String, DynamicObject> subMap, String orgid, Date start, Date end, String taxPayerType) {
        String fields = "org,serialno,businesstype,description,invoiceamount,accountingamount,businessamount,taxamount,taxmethod,taxmethodtype,taxrate,jzjt,taxreductioncode,taxreductionname,taxreductiontype,taxreductionid,suborg,declaretype,enddate,startdate,ruleid,taxpayertype,invoicetaxamount,totaltaxamount,pricetaxamount,specialtaxamount,specialinvoiceamount,otherinvoiceamount,othertaxamount,nonetaxamount,levelname,initaccountingamount,id,businesstype.mergecode,suborg.name as suborgname";
        QFilter and = new QFilter("org", "=", (Object)Long.parseLong(orgid)).and("startdate", "=", (Object)start).and("enddate", "=", (Object)end).and("taxpayertype", "=", (Object)taxPayerType);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCVAT_HZ_ACCOUNT_SUMMARY, (String)fields, (QFilter[])new QFilter[]{and});
        if (query.isEmpty()) {
            return;
        }
        for (DynamicObject object : query) {
            String suborgId;
            DynamicObject htObject;
            String mergcode = object.getString("businesstype.mergecode");
            String type = "";
            if (StringUtil.isEmpty((CharSequence)mergcode)) continue;
            if (mergcode.startsWith("2") || mergcode.startsWith("1")) {
                type = "1";
            } else if (mergcode.startsWith("3") || mergcode.startsWith("4")) {
                type = "2";
            }
            if ((htObject = subMap.get(suborgId = object.getString("suborg"))) == null) continue;
            String jzjt = object.getString("jzjt");
            if ("1".equals(type) && "0".equals(jzjt)) {
                htObject.set("xssr", (Object)htObject.getBigDecimal("xssr").add(object.getBigDecimal("taxamount")));
                continue;
            }
            if ("1".equals(type) && "1".equals(jzjt)) {
                htObject.set("jzjtxssr", (Object)htObject.getBigDecimal("jzjtxssr").add(object.getBigDecimal("taxamount")));
                continue;
            }
            if ("2".equals(type) && "0".equals(jzjt)) {
                htObject.set("ysfwxssr", (Object)htObject.getBigDecimal("ysfwxssr").add(object.getBigDecimal("taxamount")));
                continue;
            }
            if (!"2".equals(type) || !"1".equals(jzjt)) continue;
            htObject.set("ysfwjzjtxssr", (Object)htObject.getBigDecimal("ysfwjzjtxssr").add(object.getBigDecimal("taxamount")));
        }
    }
}

