/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.zlb;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.TsdStatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.common.util.UUID;

public class ZlbService {
    private static final String PAGE_ACCOUNTING_DETAIL = "tcvat_accdetail_income";
    public static final String ENTITY = "tctb_draft_main";

    public static BigDecimal calcTotalAmount(Map<String, String> dataResult, String ... keys) {
        BigDecimal result = BigDecimal.ZERO;
        for (String key : keys) {
            BigDecimal decimal = BigDecimalUtil.toBigDecimal((Object)dataResult.get(key));
            result = BigDecimalUtil.addObject((Object)result, (Object)decimal);
        }
        return result;
    }

    public static BigDecimal calcYbnsrSjjtYnseSum(Map<String, String> dataResult) {
        return ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_ybnsr#34#ybxm", "tcvat_zlb_ybnsr#34#jzjtxm", "tcvat_zlb_ybnsr#42#ybxm", "tcvat_zlb_ybnsr#50#ybxm", "tcvat_zlb_ybnsr#58#ybxm");
    }

    public static BigDecimal calcHzSjjtYnseSum(Map<String, String> dataResult) {
        return ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#34#ybxm", "tcvat_zlb_zzsybnsr_ybhz#34#jzjtxm", "tcvat_zlb_zzsybnsr_ybhz#45#ybxm", "tcvat_zlb_zzsybnsr_ybhz#53#ybxm", "tcvat_zlb_zzsybnsr_ybhz#61#ybxm");
    }

    public static BigDecimal calcHzjsYnseSum(Map<String, String> dataResult) {
        return ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_zzsybnsr_ybhz#31#ybxm", "tcvat_zlb_zzsybnsr_ybhz#31#jzjtxm");
    }

    public static BigDecimal calcXgmSjjtYnseSum(Map<String, String> dataResult) {
        return ZlbService.calcTotalAmount(dataResult, "tcvat_zlb_xgmnsr#10#hj", "tcvat_zlb_xgmnsr#17#hj", "tcvat_zlb_xgmnsr#24#hj", "tcvat_zlb_xgmnsr#31#hj");
    }

    public static BigDecimal queryHzZlbAmount(String orgId, String skssqq, String skssqz, String templateType, String ewblxh, String amountName) {
        DynamicObject zlb = YbnsrService.queryYbnsr((String)orgId, (String)templateType, (String)skssqq, (String)skssqz, (int)0, null);
        if (zlb != null) {
            String zlbId = zlb.getString("id");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tcvat_zlb_zzsybnsr_ybhz", (String)amountName, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)zlbId), new QFilter("ewblxh", "=", (Object)ewblxh)});
            return query.stream().map(o -> o.getBigDecimal(amountName)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }

    public static void updateJtynse(String draftpurpose, String templatetype, BigDecimal jtynsesum, String orgid, String skssqq, String skssqz) {
        DynamicObject draftObject = StatusUtils.queryOne((String)templatetype, (String)orgid, (String)skssqq, (String)skssqz, (String)draftpurpose);
        if ("sjjt".equals(draftpurpose) && draftObject != null) {
            DynamicObject jtDraftObj = TsdStatusUtils.loadSingle((Object)draftObject.get("id"));
            jtDraftObj.set("jtynsesum", (Object)jtynsesum);
            DeclareServiceHelper.setAccrualPlanId((String)orgid, (String)skssqq, (String)skssqz, (String)draftpurpose, (DynamicObject)jtDraftObj);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jtDraftObj});
        }
        if ("nssb".equals(draftpurpose) && draftObject != null) {
            String id = draftObject.getString("id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY);
            DeclareServiceHelper.setAccrualPlanId((String)orgid, (String)skssqq, (String)skssqz, (String)draftpurpose, (DynamicObject)object);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        }
    }

    public static Map<String, BigDecimal> fetchMdtsYtse(String[] mdType, EngineModel engineModel) throws Exception {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(16);
        if (mdType == null || mdType.length == 0) {
            return result;
        }
        String serialno = UUID.randomUUID();
        String orgId = engineModel.getOrgId();
        Object hzsbOrgList = engineModel.getCustom().get("hzsbOrgList");
        String orglistStr = hzsbOrgList != null ? hzsbOrgList.toString() : (engineModel.getCustom().get("orglist") != null ? engineModel.getCustom().get("orglist").toString() : "[" + orgId + "]");
        List orglist = JSON.parseArray((String)orglistStr, Long.class);
        orglist = orglist.stream().distinct().collect(Collectors.toList());
        String startDate = engineModel.getStartDate();
        String endDate = engineModel.getEndDate();
        List<String> periodList = PeriodService.getPeriodList(DateUtils.stringToDate2((String)startDate), DateUtils.stringToDate2((String)endDate));
        for (Long org : orglist) {
            String rulePurpose = "nssb";
            if (StringUtils.isNotBlank(engineModel.getCustom().get("draftpurpose"))) {
                rulePurpose = (String)engineModel.getCustom().get("draftpurpose");
            }
            List mdtsRules = (List)RuleUtils.getSharingAndOrgRules((Long)org, (RuleTypeEnum)RuleTypeEnum.MDTS, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.MDTS);
            for (String period : periodList) {
                for (DynamicObject rule : mdtsRules) {
                    String type = rule.getString("mdtype");
                    if (!ZlbService.isExist(mdType, type)) continue;
                    engineModel.setOrgId(org.toString());
                    NewRuleSettingTask mdtsTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, engineModel, rule.getDynamicObjectCollection("entryentity"), serialno, PAGE_ACCOUNTING_DETAIL, "", "", "amount", period);
                    List mdtsFuture = ThreadPoolsService.getInstance().submitReturnFuture((Task)mdtsTask);
                    List mdtsList = EngineTask.getFutureList((List)mdtsFuture);
                    BigDecimal rs = result.get(type) == null ? BigDecimal.ZERO : (BigDecimal)result.get(type);
                    rs = rs.add(IncomeUtils.getInvoiceTotalAmount(mdtsList, "amount"));
                    result.put(type, rs);
                }
            }
        }
        return result;
    }

    private static boolean isExist(String[] mdType, String str) {
        if (mdType == null || mdType.length == 0) {
            return false;
        }
        for (String s : mdType) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }
}

