/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.enums;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.common.constant.DraftConstant;

public enum DraftEngineEnum {
    YBNSR("ybnsr"){

        @Override
        public void deleteIncome(TcvatEngineModel model) {
            String orgId = model.getOrgId();
            DraftMetaDataInfo income = model.getDraftMetaDataDTO().getIncome();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            QFilter periodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            DynamicObjectCollection incomeCollect = QueryServiceHelper.query((String)income.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
            if (incomeCollect.size() == 0) {
                return;
            }
            List idList = incomeCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)income.getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = incomeCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            QFilter serialnoFilter = new QFilter("serialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)income.getDetailMetaDataNameMap().get("tcvat_accdetail_income"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            DeleteServiceHelper.delete((String)income.getDetailMetaDataNameMap().get("tcvat_income_invoice"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            DeleteServiceHelper.delete((String)income.getDetailMetaDataNameMap().get("tcvat_taxdeduce_sum"), (QFilter[])new QFilter[]{serialnoFilter});
        }

        @Override
        public void deleteDiff(TcvatEngineModel model) {
            QFilter taxaccountserialnoFilter;
            List serialnoList;
            String orgId = model.getOrgId();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            QFilter taxPeriodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            DynamicObjectCollection diffCollect = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getDiff().getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
            DynamicObjectCollection diffDeductCollect = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getDiffDeduct().getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
            if (!CollectionUtils.isEmpty((Collection)diffCollect)) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)model.getDraftMetaDataDTO().getDiff().getAccountMetaDataName()), (Object[])diffCollect.stream().map(i -> i.getString("id")).toArray());
                serialnoList = diffCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
                taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
                DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getDiff().getDetailMetaDataNameMap().get("tcvat_accdetail_diff"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            }
            if (!CollectionUtils.isEmpty((Collection)diffDeductCollect)) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)model.getDraftMetaDataDTO().getDiffDeduct().getAccountMetaDataName()), (Object[])diffDeductCollect.stream().map(i -> i.getString("id")).toArray());
                serialnoList = diffDeductCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
                taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
                DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getDiffDeduct().getDetailMetaDataNameMap().get("tcvat_accdetail_diff"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            }
        }

        @Override
        public void deleteRollOut(TcvatEngineModel model) {
            DraftMetaDataInfo rolloutMetaData = model.getDraftMetaDataDTO().getRollOut();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter periodFilter = new QFilter("taxperiod", ">=", (Object)PeriodService.getTaxPeriod(model.getStartDate())).and(new QFilter("taxperiod", "<=", (Object)PeriodService.getTaxPeriod(model.getEndDate())));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)rolloutMetaData.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
            if (draftCollect.size() == 0) {
                return;
            }
            List idList = draftCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)rolloutMetaData.getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = draftCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)rolloutMetaData.getDetailMetaDataNameMap().get("tcvat_accdetail_rollout"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
        }

        @Override
        public void deleteJzjtJxse(TcvatEngineModel model) {
            DraftMetaDataInfo draftMetaDataInfo = model.getDraftMetaDataDTO().getJzjtjxse();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter periodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)draftMetaDataInfo.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
            if (draftCollect.size() == 0) {
                return;
            }
            List idList = draftCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)draftMetaDataInfo.getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = draftCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)draftMetaDataInfo.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_JZJT_JXSE_ACCDETAIL), (QFilter[])new QFilter[]{orgFilter, taxaccountserialnoFilter});
        }

        @Override
        public void deleteDeduction(TcvatEngineModel model) {
            DraftMetaDataInfo deductionMetaData = model.getDraftMetaDataDTO().getDeduction();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter periodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)deductionMetaData.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
            if (draftCollect.size() == 0) {
                return;
            }
            List idList = draftCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)deductionMetaData.getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = draftCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)deductionMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCTION_DETAIL), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            DeleteServiceHelper.delete((String)deductionMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCTION_DETAIL_BILL), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            DeleteServiceHelper.delete((String)deductionMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCTION_CUSTOM_DETAIL), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            DeleteServiceHelper.delete((String)deductionMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCT_INPUT_AUTH_DETAIL), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
        }

        @Override
        public void deleteTaxReduce(TcvatEngineModel model) {
            DraftMetaDataInfo taxReductionMetaData = model.getDraftMetaDataDTO().getTaxReduction();
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter periodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)taxReductionMetaData.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter, payerTypeFilter});
            if (draftCollect.size() == 0) {
                return;
            }
            List idList = draftCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)taxReductionMetaData.getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = draftCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)taxReductionMetaData.getDetailMetaDataNameMap().get("tcvat_taxreduce_detail"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            QFilter serialnoFilter = new QFilter("serialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)taxReductionMetaData.getDetailMetaDataNameMap().get("tcvat_taxreduce_sum"), (QFilter[])new QFilter[]{serialnoFilter});
        }

        @Override
        public void deleteWait(TcvatEngineModel model) {
            DraftMetaDataInfo waitDeductionMetaData = model.getDraftMetaDataDTO().getWaitDeduction();
            String orgId = model.getOrgId();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            QFilter taxPeriodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)waitDeductionMetaData.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
            if (draftCollect.size() == 0) {
                return;
            }
            List idList = draftCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)waitDeductionMetaData.getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = draftCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)waitDeductionMetaData.getDetailMetaDataNameMap().get("tcvat_wait_deduction_det"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
        }

        @Override
        public void deleteAddDeduction(TcvatEngineModel model) {
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter taxPeriodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getAddDeduction().getAccountMetaDataName(), (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
        }

        @Override
        public void deletePerpre(TcvatEngineModel model) {
            String orgId = model.getOrgId();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            QFilter taxPeriodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter deadLineFilter = new QFilter("deadline", "=", 1.getDeadLine(model));
            DynamicObjectCollection perpreCollect = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getPerpre().getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
            if (perpreCollect.size() == 0) {
                return;
            }
            List idList = perpreCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)model.getDraftMetaDataDTO().getPerpre().getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = perpreCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getPerpre().getDetailMetaDataNameMap().get("tcvat_accdetail_perpre"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
        }

        @Override
        public void deleteDraftCellEditRecord(TcvatEngineModel model) {
            QFilter filterList = "sjjt".equals(model.getDraftMetaDataDTO().getDraftPurpose()) ? new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId())).and(new QFilter("skssqq", "<=", (Object)DateUtils.stringToDate((String)model.getStartDate()))).and(new QFilter("skssqz", ">=", (Object)DateUtils.stringToDate((String)model.getEndDate()))).and(new QFilter("templatetype", "in", (Object)model.getDraftMetaDataDTO().getTemplateType())) : new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId())).and(new QFilter("startdate", "<=", (Object)DateUtils.stringToDate((String)model.getStartDate()))).and(new QFilter("enddate", ">=", (Object)DateUtils.stringToDate((String)model.getEndDate()))).and(new QFilter("templatetype", "in", (Object)model.getDraftMetaDataDTO().getTemplateType()));
            DynamicObject object = QueryServiceHelper.queryOne((String)TemplateEnum.getEnumByDraftType((String)model.getDraftMetaDataDTO().getTemplateType()).getDraftQueryPage(), (String)"billno", (QFilter[])new QFilter[]{filterList});
            if (null == object) {
                return;
            }
            QFilter qFilter = new QFilter("draftnumber", "=", (Object)object.getString("billno"));
            DeleteServiceHelper.delete((String)DraftConstant.TCVAT_DRAFT_EDIT, (QFilter[])new QFilter[]{qFilter});
        }

        @Override
        public void deleteCurrentPay(TcvatEngineModel model) {
        }
    }
    ,
    XGMNSR("xgmnsr"){

        @Override
        public void deleteIncome(TcvatEngineModel model) {
            DraftMetaDataInfo income = model.getDraftMetaDataDTO().getIncome();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter periodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            Object deadLine = model.getCustom().getOrDefault("deadLine", 2.getDeadLine(model));
            QFilter deadLineFilter = new QFilter("deadline", "=", deadLine);
            DynamicObjectCollection incomeCollect = QueryServiceHelper.query((String)income.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
            if (incomeCollect.size() == 0) {
                return;
            }
            List idList = incomeCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            List serialnoList = incomeCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            QFilter serialnoFilter = new QFilter("serialno", "in", serialnoList);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)income.getAccountMetaDataName()), (Object[])idList.toArray());
            DeleteServiceHelper.delete((String)"tcvat_accdetail_income", (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            DeleteServiceHelper.delete((String)"tcvat_income_invoice", (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            DeleteServiceHelper.delete((String)"tcvat_taxdeduce_sum", (QFilter[])new QFilter[]{serialnoFilter});
        }

        @Override
        public void deleteDiff(TcvatEngineModel model) {
            String orgId = model.getOrgId();
            String deadLine = (String)model.getCustom().getOrDefault("deadLine", 2.getDeadLine(model));
            QFilter taxPeriodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
            DynamicObjectCollection diffCollect = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getDiff().getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter});
            if (diffCollect.size() == 0) {
                return;
            }
            List idList = diffCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)model.getDraftMetaDataDTO().getDiff().getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = diffCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getDiff().getDetailMetaDataNameMap().get("tcvat_accdetail_diff"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
        }

        @Override
        public void deleteTaxReduce(TcvatEngineModel model) {
            DraftMetaDataInfo taxReductionMetaData = model.getDraftMetaDataDTO().getTaxReduction();
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter periodFilter = new QFilter("taxperiod", ">=", (Object)model.getStartDate().substring(0, 7)).and(new QFilter("taxperiod", "<=", (Object)model.getEndDate().substring(0, 7)));
            Object deadLine = model.getCustom().getOrDefault("deadLine", 2.getDeadLine(model));
            QFilter deadLineFilter = new QFilter("deadline", "=", deadLine);
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)taxReductionMetaData.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter, payerTypeFilter});
            if (draftCollect.size() == 0) {
                return;
            }
            List idList = draftCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            List serialnoList = draftCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            QFilter serialnoFilter = new QFilter("serialno", "in", serialnoList);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)taxReductionMetaData.getAccountMetaDataName()), (Object[])idList.toArray());
            DeleteServiceHelper.delete((String)taxReductionMetaData.getDetailMetaDataNameMap().get("tcvat_taxreduce_detail"), (QFilter[])new QFilter[]{taxaccountserialnoFilter});
            DeleteServiceHelper.delete((String)taxReductionMetaData.getDetailMetaDataNameMap().get("tcvat_taxreduce_sum"), (QFilter[])new QFilter[]{serialnoFilter});
        }

        @Override
        public void deleteCurrentPay(TcvatEngineModel model) {
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            String draftpurpose = (String)model.getCustom().get("draftpurpose");
            if ("nssb".equals(draftpurpose)) {
                TemplateUtils.deleteReport((Long)Long.parseLong(model.getOrgId()), (String)"zzsaccount", (Date)startDate, (Date)endDate, null);
            } else if ("sjjt".equals(draftpurpose)) {
                TemplateUtils.deleteReport((Long)Long.parseLong(model.getOrgId()), (String)"zzsaccount_sjjt", (Date)startDate, (Date)endDate, null);
            }
        }

        @Override
        public void deleteDraftCellEditRecord(TcvatEngineModel model) {
            QFilter filterList = "sjjt".equals(model.getDraftMetaDataDTO().getDraftPurpose()) ? new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId())).and(new QFilter("skssqq", "<=", (Object)DateUtils.stringToDate((String)model.getStartDate()))).and(new QFilter("skssqz", ">=", (Object)DateUtils.stringToDate((String)model.getEndDate()))).and(new QFilter("templatetype", "in", (Object)model.getDraftMetaDataDTO().getTemplateType())) : new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId())).and(new QFilter("startdate", "<=", (Object)DateUtils.stringToDate((String)model.getStartDate()))).and(new QFilter("enddate", ">=", (Object)DateUtils.stringToDate((String)model.getEndDate()))).and(new QFilter("templatetype", "in", (Object)model.getDraftMetaDataDTO().getTemplateType()));
            DynamicObject object = QueryServiceHelper.queryOne((String)TemplateEnum.getEnumByDraftType((String)model.getDraftMetaDataDTO().getTemplateType()).getDraftQueryPage(), (String)"billno", (QFilter[])new QFilter[]{filterList});
            if (null == object) {
                return;
            }
            QFilter qFilter = new QFilter("draftnumber", "=", (Object)object.getString("billno"));
            DeleteServiceHelper.delete((String)DraftConstant.TCVAT_DRAFT_EDIT, (QFilter[])new QFilter[]{qFilter});
        }

        @Override
        public void deleteWait(TcvatEngineModel model) {
        }

        @Override
        public void deleteAddDeduction(TcvatEngineModel model) {
        }

        @Override
        public void deletePerpre(TcvatEngineModel model) {
        }

        @Override
        public void deleteRollOut(TcvatEngineModel model) {
        }

        @Override
        public void deleteDeduction(TcvatEngineModel model) {
        }
    }
    ,
    YBHZ("ybhz"){

        @Override
        public void deleteIncome(TcvatEngineModel model) {
            DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
            DraftMetaDataInfo income = draftMetaDataDTO.getIncome();
            String incomeSummary = income.getAccountMetaDataName();
            Map<String, String> incomeSummaryDetailMap = income.getDetailMetaDataNameMap();
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            String orgId = model.getOrgId();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection serialnos = QueryServiceHelper.query((String)incomeSummary, (String)"serialno", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            Object[] serialnoList = serialnos.stream().map(s -> s.getString("serialno")).toArray();
            DeleteServiceHelper.delete((String)incomeSummary, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            DeleteServiceHelper.delete((String)incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_ACCOUNTING_DETAIL), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
            DeleteServiceHelper.delete((String)incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_INVOICE_DETAIL), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
            DeleteServiceHelper.delete((String)incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_TAX_DEDUCTION_SUM), (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
        }

        @Override
        public void deleteDiff(TcvatEngineModel model) {
            DraftMetaDataDTO dto = model.getDraftMetaDataDTO();
            DraftMetaDataInfo diff = dto.getDiff();
            String entity = diff.getAccountMetaDataName();
            Map<String, String> detailMap = diff.getDetailMetaDataNameMap();
            String orgId = model.getOrgId();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection serialnos = QueryServiceHelper.query((String)entity, (String)"serialno", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            Object[] serialnoList = serialnos.stream().map(s -> s.getString("serialno")).toArray();
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            DeleteServiceHelper.delete((String)detailMap.get(DraftConstant.YBHZ_DIFF_DETAIL), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
        }

        @Override
        public void deleteRollOut(TcvatEngineModel model) {
            DraftMetaDataDTO dto = model.getDraftMetaDataDTO();
            DraftMetaDataInfo rollOut = dto.getRollOut();
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            Date lastMonthLastDay = DateUtils.stringToDate((String)model.getEndDate());
            Date lastMonthFirstDay = DateUtils.stringToDate((String)model.getStartDate());
            QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)lastMonthFirstDay).and(new QFilter("enddate", "=", (Object)lastMonthLastDay));
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection serialnos = QueryServiceHelper.query((String)rollOut.getAccountMetaDataName(), (String)"serialno", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            Object[] serialnoList = serialnos.stream().map(s -> s.getString("serialno")).toArray();
            DeleteServiceHelper.delete((String)rollOut.getAccountMetaDataName(), (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            DeleteServiceHelper.delete((String)rollOut.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_ACCOUNTING_DETAIL), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
        }

        @Override
        public void deleteJzjtJxse(TcvatEngineModel model) {
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            DraftMetaDataInfo draftMetaDataInfo = model.getDraftMetaDataDTO().getJzjtjxse();
            DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)draftMetaDataInfo.getAccountMetaDataName(), (String)"id,serialno", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            if (draftCollect.size() == 0) {
                return;
            }
            List idList = draftCollect.stream().map(i -> i.getString("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)draftMetaDataInfo.getAccountMetaDataName()), (Object[])idList.toArray());
            List serialnoList = draftCollect.stream().map(i -> i.getString("serialno")).collect(Collectors.toList());
            QFilter taxaccountserialnoFilter = new QFilter("taxaccountserialno", "in", serialnoList);
            DeleteServiceHelper.delete((String)draftMetaDataInfo.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_JZJT_JXSE_ACCDETAIL), (QFilter[])new QFilter[]{orgFilter, taxaccountserialnoFilter});
        }

        @Override
        public void deleteDeduction(TcvatEngineModel model) {
            DraftMetaDataDTO dto = model.getDraftMetaDataDTO();
            DraftMetaDataInfo deduction = dto.getDeduction();
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            QFilter dateFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            DynamicObjectCollection serialnos = QueryServiceHelper.query((String)deduction.getAccountMetaDataName(), (String)"serialno", (QFilter[])new QFilter[]{orgFilter, dateFilter, payerTypeFilter});
            Object[] serialnoList = serialnos.stream().map(s -> s.getString("serialno")).toArray();
            DeleteServiceHelper.delete((String)deduction.getAccountMetaDataName(), (QFilter[])new QFilter[]{orgFilter, dateFilter, payerTypeFilter});
            DeleteServiceHelper.delete((String)deduction.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_DEDUCTION_DETAIL), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
            DeleteServiceHelper.delete((String)deduction.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_DEDUCT_DETAIL), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
        }

        @Override
        public void deleteTaxReduce(TcvatEngineModel model) {
            DraftMetaDataDTO dto = model.getDraftMetaDataDTO();
            DraftMetaDataInfo taxReduction = dto.getTaxReduction();
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            Date lastMonthLastDay = DateUtils.stringToDate((String)model.getEndDate());
            Date lastMonthFirstDay = DateUtils.stringToDate((String)model.getStartDate());
            QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)lastMonthFirstDay).and(new QFilter("enddate", "=", (Object)lastMonthLastDay));
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection serialnos = QueryServiceHelper.query((String)taxReduction.getAccountMetaDataName(), (String)"serialno", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            Object[] serialnoList = serialnos.stream().map(s -> s.getString("serialno")).toArray();
            DeleteServiceHelper.delete((String)taxReduction.getAccountMetaDataName(), (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            DeleteServiceHelper.delete((String)taxReduction.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_TAX_REDUCTION_DETAIL), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
            DeleteServiceHelper.delete((String)taxReduction.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_TAX_REDUCETION_SUM), (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
        }

        @Override
        public void deleteWait(TcvatEngineModel model) {
            DraftMetaDataDTO dto = model.getDraftMetaDataDTO();
            DraftMetaDataInfo waitDeduction = dto.getWaitDeduction();
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection serialnos = QueryServiceHelper.query((String)waitDeduction.getAccountMetaDataName(), (String)"serialno", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            Object[] serialnoList = serialnos.stream().map(s -> s.getString("serialno")).toArray();
            DeleteServiceHelper.delete((String)waitDeduction.getAccountMetaDataName(), (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            DeleteServiceHelper.delete((String)waitDeduction.getDetailMetaDataNameMap().get(DraftConstant.YBHZ_HZ_WAIT_DEDUCT_DET), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
        }

        @Override
        public void deleteAddDeduction(TcvatEngineModel model) {
            DraftMetaDataDTO dto = model.getDraftMetaDataDTO();
            DraftMetaDataInfo addDeduction = dto.getAddDeduction();
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter taxPeriodFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)model.getStartDate())).and(new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)model.getEndDate())));
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DeleteServiceHelper.delete((String)addDeduction.getAccountMetaDataName(), (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, payerTypeFilter});
        }

        @Override
        public void deletePerpre(TcvatEngineModel model) {
            DraftMetaDataInfo perpre = model.getDraftMetaDataDTO().getPerpre();
            String entity = perpre.getAccountMetaDataName();
            Map<String, String> detailMap = perpre.getDetailMetaDataNameMap();
            String orgId = model.getOrgId();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            QFilter skssqqzFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
            String taxPayerType = (String)model.getCustom().get("taxPayerType");
            QFilter payerTypeFilter = new QFilter("taxpayertype", "in", Arrays.asList(taxPayerType, taxPayerType.replace("zzs", "")));
            DynamicObjectCollection serialnos = QueryServiceHelper.query((String)entity, (String)"serialno", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            Object[] serialnoList = serialnos.stream().map(s -> s.getString("serialno")).toArray();
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, payerTypeFilter});
            DeleteServiceHelper.delete((String)detailMap.get(DraftConstant.YBHZ_PERPRE_DET), (QFilter[])new QFilter[]{new QFilter("taxaccountserialno", "in", (Object)serialnoList)});
        }

        @Override
        public void deleteDraftCellEditRecord(TcvatEngineModel model) {
            QFilter filterList = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId())).and(new QFilter("startdate", "<=", (Object)DateUtils.stringToDate((String)model.getStartDate()))).and(new QFilter("enddate", ">=", (Object)DateUtils.stringToDate((String)model.getEndDate()))).and(new QFilter("templatetype", "in", Collections.singletonList("draft_zzsybnsr_ybhz")));
            DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_query_ybnsr", (String)"billno", (QFilter[])new QFilter[]{filterList});
            if (null == object) {
                return;
            }
            QFilter qFilter = new QFilter("draftnumber", "=", (Object)object.getString("billno"));
            DeleteServiceHelper.delete((String)DraftConstant.TCVAT_DRAFT_EDIT, (QFilter[])new QFilter[]{qFilter});
        }

        @Override
        public void deleteCurrentPay(TcvatEngineModel model) {
        }
    };

    private String drafttype;

    private DraftEngineEnum(String drafttype) {
        this.drafttype = drafttype;
    }

    public abstract void deleteIncome(TcvatEngineModel var1);

    public abstract void deleteDiff(TcvatEngineModel var1);

    public abstract void deleteRollOut(TcvatEngineModel var1);

    public abstract void deleteDeduction(TcvatEngineModel var1);

    public void deleteJzjtJxse(TcvatEngineModel model) {
    }

    public abstract void deleteTaxReduce(TcvatEngineModel var1);

    public abstract void deleteWait(TcvatEngineModel var1);

    public abstract void deleteAddDeduction(TcvatEngineModel var1);

    public abstract void deletePerpre(TcvatEngineModel var1);

    public abstract void deleteCurrentPay(TcvatEngineModel var1);

    public abstract void deleteDraftCellEditRecord(TcvatEngineModel var1);

    public static Object getDeadLine(TcvatEngineModel model) {
        Object deadLine = model.getCustom().get("deadLine");
        if (StringUtils.isBlank(deadLine)) {
            deadLine = TaxDeclareHelper.convert2DeadLine((String)model.getCustom().get("deadline"));
        }
        if (deadLine == null) {
            deadLine = TaxDeclareHelper.getDeadLine(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), DateUtils.stringToDate2((String)model.getStartDate()), DateUtils.stringToDate2((String)model.getEndDate()));
        }
        return deadLine;
    }
}

