/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.enums;

import java.util.Arrays;
import kd.bos.orm.query.QFilter;
import kd.taxc.tcvat.common.enums.InvoiceTypeEnum;

public enum InputInvoiceFilterEnum {
    RIM_INV_SPECIAL("rim_inv_special", new QFilter("deduction_purpose", "=", (Object)"1").and(new QFilter("authenticate_flag", "in", Arrays.asList("2", "3"))).and(new QFilter("invoice_status", "=", (Object)"0")).and(new QFilter("tax_period", "is not null", null)), "invoice_code,invoice_no"),
    RIM_INV_TOLL("rim_inv_toll", new QFilter("deduction_purpose", "=", (Object)"1").and(new QFilter("authenticate_flag", "in", Arrays.asList("2", "3"))).and(new QFilter("invoice_status", "=", (Object)"0")).and(new QFilter("tax_period", "is not null", null)), "invoice_code,invoice_no"),
    RIM_INV_MOTOR("rim_inv_motor", new QFilter("deduction_purpose", "=", (Object)"1").and(new QFilter("authenticate_flag", "in", Arrays.asList("2", "3"))).and(new QFilter("invoice_status", "=", (Object)"0")).and(new QFilter("tax_period", "is not null", null)), "invoice_code,invoice_no"),
    RIM_INV_ELECTRIC("rim_inv_electric", new QFilter("invoice_status", "=", (Object)"0").and("tax_period", "is not null", null).and(new QFilter("invoice_type", "=", (Object)InvoiceTypeEnum.ELECTRIC_27.getInvoiceId()).and("authenticate_flag", "in", Arrays.asList("2", "3")).and("deduction_purpose", "=", (Object)"1").or(new QFilter("invoice_type", "=", (Object)InvoiceTypeEnum.ELECTRIC_26.getInvoiceId()).and("transport_deduction", "=", (Object)"1"))), "invoice_no"),
    RIM_INV_TRAIN("rim_inv_train", new QFilter("transport_deduction", "=", (Object)"1").and(new QFilter("tax_period", "is not null", null)), "train_num,sequence_no"),
    RIM_INV_AIR("rim_inv_air", new QFilter("transport_deduction", "=", (Object)"1").and(new QFilter("tax_period", "is not null", null)), "eticket_no"),
    RIM_INV_TRANSPORT("rim_inv_transport", new QFilter("transport_deduction", "=", (Object)"1").and(new QFilter("tax_period", "is not null", null)), "invoice_code,invoice_no"),
    RIM_INV_CUSTOM("rim_inv_custom", new QFilter("authenticate_flag", "=", (Object)"2").and(new QFilter("deduction_purpose", "=", (Object)"1")).and(new QFilter("tax_period", "is not null", null).and(new QFilter("custom_declaration_no", "like", (Object)"%L%"))), "custom_declaration_no"),
    RIM_INV_ORDINARY("rim_inv_ordinary", new QFilter("invoice_type", "=", (Object)InvoiceTypeEnum.ORDINARY1.getInvoiceId()).and("invoice_status", "=", (Object)"0").and("transport_deduction", "=", (Object)"1").and("tax_period", "is not null", null), "invoice_code,invoice_no");

    private String invoiceNumber;
    private QFilter filter;
    private String invoicepkid;

    private InputInvoiceFilterEnum(String invoiceNumber, QFilter filter, String invoicepkid) {
        this.invoiceNumber = invoiceNumber;
        this.filter = filter;
        this.invoicepkid = invoicepkid;
    }

    public static InputInvoiceFilterEnum getInvoiceTypeEnum(String invoiceNumber) {
        for (InputInvoiceFilterEnum invoiceType : InputInvoiceFilterEnum.values()) {
            if (!invoiceType.getInvoiceNumber().equals(invoiceNumber)) continue;
            return invoiceType;
        }
        return null;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public QFilter getFilter() {
        return this.filter;
    }

    public String getInvoicepkid() {
        return this.invoicepkid;
    }

    public String[] getInvoicepkids() {
        return this.invoicepkid.split(",");
    }
}

