/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.taxc.bdtaxr.business.TaxcCombineBusiness;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcvat.common.dto.base.ResponseDto;
import org.apache.commons.collections4.MapUtils;

public class TcvatCommonUtil {
    private static TcvatCommonUtil tcvatCommonUtil = new TcvatCommonUtil();

    private TcvatCommonUtil() {
    }

    public static TcvatCommonUtil getInstance() {
        return tcvatCommonUtil;
    }

    public static String getBillno(String entityName) {
        return DeclareServiceHelper.generateSBBNo((String)entityName);
    }

    public static Long parseValueConvert(Map<String, Map<String, Map<String, List<String>>>> valueConvertMap, String sourceKey) {
        Long result = 0L;
        if (MapUtils.isNotEmpty(valueConvertMap)) {
            for (Map<String, List<String>> targetValue : valueConvertMap.get(String.valueOf(sourceKey)).values()) {
                List<String> targetList;
                Iterator<List<String>> iterator = targetValue.values().iterator();
                while (iterator.hasNext() && (result = Long.valueOf((targetList = iterator.next()).get(0))).compareTo(0L) == 0) {
                }
            }
        }
        return result;
    }

    public static ResponseDto<String> isYbnsr(Object orgid) {
        ResponseDto res = new ResponseDto();
        if (StringUtils.isNotBlank((Object)orgid)) {
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(String.valueOf(orgid))));
            if (!result.isSuccess()) {
                return res.build(false, "1", result.getMessage(), null);
            }
            if (EmptyCheckUtils.isEmpty((Object)result.getData()) || EmptyCheckUtils.isEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
                return res.build(false, "1", ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u8be5\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b", (String)"TcvatCommonUtil_0", (String)"taxc-tcvat", (Object[])new Object[0]), null);
            }
            DynamicObject dy = (DynamicObject)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity").get(0);
            if (!"ybnsr".equals(dy.getString("taxpayertype"))) {
                return res.build(false, "1", ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u662f\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u80fd\u6838\u7b97\u671f\u672b\u7559\u62b5\u9000\u7a0e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u4e00\u822c\u7eb3\u7a0e\u4eba", (String)"TcvatCommonUtil_1", (String)"taxc-tcvat", (Object[])new Object[0]), null);
            }
        }
        return res.buildOK();
    }

    public static void showDtoMsg(IFormView view, ResponseDto dto) {
        if ("1".equals(dto.getCode())) {
            view.showErrorNotification(dto.getMsg());
        } else if ("2".equals(dto.getCode())) {
            view.showTipNotification(dto.getMsg());
        }
    }

    public Long getDefaultOrg(Long orgId) {
        TaxResult listTaxResult = TaxcCombineBusiness.queryTaxcOrgIdByTaxationsysId((Long)RequestContext.get().getCurrUserId(), (Long)1L);
        if (listTaxResult != null && listTaxResult.getData() != null && !((List)listTaxResult.getData()).isEmpty()) {
            List data = (List)listTaxResult.getData();
            if (data.contains(orgId)) {
                return orgId;
            }
            if (data.contains(RequestContext.get().getOrgId())) {
                return RequestContext.get().getOrgId();
            }
            return (Long)data.get(0);
        }
        return 0L;
    }

    public static boolean isNumericType(String tableName, String fieldName) {
        IDataEntityProperty property = EntityMetadataCache.getDataEntityType((String)tableName).findProperty(fieldName);
        if (null == property) {
            return false;
        }
        String fieldType = property.getPropertyType().getSimpleName();
        return fieldType.equals("BigDecimal") || fieldType.equals("Integer") || fieldType.equals("Long");
    }
}

