/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.EntryProp;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.business.service.rule.validator.RuleSaveValidateDirector;
import kd.taxc.tcvat.business.service.rule.validator.RuleSaveValidator;
import kd.taxc.tcvat.common.enums.RuleSaveValidatorEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.SetUtils;

public class ValidateUtils {
    public static final String KEY_TYPE = "type";
    public static final String KEY_RULE = "rule";
    public static final String KEY_MSG = "msg";
    private static String[] FIELDS_INVOICE = new String[]{"invoicebizname", "table12", "invoicetaxrate", "invoicefiltercondition"};
    private static String[] FIELDS_SETTING = new String[]{"bizname", "table", "amountfield", "datatype", "absolute", "datadirection", "filtercondition"};
    private static String[] PREPAY_FIELDS_SETTING = new String[]{"deductionbizname", "deductiontable", "deductionamountfield", "deductiondatatype", "deductionabsolute", "deductiondatadirection", "deductionfiltercondition"};
    private static List<String> INCOME_ENTITYS = Arrays.asList("invoiceentity", "entryentity1", "entryentity11", "entryentity", "entryentity3", "entryentity2");
    private static List<String> APPORTION_ENTITYS = Arrays.asList("entryentity", "entryentity1", "entryentity11", "entryentity12");
    private static List<String> REFUND_ENTITYS = Arrays.asList("entryentity", "entryentity1", "entryentity2");

    public static String getErrorFormatAccounting() {
        return ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u548c%2$d\u884c\u91cd\u590d\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e ", (String)"ValidateUtils_21", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    private static String getTwoErrorFormatAccounting() {
        return ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u548c%3$s\u7b2c%4$s\u884c\u91cd\u590d\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e", (String)"ValidateUtils_15", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    private static String getErrorFormatInvoice() {
        return ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4e0d\u542b\u7a0e\u6536\u5165\u7b2c%1$d\u884c\u548c%2$d\u884c\u91cd\u590d\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e", (String)"ValidateUtils_22", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    private static String getTwoErrorFormatJxxm() {
        return ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u914d\u7f6e\u4e0e%2$s\u6807\u8bc6\u89c4\u5219\u7684\u7b2c%3$s\u884c\u914d\u7f6e\u5185\u5bb9\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ValidateUtils_23", (String)"taxc-tcvat", (Object[])new Object[0]);
    }

    private static String getEntityName(String ruleName, String entryname) {
        if (ruleName.startsWith("tcvat_rule_income")) {
            switch (entryname) {
                case "entryentity1": {
                    return ResManager.loadKDString((String)"\u5176\u4ed6\u53d1\u7968\u4e0d\u542b\u7a0e\u6536\u5165", (String)"ValidateUtils_11", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                case "entryentity11": {
                    return ResManager.loadKDString((String)"\u5176\u4ed6\u53d1\u7968\u7a0e\u989d", (String)"ValidateUtils_12", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                case "entryentity": {
                    return ResManager.loadKDString((String)"\u672a\u5f00\u7968\u4e0d\u542b\u7a0e\u6536\u5165", (String)"ValidateUtils_13", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                case "entryentity3": {
                    return ResManager.loadKDString((String)"\u672a\u5f00\u7968\u7a0e\u989d", (String)"ValidateUtils_14", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                case "entryentity2": {
                    return ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u7a0e\u989d", (String)"ValidateUtils_30", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
            }
        } else if (ruleName.startsWith("tcvat_rule_refund")) {
            switch (entryname) {
                case "entryentity": {
                    return ResManager.loadKDString((String)"\u4e0a\u5e74\u5ea6\u672b\u8d44\u4ea7\u603b\u989d\u53d6\u6570\u914d\u7f6e", (String)"ValidateUtils_17", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                case "entryentity1": {
                    return ResManager.loadKDString((String)"\u7279\u5b9a\u884c\u4e1a\u4e0d\u542b\u7a0e\u9500\u552e\u989d\u53d6\u6570\u914d\u7f6e", (String)"ValidateUtils_18", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                case "entryentity2": {
                    return ResManager.loadKDString((String)"\u5168\u90e8\u4e0d\u542b\u7a0e\u9500\u552e\u989d\u53d6\u6570\u914d\u7f6e", (String)"ValidateUtils_19", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
            }
        }
        return "";
    }

    public static List<BaseResult> validateByDirector(List<DynamicObject> ruleList) {
        ArrayList<BaseResult> baseResults = new ArrayList<BaseResult>(4);
        RuleSaveValidateDirector ruleSaveValidateDirector = new RuleSaveValidateDirector();
        for (DynamicObject rule : ruleList) {
            RuleTypeEnum ruleTypeEnum = RuleTypeEnum.valueOfEntry((String)rule.getDataEntityType().getName());
            RuleSaveValidator ruleSaveValidator = RuleSaveValidatorEnum.getValitorByType(ruleTypeEnum);
            ruleSaveValidator.setRule(rule);
            ruleSaveValidateDirector.setRuleSaveValidator(ruleSaveValidator);
            baseResults.add(ruleSaveValidateDirector.getValidateResult());
        }
        return baseResults;
    }

    public static List<Map<String, Object>> validate(List<DynamicObject> ruleList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ruleList.sort((o1, o2) -> o2.getString("ruletype").compareTo(o1.getString("ruletype")));
        for (int i = 0; i < ruleList.size(); ++i) {
            DynamicObject rule1 = ruleList.get(i);
            if (!rule1.getBoolean("enable")) continue;
            result.addAll(ValidateUtils.checkOrg(rule1));
            result.addAll(ValidateUtils.checkVatrate(rule1));
            result.addAll(ValidateUtils.checkInOneRule(rule1));
            result.addAll(ValidateUtils.checkInOneOrg(rule1));
        }
        return result;
    }

    public static List<Map<String, Object>> checkVatrate(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        String ruleType = rule.getDataEntityType().getName();
        TcvatRuleEntryEntityEnum entryEnum = TcvatRuleEntryEntityEnum.match((String)ruleType);
        List vatRateEnumList = entryEnum.getEntryList();
        if (!TcvatRuleEntryEntityEnum.isNeedCheckVatRateNot0((String)ruleType) || CollectionUtils.isEmpty((Collection)vatRateEnumList)) {
            return msgList;
        }
        vatRateEnumList.forEach(t -> {
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection(t.getEntryEntity());
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject e = (DynamicObject)entryentity.get(i);
                String dataType = e.getString(t.getDataTypeField());
                if (dataType.equals("zjqs") || BigDecimal.ZERO.compareTo(e.getBigDecimal(t.getVatRateField())) != 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(KEY_TYPE, "error");
                map.put(KEY_RULE, (String)rule);
                map.put(KEY_MSG, t.getEntryEntityName().getDescription() + String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u589e\u503c\u7a0e\u7a0e\u7387\u9700\u5927\u4e8e0\u3002", (String)"ValidateUtils_24", (String)"taxc-tcvat", (Object[])new Object[0]), i + 1));
                msgList.add(map);
            }
        });
        return msgList;
    }

    private static List<Map<String, Object>> checkInOneOrg(DynamicObject rule) {
        String name = rule.getDataEntityType().getName();
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        if ("tcvat_rule_perpre".equals(name)) {
            Map sharingAndOrgRules = RuleUtils.getSharingAndOrgRules((Long)rule.getDynamicObject("org").getLong("id"), Collections.singletonList(rule.getLong("id")), (RuleTypeEnum)RuleTypeEnum.PERPRE, (String)rule.getString("taxpayertype"), null);
            List list = (List)sharingAndOrgRules.get(RuleTypeEnum.valueOfEntry((String)name));
            DataEntityPropertyCollection properties = rule.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof EntryProp)) continue;
                String entityName = property.getName();
                DynamicObjectCollection entityCollection = rule.getDynamicObjectCollection(entityName);
                for (int i = 0; i < entityCollection.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entityCollection.get(i);
                    Optional<DynamicObject> first = list.stream().filter(d -> d.getDynamicObjectCollection(entityName).stream().anyMatch(e -> Arrays.stream(FIELDS_SETTING).allMatch(f -> e.get(f).equals(dynamicObject.get(f))))).findFirst();
                    if (!first.isPresent()) continue;
                    DynamicObject errorDyo = first.get();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(KEY_TYPE, "error");
                    map.put(KEY_RULE, (String)rule);
                    map.put(KEY_MSG, String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5df2\u5728\u7ec4\u7ec7\uff1a%3$s \u7f16\u7801\uff1a%4$s \u7684\u89c4\u5219\u4e2d\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e", (String)"ValidateUtils_20", (String)"taxc-tcvat", (Object[])new Object[0]), property.getDisplayName().getLocaleValue(), i + 1, errorDyo.getDynamicObject("org").getString("name"), errorDyo.getString("number")));
                    msgList.add(map);
                }
            }
        }
        return msgList;
    }

    private static List<Map<String, Object>> checkInOneRule(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList;
        block19: {
            DynamicObjectCollection entryentity1;
            String name;
            block21: {
                block20: {
                    block18: {
                        msgList = new ArrayList<Map<String, Object>>();
                        name = rule.getDataEntityType().getName();
                        if (!"tcvat_rule_income".equals(name)) break block18;
                        for (String string : INCOME_ENTITYS) {
                            DynamicObjectCollection dynamicObjectCollection = rule.getDynamicObjectCollection(string);
                            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                                for (int j = i + 1; j < dynamicObjectCollection.size(); ++j) {
                                    DynamicObject a1 = (DynamicObject)dynamicObjectCollection.get(i);
                                    DynamicObject a2 = (DynamicObject)dynamicObjectCollection.get(j);
                                    if ("invoiceentity".equals(string)) {
                                        ValidateUtils.compareInvoice(rule, rule, msgList, a1, a2, j + 1);
                                        continue;
                                    }
                                    String suffix = string.replace("entryentity", "");
                                    List<String> collect = Arrays.stream(FIELDS_SETTING).map(a -> a + suffix).collect(Collectors.toList());
                                    String[] fields = collect.toArray(new String[collect.size()]);
                                    ValidateUtils.compareAccounting(rule, rule, msgList, a1, a2, j + 1, fields, ValidateUtils.getEntityName(name, string));
                                }
                            }
                        }
                        break block19;
                    }
                    if (!"tcvat_rule_apportion".equals(name) && !"tcvat_rule_apportion_inh".equals(name) && !"tcvat_rule_refund".equals(name)) break block20;
                    List<Object> entityList = Collections.emptyList();
                    if (name.startsWith("tcvat_rule_apportion")) {
                        entityList = APPORTION_ENTITYS;
                    } else if (name.startsWith("tcvat_rule_refund")) {
                        entityList = REFUND_ENTITYS;
                    }
                    for (String string : entityList) {
                        DynamicObjectCollection entity = rule.getDynamicObjectCollection(string);
                        for (int i = 0; i < entity.size(); ++i) {
                            for (int j = i + 1; j < entity.size(); ++j) {
                                DynamicObject a1 = (DynamicObject)entity.get(i);
                                DynamicObject a2 = (DynamicObject)entity.get(j);
                                String suffix = string.replace("entryentity", "");
                                String[] fields = (String[])Arrays.stream(FIELDS_SETTING).map(a -> a + suffix).toArray(String[]::new);
                                ValidateUtils.compareAccounting(rule, rule, msgList, a1, a2, j + 1, fields, ValidateUtils.getEntityName(name, string));
                            }
                        }
                    }
                    break block19;
                }
                if (!"tcvat_ncp_product_rule".equals(name) && !"tcvat_ncp_rule".equals(name) && !"tcvat_rule_perpre".equals(name) && !"tcvat_rule_jzjt_jxse".equals(name)) break block21;
                DataEntityPropertyCollection properties = rule.getDynamicObjectType().getProperties();
                for (IDataEntityProperty iDataEntityProperty : properties) {
                    if (!(iDataEntityProperty instanceof EntryProp)) continue;
                    String string = iDataEntityProperty.getName();
                    DynamicObjectCollection entity = rule.getDynamicObjectCollection(string);
                    for (int i = 0; i < entity.size(); ++i) {
                        for (int j = i + 1; j < entity.size(); ++j) {
                            DynamicObject a1 = (DynamicObject)entity.get(i);
                            DynamicObject a2 = (DynamicObject)entity.get(j);
                            String suffix = string.replace("entryentity", "");
                            String[] fields = (String[])Arrays.stream(FIELDS_SETTING).map(a -> a + suffix).toArray(String[]::new);
                            ValidateUtils.compareAccounting(rule, rule, msgList, a1, a2, j + 1, fields, iDataEntityProperty.getDisplayName().getLocaleValue());
                        }
                    }
                }
                break block19;
            }
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryentity.size(); ++i) {
                for (int j = i + 1; j < entryentity.size(); ++j) {
                    DynamicObject a1 = (DynamicObject)entryentity.get(i);
                    DynamicObject a2 = (DynamicObject)entryentity.get(j);
                    if ("tcvat_rule_wkpsr".equals(name) || "tcvat_rule_wkpsr_inh".equals(name)) {
                        ValidateUtils.compareAccounting(rule, rule, msgList, a1, a2, j + 1, FIELDS_SETTING, ResManager.loadKDString((String)"\u603b\u5e94\u7a0e\u6536\u5165\u53d6\u6570\u914d\u7f6e", (String)"ValidateUtils_16", (String)"taxc-tcvat", (Object[])new Object[0]));
                        continue;
                    }
                    ValidateUtils.compareAccounting(rule, rule, msgList, a1, a2, j + 1, FIELDS_SETTING, ResManager.loadKDString((String)"\u6263\u9664\u989d(\u672c\u671f\u53d1\u751f)\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"ValidateUtils_25", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            }
            if (!"tcvat_rule_diff".equals(name) || !CollectionUtils.isNotEmpty((Collection)(entryentity1 = rule.getDynamicObjectCollection("entryentity1")))) break block19;
            String[] stringArray = (String[])Arrays.stream(FIELDS_SETTING).map(a -> a + "1").toArray(String[]::new);
            for (int i = 0; i < entryentity1.size(); ++i) {
                for (int j = i + 1; j < entryentity1.size(); ++j) {
                    DynamicObject a1 = (DynamicObject)entryentity1.get(i);
                    DynamicObject a2 = (DynamicObject)entryentity1.get(j);
                    ValidateUtils.compareAccounting(rule, rule, msgList, a1, a2, j + 1, stringArray, ResManager.loadKDString((String)"\u6263\u9664\u989d(\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d)\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"ValidateUtils_26", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            }
        }
        return msgList;
    }

    public static List<Map<String, Object>> checkOrg(DynamicObject rule) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        Long orgId = rule.getDynamicObject("org").getLong("id");
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgId).getData()).booleanValue()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, "error");
            map.put(KEY_RULE, (String)rule);
            map.put(KEY_MSG, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ValidateUtils_27", (String)"taxc-tcvat", (Object[])new Object[0]));
            msgList.add(map);
        }
        return msgList;
    }

    private static void compareAccounting(DynamicObject rule1, DynamicObject rule2, List<Map<String, Object>> msgList, DynamicObject a1, DynamicObject a2, int seq, String[] filtersName, String entryName) {
        boolean equals = true;
        for (String field : filtersName) {
            if (Objects.equals(rule1.getDataEntityType().getName(), "tcvat_rule_prepay") && ("bizname".equals(field) || "deductionbizname".equals(field)) || null == a1.get(field) || a1.get(field).equals(a2.get(field))) continue;
            equals = false;
            break;
        }
        if (equals) {
            String msg = String.format(ValidateUtils.getErrorFormatAccounting(), a1.get("seq"), a2.get("seq"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, ValidateUtils.getErrorType(rule1, rule2));
            map.put(KEY_RULE, (String)rule2);
            map.put(KEY_MSG, entryName + msg);
            msgList.add(map);
        }
    }

    private static void compareAccounting(DynamicObject rule1, DynamicObject rule2, List<Map<String, Object>> msgList, DynamicObject a1, DynamicObject a2, int seq, String[] filtersName1, String[] filtersName2, String entryName1, String entryName2) {
        boolean equals = true;
        for (int i = 0; i < filtersName1.length; ++i) {
            if (Objects.equals(rule1.getDataEntityType().getName(), "tcvat_rule_prepay") && ("bizname".equals(filtersName1[i]) || "deductionbizname".equals(filtersName1[i])) || null == a1.get(filtersName1[i]) || a1.get(filtersName1[i]).equals(a2.get(filtersName2[i]))) continue;
            equals = false;
            break;
        }
        if (equals) {
            String msg = String.format(ValidateUtils.getTwoErrorFormatAccounting(), entryName1, a1.get("seq"), entryName2, a2.get("seq"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, ValidateUtils.getErrorType(rule1, rule2));
            map.put(KEY_RULE, (String)rule2);
            map.put(KEY_MSG, msg);
            msgList.add(map);
        }
    }

    public static void judgeRepetation(DynamicObject rule1, List<DynamicObject> rules2, List<Map<String, Object>> msgList, String field) {
        DynamicObjectCollection table1 = rule1.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < table1.size(); ++i) {
            for (int j = i + 1; j < table1.size(); ++j) {
                ValidateUtils.compareValue(table1, table1, i, j, field, msgList, ResManager.loadKDString((String)"\u672c", (String)"ValidateUtils_28", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
        rules2.forEach(one -> {
            DynamicObjectCollection table2 = one.getDynamicObjectCollection("entryentity");
            for (int m = 0; m < table1.size(); ++m) {
                for (int n = 0; n < table2.size(); ++n) {
                    ValidateUtils.compareValue(table1, table2, m, n, field, msgList, one.getString("name"));
                }
            }
        });
    }

    private static void compareValue(DynamicObjectCollection table1, DynamicObjectCollection table2, int m, int n, String field, List<Map<String, Object>> msgList, String name) {
        DynamicObject gltj1 = (DynamicObject)table1.get(m);
        DynamicObject gltj2 = (DynamicObject)table2.get(n);
        if (Objects.equals(gltj1.get("table"), gltj2.get("table"))) {
            List<String> split2;
            Set collect2;
            String ruleStr1 = gltj1.getString(field);
            String ruleStr2 = gltj2.getString(field);
            List<String> split1 = Arrays.asList(ruleStr1.split(ResManager.loadKDString((String)"\u5e76\u4e14", (String)"ValidateUtils_29", (String)"taxc-tcvat", (Object[])new Object[0])));
            Set collect1 = split1.stream().map(String::trim).collect(Collectors.toSet());
            if (SetUtils.isEqualSet(collect1, collect2 = (split2 = Arrays.asList(ruleStr2.split(ResManager.loadKDString((String)"\u5e76\u4e14", (String)"ValidateUtils_29", (String)"taxc-tcvat", (Object[])new Object[0])))).stream().map(String::trim).collect(Collectors.toSet()))) {
                String msg = String.format(ValidateUtils.getTwoErrorFormatJxxm(), gltj1.get("seq"), name, gltj2.get("seq"));
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(KEY_TYPE, "error");
                map.put(KEY_RULE, name);
                map.put(KEY_MSG, msg);
                msgList.add(map);
            }
        }
    }

    private static void compareInvoice(DynamicObject rule1, DynamicObject rule2, List<Map<String, Object>> msgList, DynamicObject a1, DynamicObject a2, int seq) {
        boolean equals = true;
        for (String field : FIELDS_INVOICE) {
            if (a1.get(field).equals(a2.get(field))) continue;
            equals = false;
            break;
        }
        if (equals) {
            String msg = String.format(ValidateUtils.getErrorFormatInvoice(), a1.get("seq"), a2.get("seq"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(KEY_TYPE, ValidateUtils.getErrorType(rule1, rule2));
            map.put(KEY_RULE, (String)rule2);
            map.put(KEY_MSG, msg);
            msgList.add(map);
        }
    }

    private static String getErrorType(DynamicObject rule1, DynamicObject rule2) {
        String longnumber2;
        String ruletype1 = rule1.getString("ruletype");
        String ruletype2 = rule2.getString("ruletype");
        long ruleId1 = rule1.getDynamicObject("org").getLong("id");
        long ruleId2 = rule2.getDynamicObject("org").getLong("id");
        DynamicObjectCollection collection = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", Arrays.asList(ruleId1, ruleId2)));
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject object : collection) {
            map.put(object.getPkValue(), object);
        }
        String longnumber1 = ((DynamicObject)map.get(ruleId1)).getString("longnumber");
        if (longnumber1.startsWith(longnumber2 = ((DynamicObject)map.get(ruleId2)).getString("longnumber")) && !longnumber1.equals(longnumber2) || !ruletype1.equals(ruletype2)) {
            return "warning";
        }
        return "error";
    }

    public static List<Map<String, Object>> validate(DynamicObject currentRule) {
        DynamicObject a2;
        DynamicObject a1;
        int i;
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection invoiceentity = currentRule.getDynamicObjectCollection("entryentity");
        for (int i2 = 0; i2 < invoiceentity.size(); ++i2) {
            for (int j = i2 + 1; j < invoiceentity.size(); ++j) {
                DynamicObject a12 = (DynamicObject)invoiceentity.get(i2);
                DynamicObject a22 = (DynamicObject)invoiceentity.get(j);
                ValidateUtils.compareAccounting(currentRule, currentRule, msgList, a12, a22, j + 1, FIELDS_SETTING, ResManager.loadKDString((String)"\u9500\u552e\u989d\u53d6\u6570\u89c4\u5219", (String)"ValidateUtils_9", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection entryentity = currentRule.getDynamicObjectCollection("deductionentry");
        for (i = 0; i < entryentity.size(); ++i) {
            for (int j = i + 1; j < entryentity.size(); ++j) {
                a1 = (DynamicObject)entryentity.get(i);
                a2 = (DynamicObject)entryentity.get(j);
                ValidateUtils.compareAccounting(currentRule, currentRule, msgList, a1, a2, j + 1, PREPAY_FIELDS_SETTING, ResManager.loadKDString((String)"\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219", (String)"ValidateUtils_10", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)invoiceentity) && CollectionUtils.isNotEmpty((Collection)entryentity)) {
            for (i = 0; i < invoiceentity.size(); ++i) {
                for (int j = 0; j < entryentity.size(); ++j) {
                    a1 = (DynamicObject)invoiceentity.get(i);
                    a2 = (DynamicObject)entryentity.get(j);
                    ValidateUtils.compareAccounting(currentRule, currentRule, msgList, a1, a2, j + 1, FIELDS_SETTING, PREPAY_FIELDS_SETTING, ResManager.loadKDString((String)"\u9500\u552e\u989d\u53d6\u6570\u89c4\u5219", (String)"ValidateUtils_9", (String)"taxc-tcvat", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219", (String)"ValidateUtils_10", (String)"taxc-tcvat", (Object[])new Object[0]));
                }
            }
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        result.addAll(msgList);
        return result;
    }
}

