/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.common.util;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;

public class ZzsOrgCheckUtil {
    private static final String ID = "id";
    private static final String AYSB = "aysb";
    private static final String AJSB = "ajsb";
    private static final String TAXPAYERTYPE = "taxpayertype";
    private static final String MONTH = "month";
    private static final String SEASON = "season";
    private static final String ZZS = "zzs";
    private static final String YBNSR = "ybnsr";
    private static final String FAILINFO = "failInfo";
    private static final String CODE = "code";

    public static String getCheckResult(String orgId, String entityName) {
        String failInfo = ZzsOrgCheckUtil.checkOrg(orgId, entityName);
        if (StringUtils.isNotBlank((CharSequence)failInfo)) {
            return failInfo;
        }
        Map<String, String> singleApplyMap = ZzsOrgCheckUtil.isSingleApply(Long.valueOf(orgId));
        if (StringUtils.equalsIgnoreCase((CharSequence)singleApplyMap.get(CODE), (CharSequence)"true")) {
            return singleApplyMap.get(FAILINFO);
        }
        return "";
    }

    public static String checkOrg(String orgId, String entityName) {
        TaxResult<Boolean> result = ZzsOrgCheckUtil.licenseCheck(orgId, "tcvat");
        if (result != null && Boolean.TRUE.equals(result.getData())) {
            return result.getMessage();
        }
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)ID, (Object)orgId));
        Map<String, String> orgEnableMap = ZzsOrgCheckUtil.orgEnable(org);
        if (StringUtils.equalsIgnoreCase((CharSequence)orgEnableMap.get(CODE), (CharSequence)"true")) {
            return orgEnableMap.get(FAILINFO);
        }
        Map<String, String> authMap = ZzsOrgCheckUtil.isTaxPayerAuth(orgId, entityName);
        if (StringUtils.equalsIgnoreCase((CharSequence)authMap.get(CODE), (CharSequence)"true")) {
            return authMap.get(FAILINFO);
        }
        Map<String, String> categoryEnableMap = ZzsOrgCheckUtil.taxCategoryEnable(orgId);
        if (StringUtils.equalsIgnoreCase((CharSequence)categoryEnableMap.get(CODE), (CharSequence)"true")) {
            return categoryEnableMap.get(FAILINFO);
        }
        return "";
    }

    public static TaxResult<Boolean> licenseCheck(Object orgid, String appid) {
        return TaxcLicenseCheckDataServiceHelper.check((Long)Long.parseLong(String.valueOf(orgid)), (String)appid);
    }

    public static Map<String, String> orgEnable(DynamicObjectCollection org) {
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"orgEnable", (Object[])new Object[]{((DynamicObject)org.get(0)).getLong(ID), true});
        return map;
    }

    public static Map<String, String> isTaxPayerAuth(String orgId, String entityName) {
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"isTaxPayerAuth", (Object[])new Object[]{orgId, entityName, true});
        return map;
    }

    public static Map<String, String> taxCategoryEnable(String orgId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CODE, "false");
        map.put(FAILINFO, "");
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(orgId)));
        if (EmptyCheckUtils.isEmpty((Object)result.getData()) || EmptyCheckUtils.isEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            map.put(CODE, "true");
            map.put(FAILINFO, ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"ZzsOrgCheckUtil_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        } else {
            DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
            DynamicObject dy = (DynamicObject)taxMain.getDynamicObjectCollection("categoryentryentity").get(0);
            if (Objects.equals("0", dy.getString("enable"))) {
                String taxpayer = TaxOrgUtil.getTaxpayer((DynamicObject)taxMain.getDynamicObject("taxorg"));
                map.put(CODE, "true");
                map.put(FAILINFO, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5361\u7247\u5c1a\u672a\u542f\u7528\u3002", (String)"ZzsOrgCheckUtil_1", (String)"taxc-tcvat", (Object[])new Object[0]), taxpayer, ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"ZzsOrgCheckUtil_2", (String)"taxc-tcvat", (Object[])new Object[0])));
            }
        }
        return map;
    }

    public static Map<String, String> isybnsr(Long orgId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CODE, "false");
        map.put(FAILINFO, "");
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(orgId));
        if (!result.isSuccess()) {
            map.put(CODE, "true");
            map.put(FAILINFO, result.getMessage());
            return map;
        }
        if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
            map.put(CODE, "true");
            map.put(FAILINFO, ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f", (String)"ZzsOrgCheckUtil_3", (String)"taxc-tcvat", (Object[])new Object[0]));
            return map;
        }
        DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
        DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
        if (EmptyCheckUtils.isEmpty((Object)categoryentryentity) || EmptyCheckUtils.isEmpty((Object)((DynamicObject)categoryentryentity.get(0)).getString(TAXPAYERTYPE))) {
            map.put(CODE, "true");
            map.put(FAILINFO, ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u8be5\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b", (String)"ZzsOrgCheckUtil_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            return map;
        }
        if (!YBNSR.equals(((DynamicObject)categoryentryentity.get(0)).getString(TAXPAYERTYPE))) {
            map.put(CODE, "true");
            map.put(FAILINFO, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u662f\u589e\u503c\u7a0e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u65e0\u9700\u7559\u62b5\u9000\u7a0e", (String)"ZzsOrgCheckUtil_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            return map;
        }
        return map;
    }

    public static Map<String, String> isSingleApply(Long orgId) {
        Map<String, String> map = ZzsOrgCheckUtil.isybnsr(orgId);
        if (StringUtils.equalsIgnoreCase((CharSequence)map.get(CODE), (CharSequence)"false")) {
            Date date = new Date();
            Date skssqq = null;
            Date skssqz = null;
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(orgId));
            if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
                map.put(CODE, "true");
                map.put(FAILINFO, ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f", (String)"ZzsOrgCheckUtil_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                return map;
            }
            DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            String taxLimit = "";
            if (EmptyCheckUtils.isNotEmpty((Object)categoryentryentity)) {
                taxLimit = ((DynamicObject)categoryentryentity.get(0)).getString("deadline");
            }
            if (AYSB.equals(taxLimit)) {
                skssqq = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)date, (int)-1));
                skssqz = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)date, (int)-1));
            } else if (AJSB.equals(taxLimit)) {
                Date lastSeason = DateUtils.addMonth((Date)date, (int)-3);
                skssqq = DateUtils.getFirstDateOfSeason((Date)lastSeason);
                skssqz = DateUtils.getLastDateOfSeason((Date)skssqq);
            }
            String declaration = OrgUtils.getOrgGroupDeclaration((Long)orgId, (String)ZZS, (Date)skssqq, skssqz);
            if ("3".equals(declaration)) {
                String taxpayer = TaxOrgUtil.getTaxpayer((DynamicObject)taxMain.getDynamicObject("taxorg"));
                map.put(CODE, "true");
                map.put(FAILINFO, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u4e3a\u6c47\u603b\u7533\u62a5\u7684\u5206\u652f\u673a\u6784\uff0c\u65e0\u9700\u7559\u62b5\u9000\u7a0e", (String)"ZzsOrgCheckUtil_6", (String)"taxc-tcvat", (Object[])new Object[0]), taxpayer));
            }
        }
        return map;
    }

    public static Map<String, String> checkTaxLimit(Long orgId, Date skssqq, Date skssqz) {
        DynamicObjectCollection categoryentryentity;
        Map<String, String> map = ZzsOrgCheckUtil.isybnsr(orgId);
        String limit = null;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(orgId));
        if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)(categoryentryentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity")))) {
            limit = ((DynamicObject)categoryentryentity.get(0)).getString("deadline");
        }
        String taxlimit = null;
        if (AYSB.equals(limit)) {
            taxlimit = MONTH;
        } else if (AJSB.equals(limit)) {
            taxlimit = SEASON;
        }
        if (!TaxDeclarationService.isNature(skssqq, skssqz)) {
            map.put(CODE, "true");
            map.put(FAILINFO, ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u6708\u6216\u6574\u5b63\u5ea6", (String)"ZzsOrgCheckUtil_7", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if (!DateUtils.validDateRange((String)taxlimit, (Date)skssqq, (Date)skssqz)) {
            map.put(CODE, "true");
            map.put(FAILINFO, ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u671f\u95f4\u4e0e\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"ZzsOrgCheckUtil_8", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        return map;
    }
}

