/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.account.AccountSelectFormService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.common.enums.TaxdataTabEnum;

public class AccountSelectFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static Log logger = LogFactory.getLog(AccountSelectFormPlugin.class);
    private static final String TABAP = "tabap";
    private static final String BTN_FASTSETTING = "btnfastsetting";
    private static final String BTN_FASTSETTING_AP = "vectorap";
    private AccountSelectFormService accountSelectFormService = new AccountSelectFormService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, TABAP);
        this.addClickListeners(new String[]{BTN_FASTSETTING});
    }

    private void addTabSelectListener(TabSelectListener form, String ... tabName) {
        for (int i = 0; i < tabName.length; ++i) {
            Tab tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Button && ((Button)evt.getSource()).getKey().equals(BTN_FASTSETTING)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            HashMap customParams = new HashMap();
            customParams.put("orgid", params.get("orgid"));
            customParams.put("ruletype", "private");
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcvat_rule_configs", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.setTabVisible(customParams);
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        boolean readonly = (Boolean)customParams.get("readonly");
        if (readonly) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        } else {
            this.getView().setVisible(Boolean.valueOf(customParams.get("from") == null), new String[]{BTN_FASTSETTING, BTN_FASTSETTING_AP});
        }
        Tab tab = (Tab)this.getControl(TABAP);
        if (null != tab) {
            AccountSelectFormService.showPage("AccountSelectFormPlugin", this.getView(), this.getPageCache(), tab.getCurrentTab());
            this.setParenCache(tab.getCurrentTab());
        }
    }

    private void setTabVisible(Map<String, Object> customParams) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        DraftMetaDataDTO metaDataDTO = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DynamicObject confirm = this.accountSelectFormService.queryPolicyConfirm(customParams, metaDataDTO);
        if (null == confirm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"diff", "decrease", "deduct", "perpre"});
            return;
        }
        String ruledata_tag = confirm.getString("ruledata_tag");
        JSONObject object = JSONObject.parseObject((String)ruledata_tag);
        JSONArray diffs = object.getJSONArray(RuleTypeEnum.DIFF.name());
        this.getView().setVisible(Boolean.valueOf(diffs.size() > 0), new String[]{"diff"});
        JSONArray rollout = object.getJSONArray(RuleTypeEnum.ROLL_OUT.name());
        this.getView().setVisible(Boolean.valueOf(rollout.size() > 0), new String[]{"rollout"});
        JSONArray deduction = object.getJSONArray(RuleTypeEnum.REDUCE.name());
        this.getView().setVisible(Boolean.valueOf(deduction.size() > 0), new String[]{"taxreduction"});
        String deductionrate = confirm.getString("deductionrate");
        this.getView().setVisible(Boolean.valueOf(!"N".equals(deductionrate)), new String[]{"decrease"});
        Boolean existRecord = this.getJzjtJxseTabVisible(customParams, metaDataDTO);
        this.getView().setVisible(existRecord, new String[]{"jzjtjxse"});
        JSONArray deduct = object.getJSONArray(RuleTypeEnum.DEDUCT.name());
        this.getView().setVisible(Boolean.valueOf("sjjt".equals(metaDataDTO.getDraftPurpose()) && deduct.size() > 0), new String[]{"deduct"});
        this.getView().setVisible(Boolean.valueOf(!"sjjt".equals(metaDataDTO.getDraftPurpose())), new String[]{"deduction"});
        this.getView().setVisible(Boolean.valueOf(this.accountSelectFormService.isVisibleDeductTab(deduct)), new String[]{"waitdeduction"});
        JSONArray perpre = object.getJSONArray(RuleTypeEnum.PERPRE.name());
        this.getView().setVisible(Boolean.valueOf(perpre != null && perpre.size() > 0), new String[]{"perpre"});
    }

    private Boolean getJzjtJxseTabVisible(Map<String, Object> customParams, DraftMetaDataDTO metaDataDTO) {
        try {
            String accountMetaDataName = metaDataDTO.getJzjtjxse().getAccountMetaDataName();
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)customParams.get("orgid")));
            QFilter periodFilter = new QFilter("taxperiod", "=", (Object)((String)customParams.get("skssqq")).substring(0, 7));
            QFilter deadLineFilter = new QFilter("deadline", "=", customParams.get("deadLine"));
            return QueryServiceHelper.exists((String)accountMetaDataName, (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return Boolean.TRUE;
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        AccountSelectFormService.setVisibleForFastSetting(this.getView(), evt.getTabKey());
        AccountSelectFormService.showPage("AccountSelectFormPlugin", this.getView(), this.getPageCache(), evt.getTabKey());
        this.setParenCache(evt.getTabKey());
    }

    private void setParenCache(String sheetName) {
        IPageCache parentPageCache;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (parentView = parentView.getParentView()) != null && (parentPageCache = (IPageCache)parentView.getService(IPageCache.class)) != null) {
            parentPageCache.put("sheetName", TaxdataTabEnum.getNameByValue(sheetName));
        }
    }
}

