/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.account.AccountingDetailFormService;
import kd.taxc.tcvat.business.service.rule.RuleService;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.formplugin.account.AbstractEditPopFormPlugin;

public class AccountingDetailsFormPlugin
extends AbstractEditPopFormPlugin {
    private static final String DIFF_DETAIL_ENTITY = "tcvat_accdetail_diff";
    private static final String ROLLOUT_DETAIL_ENTITY = "tcvat_accdetail_rollout";
    private static final String INCOME_INVOICE_DETAIL_ENTITY = "tcvat_income_invoice";
    private static final String INCOME_DETAIL_ENTITY = "tcvat_accdetail_income";
    private static final String TAX_REDUCTION_DETAIL_ENTITY = "tcvat_taxreduce_detail";
    private static final String WAIT_DEDUCTION_DETAIL_ENTITY = "tcvat_wait_deduction_det";
    private AccountingDetailFormService accountingDetailFormService = new AccountingDetailFormService();
    private RuleService ruleService = new RuleService();
    private static final String ENTRYENTITY_CARD = "entryentitycard";

    @Override
    public void queryRightList(Map<String, Object> customParams) {
        boolean isIncomeZyfp = INCOME_INVOICE_DETAIL_ENTITY.equals(customParams.get("entry"));
        Object taxperiod = customParams.get("taxperiod");
        QFilter qFilter = new QFilter("taxaccountserialno", "=", customParams.get("taxaccountserialno"));
        Object type = customParams.get("type");
        String fieldName = String.valueOf(customParams.get("fieldName"));
        boolean countCell = "count".equals(fieldName);
        this.getView().setVisible(Boolean.valueOf(!countCell), new String[]{"amountfield"});
        this.getView().setVisible(Boolean.valueOf(countCell), new String[]{"count"});
        String selectFields = "skssqq,table,amountfield,datatype,datadirection,fetchamount,amount,filtercondition,absolute,conditionjson";
        selectFields = this.accountingDetailFormService.buildQueryParam(customParams, qFilter, selectFields);
        IDataModel model = this.getModel();
        String entityName = (String)customParams.get("entry");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dynamicObjects.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (taxperiod == null) {
                    if (isIncomeZyfp) {
                        model.setValue("taxperiod", (Object)DateUtils.stringToDate((String)dynamicObject.getString("taxperiod"), (String)"yyyy-MM"), rowIndex);
                    } else {
                        model.setValue("taxperiod", dynamicObject.get("skssqq"), rowIndex);
                    }
                } else {
                    model.setValue("taxperiod", (Object)DateUtils.stringToDate((String)((String)customParams.get("taxperiod")), (String)"yyyy-MM"), rowIndex);
                }
                model.setValue("table", dynamicObject.get("table"), rowIndex);
                model.setValue("amountfield", dynamicObject.get("amountfield"), rowIndex);
                model.setValue("count", dynamicObject.get("amountfield"), rowIndex);
                model.setValue("datatype", dynamicObject.get("datatype"), rowIndex);
                model.setValue("datadirection", dynamicObject.get("datadirection"), rowIndex);
                model.setValue("absolute", dynamicObject.get("absolute"), rowIndex);
                model.setValue("fetchamount", dynamicObject.get("fetchamount"), rowIndex);
                model.setValue("currentamount", isIncomeZyfp ? dynamicObject.get("invoiceamount") : dynamicObject.get("amount"), rowIndex);
                model.setValue("amount", isIncomeZyfp ? dynamicObject.get("invoiceamount") : dynamicObject.get("amount"), rowIndex);
                model.setValue("invoiceamount", isIncomeZyfp ? dynamicObject.get("invoiceamount") : dynamicObject.get("amount"), rowIndex);
                model.setValue("filtercondition", dynamicObject.get("filtercondition"), rowIndex);
                model.setValue("filtercondition_tag", dynamicObject.get("filtercondition"), rowIndex);
                model.setValue("conditionjson", dynamicObject.get("conditionjson"), rowIndex);
                if (dynamicObject.containsProperty("exrate")) {
                    model.setValue("exrate", dynamicObject.get("exrate"), rowIndex);
                }
                if (dynamicObject.containsProperty("differenceinvoice")) {
                    model.setValue("differenceinvoice", dynamicObject.get("differenceinvoice"), rowIndex);
                }
                LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("filtercondition");
                String tagPropName = largeTextEdit.getTagFieldKey();
                String largeText = (String)dynamicObject.get("filtercondition");
                if (StringUtil.isEmpty((CharSequence)largeText)) {
                    largeText = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"AccountingDetailsFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]);
                }
                this.getModel().setValue(tagPropName, (Object)largeText, rowIndex);
                if (Objects.equals(INCOME_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
                    model.setValue("taxrate", dynamicObject.get("taxrate"), rowIndex);
                    model.setValue("taxamount", dynamicObject.get("taxamount"), rowIndex);
                    model.setValue("taxamount1", dynamicObject.get("taxamount"), rowIndex);
                }
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"taxrate", "taxamount", "taxamount1"});
        if (Objects.equals(INCOME_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"exrate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"amount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"currentamount"});
            if (Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_QTSE) || Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_WKPSE) || Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_ZYSE)) {
                Object invoiceseqs = customParams.get("invoiceseqs");
                Object wkpseqs = customParams.get("wkpseqs");
                Object qtfpseqs = customParams.get("qtfpseqs");
                boolean a = Objects.equals(wkpseqs, "false") && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                boolean b = Objects.equals(qtfpseqs, "false") && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_QTSE);
                boolean c = Objects.equals(invoiceseqs, "false") && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                boolean showTaxrate = a || b || c;
                this.getView().setVisible(Boolean.valueOf(showTaxrate), new String[]{"taxrate"});
                this.getView().setVisible(Boolean.valueOf(showTaxrate), new String[]{"invoiceamount"});
                this.getView().setVisible(Boolean.valueOf(!showTaxrate), new String[]{"taxamount"});
                this.getView().setVisible(Boolean.valueOf(showTaxrate), new String[]{"taxamount1"});
            } else if (Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_QTSR) || Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_WKPSR) || Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_ZYSR)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"invoiceamount"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"exrate"});
        }
        if (Objects.equals(INCOME_INVOICE_DETAIL_ENTITY, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"exrate"});
        }
        if (Objects.equals(DIFF_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(TAX_REDUCTION_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(DraftConstant.YBNSR_PERPRE_DETAIL, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"amount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
        }
        if (Objects.equals(ROLLOUT_DETAIL_ENTITY, customParams.get("entry")) || Objects.equals(DraftConstant.YBNSR_JZJT_JXSE_ACCDETAIL, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"currentamount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
        }
        if (Objects.equals(WAIT_DEDUCTION_DETAIL_ENTITY, customParams.get("entry"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"amount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"currentamount"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoiceamount"});
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            entry.setColumnProperty("fetchamount", "header", (Object)ResManager.loadKDString((String)"\u53d6\u6570\u6570\u503c", (String)"AccountingDetailsFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (Objects.equals(DraftConstant.YBNSR_JZJT_JXSE_ACCDETAIL, customParams.get("entry"))) {
            String value = ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d", (String)"AccountingDetailsFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]);
            this.changeFiledName("amount", value);
        }
    }

    public void changeFiledName(String field, String newName) {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.setColumnProperty(field, "header", (Object)new LocaleString(newName));
    }

    @Override
    protected void addCustomParams(Map<String, Object> customParams) {
        super.addCustomParams(customParams);
        Object draftEntry = customParams.get("draftEntry");
        if (this.ruleService.isIncomeRuleSumEntry((String)draftEntry)) {
            customParams.put("ruleEntry", "tcvat_rule_income");
        }
        if (this.ruleService.isPatialPerpayRuleSumEntry((String)draftEntry)) {
            Map customParam = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("perpreprojectnumber", customParam.get("perpreprojectnumber"));
        }
    }
}

