/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.constant.DraftExportConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.AbstractAccountService;
import kd.taxc.tcvat.business.service.account.AddDeductionService;
import kd.taxc.tcvat.business.service.account.RecordDraftModifyDataService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.common.dto.TcvatDraftEditRecordEntity;

public class AddDeductionPlgin
extends AbstractFormPlugin {
    private AddDeductionService addDeductionService = new AddDeductionService();

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        String drafttype = (String)customParams.get("drafttype");
        String draftnumber = (String)customParams.get("draftnumber");
        try (TXHandle h = TX.requiresNew();){
            try {
                this.save();
                DynamicObject dataEntity = changeData.getDataEntity();
                TcvatDraftEditRecordEntity entity = new TcvatDraftEditRecordEntity("2", dataEntity.getString("servicetype"), orgid, oldValue, newValue, "", dataEntity.getString("id"), drafttype, e.getProperty().getName(), draftnumber);
                RecordDraftModifyDataService.recordModify(entity);
                this.getView().invokeOperation("refresh");
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
        String entityId = this.getView().getEntityId();
        String pluginName = DraftExportConstant.getClassName((String)entityId);
        IPageCache parentPageCache = null;
        if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null && this.getView().getParentView().getParentView().getParentView() != null) {
            parentPageCache = this.getView().getParentView().getParentView().getParentView().getPageCache();
        }
        if (parentPageCache != null) {
            parentPageCache.put("draftPageId", this.getView().getPageId());
            parentPageCache.put("entryEntityName", "entryentity");
            parentPageCache.put("pluginFeildExpandStr", null);
            parentPageCache.put("draftDataDtoPluginName", pluginName);
        }
    }

    private void init() {
        String deadLine;
        Date skssqz;
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO dto = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        DynamicObject[] dObjects = this.addDeductionService.loadPreAddDeduction(customParams, skssqq, skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz"))), deadLine = TaxDeclareHelper.getDeadLine(dto.getDraftPurpose(), customParams.get("orgid").toString(), skssqq, skssqz));
        if (dObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("servicetype", dynamicObject.get("servicetype"), rowIndex);
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue("currentamount", dynamicObject.get("currentamount"), rowIndex);
                model.setValue("currentdecrease", dynamicObject.get("currentdecrease"), rowIndex);
                model.setValue("rowno", dynamicObject.get("rowno"), rowIndex);
                AbstractAccountService.markEditCell(model, this.getView(), rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(deadLine)), new String[]{"taxperiod"});
    }

    private void save() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (entryentity != null && !entryentity.isEmpty()) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            AddDeductionService.save(customParams, entryentity);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f!", (String)"AddDeductionPlgin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }
}

