/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.account.DiffDeductionService;
import kd.taxc.tcvat.business.service.account.RecordDraftModifyDataService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.dto.TcvatDraftEditRecordEntity;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class DiffDeductionPlgin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl("entryentity1");
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        List<String> editRows = Arrays.asList("ynse", "jzjtynse");
        if (editRows.contains(fieldKey)) {
            this.doUpdateDraft(e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
        super.afterCreateData(null);
    }

    private void init() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaDto = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        DraftMetaDataInfo diffDraftMetaData = metaDto.getDiff();
        DraftMetaDataInfo diffDeductDraftMetaData = metaDto.getDiffDeduct();
        IDataModel model = this.getModel();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        String deadLine = (String)customParams.get("deadLine");
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
        DynamicObject[] diffDraftArr = BusinessDataServiceHelper.load((String)diffDraftMetaData.getAccountMetaDataName(), (String)"id,serialno,taxperiod,project,difftype,deductiontype,currentamount,deductamount,rowno,deductproject", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter}, (String)"taxperiod,difftype.number");
        DynamicObject[] diffDeductDraftArr = BusinessDataServiceHelper.load((String)diffDeductDraftMetaData.getAccountMetaDataName(), (String)"id,serialno,taxperiod,difftype,ruleid,notaxamount,beginamount,currentamount,predeductamount,endamount,deductamount,jzjtdeductamount,ynse,jzjtsumamount,jzjtynse", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter}, (String)"difftype.number");
        if (diffDraftArr.length > 0) {
            this.fillDiffEntry(model, diffDraftArr);
        }
        if (diffDeductDraftArr.length > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryentity1"});
            this.fillDiffDeductEntry(model, diffDeductDraftArr);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1"});
        }
        this.setColumnProperty(deadLine);
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(deadLine)), new String[]{"taxperiod"});
    }

    private void doUpdateDraft(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        BigDecimal oldValue = (BigDecimal)changeData.getOldValue();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = (String)customParams.get("orgid");
        String drafttype = (String)customParams.get("drafttype");
        String draftnumber = (String)customParams.get("draftnumber");
        try (TXHandle h = TX.requiresNew();){
            try {
                this.save();
                DynamicObject dataEntity = changeData.getDataEntity();
                TcvatDraftEditRecordEntity entity = new TcvatDraftEditRecordEntity("2", dataEntity.getString("difftype1.value"), orgid, oldValue, newValue, "", dataEntity.getString("id1"), drafttype, e.getProperty().getName(), draftnumber);
                RecordDraftModifyDataService.recordModify(entity);
                this.getView().invokeOperation("refresh");
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
    }

    private void save() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity1");
        if (entryentity != null && !entryentity.isEmpty()) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            DiffDeductionService.save(customParams, entryentity);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f!", (String)"AddDeductionPlgin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
    }

    private void fillDiffDeductEntry(IDataModel model, DynamicObject[] diffDeductDraftArr) {
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity1", diffDeductDraftArr.length);
        int rowIndex = 0;
        for (DynamicObject dynamicObject : diffDeductDraftArr) {
            model.setValue("id1", dynamicObject.get("id"), rowIndex);
            model.setValue("serialno1", dynamicObject.get("serialno"), rowIndex);
            model.setValue("difftype1", dynamicObject.get("difftype"), rowIndex);
            model.setValue("notaxamount", dynamicObject.get("notaxamount"), rowIndex);
            model.setValue("beginamount", dynamicObject.get("beginamount"), rowIndex);
            model.setValue("beginamount", dynamicObject.get("beginamount"), rowIndex);
            model.setValue("currentamount1", dynamicObject.get("currentamount"), rowIndex);
            model.setValue("predeductamount", dynamicObject.get("predeductamount"), rowIndex);
            model.setValue("deductamount1", dynamicObject.get("deductamount"), rowIndex);
            model.setValue("endamount", dynamicObject.get("endamount"), rowIndex);
            model.setValue("ynse", dynamicObject.get("ynse"), rowIndex);
            model.setValue("jzjtsumamount", dynamicObject.get("jzjtsumamount"), rowIndex);
            model.setValue("jzjtdeductamount", dynamicObject.get("jzjtdeductamount"), rowIndex);
            model.setValue("jzjtynse", dynamicObject.get("jzjtynse"), rowIndex);
            this.markEditCell1(model, rowIndex, "1");
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity1");
    }

    private void markEditCell1(IDataModel model, int rowIndex, String suffix) {
        QFilter draftTypeFilter = new QFilter("drafttype", "=", (Object)model.getDataEntityType().getName());
        QFilter draftIdFilter = new QFilter("draftid", "=", model.getValue("id" + suffix, rowIndex));
        DynamicObjectCollection editList = QueryServiceHelper.query((String)DraftConstant.TCVAT_DRAFT_EDIT, (String)"rowcode", (QFilter[])new QFilter[]{draftTypeFilter, draftIdFilter});
        if (!CollectionUtils.isEmpty((Collection)editList)) {
            Set<String> rowCodeSet = editList.stream().map(d -> d.getString("rowcode")).collect(Collectors.toSet());
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity" + suffix);
            rowCodeSet.forEach(r -> {
                CellStyle cellStyle = new CellStyle();
                cellStyle.setRow(rowIndex);
                if (r.equals("deductamount")) {
                    cellStyle.setFieldKey(r + suffix);
                } else {
                    cellStyle.setFieldKey(r);
                }
                cellStyle.setBackColor("#DCFAE4");
                entryGrid.setCellStyle(Collections.singletonList(cellStyle));
            });
        }
    }

    private void fillDiffEntry(IDataModel model, DynamicObject[] diffDraftArr) {
        model.beginInit();
        long length = Arrays.stream(diffDraftArr).filter(d -> !"bqsjkce".equals(d.getString("deductproject"))).count();
        if (length == 0L) {
            return;
        }
        model.batchCreateNewEntryRow("entryentity", (int)length);
        int rowIndex = 0;
        for (DynamicObject dynamicObject : diffDraftArr) {
            if ("bqsjkce".equals(dynamicObject.getString("deductproject"))) continue;
            model.setValue("id", dynamicObject.get("id"), rowIndex);
            model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
            model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
            model.setValue("project", dynamicObject.get("project"), rowIndex);
            model.setValue("difftype", dynamicObject.get("difftype"), rowIndex);
            Object deductiontypeNum = dynamicObject.get("deductiontype.number");
            if (!Objects.isNull(deductiontypeNum)) {
                model.setValue("deductiontype", deductiontypeNum, rowIndex);
            }
            model.setValue("currentamount", dynamicObject.get("currentamount"), rowIndex);
            model.setValue("deductamount", dynamicObject.get("deductamount"), rowIndex);
            this.markEditCell(model, rowIndex, "entryentity");
            ++rowIndex;
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setColumnProperty(String deadLine) {
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("entryentity");
        entryentity.setColumnProperty("taxperiod", "isFixed", (Object)true);
        entryentity.setColumnProperty("project", "isFixed", (Object)true);
        entryentity.setColumnProperty("difftype", "isFixed", (Object)true);
        entryentity.setColumnProperty("deductiontype", "isFixed", (Object)"aysb".equalsIgnoreCase(deadLine));
    }

    public void initialize() {
        EntryGrid entryentity = (EntryGrid)this.getView().getControl("entryentity");
        entryentity.addPackageDataListener(this::packageData);
        EntryGrid entryentity1 = (EntryGrid)this.getView().getControl("entryentity1");
        entryentity1.addPackageDataListener(this::packageData);
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        DynamicObject rowData = e.getRowData();
        if ("deductamount".equals(columnDesc.getKey()) && !"VAT_CEKCLX_008".equals(rowData.getString("difftype.number"))) {
            e.setNoLinkKey(Collections.singletonList("deductamount"));
        }
        if ("deductamount1".equals(columnDesc.getKey()) && "VAT_CEKCLX_008".equals(rowData.getString("difftype1.number"))) {
            e.setNoLinkKey(Arrays.asList("deductamount1", "jzjtdeductamount"));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String caption;
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaDto = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap);
        DraftMetaDataInfo diffDraftMetaData = metaDto.getDiff();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tcvat_income_invoice_tab");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("fieldName", (Object)fieldName);
        parameter.setCustomParam("type", (Object)fieldName);
        parameter.setCustomParam("description", this.getModel().getValue("project", rowIndex));
        parameter.setCustomParam("amount", this.getModel().getValue(fieldName, rowIndex));
        parameter.setCustomParam("draftnumber", customParamMap.get("draftnumber"));
        parameter.setCustomParam("drafttype", customParamMap.get("drafttype"));
        parameter.setCustomParam("billstatus", customParamMap.get("billstatus"));
        parameter.setCustomParam("draftpurpose", customParamMap.get("draftpurpose"));
        parameter.setCustomParam("taxPayerType", customParamMap.get("taxpayertype"));
        parameter.setCustomParam("taxaccountserialno", (Object)serialno);
        parameter.setCustomParam("skssqq", customParamMap.get("skssqq"));
        parameter.setCustomParam("skssqz", customParamMap.get("skssqz"));
        parameter.setCustomParam("entry", (Object)diffDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DIFF_DETAIL));
        parameter.setCustomParam("updateDraft", (Object)diffDraftMetaData.getAccountMetaDataName());
        parameter.setCustomParam("orgid", customParamMap.get("orgid"));
        parameter.setCustomParam("id", this.getModel().getValue("id", rowIndex));
        if ("currentamount".equals(fieldName)) {
            caption = ResManager.loadKDString((String)"\u5dee\u989d\u6263\u9664\u672c\u671f\u53d1\u751f\u989d\u53d6\u6570\u660e\u7ec6\u8868", (String)"DiffDeductionPlgin_2", (String)"taxc-tcvat", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"DiffDeductionPlgin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if ("deductamount".equals(fieldName)) {
            caption = ResManager.loadKDString((String)"\u5dee\u989d\u6263\u9664\u514d\u7a0e\u9879\u76ee\u7684\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u660e\u7ec6\u8868", (String)"DiffDeductionPlgin_4", (String)"taxc-tcvat", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u514d\u7a0e\u9879\u76ee\u7684\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d", (String)"DiffDeductionPlgin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if ("deductamount1".equals(fieldName)) {
            parameter.setCustomParam("id", this.getModel().getValue("id1", rowIndex));
            parameter.setCustomParam("description", (Object)((DynamicObject)this.getModel().getValue("difftype1", rowIndex)).getString("value"));
            parameter.setCustomParam("taxaccountserialno", this.getModel().getValue("serialno1", rowIndex));
            parameter.setCustomParam("updateDraft", (Object)metaDto.getDiffDeduct().getAccountMetaDataName());
            parameter.setCustomParam("fieldName", (Object)fieldName.replace("1", ""));
            caption = ResManager.loadKDString((String)"\u5dee\u989d\u6263\u9664\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u660e\u7ec6\u8868", (String)"DiffDeductionPlgin_6", (String)"taxc-tcvat", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d", (String)"DiffDeductionPlgin_7", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        if ("jzjtdeductamount".equals(fieldName)) {
            parameter.setCustomParam("id", this.getModel().getValue("id1", rowIndex));
            parameter.setCustomParam("description", (Object)((DynamicObject)this.getModel().getValue("difftype1", rowIndex)).getString("value"));
            parameter.setCustomParam("taxaccountserialno", this.getModel().getValue("serialno1", rowIndex));
            parameter.setCustomParam("updateDraft", (Object)metaDto.getDiffDeduct().getAccountMetaDataName());
            caption = ResManager.loadKDString((String)"\u5dee\u989d\u6263\u9664\u5373\u5f81\u5373\u9000\u7684\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u660e\u7ec6\u8868", (String)"DiffDeductionPlgin_8", (String)"taxc-tcvat", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u7684\u5b9e\u9645\u6263\u9664\u989d", (String)"DiffDeductionPlgin_9", (String)"taxc-tcvat", (Object[])new Object[0]));
        }
        this.getView().showForm(parameter);
    }
}

