/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftFieldEnum;

public class DraftEditFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        QFilter draftFilter = new QFilter("draftid", "=", customParams.get("id"));
        String fieldName = DraftFieldEnum.mapping((String)customParams.get("drafttype"), (String)customParams.get("fieldName"));
        QFilter rowFilter = new QFilter("rowcode", "=", (Object)fieldName);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)DraftConstant.TCVAT_DRAFT_EDIT, (String)"adjusttype,itemname,taxorg,tzszq,tzszh,tzsm,creator,createtime", (QFilter[])new QFilter[]{draftFilter, rowFilter}, (String)"createtime");
        String updateDraft = customParams.getOrDefault("updateDraft", "");
        if (Arrays.asList("tcvat_hz_deduction_sum", "tcvat_hz_wait_deduct_sum").contains(updateDraft)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxorg"});
        }
        if (collect.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", collect.size());
            int rowIndex = 0;
            for (DynamicObject dynamicObject : collect) {
                model.setValue("adjusttype", dynamicObject.get("adjusttype"), rowIndex);
                model.setValue("itemname", dynamicObject.get("itemname"), rowIndex);
                model.setValue("taxorg", dynamicObject.get("taxorg"), rowIndex);
                model.setValue("tzszq", dynamicObject.get("tzszq"), rowIndex);
                model.setValue("tzszh", dynamicObject.get("tzszh"), rowIndex);
                model.setValue("tzsm", dynamicObject.get("tzsm"), rowIndex);
                model.setValue("creator", dynamicObject.get("creator"), rowIndex);
                model.setValue("createtime", dynamicObject.get("createtime"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "close".equals(((Donothing)args.getSource()).getOperateKey())) {
            this.close();
        }
    }

    private void close() {
        IFormView parentView = this.getView().getParentView();
        IFormView grandparentView = parentView.getParentView();
        grandparentView.invokeOperation("refresh");
        parentView.close();
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }
}

