/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.TaxRateConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.PartitionSaveTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class IncomeFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams);
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        String deadLine = TaxDeclareHelper.getDeadLine(metaData.getDraftPurpose(), orgid.toString(), skssqq, skssqz);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)metaData.getIncome().getAccountMetaDataName(), (String)MetadataUtil.getAllSubFieldString((String)metaData.getIncome().getAccountMetaDataName()), (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, deadLineFilter}, (String)"taxperiod asc,description desc");
        ArrayList strings = Lists.newArrayList((Object[])new String[]{TaxRateConstant.getExcludeTaxCN(), TaxRateConstant.getExportMsTaxCN(), TaxRateConstant.getExportTsTaxCN()});
        if (genericObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("ruleid", dynamicObject.get("ruleid"), rowIndex);
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("description", dynamicObject.get("description"), rowIndex);
                model.setValue("taxmethod", dynamicObject.get("taxmethod"), rowIndex);
                if (strings.contains(dynamicObject.getString("taxmethod"))) {
                    model.setValue("taxrate", (Object)TaxRateConstant.getNullDataString(), rowIndex);
                } else {
                    model.setValue("taxrate", dynamicObject.get("taxrate"), rowIndex);
                }
                model.setValue("jzjt", dynamicObject.get("jzjt"), rowIndex);
                model.setValue("taxamount", dynamicObject.get("taxamount"), rowIndex);
                model.setValue("invoiceamount", dynamicObject.get("invoiceamount"), rowIndex);
                model.setValue("businessamount", dynamicObject.get("businessamount"), rowIndex);
                model.setValue("accountingamount", dynamicObject.get("accountingamount"), rowIndex);
                model.setValue("specialinvoiceamount", dynamicObject.get("specialinvoiceamount"), rowIndex);
                model.setValue("specialtaxamount", dynamicObject.get("specialtaxamount"), rowIndex);
                model.setValue("otherinvoiceamount", dynamicObject.get("otherinvoiceamount"), rowIndex);
                model.setValue("othertaxamount", dynamicObject.get("othertaxamount"), rowIndex);
                model.setValue("initnoneinvoiceamount", dynamicObject.get("initaccountingamount"), rowIndex);
                model.setValue("noneinvoiceamount", dynamicObject.get("accountingamount"), rowIndex);
                model.setValue("nonetaxamount", dynamicObject.get("nonetaxamount"), rowIndex);
                model.setValue("totaltaxamount", dynamicObject.get("totaltaxamount"), rowIndex);
                model.setValue("pricetaxamount", dynamicObject.get("pricetaxamount"), rowIndex);
                model.setValue("totalinvoiceamount", dynamicObject.get("taxamount"), rowIndex);
                model.setValue("bizdimensionname", (Object)dynamicObject.getString("bizdimensionname"), rowIndex);
                model.setValue("bizdimensiontype", (Object)(null != dynamicObject.getDynamicObject("bizdimensiontype") ? dynamicObject.getDynamicObject("bizdimensiontype").getString("id") : ""), rowIndex);
                model.setValue("bizdimensionid", (Object)dynamicObject.getString("bizdimensionid"), rowIndex);
                model.setValue("accountorg", (Object)(null != dynamicObject.getDynamicObject("accountorg") ? dynamicObject.getDynamicObject("accountorg").getLong("id") : 0L), rowIndex);
                this.markEditCell(model, rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
        String accountOrg = (String)customParams.get("accountorg");
        String businessdimension = (String)customParams.get("businessdimension");
        this.getView().setVisible(Boolean.valueOf("true".equals(accountOrg)), new String[]{"accountorg"});
        this.getView().setVisible(Boolean.valueOf("true".equals(businessdimension)), new String[]{"bizdimensiontype"});
        this.getView().setVisible(Boolean.valueOf("true".equals(businessdimension)), new String[]{"bizdimensionname"});
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(deadLine)), new String[]{"taxperiod"});
        super.afterCreateData(null);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("tcvat_income_invoice_tab".endsWith(actionId)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgidStr = (String)customParams.get("orgid");
            String skssqqStr = (String)customParams.get("skssqq");
            String skssqzStr = (String)customParams.get("skssqz");
            Date skssqq = DateUtils.stringToDate((String)skssqqStr);
            Date skssqz = DateUtils.stringToDate((String)skssqzStr);
            String taxpayerType = (String)customParams.get("taxpayertype");
            TcvatEngineModel model = TaxDeclareHelper.buildEngineModel(orgidStr, skssqqStr, skssqzStr, taxpayerType, null, customParams.getOrDefault("draftpurpose", "nssb"));
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgidStr));
            QFilter deadLineFilter = new QFilter("deadline", "=", model.getCustom().get("deadLine"));
            QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
            DynamicObjectCollection genericObjects = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getIncome().getAccountMetaDataName(), (String)"id,description,taxamount,accountingamount,invoiceamount,businessamount,taxmethodtype,taxrate,taxperiod,serialno,jzjt,businesstype,taxreductioncode,taxreductionname,taxreductiontype,taxreductionid,taxmethod,org,ruleid,invoicetaxamount,nonetaxamount,specialinvoiceamount,otherinvoiceamount,othertaxamount,totaltaxamount,pricetaxamount,specialtaxamount,deadline,initaccountingamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter});
            if (genericObjects.size() > 0) {
                String taxperiod = skssqqStr.substring(0, 7);
                String templateType = "IncomeEngine";
                QFilter periodFilter = new QFilter("taxperiod", "=", (Object)taxperiod);
                DeleteServiceHelper.delete((String)model.getDraftMetaDataDTO().getIncome().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_INCOME_TAX_DEDUCTION_SUM), (QFilter[])new QFilter[]{orgFilter, periodFilter, deadLineFilter});
                List<DynamicObject> groupSummaryDataList = IncomeUtils.groupSummaryData(templateType, model, (List<DynamicObject>)genericObjects);
                if (!groupSummaryDataList.isEmpty()) {
                    ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
                }
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo incomeDraftMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap).getIncome();
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        Long ruleid = (Long)this.getModel().getValue("ruleid", rowIndex);
        String accoutorg = null != (DynamicObject)this.getModel().getValue("accountorg", rowIndex) ? ((DynamicObject)this.getModel().getValue("accountorg", rowIndex)).getString("id") : "0";
        String bizdimensionid = (String)this.getModel().getValue("bizdimensionid", rowIndex);
        String fieldName = evt.getFieldName();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("orgid", customParamMap.get("orgid"));
        customParams.put("billstatus", customParamMap.get("billstatus"));
        customParams.put("id", this.getModel().getValue("id", rowIndex));
        customParams.put("fieldName", fieldName);
        customParams.put("taxaccountserialno", serialno);
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleid, (String)RuleTypeEnum.INCOME.getEntry());
        customParams.put("invoiceseqs", rule != null && rule.getBoolean("invoiceseqs") ? "true" : "false");
        customParams.put("wkpseqs", rule != null && rule.getBoolean("wkpseqs") ? "true" : "false");
        customParams.put("qtfpseqs", rule != null && rule.getBoolean("qtfpseqs") ? "true" : "false");
        customParams.put("description", this.getModel().getValue("description", rowIndex));
        customParams.put("updateDraft", incomeDraftMetaData.getAccountMetaDataName());
        customParams.put("amount", this.getModel().getValue(fieldName, rowIndex));
        customParams.put("draftnumber", customParamMap.get("draftnumber"));
        customParams.put("drafttype", customParamMap.get("drafttype"));
        customParams.put("draftpurpose", customParamMap.get("draftpurpose"));
        customParams.put("taxPayerType", customParamMap.get("taxpayertype"));
        customParams.put("skssqq", customParamMap.get("skssqq"));
        customParams.put("skssqz", customParamMap.get("skssqz"));
        customParams.put("bizdimensionid", "0".equals(bizdimensionid) ? " " : bizdimensionid);
        customParams.put("accountorg", accoutorg);
        switch (fieldName) {
            case "specialtaxamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"IncomeFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_00", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_INCOME_INVOICE_DETAIL));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "specialinvoiceamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"IncomeFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4e0d\u542b\u7a0e\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_INCOME_INVOICE_DETAIL));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_ZYSR);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "otherinvoiceamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"IncomeFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_INCOME_DETAIL));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u5f00\u5177\u5176\u4ed6\u53d1\u7968\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_QTSR);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "othertaxamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"IncomeFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_INCOME_DETAIL));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u5f00\u5177\u5176\u4ed6\u53d1\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_QTSE);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "noneinvoiceamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u9500\u552e\u989d", (String)"IncomeFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_INCOME_DETAIL));
                customParams.put("fieldName", "accountingamount");
                customParams.put("customCaption", ResManager.loadKDString((String)"\u672a\u5f00\u7968\u9500\u552e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_WKPSR);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "nonetaxamount": {
                customParams.put("cellName", ResManager.loadKDString((String)"\u7a0e\u989d", (String)"IncomeFormPlugin_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("entry", incomeDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_INCOME_DETAIL));
                customParams.put("customCaption", ResManager.loadKDString((String)"\u672a\u5f00\u7968\u7a0e\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"IncomeFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
                customParams.put("type", RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcvat_income_invoice_tab", (IFormView)this.getView(), customParams, (IFormPlugin)this);
            }
        }
    }
}

