/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.DecimalEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class RolloutFormPlugin
extends AbstractAccountingPlugin
implements HyperLinkClickListener,
TreeNodeQueryListener {
    private static final String treeentryentity = "treeentryentity";
    private static final String FIELD_ACCOUNTING = "accountingamount";
    private static final String FIELD_JZJT_ROLLOUT_AMOUNT = "jzjtrolloutamount";
    private static final String PAGE_ACCOUNTING = "tcvat_accdetail_rollout";
    private static final String ROLLOUT_DETAIL_ENTITY = "tcvat_accdetail_rollout";

    public void registerListener(EventObject e) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(treeentryentity);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addCellClickListener((TreeNodeQueryListener)this);
    }

    public void initialize() {
        super.initialize();
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(treeentryentity);
        entryGrid.addPackageDataListener(this::packageData);
    }

    public void afterCreateNewData(EventObject e) {
        boolean readonly;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo rollOutMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams).getRollOut();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        String deadLine = String.valueOf(customParams.get("deadLine"));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid.toString()));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        QFilter pidFilter = new QFilter("pid", "=", (Object)0L);
        QFilter deadLineFilter = new QFilter("deadline", "=", (Object)deadLine);
        IDataModel model = this.getModel();
        DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)rollOutMetaData.getAccountMetaDataName(), (String)"id,pid,org,taxperiod,serialno,rollouttype,description,accountingamount,jzjt,jzjtrolloutamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, pidFilter, deadLineFilter}, (String)"taxperiod,rollouttype");
        if (genericObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(treeentryentity, genericObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : genericObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("org", dynamicObject.get("org"), rowIndex);
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("rollouttype", dynamicObject.get("rollouttype"), rowIndex);
                model.setValue("description", dynamicObject.get("description"), rowIndex);
                model.setValue(FIELD_ACCOUNTING, dynamicObject.get(FIELD_ACCOUNTING), rowIndex);
                model.setValue("jzjt", dynamicObject.get("jzjt"), rowIndex);
                model.setValue(FIELD_JZJT_ROLLOUT_AMOUNT, dynamicObject.get(FIELD_JZJT_ROLLOUT_AMOUNT), rowIndex);
                this.markEditCell(model, rowIndex, treeentryentity);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView(treeentryentity);
        }
        if (readonly = ((Boolean)this.getView().getFormShowParameter().getCustomParam("readonly")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{treeentryentity});
        }
        this.getView().setVisible(Boolean.valueOf("ajsb".equalsIgnoreCase(deadLine)), new String[]{"taxperiod"});
        super.afterCreateData(null);
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof DecimalEdit && FIELD_JZJT_ROLLOUT_AMOUNT.equals(((DecimalEdit)e.getSource()).getKey()) && "0".equals(e.getRowData().get("jzjt"))) {
            e.getNoLinkKey().add(((DecimalEdit)e.getSource()).getFieldKey());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo rollOutMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap).getRollOut();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("draftpurpose", customParamMap.get("draftpurpose"));
        if (FIELD_ACCOUNTING.equals(fieldName)) {
            String caption = ResManager.loadKDString((String)"\u8fdb\u9879\u8f6c\u51fa\u89c4\u5219\u53d6\u6570\u7ed3\u679c", (String)"RolloutFormPlugin_2", (String)"taxc-tcvat", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setFormId("tcvat_income_invoice_tab");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("taxaccountserialno", (Object)serialno);
            parameter.setCustomParam("entry", (Object)"tcvat_accdetail_rollout");
            parameter.setCustomParam("updateDraft", (Object)rollOutMetaData.getAccountMetaDataName());
            parameter.setCustomParam("orgid", customParamMap.get("orgid"));
            parameter.setCustomParam("id", this.getModel().getValue("id", rowIndex));
            parameter.setCustomParam("fieldName", (Object)fieldName);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u8f6c\u51fa\u7a0e\u989d", (String)"RolloutFormPlugin_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            parameter.setCustomParam("description", this.getModel().getValue("description", rowIndex));
            parameter.setCustomParam("amount", this.getModel().getValue(fieldName, rowIndex));
            parameter.setCustomParam("draftnumber", customParamMap.get("draftnumber"));
            parameter.setCustomParam("drafttype", customParamMap.get("drafttype"));
            parameter.setCustomParam("billstatus", customParamMap.get("billstatus"));
            this.getView().showForm(parameter);
        } else if (FIELD_JZJT_ROLLOUT_AMOUNT.equals(fieldName)) {
            String jzjt = (String)this.getModel().getValue("jzjt", rowIndex);
            String caption = ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8fdb\u9879\u8f6c\u51fa\u989d\u660e\u7ec6", (String)"RolloutFormPlugin_3", (String)"taxc-tcvat", (Object[])new Object[0]);
            parameter.setCaption(caption);
            parameter.setFormId("tcvat_income_invoice_tab");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("taxaccountserialno", (Object)serialno);
            parameter.setCustomParam("entry", (Object)"tcvat_accdetail_rollout");
            parameter.setCustomParam("updateDraft", (Object)rollOutMetaData.getAccountMetaDataName());
            parameter.setCustomParam("orgid", customParamMap.get("orgid"));
            parameter.setCustomParam("id", this.getModel().getValue("id", rowIndex));
            parameter.setCustomParam("fieldName", (Object)fieldName);
            parameter.setCustomParam("jzjt", (Object)jzjt);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u8f6c\u51fa\u989d", (String)"RolloutFormPlugin_5", (String)"taxc-tcvat", (Object[])new Object[0]));
            parameter.setCustomParam("description", this.getModel().getValue("description", rowIndex));
            parameter.setCustomParam("amount", this.getModel().getValue(fieldName, rowIndex));
            parameter.setCustomParam("draftnumber", customParamMap.get("draftnumber"));
            parameter.setCustomParam("drafttype", customParamMap.get("drafttype"));
            parameter.setCustomParam("billstatus", customParamMap.get("billstatus"));
            this.getView().showForm(parameter);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
    }

    @Override
    protected String getEntityName() {
        return treeentryentity;
    }
}

