/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.formplugin.account;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.formplugin.account.AbstractAccountingPlugin;

public class SmallScaleDiffDeductionPlgin
extends AbstractAccountingPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
        boolean readonly = (Boolean)this.getView().getFormShowParameter().getCustomParam("readonly");
        if (readonly) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
        super.afterCreateData(null);
    }

    private void init() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo diffDraftMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParams).getDiff();
        IDataModel model = this.getModel();
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(orgid)));
        QFilter taxPeriodFilter = new QFilter("taxperiod", "in", PeriodService.getPeriodList(skssqq, skssqz));
        QFilter deadLineFilter = new QFilter("deadline", "=", customParams.get("deadLine"));
        filters.add(deadLineFilter);
        filters.add(orgFilter);
        filters.add(taxPeriodFilter);
        DynamicObject[] dObjects = BusinessDataServiceHelper.load((String)diffDraftMetaData.getAccountMetaDataName(), (String)"id,taxperiod,serialno,project,difftype,deductiontype,currentamount,rowno", (QFilter[])filters.toArray(new QFilter[0]), (String)"taxperiod,difftype");
        if (dObjects.length > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", dObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : dObjects) {
                model.setValue("id", dynamicObject.get("id"), rowIndex);
                model.setValue("taxperiod", dynamicObject.get("taxperiod"), rowIndex);
                model.setValue("serialno", dynamicObject.get("serialno"), rowIndex);
                model.setValue("project", dynamicObject.get("project"), rowIndex);
                model.setValue("difftype", dynamicObject.get("difftype"), rowIndex);
                Object deductiontypeNum = dynamicObject.get("deductiontype.number");
                if (!Objects.isNull(deductiontypeNum)) {
                    model.setValue("deductiontype", deductiontypeNum, rowIndex);
                }
                model.setValue("currentamount", dynamicObject.get("currentamount"), rowIndex);
                this.markEditCell(model, rowIndex, "entryentity");
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String serialno = (String)this.getModel().getValue("serialno", rowIndex);
        String fieldName = evt.getFieldName();
        Map customParamMap = this.getView().getFormShowParameter().getCustomParams();
        DraftMetaDataInfo diffDraftMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(customParamMap).getDiff();
        if ("currentamount".equals(fieldName)) {
            String caption = ResManager.loadKDString((String)"\u5dee\u989d\u6263\u9664\u672c\u671f\u53d1\u751f\u989d\u53d6\u6570\u660e\u7ec6\u5217\u8868", (String)"SmallScaleDiffDeductionPlgin_1", (String)"taxc-tcvat", (Object[])new Object[0]);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCaption(caption);
            parameter.setFormId("tcvat_income_invoice_tab");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("taxaccountserialno", (Object)serialno);
            parameter.setCustomParam("taxpayertype", customParamMap.get("taxpayertype"));
            parameter.setCustomParam("entry", (Object)diffDraftMetaData.getDetailMetaDataNameMap().get("tcvat_accdetail_diff"));
            parameter.setCustomParam("updateDraft", (Object)diffDraftMetaData.getAccountMetaDataName());
            parameter.setCustomParam("orgid", customParamMap.get("orgid"));
            parameter.setCustomParam("id", this.getModel().getValue("id", rowIndex));
            parameter.setCustomParam("fieldName", (Object)fieldName);
            parameter.setCustomParam("cellName", (Object)ResManager.loadKDString((String)"\u672c\u671f\u53d1\u751f\u989d", (String)"SmallScaleDiffDeductionPlgin_2", (String)"taxc-tcvat", (Object[])new Object[0]));
            parameter.setCustomParam("description", this.getModel().getValue("project", rowIndex));
            parameter.setCustomParam("amount", this.getModel().getValue(fieldName, rowIndex));
            parameter.setCustomParam("draftnumber", customParamMap.get("draftnumber"));
            parameter.setCustomParam("drafttype", customParamMap.get("drafttype"));
            parameter.setCustomParam("billstatus", customParamMap.get("billstatus"));
            parameter.setCustomParam("deadline", customParamMap.get("deadLine"));
            parameter.setCustomParam("skssqq", customParamMap.get("skssqq"));
            parameter.setCustomParam("skssqz", customParamMap.get("skssqz"));
            parameter.setCustomParam("draftpurpose", customParamMap.get("draftpurpose"));
            this.getView().showForm(parameter);
        }
    }
}

